/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.util;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.rubypeople.rdt.internal.ui.util.StringMatcher;
import org.rubypeople.rdt.internal.ui.util.TwoArrayQuickSorter;

public class FilteredList
extends Composite {
    private Table fList;
    private ILabelProvider fRenderer;
    private boolean fMatchEmtpyString = true;
    private boolean fIgnoreCase;
    private boolean fAllowDuplicates;
    private String fFilter = "";
    private TwoArrayQuickSorter fSorter;
    private Object[] fElements = new Object[0];
    private Label[] fLabels;
    private Vector fImages = new Vector();
    private int[] fFoldedIndices;
    private int fFoldedCount;
    private int[] fFilteredIndices;
    private int fFilteredCount;
    private FilterMatcher fFilterMatcher = new DefaultFilterMatcher();
    private Comparator fComparator;

    public FilteredList(Composite composite, int n, ILabelProvider iLabelProvider, boolean bl, boolean bl2, boolean bl3) {
        super(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.fList = new Table((Composite)this, n);
        this.fList.setLayoutData((Object)new GridData(1808));
        this.fList.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                FilteredList.this.fRenderer.dispose();
            }
        });
        this.fRenderer = iLabelProvider;
        this.fIgnoreCase = bl;
        this.fSorter = new TwoArrayQuickSorter(new LabelComparator(bl));
        this.fAllowDuplicates = bl2;
        this.fMatchEmtpyString = bl3;
    }

    public void setElements(Object[] objectArray) {
        if (objectArray == null) {
            this.fElements = new Object[0];
        } else {
            this.fElements = new Object[objectArray.length];
            System.arraycopy(objectArray, 0, this.fElements, 0, objectArray.length);
        }
        int n = this.fElements.length;
        this.fLabels = new Label[n];
        HashSet<Image> hashSet = new HashSet<Image>();
        int n2 = 0;
        while (n2 != n) {
            String string = this.fRenderer.getText(this.fElements[n2]);
            Image image = this.fRenderer.getImage(this.fElements[n2]);
            this.fLabels[n2] = new Label(string, image);
            hashSet.add(image);
            ++n2;
        }
        this.fImages.clear();
        this.fImages.addAll(hashSet);
        this.fSorter.sort(this.fLabels, this.fElements);
        this.fFilteredIndices = new int[n];
        this.fFilteredCount = this.filter();
        this.fFoldedIndices = new int[n];
        this.fFoldedCount = this.fold();
        this.updateList();
    }

    public boolean isEmpty() {
        return this.fElements == null || this.fElements.length == 0;
    }

    public void setFilterMatcher(FilterMatcher filterMatcher) {
        Assert.isNotNull((Object)filterMatcher);
        this.fFilterMatcher = filterMatcher;
    }

    public void setComparator(Comparator comparator) {
        Assert.isNotNull((Object)comparator);
        this.fComparator = comparator;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.fList.addSelectionListener(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.fList.removeSelectionListener(selectionListener);
    }

    public void setSelection(int[] nArray) {
        this.fList.setSelection(nArray);
    }

    public int[] getSelectionIndices() {
        return this.fList.getSelectionIndices();
    }

    public int getSelectionIndex() {
        return this.fList.getSelectionIndex();
    }

    public void setSelection(Object[] objectArray) {
        if (objectArray == null || this.fElements == null) {
            return;
        }
        int[] nArray = new int[objectArray.length];
        int n = 0;
        while (n != objectArray.length) {
            int n2 = 0;
            while (n2 != this.fFoldedCount) {
                int n3 = n2 == this.fFoldedCount - 1 ? this.fFilteredCount : this.fFoldedIndices[n2 + 1];
                int n4 = this.fFoldedIndices[n2];
                while (n4 != n3) {
                    if (this.fElements[this.fFilteredIndices[n4]].equals(objectArray[n])) {
                        nArray[n] = n2;
                        break;
                    }
                    ++n4;
                }
                if (n4 != n3) break;
                ++n2;
            }
            if (n2 == this.fFoldedCount) {
                nArray[n] = 0;
            }
            ++n;
        }
        this.fList.setSelection(nArray);
    }

    public Object[] getSelection() {
        if (this.fList.isDisposed() || this.fList.getSelectionCount() == 0) {
            return new Object[0];
        }
        int[] nArray = this.fList.getSelectionIndices();
        Object[] objectArray = new Object[nArray.length];
        int n = 0;
        while (n != nArray.length) {
            objectArray[n] = this.fElements[this.fFilteredIndices[this.fFoldedIndices[nArray[n]]]];
            ++n;
        }
        return objectArray;
    }

    public void setFilter(String string) {
        this.fFilter = string == null ? "" : string;
        this.fFilteredCount = this.filter();
        this.fFoldedCount = this.fold();
        this.updateList();
    }

    public String getFilter() {
        return this.fFilter;
    }

    public Object[] getFoldedElements(int n) {
        if (n < 0 || n >= this.fFoldedCount) {
            return null;
        }
        int n2 = this.fFoldedIndices[n];
        int n3 = n == this.fFoldedCount - 1 ? this.fFilteredCount - n2 : this.fFoldedIndices[n + 1] - n2;
        Object[] objectArray = new Object[n3];
        int n4 = 0;
        while (n4 != n3) {
            objectArray[n4] = this.fElements[this.fFilteredIndices[n2 + n4]];
            ++n4;
        }
        return objectArray;
    }

    private int fold() {
        if (this.fAllowDuplicates) {
            int n = 0;
            while (n != this.fFilteredCount) {
                this.fFoldedIndices[n] = n;
                ++n;
            }
            return this.fFilteredCount;
        }
        int n = 0;
        Label label = null;
        int n2 = 0;
        while (n2 != this.fFilteredCount) {
            int n3 = this.fFilteredIndices[n2];
            Label label2 = this.fLabels[n3];
            if (!label2.equals(label)) {
                this.fFoldedIndices[n] = n2;
                ++n;
                label = label2;
            }
            ++n2;
        }
        return n;
    }

    private int filter() {
        if (!(this.fFilter != null && this.fFilter.length() != 0 || this.fMatchEmtpyString)) {
            return 0;
        }
        this.fFilterMatcher.setFilter(this.fFilter.trim(), this.fIgnoreCase, false);
        int n = 0;
        int n2 = 0;
        while (n2 != this.fElements.length) {
            if (this.fFilterMatcher.match(this.fElements[n2])) {
                this.fFilteredIndices[n++] = n2;
            }
            ++n2;
        }
        return n;
    }

    private void updateList() {
        if (this.fList.isDisposed()) {
            return;
        }
        this.fList.setRedraw(false);
        int n = this.fList.getItemCount();
        if (this.fFoldedCount < n) {
            this.fList.remove(0, n - this.fFoldedCount - 1);
        } else if (this.fFoldedCount > n) {
            int n2 = 0;
            while (n2 != this.fFoldedCount - n) {
                new TableItem(this.fList, 0);
                ++n2;
            }
        }
        TableItem[] tableItemArray = this.fList.getItems();
        int n3 = 0;
        while (n3 != this.fFoldedCount) {
            TableItem tableItem = tableItemArray[n3];
            Label label = this.fLabels[this.fFilteredIndices[this.fFoldedIndices[n3]]];
            tableItem.setText(label.string);
            tableItem.setImage(label.image);
            ++n3;
        }
        if (this.fList.getItemCount() > 0) {
            this.fList.setSelection(0);
        }
        this.fList.setRedraw(true);
        this.fList.notifyListeners(13, new Event());
    }

    public static interface FilterMatcher {
        public void setFilter(String var1, boolean var2, boolean var3);

        public boolean match(Object var1);
    }

    private class DefaultFilterMatcher
    implements FilterMatcher {
        private StringMatcher fMatcher;

        DefaultFilterMatcher() {
        }

        public void setFilter(String string, boolean bl, boolean bl2) {
            this.fMatcher = new StringMatcher(String.valueOf(string) + '*', bl, bl2);
        }

        public boolean match(Object object) {
            return this.fMatcher.match(FilteredList.this.fRenderer.getText(object));
        }
    }

    private static class Label {
        public final String string;
        public final Image image;

        public Label(String string, Image image) {
            this.string = string;
            this.image = image;
        }

        public boolean equals(Label label) {
            if (label == null) {
                return false;
            }
            return this.string.equals(label.string) && this.image.equals((Object)label.image);
        }
    }

    private final class LabelComparator
    implements Comparator {
        private boolean fIgnoreCase;

        LabelComparator(boolean bl) {
            this.fIgnoreCase = bl;
        }

        public int compare(Object object, Object object2) {
            Label label = (Label)object;
            Label label2 = (Label)object2;
            int n = FilteredList.this.fComparator == null ? (this.fIgnoreCase ? label.string.compareToIgnoreCase(label2.string) : label.string.compareTo(label2.string)) : FilteredList.this.fComparator.compare(label.string, label2.string);
            if (n != 0) {
                return n;
            }
            if (label.image == null) {
                return label2.image == null ? 0 : -1;
            }
            if (label2.image == null) {
                return 1;
            }
            return FilteredList.this.fImages.indexOf(label.image) - FilteredList.this.fImages.indexOf(label2.image);
        }
    }
}

