/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.ruby.hover;

import java.util.List;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.ICommandManager;
import org.eclipse.ui.commands.IKeySequenceBinding;
import org.eclipse.ui.keys.KeySequence;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.text.HTMLTextPresenter;
import org.rubypeople.rdt.internal.ui.text.RubyWordFinder;
import org.rubypeople.rdt.internal.ui.text.ruby.hover.RubyHoverMessages;
import org.rubypeople.rdt.ui.text.ruby.hover.IRubyEditorTextHover;

public abstract class AbstractRubyEditorTextHover
implements IRubyEditorTextHover,
ITextHoverExtension {
    private IEditorPart fEditor;
    private ICommand fCommand;

    public AbstractRubyEditorTextHover() {
        ICommandManager iCommandManager = PlatformUI.getWorkbench().getCommandSupport().getCommandManager();
        this.fCommand = iCommandManager.getCommand("org.rubypeople.rdt.ui.edit.text.ruby.show.rdoc");
        if (!this.fCommand.isDefined()) {
            this.fCommand = null;
        }
    }

    public void setEditor(IEditorPart iEditorPart) {
        this.fEditor = iEditorPart;
    }

    protected IEditorPart getEditor() {
        return this.fEditor;
    }

    public IRegion getHoverRegion(ITextViewer iTextViewer, int n) {
        return RubyWordFinder.findWord(iTextViewer.getDocument(), n);
    }

    public abstract String getHoverInfo(ITextViewer var1, IRegion var2);

    protected String getHoverInfo(IRubyElement[] iRubyElementArray) {
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new DefaultInformationControl(shell, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), AbstractRubyEditorTextHover.this.getTooltipAffordanceString());
            }
        };
    }

    protected String getTooltipAffordanceString() {
        if (!RubyPlugin.getDefault().getPreferenceStore().getBoolean("PreferenceConstants.EDITOR_SHOW_TEXT_HOVER_AFFORDANCE")) {
            return null;
        }
        KeySequence[] keySequenceArray = this.getKeySequences();
        if (keySequenceArray == null) {
            return null;
        }
        String string = keySequenceArray[0].format();
        return RubyHoverMessages.getFormattedString("RubyTextHover.makeStickyHint", string);
    }

    private KeySequence[] getKeySequences() {
        List list;
        if (this.fCommand != null && !(list = this.fCommand.getKeySequenceBindings()).isEmpty()) {
            KeySequence[] keySequenceArray = new KeySequence[list.size()];
            int n = 0;
            while (n < keySequenceArray.length) {
                keySequenceArray[n] = ((IKeySequenceBinding)list.get(n)).getKeySequence();
                ++n;
            }
            return keySequenceArray;
        }
        return null;
    }
}

