/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.graph;

import edu.umd.cs.findbugs.graph.AbstractEdge;
import edu.umd.cs.findbugs.graph.GraphVertex;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractVertex<EdgeType extends AbstractEdge<EdgeType, ActualVertexType>, ActualVertexType extends AbstractVertex<EdgeType, ActualVertexType>>
implements GraphVertex<ActualVertexType> {
    private int id;
    private int label;
    EdgeType firstIncomingEdge;
    EdgeType lastIncomingEdge;
    EdgeType firstOutgoingEdge;
    EdgeType lastOutgoingEdge;

    void setId(int id) {
        this.id = id;
    }

    int getId() {
        return this.id;
    }

    @Override
    public int getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(int label) {
        this.label = label;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractVertex) {
            return this.id == ((AbstractVertex)o).id;
        }
        return false;
    }

    @Override
    public int compareTo(ActualVertexType other) {
        return this.id - ((AbstractVertex)other).id;
    }

    void addOutgoingEdge(EdgeType edge) {
        if (this.firstOutgoingEdge == null) {
            this.lastOutgoingEdge = edge;
            this.firstOutgoingEdge = this.lastOutgoingEdge;
        } else {
            ((AbstractEdge)this.lastOutgoingEdge).setNextOutgoingEdge(edge);
            this.lastOutgoingEdge = edge;
        }
    }

    EdgeType getFirstOutgoingEdge() {
        return this.firstOutgoingEdge;
    }

    void addIncomingEdge(EdgeType edge) {
        if (this.firstIncomingEdge == null) {
            this.lastIncomingEdge = edge;
            this.firstIncomingEdge = this.lastIncomingEdge;
        } else {
            ((AbstractEdge)this.lastIncomingEdge).setNextIncomingEdge(edge);
            this.lastIncomingEdge = edge;
        }
    }

    EdgeType getFirstIncomingEdge() {
        return this.firstIncomingEdge;
    }

    void removeIncomingEdge(EdgeType edge) {
        AbstractEdge prev = null;
        Object cur = this.firstIncomingEdge;
        while (cur != null) {
            Object next = ((AbstractEdge)cur).getNextIncomingEdge();
            if (((AbstractEdge)cur).equals(edge)) {
                if (prev != null) {
                    prev.setNextIncomingEdge(next);
                } else {
                    this.firstIncomingEdge = next;
                }
                return;
            }
            prev = (AbstractEdge)cur;
            cur = next;
        }
        throw new IllegalArgumentException("removing nonexistent edge!");
    }

    void removeOutgoingEdge(EdgeType edge) {
        AbstractEdge prev = null;
        for (Object cur = this.firstOutgoingEdge; cur != null; cur = ((AbstractEdge)cur).getNextOutgoingEdge()) {
            Object next = ((AbstractEdge)cur).getNextOutgoingEdge();
            if (((AbstractEdge)cur).equals(edge)) {
                if (prev != null) {
                    prev.setNextOutgoingEdge(next);
                } else {
                    this.firstOutgoingEdge = next;
                }
                return;
            }
            prev = (AbstractEdge)cur;
        }
        throw new IllegalArgumentException("removing nonexistent edge!");
    }

    @Override
    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((ActualVertexType)((AbstractVertex)x0));
    }
}

