;; autoload.jl -- Initialise auto-load functions

;; Copyright (C) 1999 John Harper <john@dcs.warwick.ac.uk>

;; This file is part of sawfish.

;; sawfish is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; sawfish is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with sawfish; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;; to rebuild this file, load a tags file containing all lisp files
;; into Jade, then run:

;; (tags-map-buffers
;;  (lambda (buffer)
;;    (add-autoloads "SOURCE-DIR/lisp/sawfish/wm/autoload.jl" buffer)))

;;; ::autoload-start::
(autoload-command 'customize 'sawfish.wm.customize)
(autoload-command 'popup-window-ops-menu 'sawfish.wm.menus)
(autoload-command 'popup-root-menu 'sawfish.wm.menus)
(autoload-command 'popup-apps-menu 'sawfish.wm.menus)
(autoload-command 'popup-window-list-menu 'sawfish.wm.menus)
(autoload-window-animator 'wireframe 'sawfish.wm.animation.main)
(autoload-window-animator 'solid 'sawfish.wm.animation.main)
(autoload-window-animator 'cross 'sawfish.wm.animation.main)
(autoload-window-animator 'elliptical 'sawfish.wm.animation.main)
(autoload-window-animator 'draft 'sawfish.wm.animation.main)
(autoload-command 'next-workspace-window 'sawfish.wm.commands.cycle)
(autoload-command 'previous-workspace-window 'sawfish.wm.commands.cycle)
(autoload-command 'next-window 'sawfish.wm.commands.cycle)
(autoload-command 'previous-window 'sawfish.wm.commands.cycle)
(autoload-command 'describe-symbol 'sawfish.wm.commands.describe)
(autoload-command 'describe-symbol-to-screen 'sawfish.wm.commands.describe)
(autoload-command 'apropos-function 'sawfish.wm.commands.describe)
(autoload-command 'apropos-function-to-screen 'sawfish.wm.commands.describe)
(autoload-command 'apropos-variable 'sawfish.wm.commands.describe)
(autoload-command 'apropos-variable-to-screen 'sawfish.wm.commands.describe)
(autoload-command 'make-group-sticky 'sawfish.wm.commands.groups)
(autoload-command 'make-group-unsticky 'sawfish.wm.commands.groups)
(autoload-command 'toggle-group-sticky 'sawfish.wm.commands.groups)
(autoload-command 'send-group-to-current-workspace 'sawfish.wm.commands.groups)
(autoload-command 'send-group-to-next-workspace 'sawfish.wm.commands.groups)
(autoload-command 'send-group-to-previous-workspace 'sawfish.wm.commands.groups)
(autoload-command 'move-group-to-current-viewport 'sawfish.wm.commands.groups)
(autoload-command 'move-group-left 'sawfish.wm.commands.groups)
(autoload-command 'move-group-right 'sawfish.wm.commands.groups)
(autoload-command 'move-group-up 'sawfish.wm.commands.groups)
(autoload-command 'move-group-down 'sawfish.wm.commands.groups)
(autoload-command 'raise-group 'sawfish.wm.commands.groups)
(autoload-command 'lower-group 'sawfish.wm.commands.groups)
(autoload-command 'raise-lower-group 'sawfish.wm.commands.groups)
(autoload-command 'raise-group-depth 'sawfish.wm.commands.groups)
(autoload-command 'lower-group-depth 'sawfish.wm.commands.groups)
(autoload-command 'delete-group 'sawfish.wm.commands.groups)
(autoload-command 'grow-window-left 'sawfish.wm.commands.grow-pack)
(autoload-command 'grow-window-right 'sawfish.wm.commands.grow-pack)
(autoload-command 'grow-window-up 'sawfish.wm.commands.grow-pack)
(autoload-command 'grow-window-down 'sawfish.wm.commands.grow-pack)
(autoload-command 'pack-window-left 'sawfish.wm.commands.grow-pack)
(autoload-command 'pack-window-right 'sawfish.wm.commands.grow-pack)
(autoload-command 'pack-window-up 'sawfish.wm.commands.grow-pack)
(autoload-command 'pack-window-down 'sawfish.wm.commands.grow-pack)
(autoload-command 'shrink-window-left 'sawfish.wm.commands.shrink-yank)
(autoload-command 'shrink-window-right 'sawfish.wm.commands.shrink-yank)
(autoload-command 'shrink-window-up 'sawfish.wm.commands.shrink-yank)
(autoload-command 'shrink-window-down 'sawfish.wm.commands.shrink-yank)
(autoload-command 'yank-window-left 'sawfish.wm.commands.shrink-yank)
(autoload-command 'yank-window-right 'sawfish.wm.commands.shrink-yank)
(autoload-command 'yank-window-up 'sawfish.wm.commands.shrink-yank)
(autoload-command 'yank-window-down 'sawfish.wm.commands.shrink-yank)
(autoload-command 'help:show-faq 'sawfish.wm.commands.help)
(autoload-command 'help:show-news 'sawfish.wm.commands.help)
(autoload-command 'help:show-programmer-manual 'sawfish.wm.commands.help)
(autoload-command 'help:show-homepage 'sawfish.wm.commands.help)
(autoload-command 'help:about 'sawfish.wm.commands.help)
(autoload-command 'move-cursor-right 'sawfish.wm.commands.move-cursor)
(autoload-command 'move-cursor-left 'sawfish.wm.commands.move-cursor)
(autoload-command 'move-cursor-up 'sawfish.wm.commands.move-cursor)
(autoload-command 'move-cursor-down 'sawfish.wm.commands.move-cursor)
(autoload-command 'move-cursor-right-fine 'sawfish.wm.commands.move-cursor)
(autoload-command 'move-cursor-left-fine 'sawfish.wm.commands.move-cursor)
(autoload-command 'move-cursor-up-fine 'sawfish.wm.commands.move-cursor)
(autoload-command 'move-cursor-down-fine 'sawfish.wm.commands.move-cursor)
(autoload-command 'move-cursor-northwest 'sawfish.wm.commands.move-cursor)
(autoload-command 'move-cursor-northeast 'sawfish.wm.commands.move-cursor)
(autoload-command 'move-cursor-southwest 'sawfish.wm.commands.move-cursor)
(autoload-command 'move-cursor-southeast 'sawfish.wm.commands.move-cursor)
(autoload-command 'move-cursor-northwest-fine 'sawfish.wm.commands.move-cursor)
(autoload-command 'move-cursor-northeast-fine 'sawfish.wm.commands.move-cursor)
(autoload-command 'move-cursor-southwest-fine 'sawfish.wm.commands.move-cursor)
(autoload-command 'move-cursor-southeast-fine 'sawfish.wm.commands.move-cursor)
(autoload-command 'move-cursor-center 'sawfish.wm.commands.move-cursor)
(autoload-command 'move-window-center 'sawfish.wm.commands.move-resize)
(autoload-command 'move-window-interactively 'sawfish.wm.commands.move-resize)
(autoload-command 'resize-window-interactively 'sawfish.wm.commands.move-resize)
(autoload-command 'move-selected-window 'sawfish.wm.commands.move-resize)
(autoload-command 'double-window-size 'sawfish.wm.commands.move-resize)
(autoload-command 'halve-window-size 'sawfish.wm.commands.move-resize)
(autoload-command 'resize-selected-window 'sawfish.wm.commands.move-resize)
(autoload-command 'raise-and-pass-through-click 'sawfish.wm.commands.raise-commands)
(autoload-command 'raise-and-pass-through-click-if-focused 'sawfish.wm.commands.raise-commands)
(autoload-command 'raise-or-pass-through-click 'sawfish.wm.commands.raise-commands)
(autoload-command 'raise-window-and-pass-through-click 'sawfish.wm.commands.raise-commands)
(autoload-command 'raise-group-and-pass-through-click 'sawfish.wm.commands.raise-commands)
(autoload-command 'raise-transients-and-pass-through-click 'sawfish.wm.commands.raise-commands)
(autoload-command 'size-window-add-row 'sawfish.wm.commands.size-window)
(autoload-command 'size-window-subtract-row 'sawfish.wm.commands.size-window)
(autoload-command 'size-window-add-column 'sawfish.wm.commands.size-window)
(autoload-command 'size-window-subtract-column 'sawfish.wm.commands.size-window)
(autoload-command 'slide-window-left 'sawfish.wm.commands.slide-window)
(autoload-command 'slide-window-right 'sawfish.wm.commands.slide-window)
(autoload-command 'slide-window-up 'sawfish.wm.commands.slide-window)
(autoload-command 'slide-window-down 'sawfish.wm.commands.slide-window)
(autoload-command 'slide-group-left 'sawfish.wm.commands.slide-window)
(autoload-command 'slide-group-right 'sawfish.wm.commands.slide-window)
(autoload-command 'slide-group-up 'sawfish.wm.commands.slide-window)
(autoload-command 'slide-group-down 'sawfish.wm.commands.slide-window)
(defgroup gpsy "Grow, Pack, Shrink & Yank" :group move :require sawfish.wm.commands.grow-pack)
(defgroup cycle "Window Cycling" :group focus :require sawfish.wm.commands.x-cycle)
(autoload-command 'cycle-windows 'sawfish.wm.commands.x-cycle)
(autoload-command 'cycle-windows-backwards 'sawfish.wm.commands.x-cycle)
(autoload-command 'cycle-group 'sawfish.wm.commands.x-cycle)
(autoload-command 'cycle-group-backwards 'sawfish.wm.commands.x-cycle)
(autoload-command 'cycle-among-groups 'sawfish.wm.commands.x-cycle)
(autoload-command 'cycle-among-groups-backwards 'sawfish.wm.commands.x-cycle)
(autoload-command 'cycle-prefix 'sawfish.wm.commands.x-cycle)
(autoload-command 'cycle-prefix-backwards 'sawfish.wm.commands.x-cycle)
(autoload-command 'cycle-class 'sawfish.wm.commands.x-cycle)
(autoload-command 'cycle-class-backwards 'sawfish.wm.commands.x-cycle)
(autoload-command 'cycle-dock 'sawfish.wm.commands.x-cycle)
(autoload-command 'cycle-dock-backwards 'sawfish.wm.commands.x-cycle)
(autoload-command 'xterm 'sawfish.wm.commands.launcher)
(autoload-command 'browser 'sawfish.wm.commands.launcher)
(autoload-command 'poweroff 'sawfish.wm.commands.poweroff)
(autoload-command 'rename-window 'sawfish.wm.windows)
(defgroup audio "Sound" :require sawfish.wm.ext.audio-events)
(defgroup match-window "Window Rules" :layout single :require sawfish.wm.ext.match-window)
(defgroup tooltips "Tooltips" :group appearance :require sawfish.wm.ext.tooltips)
(defgroup window-history "History" :group match-window :require sawfish.wm.ext.window-history)
(defgroup messages "Messages" :group misc :require sawfish.wm.util.prompt)
(autoload-placement-mode 'first-fit 'sawfish.wm.placement.smart #:for-normal t)
(autoload-placement-mode 'best-fit 'sawfish.wm.placement.smart #:for-normal t)
(autoload-placement-mode 'best-fit-group 'sawfish.wm.placement.smart #:for-normal t)
(autoload-placement-mode 'first-fit-or-interactive 'sawfish.wm.placement.smart #:for-normal t)
(autoload-command 'maximize-window 'sawfish.wm.state.maximize)
(autoload-command 'unmaximize-window 'sawfish.wm.state.maximize)
(autoload-command 'maximize-window-vertically 'sawfish.wm.state.maximize)
(autoload-command 'maximize-window-horizontally 'sawfish.wm.state.maximize)
(autoload-command 'maximize-window-toggle 'sawfish.wm.state.maximize)
(autoload-command 'maximize-window-horizontally-toggle 'sawfish.wm.state.maximize)
(autoload-command 'maximize-window-vertically-toggle 'sawfish.wm.state.maximize)
(autoload-command 'maximize-fill-window 'sawfish.wm.state.maximize)
(autoload-command 'maximize-fill-window-vertically 'sawfish.wm.state.maximize)
(autoload-command 'maximize-fill-window-horizontally 'sawfish.wm.state.maximize)
(autoload-command 'maximize-fill-window-toggle 'sawfish.wm.state.maximize)
(autoload-command 'maximize-fill-window-horizontally-toggle 'sawfish.wm.state.maximize)
(autoload-command 'maximize-fill-window-vertically-toggle 'sawfish.wm.state.maximize)
(autoload-command 'describe-key 'sawfish.wm.util.keymap)
(autoload-command 'describe-key-to-screen 'sawfish.wm.util.keymap)
(autoload-command 'quote-event 'sawfish.wm.util.keymap)
(autoload-placement-mode 'top-left 'sawfish.wm.placement.top-left #:for-normal t)
(autoload-placement-mode 'stagger 'sawfish.wm.placement.stagger #:for-normal t)
(autoload-placement-mode 'off-center 'sawfish.wm.placement.off-center #:for-normal t)
(autoload-command 'move-viewport-right 'sawfish.wm.viewport)
(autoload-command 'move-viewport-up 'sawfish.wm.viewport)
(autoload-command 'move-viewport-down 'sawfish.wm.viewport)
(autoload-command 'move-viewport-left 'sawfish.wm.viewport)
(autoload-command 'move-window-right 'sawfish.wm.viewport)
(autoload-command 'move-window-up 'sawfish.wm.viewport)
(autoload-command 'move-window-down 'sawfish.wm.viewport)
(autoload-command 'move-window-left 'sawfish.wm.viewport)
(autoload-command 'move-viewport-next 'sawfish.wm.commands.viewport-extras)
(autoload-command 'move-viewport-previous 'sawfish.wm.commands.viewport-extras)
(autoload-command 'move-window-previous 'sawfish.wm.commands.viewport-extras)
(autoload-command 'move-window-next 'sawfish.wm.commands.viewport-extras)
(autoload-command 'workspace-down 'sawfish.wm.ext.workspace-grid)
(autoload-command 'workspace-up 'sawfish.wm.ext.workspace-grid)
(autoload-command 'workspace-left 'sawfish.wm.ext.workspace-grid)
(autoload-command 'workspace-right 'sawfish.wm.ext.workspace-grid)
(autoload-command 'send-to-workspace-down 'sawfish.wm.ext.workspace-grid)
(autoload-command 'send-to-workspace-up 'sawfish.wm.ext.workspace-grid)
(autoload-command 'send-to-workspace-left 'sawfish.wm.ext.workspace-grid)
(autoload-command 'send-to-workspace-right 'sawfish.wm.ext.workspace-grid)
(autoload-command (quote set-viewport-linear) (quote "viewport-linear") #:type (backquote (and (labelled (backquote-unquote (_ "Index:")) (number 0)))))
(autoload-command (quote set-window-viewport-linear) (quote "viewport-linear") #:type (backquote (and (labelled (backquote-unquote (_ "Index:")) (number 0)))))
(autoload-command 'jump-or-exec 'sawfish.wm.commands.jump-or-exec)
;;; ::autoload-end::
