#ifdef SEMASTART
__SEMASTART = DIAG_START_SEMA,
#undef SEMASTART
#endif

DIAG(err_abstract_type_in_decl, CLASS_ERROR, diag::MAP_ERROR, "%select{return|parameter|variable|field}0 type %1 is an abstract class", 0, true, false, 3)
DIAG(err_access, CLASS_ERROR, diag::MAP_ERROR, "%1 is a %select{private|protected}0 member of %3", 0, true, true, 3)
DIAG(err_access_assign_base, CLASS_ERROR, diag::MAP_ERROR, "base class %0 has %select{private|protected}1 copy assignment operator", 0, true, true, 3)
DIAG(err_access_assign_field, CLASS_ERROR, diag::MAP_ERROR, "field of type %1 has %select{private|protected}2 copy assignment operator", 0, true, true, 3)
DIAG(err_access_base, CLASS_ERROR, diag::MAP_ERROR, "%select{base class|inherited virtual base class}0 %1 has %select{private|protected}3 %select{constructor|copy constructor|copy assignment operator|destructor}2", 0, true, true, 3)
DIAG(err_access_copy_base, CLASS_ERROR, diag::MAP_ERROR, "base class %0 has %select{private|protected}1 copy constructor", 0, true, true, 3)
DIAG(err_access_copy_field, CLASS_ERROR, diag::MAP_ERROR, "field of type %1 has %select{private|protected}2 copy constructor", 0, true, true, 3)
DIAG(err_access_ctor, CLASS_ERROR, diag::MAP_ERROR, "calling a %select{private|protected}0 constructor of class %2", 0, true, true, 3)
DIAG(err_access_ctor_field, CLASS_ERROR, diag::MAP_ERROR, "field of type %1 has %select{private|protected}2 constructor", 0, true, true, 3)
DIAG(err_access_dtor, CLASS_ERROR, diag::MAP_ERROR, "calling a %select{private|protected}1 destructor of class %0", 0, true, true, 3)
DIAG(err_access_dtor_base, CLASS_ERROR, diag::MAP_ERROR, "base class %0 has %select{private|protected}1 destructor", 0, true, true, 3)
DIAG(err_access_dtor_exception, CLASS_ERROR, diag::MAP_ERROR, "exception object of type %0 has %select{private|protected}1 destructor", 0, true, true, 3)
DIAG(err_access_dtor_field, CLASS_ERROR, diag::MAP_ERROR, "field of type %1 has %select{private|protected}2 destructor", 0, true, true, 3)
DIAG(err_access_dtor_ivar, CLASS_ERROR, diag::MAP_ERROR, "instance variable of type %0 has %select{private|protected}1 destructor", 0, true, true, 3)
DIAG(err_access_dtor_temp, CLASS_ERROR, diag::MAP_ERROR, "temporary of type %0 has %select{private|protected}1 destructor", 0, true, true, 3)
DIAG(err_access_dtor_var, CLASS_ERROR, diag::MAP_ERROR, "variable of type %1 has %select{private|protected}2 destructor", 0, true, true, 3)
DIAG(err_access_dtor_vbase, CLASS_ERROR, diag::MAP_ERROR, "inherited virtual base class %0 has %select{private|protected}1 destructor", 0, true, true, 3)
DIAG(err_access_field, CLASS_ERROR, diag::MAP_ERROR, "field of type %0 has %select{private|protected}2 %select{constructor|copy constructor|copy assignment operator|destructor}1", 0, true, true, 3)
DIAG(err_access_outside_class, CLASS_ERROR, diag::MAP_ERROR, "access to %select{private|protected}0 member outside any class context", 0, true, true, 3)
DIAG(err_addr_ovl_ambiguous, CLASS_ERROR, diag::MAP_ERROR, "address of overloaded function %0 is ambiguous", 0, true, false, 3)
DIAG(err_addr_ovl_no_qualifier, CLASS_ERROR, diag::MAP_ERROR, "can't form member pointer of type %0 without '&' and class name", 0, true, false, 3)
DIAG(err_addr_ovl_no_viable, CLASS_ERROR, diag::MAP_ERROR, "address of overloaded function %0 does not match required type %1", 0, true, false, 3)
DIAG(err_addr_ovl_not_func_ptrref, CLASS_ERROR, diag::MAP_ERROR, "address of overloaded function %0 cannot be converted to type %1", 0, true, false, 3)
DIAG(err_alias_not_supported_on_darwin, CLASS_ERROR, diag::MAP_ERROR, "only weak aliases are supported on darwin", 0, true, false, 3)
DIAG(err_allocation_of_abstract_type, CLASS_ERROR, diag::MAP_ERROR, "allocating an object of abstract class type %0", 0, true, false, 3)
DIAG(err_altivec_empty_initializer, CLASS_ERROR, diag::MAP_ERROR, "expected initializer", 0, true, false, 3)
DIAG(err_ambiguous_base_to_derived_cast, CLASS_ERROR, diag::MAP_ERROR, "ambiguous cast from base %0 to derived %1:%2", 0, true, false, 3)
DIAG(err_ambiguous_delete_operand, CLASS_ERROR, diag::MAP_ERROR, "ambiguous conversion of delete expression of type %0 to a pointer", 0, true, false, 3)
DIAG(err_ambiguous_derived_to_base_conv, CLASS_ERROR, diag::MAP_ERROR, "ambiguous conversion from derived class %0 to base class %1:%2", 0, true, false, 3)
DIAG(err_ambiguous_member_multiple_subobject_types, CLASS_ERROR, diag::MAP_ERROR, "member %0 found in multiple base classes of different types", 0, true, false, 3)
DIAG(err_ambiguous_member_multiple_subobjects, CLASS_ERROR, diag::MAP_ERROR, "non-static member %0 found in multiple base-class subobjects of type %1:%2", 0, true, false, 3)
DIAG(err_ambiguous_memptr_conv, CLASS_ERROR, diag::MAP_ERROR, "ambiguous conversion from pointer to member of %select{base|derived}0 class %1 to pointer to member of %select{derived|base}0 class %2:%3", 0, true, false, 3)
DIAG(err_ambiguous_reference, CLASS_ERROR, diag::MAP_ERROR, "reference to %0 is ambiguous", 0, true, false, 3)
DIAG(err_ambiguous_suitable_delete_member_function_found, CLASS_ERROR, diag::MAP_ERROR, "multiple suitable %0 functions in %1", 0, true, false, 3)
DIAG(err_ambiguous_tag_hiding, CLASS_ERROR, diag::MAP_ERROR, "a type named %0 is hidden by a declaration in a different namespace", 0, true, false, 3)
DIAG(err_anon_bitfield_has_negative_width, CLASS_ERROR, diag::MAP_ERROR, "anonymous bit-field has negative width (%0)", 0, true, false, 3)
DIAG(err_anon_bitfield_width_exceeds_type_size, CLASS_ERROR, diag::MAP_ERROR, "size of anonymous bit-field (%0 bits) exceeds size of its type (%1 bits)", 0, true, false, 3)
DIAG(err_anonymous_record_bad_member, CLASS_ERROR, diag::MAP_ERROR, "anonymous %select{struct|union}0 can only contain non-static data members", 0, true, false, 3)
DIAG(err_anonymous_record_nonpublic_member, CLASS_ERROR, diag::MAP_ERROR, "anonymous %select{struct|union}0 cannot contain a %select{private|protected}1 data member", 0, true, false, 3)
DIAG(err_anonymous_record_with_function, CLASS_ERROR, diag::MAP_ERROR, "functions cannot be declared in an anonymous %select{struct|union}0", 0, true, false, 3)
DIAG(err_anonymous_record_with_static, CLASS_ERROR, diag::MAP_ERROR, "static members cannot be declared in an anonymous %select{struct|union}0", 0, true, false, 3)
DIAG(err_anonymous_record_with_type, CLASS_ERROR, diag::MAP_ERROR, "types cannot be declared in an anonymous %select{struct|union}0", 0, true, false, 3)
DIAG(err_anonymous_struct_member_redecl, CLASS_ERROR, diag::MAP_ERROR, "member of anonymous struct redeclares %0", 0, true, false, 3)
DIAG(err_anonymous_struct_not_member, CLASS_ERROR, diag::MAP_ERROR, "anonymous %select{structs|structs and classes}0 must be %select{struct or union|class}0 members", 0, true, false, 3)
DIAG(err_anonymous_union_member_redecl, CLASS_ERROR, diag::MAP_ERROR, "member of anonymous union redeclares %0", 0, true, false, 3)
DIAG(err_anonymous_union_not_static, CLASS_ERROR, diag::MAP_ERROR, "anonymous unions at namespace or global scope must be declared 'static'", 0, true, false, 3)
DIAG(err_anonymous_union_with_storage_spec, CLASS_ERROR, diag::MAP_ERROR, "anonymous union at class scope must not have a storage specifier", 0, true, false, 3)
DIAG(err_arg_with_address_space, CLASS_ERROR, diag::MAP_ERROR, "parameter may not be qualified with an address space", 0, true, false, 3)
DIAG(err_argument_invalid_range, CLASS_ERROR, diag::MAP_ERROR, "argument should be a value from %0 to %1", 0, true, false, 3)
DIAG(err_arithmetic_nonfragile_interface, CLASS_ERROR, diag::MAP_ERROR, "arithmetic on pointer to interface %0, which is not a constant size in non-fragile ABI", 0, true, false, 3)
DIAG(err_array_designator_empty_range, CLASS_ERROR, diag::MAP_ERROR, "array designator range [%0, %1] is empty", 0, true, false, 3)
DIAG(err_array_designator_negative, CLASS_ERROR, diag::MAP_ERROR, "array designator value '%0' is negative", 0, true, false, 3)
DIAG(err_array_designator_non_array, CLASS_ERROR, diag::MAP_ERROR, "array designator cannot initialize non-array type %0", 0, true, false, 3)
DIAG(err_array_designator_too_large, CLASS_ERROR, diag::MAP_ERROR, "array designator index (%0) exceeds array bounds (%1)", 0, true, false, 3)
DIAG(err_array_init_different_type, CLASS_ERROR, diag::MAP_ERROR, "cannot initialize array of type %0 with array of type %1", 0, true, false, 3)
DIAG(err_array_init_list_required, CLASS_ERROR, diag::MAP_ERROR, "initialization with '{...}' expected for array", 0, true, false, 3)
DIAG(err_array_init_non_constant_array, CLASS_ERROR, diag::MAP_ERROR, "cannot initialize array of type %0 with non-constant array of type %1", 0, true, false, 3)
DIAG(err_array_init_not_init_list, CLASS_ERROR, diag::MAP_ERROR, "array initializer must be an initializer list%select{| or string literal}0", 0, true, false, 3)
DIAG(err_array_new_needs_size, CLASS_ERROR, diag::MAP_ERROR, "array size must be specified in new expressions", 0, true, false, 3)
DIAG(err_array_of_abstract_type, CLASS_ERROR, diag::MAP_ERROR, "array of abstract class type %0", 0, true, false, 3)
DIAG(err_array_size_ambiguous_conversion, CLASS_ERROR, diag::MAP_ERROR, "ambiguous conversion of array size expression of type %0 to an integral or enumeration type", 0, true, false, 3)
DIAG(err_array_size_explicit_conversion, CLASS_ERROR, diag::MAP_ERROR, "array size expression of type %0 requires explicit conversion to type %1", 0, true, false, 3)
DIAG(err_array_size_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "array size expression has incomplete class type %0", 0, true, false, 3)
DIAG(err_array_size_non_int, CLASS_ERROR, diag::MAP_ERROR, "size of array has non-integer type %0", 0, true, false, 3)
DIAG(err_array_size_not_integral, CLASS_ERROR, diag::MAP_ERROR, "array size expression must have integral or enumerated type, not %0", 0, true, false, 3)
DIAG(err_array_star_in_function_definition, CLASS_ERROR, diag::MAP_ERROR, "variable length array must be bound in function definition", 0, true, false, 3)
DIAG(err_array_star_outside_prototype, CLASS_ERROR, diag::MAP_ERROR, "star modifier used outside of function prototype", 0, true, false, 3)
DIAG(err_array_too_large, CLASS_ERROR, diag::MAP_ERROR, "array is too large (%0 elements)", 0, true, false, 3)
DIAG(err_as_qualified_auto_decl, CLASS_ERROR, diag::MAP_ERROR, "automatic variable qualified with an address space", 0, true, false, 3)
DIAG(err_asm_invalid_input_constraint, CLASS_ERROR, diag::MAP_ERROR, "invalid input constraint '%0' in asm", 0, true, false, 4)
DIAG(err_asm_invalid_lvalue_in_input, CLASS_ERROR, diag::MAP_ERROR, "invalid lvalue in asm input for constraint '%0'", 0, true, false, 4)
DIAG(err_asm_invalid_lvalue_in_output, CLASS_ERROR, diag::MAP_ERROR, "invalid lvalue in asm output", 0, true, false, 4)
DIAG(err_asm_invalid_output_constraint, CLASS_ERROR, diag::MAP_ERROR, "invalid output constraint '%0' in asm", 0, true, false, 4)
DIAG(err_asm_invalid_type_in_input, CLASS_ERROR, diag::MAP_ERROR, "invalid type %0 in asm input for constraint '%1'", 0, true, false, 4)
DIAG(err_asm_tying_incompatible_types, CLASS_ERROR, diag::MAP_ERROR, "unsupported inline asm: input with type %0 matching output with type %1", 0, true, false, 4)
DIAG(err_asm_unknown_register_name, CLASS_ERROR, diag::MAP_ERROR, "unknown register name '%0' in asm", 0, true, false, 4)
DIAG(err_asm_wide_character, CLASS_ERROR, diag::MAP_ERROR, "wide string is invalid in 'asm'", 0, true, false, 4)
DIAG(err_assignment_requires_nonfragile_object, CLASS_ERROR, diag::MAP_ERROR, "cannot assign to class object in non-fragile ABI (%0 invalid)", 0, true, false, 3)
DIAG(err_at_least_one_initializer_needed_to_size_array, CLASS_ERROR, diag::MAP_ERROR, "at least one initializer value required to size array", 0, true, false, 3)
DIAG(err_atdef_nonfragile_interface, CLASS_ERROR, diag::MAP_ERROR, "invalid application of @defs in non-fragile ABI", 0, true, false, 3)
DIAG(err_atomic_builtin_must_be_pointer, CLASS_ERROR, diag::MAP_ERROR, "first argument to atomic builtin must be a pointer (%0 invalid)", 0, true, false, 3)
DIAG(err_atomic_builtin_must_be_pointer_intptr, CLASS_ERROR, diag::MAP_ERROR, "first argument to atomic builtin must be a pointer to integer or pointer (%0 invalid)", 0, true, false, 3)
DIAG(err_atomic_builtin_pointer_size, CLASS_ERROR, diag::MAP_ERROR, "first argument to atomic builtin must be a pointer to 1,2,4,8 or 16 byte type (%0 invalid)", 0, true, false, 3)
DIAG(err_attr_wrong_decl, CLASS_ERROR, diag::MAP_ERROR, "'%0' attribute invalid on this declaration, requires typedef or value", 0, true, false, 3)
DIAG(err_attribute_address_multiple_qualifiers, CLASS_ERROR, diag::MAP_ERROR, "multiple address spaces specified for type", 0, true, false, 3)
DIAG(err_attribute_address_space_negative, CLASS_ERROR, diag::MAP_ERROR, "address space is negative", 0, true, false, 3)
DIAG(err_attribute_address_space_not_int, CLASS_ERROR, diag::MAP_ERROR, "address space attribute requires an integer constant", 0, true, false, 3)
DIAG(err_attribute_address_space_too_high, CLASS_ERROR, diag::MAP_ERROR, "address space is larger than the maximum supported (%0)", 0, true, false, 3)
DIAG(err_attribute_aligned_not_power_of_two, CLASS_ERROR, diag::MAP_ERROR, "requested alignment is not a power of 2", 0, true, false, 3)
DIAG(err_attribute_argument_n_not_int, CLASS_ERROR, diag::MAP_ERROR, "'%0' attribute requires parameter %1 to be an integer constant", 0, true, false, 3)
DIAG(err_attribute_argument_n_not_string, CLASS_ERROR, diag::MAP_ERROR, "'%0' attribute requires parameter %1 to be a string", 0, true, false, 3)
DIAG(err_attribute_argument_not_int, CLASS_ERROR, diag::MAP_ERROR, "'%0' attribute requires integer constant", 0, true, false, 3)
DIAG(err_attribute_argument_out_of_bounds, CLASS_ERROR, diag::MAP_ERROR, "'%0' attribute parameter %1 is out of bounds", 0, true, false, 3)
DIAG(err_attribute_argument_outof_range, CLASS_ERROR, diag::MAP_ERROR, "init_priority attribute requires integer constant between 101 and 65535 inclusive", 0, true, false, 3)
DIAG(err_attribute_bad_neon_vector_size, CLASS_ERROR, diag::MAP_ERROR, "Neon vector size must be 64 or 128 bits", 0, true, false, 3)
DIAG(err_attribute_can_be_applied_only_to_symbol_declaration, CLASS_ERROR, diag::MAP_ERROR, "%0 attribute can be applied only to symbol declaration", 0, true, false, 3)
DIAG(err_attribute_cleanup_arg_not_found, CLASS_ERROR, diag::MAP_ERROR, "'cleanup' argument %0 not found", 0, true, false, 3)
DIAG(err_attribute_cleanup_arg_not_function, CLASS_ERROR, diag::MAP_ERROR, "'cleanup' argument %0 is not a function", 0, true, false, 3)
DIAG(err_attribute_cleanup_func_arg_incompatible_type, CLASS_ERROR, diag::MAP_ERROR, "'cleanup' function %0 parameter has type %1 which is incompatible with type %2", 0, true, false, 3)
DIAG(err_attribute_cleanup_func_must_take_one_arg, CLASS_ERROR, diag::MAP_ERROR, "'cleanup' function %0 must take 1 parameter", 0, true, false, 3)
DIAG(err_attribute_invalid_implicit_this_argument, CLASS_ERROR, diag::MAP_ERROR, "'%0' attribute is invalid for the implicit this argument", 0, true, false, 3)
DIAG(err_attribute_invalid_size, CLASS_ERROR, diag::MAP_ERROR, "vector size not an integral multiple of component size", 0, true, false, 3)
DIAG(err_attribute_invalid_vector_type, CLASS_ERROR, diag::MAP_ERROR, "invalid vector element type %0", 0, true, false, 3)
DIAG(err_attribute_missing_parameter_name, CLASS_ERROR, diag::MAP_ERROR, "attribute requires unquoted parameter", 0, true, false, 3)
DIAG(err_attribute_multiple_objc_gc, CLASS_ERROR, diag::MAP_ERROR, "multiple garbage collection attributes specified for type", 0, true, false, 3)
DIAG(err_attribute_not_string, CLASS_ERROR, diag::MAP_ERROR, "argument to %0 attribute was not a string literal", 0, true, false, 3)
DIAG(err_attribute_overloadable_missing, CLASS_ERROR, diag::MAP_ERROR, "%select{overloaded function|redeclaration of}0 %1 must have the 'overloadable' attribute", 0, true, false, 3)
DIAG(err_attribute_overloadable_no_prototype, CLASS_ERROR, diag::MAP_ERROR, "'overloadable' function %0 must have a prototype", 0, true, false, 3)
DIAG(err_attribute_overloadable_not_function, CLASS_ERROR, diag::MAP_ERROR, "'overloadable' attribute can only be applied to a function", 0, true, false, 3)
DIAG(err_attribute_regparm_invalid_number, CLASS_ERROR, diag::MAP_ERROR, "'regparm' parameter must be between 0 and %0 inclusive", 0, true, false, 3)
DIAG(err_attribute_regparm_wrong_platform, CLASS_ERROR, diag::MAP_ERROR, "'regparm' is not valid on this platform", 0, true, false, 3)
DIAG(err_attribute_requires_objc_interface, CLASS_ERROR, diag::MAP_ERROR, "attribute may only be applied to an Objective-C interface", 0, true, false, 3)
DIAG(err_attribute_section_invalid_for_target, CLASS_ERROR, diag::MAP_ERROR, "argument to 'section' attribute is not valid for this target: %0", 0, true, false, 3)
DIAG(err_attribute_section_local_variable, CLASS_ERROR, diag::MAP_ERROR, "'section' attribute is not valid on local variables", 0, true, false, 3)
DIAG(err_attribute_sentinel_less_than_zero, CLASS_ERROR, diag::MAP_ERROR, "'sentinel' parameter 1 less than zero", 0, true, false, 3)
DIAG(err_attribute_sentinel_not_zero_or_one, CLASS_ERROR, diag::MAP_ERROR, "'sentinel' parameter 2 not 0 or 1", 0, true, false, 3)
DIAG(err_attribute_too_many_arguments, CLASS_ERROR, diag::MAP_ERROR, "attribute takes no more than %0 argument%s0", 0, true, false, 3)
DIAG(err_attribute_uuid_malformed_guid, CLASS_ERROR, diag::MAP_ERROR, "uuid attribute contains a malformed GUID", 0, true, false, 3)
DIAG(err_attribute_vecreturn_only_pod_record, CLASS_ERROR, diag::MAP_ERROR, "the vecreturn attribute can only be used on a POD (plain old data) class or structure (i.e. no virtual functions)", 0, true, false, 3)
DIAG(err_attribute_vecreturn_only_vector_member, CLASS_ERROR, diag::MAP_ERROR, "the vecreturn attribute can only be used on a class or structure with one member, which must be a vector", 0, true, false, 3)
DIAG(err_attribute_weak_static, CLASS_ERROR, diag::MAP_ERROR, "weak declaration cannot have internal linkage", 0, true, false, 3)
DIAG(err_attribute_weakref_not_global_context, CLASS_ERROR, diag::MAP_ERROR, "weakref declaration of '%0' must be in a global context", 0, true, false, 3)
DIAG(err_attribute_weakref_not_static, CLASS_ERROR, diag::MAP_ERROR, "weakref declaration must have internal linkage", 0, true, false, 3)
DIAG(err_attribute_weakref_without_alias, CLASS_ERROR, diag::MAP_ERROR, "weakref declaration of '%0' must also have an alias attribute", 0, true, false, 3)
DIAG(err_attribute_wrong_decl_type, CLASS_ERROR, diag::MAP_ERROR, "%0 attribute only applies to %select{functions|unions|variables and functions|functions and methods|parameters|parameters and methods|functions, methods and blocks|classes and virtual methods|functions, methods, and parameters|classes|virtual methods|class members|variables|methods}1", 0, true, false, 3)
DIAG(err_attribute_wrong_number_arguments, CLASS_ERROR, diag::MAP_ERROR, "attribute %plural{0:takes no arguments|1:takes one argument|:requires exactly %0 arguments}0", 0, true, false, 3)
DIAG(err_attribute_zero_size, CLASS_ERROR, diag::MAP_ERROR, "zero vector size", 0, true, false, 3)
DIAG(err_attributes_are_not_compatible, CLASS_ERROR, diag::MAP_ERROR, "%0 and %1 attributes are not compatible", 0, true, false, 3)
DIAG(err_auto_different_deductions, CLASS_ERROR, diag::MAP_ERROR, "'auto' deduced as %0 in declaration of %1 and deduced as %2 in declaration of %3", 0, true, false, 3)
DIAG(err_auto_missing_trailing_return, CLASS_ERROR, diag::MAP_ERROR, "'auto' return without trailing return type", 0, true, false, 3)
DIAG(err_auto_new_ctor_multiple_expressions, CLASS_ERROR, diag::MAP_ERROR, "new expression for type %0 contains multiple constructor arguments", 0, true, false, 3)
DIAG(err_auto_new_deduction_failure, CLASS_ERROR, diag::MAP_ERROR, "new expression for type %0 has incompatible constructor argument of type %1", 0, true, false, 3)
DIAG(err_auto_new_requires_ctor_arg, CLASS_ERROR, diag::MAP_ERROR, "new expression for type %0 requires a constructor argument", 0, true, false, 3)
DIAG(err_auto_not_allowed, CLASS_ERROR, diag::MAP_ERROR, "'auto' not allowed %select{in function prototype|in struct member|in union member|in class member|in exception declaration|in template parameter|in block literal|in template argument|in typedef|in function return type|here}0", 0, true, false, 3)
DIAG(err_auto_var_deduction_failure, CLASS_ERROR, diag::MAP_ERROR, "variable %0 with type %1 has incompatible initializer of type %2", 0, true, false, 3)
DIAG(err_auto_var_init_multiple_expressions, CLASS_ERROR, diag::MAP_ERROR, "initializer for variable %0 with type %1 contains multiple expressions", 0, true, false, 3)
DIAG(err_auto_var_requires_init, CLASS_ERROR, diag::MAP_ERROR, "declaration of variable %0 with type %1 requires an initializer", 0, true, false, 3)
DIAG(err_auto_variable_cannot_appear_in_own_initializer, CLASS_ERROR, diag::MAP_ERROR, "variable %0 declared with 'auto' type cannot appear in its own initializer", 0, true, false, 3)
DIAG(err_bad_const_cast_dest, CLASS_ERROR, diag::MAP_ERROR, "%select{const_cast||||C-style cast|functional-style cast}0 to %2, which is not a reference, pointer-to-object, or pointer-to-data-member", 0, true, false, 3)
DIAG(err_bad_cstyle_cast_overload, CLASS_ERROR, diag::MAP_ERROR, "address of overloaded function %0 cannot be cast to type %1", 0, true, false, 3)
DIAG(err_bad_cxx_cast_const_away, CLASS_ERROR, diag::MAP_ERROR, "%select{const_cast|static_cast|reinterpret_cast|dynamic_cast|C-style cast|functional-style cast}0 from %1 to %2 casts away constness", 0, true, false, 3)
DIAG(err_bad_cxx_cast_generic, CLASS_ERROR, diag::MAP_ERROR, "%select{const_cast|static_cast|reinterpret_cast|dynamic_cast|C-style cast|functional-style cast}0 from %1 to %2 is not allowed", 0, true, false, 3)
DIAG(err_bad_cxx_cast_member_pointer_size, CLASS_ERROR, diag::MAP_ERROR, "cannot %select{||reinterpret_cast||C-style cast|}0 from member pointer type %1 to member pointer type %2 of different size", 0, true, false, 3)
DIAG(err_bad_cxx_cast_rvalue, CLASS_ERROR, diag::MAP_ERROR, "%select{const_cast|static_cast|reinterpret_cast|dynamic_cast|C-style cast|functional-style cast}0 from rvalue to reference type %2", 0, true, false, 3)
DIAG(err_bad_cxx_cast_scalar_to_vector_different_size, CLASS_ERROR, diag::MAP_ERROR, "%select{||reinterpret_cast||C-style cast|}0 from scalar %1 to vector %2 of different size", 0, true, false, 3)
DIAG(err_bad_cxx_cast_vector_to_scalar_different_size, CLASS_ERROR, diag::MAP_ERROR, "%select{||reinterpret_cast||C-style cast|}0 from vector %1 to scalar %2 of different size", 0, true, false, 3)
DIAG(err_bad_cxx_cast_vector_to_vector_different_size, CLASS_ERROR, diag::MAP_ERROR, "%select{||reinterpret_cast||C-style cast|}0 from vector %1 to vector %2 of different size", 0, true, false, 3)
DIAG(err_bad_dynamic_cast_incomplete, CLASS_ERROR, diag::MAP_ERROR, "%0 is an incomplete type", 0, true, false, 3)
DIAG(err_bad_dynamic_cast_not_class, CLASS_ERROR, diag::MAP_ERROR, "%0 is not a class", 0, true, false, 3)
DIAG(err_bad_dynamic_cast_not_polymorphic, CLASS_ERROR, diag::MAP_ERROR, "%0 is not polymorphic", 0, true, false, 3)
DIAG(err_bad_dynamic_cast_not_ptr, CLASS_ERROR, diag::MAP_ERROR, "%0 is not a pointer", 0, true, false, 3)
DIAG(err_bad_dynamic_cast_not_ref_or_ptr, CLASS_ERROR, diag::MAP_ERROR, "%0 is not a reference or pointer", 0, true, false, 3)
DIAG(err_bad_language, CLASS_ERROR, diag::MAP_ERROR, "unknown linkage language", 0, true, false, 3)
DIAG(err_bad_lvalue_to_rvalue_cast, CLASS_ERROR, diag::MAP_ERROR, "cannot cast from lvalue of type %1 to rvalue reference type %2; types are not compatible", 0, true, false, 3)
DIAG(err_bad_memptr_lhs, CLASS_ERROR, diag::MAP_ERROR, "left hand operand to %0 must be a %select{|pointer to }1class compatible with the right hand operand, but is %2", 0, true, false, 3)
DIAG(err_bad_memptr_rhs, CLASS_ERROR, diag::MAP_ERROR, "right hand operand to %0 has non pointer-to-member type %1", 0, true, false, 3)
DIAG(err_bad_new_type, CLASS_ERROR, diag::MAP_ERROR, "cannot allocate %select{function|reference}1 type %0 with new", 0, true, false, 3)
DIAG(err_bad_parameter_name, CLASS_ERROR, diag::MAP_ERROR, "'%0' cannot be the name of a parameter", 0, true, false, 3)
DIAG(err_bad_receiver_type, CLASS_ERROR, diag::MAP_ERROR, "bad receiver type %0", 0, true, false, 3)
DIAG(err_bad_reinterpret_cast_overload, CLASS_ERROR, diag::MAP_ERROR, "reinterpret_cast cannot resolve overloaded function %0 to type %1", 0, true, false, 3)
DIAG(err_bad_reinterpret_cast_small_int, CLASS_ERROR, diag::MAP_ERROR, "cast from pointer to smaller type %2 loses information", 0, true, false, 3)
DIAG(err_bad_static_cast_incomplete, CLASS_ERROR, diag::MAP_ERROR, "%0 is an incomplete type", 0, true, false, 3)
DIAG(err_bad_static_cast_member_pointer_nonmp, CLASS_ERROR, diag::MAP_ERROR, "cannot cast from type %1 to member pointer type %2", 0, true, false, 3)
DIAG(err_bad_static_cast_overload, CLASS_ERROR, diag::MAP_ERROR, "address of overloaded function %0 cannot be static_cast to type %1", 0, true, false, 3)
DIAG(err_bad_static_cast_pointer_nonpointer, CLASS_ERROR, diag::MAP_ERROR, "cannot cast from type %1 to pointer type %2", 0, true, false, 3)
DIAG(err_bad_variable_name, CLASS_ERROR, diag::MAP_ERROR, "'%0' cannot be the name of a variable or data member", 0, true, false, 3)
DIAG(err_base_clause_on_union, CLASS_ERROR, diag::MAP_ERROR, "unions cannot have base classes", 0, true, false, 3)
DIAG(err_base_init_direct_and_virtual, CLASS_ERROR, diag::MAP_ERROR, "base class initializer %0 names both a direct base class and an inherited virtual base class", 0, true, false, 3)
DIAG(err_base_init_does_not_name_class, CLASS_ERROR, diag::MAP_ERROR, "constructor initializer %0 does not name a class", 0, true, false, 3)
DIAG(err_base_must_be_class, CLASS_ERROR, diag::MAP_ERROR, "base specifier must name a class", 0, true, false, 3)
DIAG(err_bitfield_has_negative_width, CLASS_ERROR, diag::MAP_ERROR, "bit-field %0 has negative width (%1)", 0, true, false, 3)
DIAG(err_bitfield_has_zero_width, CLASS_ERROR, diag::MAP_ERROR, "named bit-field %0 has zero width", 0, true, false, 3)
DIAG(err_bitfield_width_exceeds_type_size, CLASS_ERROR, diag::MAP_ERROR, "size of bit-field %0 (%1 bits) exceeds size of its type (%2 bits)", 0, true, false, 3)
DIAG(err_block_decl_ref_not_modifiable_lvalue, CLASS_ERROR, diag::MAP_ERROR, "variable is not assignable (missing __block type specifier)", 0, true, false, 3)
DIAG(err_block_extern_cant_init, CLASS_ERROR, diag::MAP_ERROR, "'extern' variable cannot have an initializer", 0, true, false, 3)
DIAG(err_block_on_nonlocal, CLASS_ERROR, diag::MAP_ERROR, "__block attribute not allowed, only allowed on local variables", 0, true, false, 3)
DIAG(err_block_on_vm, CLASS_ERROR, diag::MAP_ERROR, "__block attribute not allowed on declaration with a variably modified type", 0, true, false, 3)
DIAG(err_block_return_missing_expr, CLASS_ERROR, diag::MAP_ERROR, "non-void block should return a value", 0, true, false, 3)
DIAG(err_block_returning_array_function, CLASS_ERROR, diag::MAP_ERROR, "block cannot return %select{array|function}0 type %1", 0, true, false, 3)
DIAG(err_block_with_return_type_requires_args, CLASS_ERROR, diag::MAP_ERROR, "block with explicit return type requires argument list", 0, true, false, 3)
DIAG(err_blocks_disable, CLASS_ERROR, diag::MAP_ERROR, "blocks support disabled - compile with -fblocks or pick a deployment target that supports them", 0, true, false, 3)
DIAG(err_break_not_in_loop_or_switch, CLASS_ERROR, diag::MAP_ERROR, "'break' statement not in loop or switch statement", 0, true, false, 3)
DIAG(err_builtin_definition, CLASS_ERROR, diag::MAP_ERROR, "definition of builtin function %0", 0, true, false, 3)
DIAG(err_builtin_direct_init_more_than_one_arg, CLASS_ERROR, diag::MAP_ERROR, "initializer of a builtin type can only take one argument", 0, true, false, 3)
DIAG(err_builtin_func_cast_more_than_one_arg, CLASS_ERROR, diag::MAP_ERROR, "function-style cast to a builtin type can only take one argument", 0, true, false, 3)
DIAG(err_builtin_longjmp_invalid_val, CLASS_ERROR, diag::MAP_ERROR, "argument to __builtin_longjmp must be a constant 1", 0, true, false, 3)
DIAG(err_c99_array_usage_cxx, CLASS_ERROR, diag::MAP_ERROR, "C99-specific array features are not permitted in C++", 0, true, false, 3)
DIAG(err_call_function_incomplete_return, CLASS_ERROR, diag::MAP_ERROR, "calling %0 with incomplete return type %1", 0, true, false, 3)
DIAG(err_call_incomplete_argument, CLASS_ERROR, diag::MAP_ERROR, "argument type %0 is incomplete", 0, true, false, 3)
DIAG(err_call_incomplete_return, CLASS_ERROR, diag::MAP_ERROR, "calling function with incomplete return type %0", 0, true, false, 3)
DIAG(err_cannot_determine_declared_type_of_overloaded_function, CLASS_ERROR, diag::MAP_ERROR, "cannot determine the type of an overloaded function", 0, true, false, 3)
DIAG(err_cannot_form_pointer_to_member_of_reference_type, CLASS_ERROR, diag::MAP_ERROR, "cannot form a pointer-to-member to member %0 of reference type %1", 0, true, false, 3)
DIAG(err_cannot_initialize_decl, CLASS_ERROR, diag::MAP_ERROR, "cannot initialize %0 with an %select{rvalue|lvalue}1 of type %2", 0, true, false, 3)
DIAG(err_cannot_initialize_decl_noname, CLASS_ERROR, diag::MAP_ERROR, "cannot initialize a value of type %0 with an %select{rvalue|lvalue}1 of type %2", 0, true, false, 3)
DIAG(err_cannot_pass_objc_interface_to_vararg, CLASS_ERROR, diag::MAP_ERROR, "cannot pass object with interface type %0 by-value through variadic %select{function|block|method}1", 0, true, false, 3)
DIAG(err_case_not_in_switch, CLASS_ERROR, diag::MAP_ERROR, "'case' statement not in switch statement", 0, true, false, 3)
DIAG(err_cast_pointer_from_non_pointer_int, CLASS_ERROR, diag::MAP_ERROR, "operand of type %0 cannot be cast to a pointer type", 0, true, false, 3)
DIAG(err_cast_pointer_to_non_pointer_int, CLASS_ERROR, diag::MAP_ERROR, "pointer cannot be cast to type %0", 0, true, false, 3)
DIAG(err_cast_selector_expr, CLASS_ERROR, diag::MAP_ERROR, "cannot type cast @selector expression", 0, true, false, 3)
DIAG(err_catch_incomplete, CLASS_ERROR, diag::MAP_ERROR, "cannot catch incomplete type %0", 0, true, false, 3)
DIAG(err_catch_param_not_objc_type, CLASS_ERROR, diag::MAP_ERROR, "@catch parameter is not a pointer to an interface type", 0, true, false, 3)
DIAG(err_catch_rvalue_ref, CLASS_ERROR, diag::MAP_ERROR, "cannot catch exceptions by rvalue reference", 0, true, false, 3)
DIAG(err_cconv_change, CLASS_ERROR, diag::MAP_ERROR, "function declared '%0' here was previously declared %select{'%2'|without calling convention}1", 0, true, false, 3)
DIAG(err_cconv_knr, CLASS_ERROR, diag::MAP_ERROR, "function with no prototype cannot use %0 calling convention", 0, true, false, 3)
DIAG(err_cconv_varargs, CLASS_ERROR, diag::MAP_ERROR, "variadic function cannot use %0 calling convention", 0, true, false, 3)
DIAG(err_cfstring_literal_not_string_constant, CLASS_ERROR, diag::MAP_ERROR, "CFString literal is not a string constant", 0, true, false, 3)
DIAG(err_class_extension_after_impl, CLASS_ERROR, diag::MAP_ERROR, "cannot declare class extension for %0 after class implementation", 0, true, false, 3)
DIAG(err_class_marked_final_used_as_base, CLASS_ERROR, diag::MAP_ERROR, "base %0 is marked 'final'", 0, true, false, 3)
DIAG(err_class_redeclared_with_different_access, CLASS_ERROR, diag::MAP_ERROR, "%0 redeclared with '%1' access", 0, true, false, 3)
DIAG(err_collection_expr_type, CLASS_ERROR, diag::MAP_ERROR, "collection expression type %0 is not a valid object", 0, true, false, 3)
DIAG(err_conditional_ambiguous, CLASS_ERROR, diag::MAP_ERROR, "conditional expression is ambiguous; %0 can be converted to %1 and vice versa", 0, true, false, 3)
DIAG(err_conditional_ambiguous_ovl, CLASS_ERROR, diag::MAP_ERROR, "conditional expression is ambiguous; %0 and %1 can be converted to several common types", 0, true, false, 3)
DIAG(err_conditional_void_nonvoid, CLASS_ERROR, diag::MAP_ERROR, "%select{left|right}1 operand to ? is void, but %select{right|left}1 operand is of type %0", 0, true, false, 3)
DIAG(err_config_scalar_return, CLASS_ERROR, diag::MAP_ERROR, "CUDA special function 'cudaConfigureCall' must have scalar return type", 0, true, false, 3)
DIAG(err_conflicting_aliasing_type, CLASS_ERROR, diag::MAP_ERROR, "conflicting types for alias %0", 0, true, false, 3)
DIAG(err_conflicting_ivar_bitwidth, CLASS_ERROR, diag::MAP_ERROR, "instance variable %0 has conflicting bit-field width", 0, true, false, 3)
DIAG(err_conflicting_ivar_name, CLASS_ERROR, diag::MAP_ERROR, "conflicting instance variable names: %0 vs %1", 0, true, false, 3)
DIAG(err_conflicting_ivar_type, CLASS_ERROR, diag::MAP_ERROR, "instance variable %0 has conflicting type: %1 vs %2", 0, true, false, 3)
DIAG(err_conflicting_super_class, CLASS_ERROR, diag::MAP_ERROR, "conflicting super class name %0", 0, true, false, 3)
DIAG(err_conflicting_types, CLASS_ERROR, diag::MAP_ERROR, "conflicting types for %0", 0, true, false, 3)
DIAG(err_const_var_requires_init, CLASS_ERROR, diag::MAP_ERROR, "declaration of const variable '%0' requires an initializer", 0, true, false, 3)
DIAG(err_constant_integer_arg_type, CLASS_ERROR, diag::MAP_ERROR, "argument to %0 must be a constant integer", 0, true, false, 3)
DIAG(err_constructor_byvalue_arg, CLASS_ERROR, diag::MAP_ERROR, "copy constructor must pass its first argument by reference", 0, true, false, 3)
DIAG(err_constructor_cannot_be, CLASS_ERROR, diag::MAP_ERROR, "constructor cannot be declared '%0'", 0, true, false, 3)
DIAG(err_constructor_redeclared, CLASS_ERROR, diag::MAP_ERROR, "constructor cannot be redeclared", 0, true, false, 3)
DIAG(err_constructor_return_type, CLASS_ERROR, diag::MAP_ERROR, "constructor cannot have a return type", 0, true, false, 3)
DIAG(err_continuation_class, CLASS_ERROR, diag::MAP_ERROR, "continuation class has no primary class", 0, true, false, 3)
DIAG(err_continue_not_in_loop, CLASS_ERROR, diag::MAP_ERROR, "'continue' statement not in loop statement", 0, true, false, 3)
DIAG(err_conv_function_not_member, CLASS_ERROR, diag::MAP_ERROR, "conversion function must be a non-static member function", 0, true, false, 3)
DIAG(err_conv_function_redeclared, CLASS_ERROR, diag::MAP_ERROR, "conversion function cannot be redeclared", 0, true, false, 3)
DIAG(err_conv_function_return_type, CLASS_ERROR, diag::MAP_ERROR, "conversion function cannot have a return type", 0, true, false, 3)
DIAG(err_conv_function_to_array, CLASS_ERROR, diag::MAP_ERROR, "conversion function cannot convert to an array type", 0, true, false, 3)
DIAG(err_conv_function_to_function, CLASS_ERROR, diag::MAP_ERROR, "conversion function cannot convert to a function type", 0, true, false, 3)
DIAG(err_conv_function_variadic, CLASS_ERROR, diag::MAP_ERROR, "conversion function cannot be variadic", 0, true, false, 3)
DIAG(err_conv_function_with_complex_decl, CLASS_ERROR, diag::MAP_ERROR, "must use a typedef to declare a conversion to %0", 0, true, false, 3)
DIAG(err_conv_function_with_params, CLASS_ERROR, diag::MAP_ERROR, "conversion function cannot have any parameters", 0, true, false, 3)
DIAG(err_conv_to_inaccessible_base, CLASS_ERROR, diag::MAP_ERROR, "conversion from %0 to inaccessible base class %1", 0, true, true, 3)
DIAG(err_covariant_return_ambiguous_derived_to_base_conv, CLASS_ERROR, diag::MAP_ERROR, "return type of virtual function %3 is not covariant with the return type of the function it overrides (ambiguous conversion from derived class %0 to base class %1:%2)", 0, true, false, 3)
DIAG(err_covariant_return_inaccessible_base, CLASS_ERROR, diag::MAP_ERROR, "invalid covariant return for virtual function: %1 is a %select{private|protected}2 base class of %0", 0, true, true, 3)
DIAG(err_covariant_return_incomplete, CLASS_ERROR, diag::MAP_ERROR, "return type of virtual function %0 is not covariant with the return type of the function it overrides (%1 is incomplete)", 0, true, false, 3)
DIAG(err_covariant_return_not_derived, CLASS_ERROR, diag::MAP_ERROR, "return type of virtual function %0 is not covariant with the return type of the function it overrides (%1 is not derived from %2)", 0, true, false, 3)
DIAG(err_covariant_return_type_class_type_more_qualified, CLASS_ERROR, diag::MAP_ERROR, "return type of virtual function %0 is not covariant with the return type of the function it overrides (class type %1 is more qualified than class type %2", 0, true, false, 3)
DIAG(err_covariant_return_type_different_qualifications, CLASS_ERROR, diag::MAP_ERROR, "return type of virtual function %0 is not covariant with the return type of the function it overrides (%1 has different qualifiers than %2)", 0, true, false, 3)
DIAG(err_decimal_unsupported, CLASS_ERROR, diag::MAP_ERROR, "GNU decimal type extension not supported", 0, true, false, 3)
DIAG(err_decl_negative_array_size, CLASS_ERROR, diag::MAP_ERROR, "'%0' declared as an array with a negative size", 0, true, false, 3)
DIAG(err_declarator_need_ident, CLASS_ERROR, diag::MAP_ERROR, "declarator requires an identifier", 0, true, false, 3)
DIAG(err_decrement_bool, CLASS_ERROR, diag::MAP_ERROR, "cannot decrement expression of type bool", 0, true, false, 3)
DIAG(err_deduced_non_type_template_arg_type_mismatch, CLASS_ERROR, diag::MAP_ERROR, "deduced non-type template argument does not have the same type as the its corresponding template parameter (%0 vs %1)", 0, true, false, 3)
DIAG(err_deep_exception_specs_differ, CLASS_ERROR, diag::MAP_ERROR, "exception specifications of %select{return|argument}0 types differ", 0, true, false, 3)
DIAG(err_default_arg_in_partial_spec, CLASS_ERROR, diag::MAP_ERROR, "default template argument in a class template partial specialization", 0, true, false, 3)
DIAG(err_default_init_const, CLASS_ERROR, diag::MAP_ERROR, "default initialization of an object of const type %0%select{| requires a user-provided default constructor}1", 0, true, false, 3)
DIAG(err_default_not_in_switch, CLASS_ERROR, diag::MAP_ERROR, "'default' statement not in switch statement", 0, true, false, 3)
DIAG(err_definition_of_implicitly_declared_member, CLASS_ERROR, diag::MAP_ERROR, "definition of implicitly declared %select{constructor|copy constructor|copy assignment operator|destructor}1", 0, true, false, 3)
DIAG(err_delegating_initializer_alone, CLASS_ERROR, diag::MAP_ERROR, "an initializer for a delegating constructor must appear alone", 0, true, false, 3)
DIAG(err_delegation_0x_only, CLASS_ERROR, diag::MAP_ERROR, "delegating constructors are permitted only in C++0x", 0, true, false, 3)
DIAG(err_delegation_unimplemented, CLASS_ERROR, diag::MAP_ERROR, "delegating constructors are not fully implemented", 0, true, false, 3)
DIAG(err_delete_incomplete_class_type, CLASS_WARNING, diag::MAP_WARNING, "deleting incomplete class type %0; no conversions to pointer type", 0, true, false, 3)
DIAG(err_delete_operand, CLASS_ERROR, diag::MAP_ERROR, "cannot delete expression of type %0", 0, true, false, 3)
DIAG(err_deleted_decl_not_first, CLASS_ERROR, diag::MAP_ERROR, "deleted definition must be first declaration", 0, true, false, 3)
DIAG(err_deleted_function_use, CLASS_ERROR, diag::MAP_ERROR, "attempt to use a deleted function", 0, true, false, 3)
DIAG(err_deleted_non_function, CLASS_ERROR, diag::MAP_ERROR, "only functions can have deleted definitions", 0, true, false, 3)
DIAG(err_dependent_nested_name_spec, CLASS_ERROR, diag::MAP_ERROR, "nested name specifier for a declaration cannot depend on a template parameter", 0, true, false, 3)
DIAG(err_dependent_non_type_arg_in_partial_spec, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument depends on a template parameter of the partial specialization", 0, true, false, 3)
DIAG(err_dependent_tag_decl, CLASS_ERROR, diag::MAP_ERROR, "%select{declaration|definition}0 of %select{struct|union|class|enum}1 in a dependent scope", 0, true, false, 3)
DIAG(err_dependent_typed_non_type_arg_in_partial_spec, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument specializes a template parameter with dependent type %0", 0, true, false, 3)
DIAG(err_designator_for_scalar_init, CLASS_ERROR, diag::MAP_ERROR, "designator in initializer for scalar type %0", 0, true, false, 3)
DIAG(err_designator_into_flexible_array_member, CLASS_ERROR, diag::MAP_ERROR, "designator into flexible array member subobject", 0, true, false, 3)
DIAG(err_destructor_cannot_be, CLASS_ERROR, diag::MAP_ERROR, "destructor cannot be declared '%0'", 0, true, false, 3)
DIAG(err_destructor_class_name, CLASS_ERROR, diag::MAP_ERROR, "expected the class name after '~' to name a destructor", 0, true, false, 3)
DIAG(err_destructor_expr_type_mismatch, CLASS_ERROR, diag::MAP_ERROR, "destructor type %0 in object destruction expression does not match the type %1 of the object being destroyed", 0, true, false, 3)
DIAG(err_destructor_name, CLASS_ERROR, diag::MAP_ERROR, "expected the class name after '~' to name the enclosing class", 0, true, false, 3)
DIAG(err_destructor_not_member, CLASS_ERROR, diag::MAP_ERROR, "destructor must be a non-static member function", 0, true, false, 3)
DIAG(err_destructor_redeclared, CLASS_ERROR, diag::MAP_ERROR, "destructor cannot be redeclared", 0, true, false, 3)
DIAG(err_destructor_return_type, CLASS_ERROR, diag::MAP_ERROR, "destructor cannot have a return type", 0, true, false, 3)
DIAG(err_destructor_template, CLASS_ERROR, diag::MAP_ERROR, "destructor cannot be declared as a template", 0, true, false, 3)
DIAG(err_destructor_typedef_name, CLASS_ERROR, diag::MAP_ERROR, "destructor cannot be declared using a typedef %0 of the class name", 0, true, false, 3)
DIAG(err_destructor_variadic, CLASS_ERROR, diag::MAP_ERROR, "destructor cannot be variadic", 0, true, false, 3)
DIAG(err_destructor_with_params, CLASS_ERROR, diag::MAP_ERROR, "destructor cannot have any parameters", 0, true, false, 3)
DIAG(err_different_return_type_for_overriding_virtual_function, CLASS_ERROR, diag::MAP_ERROR, "virtual function %0 has a different return type (%1) than the function it overrides (which has return type %2)", 0, true, false, 3)
DIAG(err_direct_interface_unsupported, CLASS_ERROR, diag::MAP_ERROR, "indirection to an interface is not supported (%0 invalid)", 0, true, false, 3)
DIAG(err_distant_exception_spec, CLASS_ERROR, diag::MAP_ERROR, "exception specifications are not allowed beyond a single level of indirection", 0, true, false, 3)
DIAG(err_double_requires_fp64, CLASS_ERROR, diag::MAP_ERROR, "use of type 'double' requires cl_khr_fp64 extension to be enabled", 0, true, false, 3)
DIAG(err_downcast_from_inaccessible_base, CLASS_ERROR, diag::MAP_ERROR, "cannot cast %select{private|protected}2 base class %1 to %0", 0, true, false, 3)
DIAG(err_dtor_expr_without_call, CLASS_ERROR, diag::MAP_ERROR, "%select{destructor reference|pseudo-destructor expression}0 must be called immediately with '()'", 0, true, false, 3)
DIAG(err_dup_implementation_category, CLASS_ERROR, diag::MAP_ERROR, "reimplementation of category %1 for class %0", 0, true, false, 3)
DIAG(err_dup_implementation_class, CLASS_ERROR, diag::MAP_ERROR, "reimplementation of class %0", 0, true, false, 3)
DIAG(err_duplicate_base_class, CLASS_ERROR, diag::MAP_ERROR, "base class %0 specified more than once as a direct base class", 0, true, false, 3)
DIAG(err_duplicate_case, CLASS_ERROR, diag::MAP_ERROR, "duplicate case value '%0'", 0, true, false, 3)
DIAG(err_duplicate_class_def, CLASS_ERROR, diag::MAP_ERROR, "duplicate interface definition for class %0", 0, true, false, 3)
DIAG(err_duplicate_ivar_declaration, CLASS_ERROR, diag::MAP_ERROR, "instance variable is already declared", 0, true, false, 3)
DIAG(err_duplicate_member, CLASS_ERROR, diag::MAP_ERROR, "duplicate member %0", 0, true, false, 3)
DIAG(err_duplicate_method_decl, CLASS_ERROR, diag::MAP_ERROR, "duplicate declaration of method %0", 0, true, false, 3)
DIAG(err_duplicate_property, CLASS_ERROR, diag::MAP_ERROR, "property has a previous declaration", 0, true, false, 3)
DIAG(err_early_catch_all, CLASS_ERROR, diag::MAP_ERROR, "catch-all handler must come last", 0, true, false, 3)
DIAG(err_ellipsis_first_arg, CLASS_ERROR, diag::MAP_ERROR, "ISO C requires a named argument before '...'", 0, true, false, 3)
DIAG(err_ellipsis_in_declarator_not_parameter, CLASS_ERROR, diag::MAP_ERROR, "only function and template parameters can be parameter packs", 0, true, false, 3)
DIAG(err_empty_scalar_initializer, CLASS_ERROR, diag::MAP_ERROR, "scalar initializer cannot be empty", 0, true, false, 3)
DIAG(err_enum_invalid_underlying, CLASS_ERROR, diag::MAP_ERROR, "non-integral type %0 is an invalid underlying type", 0, true, false, 3)
DIAG(err_enum_redeclare_fixed_mismatch, CLASS_ERROR, diag::MAP_ERROR, "enumeration previously declared with %select{non|}0fixed underlying type", 0, true, false, 3)
DIAG(err_enum_redeclare_scoped_mismatch, CLASS_ERROR, diag::MAP_ERROR, "enumeration previously declared as %select{un|}0scoped", 0, true, false, 3)
DIAG(err_enum_redeclare_type_mismatch, CLASS_ERROR, diag::MAP_ERROR, "enumeration redeclared with different underlying type %0 (was %1)", 0, true, false, 3)
DIAG(err_enumerator_too_large, CLASS_ERROR, diag::MAP_ERROR, "enumerator value is not representable in the underlying type %0", 0, true, false, 3)
DIAG(err_enumerator_wrapped, CLASS_ERROR, diag::MAP_ERROR, "enumerator value %0 is not representable in the underlying type %1", 0, true, false, 3)
DIAG(err_exception_spec_in_typedef, CLASS_ERROR, diag::MAP_ERROR, "exception specifications are not allowed in typedefs", 0, true, false, 3)
DIAG(err_exceptions_disabled, CLASS_ERROR, diag::MAP_ERROR, "cannot use '%0' with exceptions disabled", 0, true, false, 3)
DIAG(err_excess_initializers, CLASS_ERROR, diag::MAP_ERROR, "excess elements in %select{array|vector|scalar|union|struct}0 initializer", 0, true, false, 3)
DIAG(err_excess_initializers_in_char_array_initializer, CLASS_ERROR, diag::MAP_ERROR, "excess elements in char array initializer", 0, true, false, 3)
DIAG(err_expected_block_lbrace, CLASS_ERROR, diag::MAP_ERROR, "expected '{' in block literal", 0, true, false, 3)
DIAG(err_expected_class_or_namespace, CLASS_ERROR, diag::MAP_ERROR, "expected a class or namespace", 0, true, false, 3)
DIAG(err_expected_ident_or_lparen, CLASS_ERROR, diag::MAP_ERROR, "expected identifier or '('", 0, true, false, 3)
DIAG(err_explicit_instantiation_ambiguous, CLASS_ERROR, diag::MAP_ERROR, "partial ordering for explicit instantiation of %0 is ambiguous", 0, true, false, 3)
DIAG(err_explicit_instantiation_data_member_not_instantiated, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation refers to static data member %q0 that is not an instantiation", 0, true, false, 3)
DIAG(err_explicit_instantiation_declaration_after_definition, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation declaration (with 'extern') follows explicit instantiation definition (without 'extern')", 0, true, false, 3)
DIAG(err_explicit_instantiation_duplicate, CLASS_ERROR, diag::MAP_ERROR, "duplicate explicit instantiation of %0", 0, true, false, 3)
DIAG(err_explicit_instantiation_enum, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation of enumeration type %0", 0, true, false, 3)
DIAG(err_explicit_instantiation_in_class, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation of %0 in class scope", 0, true, false, 3)
DIAG(err_explicit_instantiation_inline, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation cannot be 'inline'", 0, true, false, 3)
DIAG(err_explicit_instantiation_member_function_not_instantiated, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation refers to member function %q0 that is not an instantiation", 0, true, false, 3)
DIAG(err_explicit_instantiation_must_be_global, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation of %0 must occur at global scope", 0, true, false, 3)
DIAG(err_explicit_instantiation_nontemplate_type, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation of non-templated type %0", 0, true, false, 3)
DIAG(err_explicit_instantiation_not_known, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation of %0 does not refer to a function template, member function, member class, or static data member", 0, true, false, 3)
DIAG(err_explicit_instantiation_of_typedef, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation of typedef %0", 0, true, false, 3)
DIAG(err_explicit_instantiation_out_of_scope, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation of %0 not in a namespace enclosing %1", 0, true, false, 3)
DIAG(err_explicit_instantiation_requires_name, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation declaration requires a name", 0, true, false, 3)
DIAG(err_explicit_instantiation_undefined_func_template, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation of undefined function template %0", 0, true, false, 3)
DIAG(err_explicit_instantiation_undefined_member, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation of undefined %select{member class|member function|static data member}0 %1 of class template %2", 0, true, false, 3)
DIAG(err_explicit_instantiation_unqualified_wrong_namespace, CLASS_ERROR, diag::MAP_ERROR, "explicit instantiation of %q0 must occur in %1", 0, true, false, 3)
DIAG(err_explicit_non_ctor_or_conv_function, CLASS_ERROR, diag::MAP_ERROR, "'explicit' can only be applied to a constructor or conversion function", 0, true, false, 3)
DIAG(err_explicit_non_function, CLASS_ERROR, diag::MAP_ERROR, "'explicit' can only appear on non-static member functions", 0, true, false, 3)
DIAG(err_explicit_out_of_class, CLASS_ERROR, diag::MAP_ERROR, "'explicit' can only be specified inside the class definition", 0, true, false, 3)
DIAG(err_expr_not_ice, CLASS_ERROR, diag::MAP_ERROR, "expression is not an integer constant expression", 0, true, false, 3)
DIAG(err_ext_vector_component_exceeds_length, CLASS_ERROR, diag::MAP_ERROR, "vector component access exceeds type %0", 0, true, false, 3)
DIAG(err_ext_vector_component_name_illegal, CLASS_ERROR, diag::MAP_ERROR, "illegal vector component name '%0'", 0, true, false, 3)
DIAG(err_extern_non_extern, CLASS_ERROR, diag::MAP_ERROR, "extern declaration of %0 follows non-extern declaration", 0, true, false, 3)
DIAG(err_falloff_nonvoid_block, CLASS_ERROR, diag::MAP_ERROR, "control reaches end of non-void block", 0, true, false, 3)
DIAG(err_field_declared_as_function, CLASS_ERROR, diag::MAP_ERROR, "field %0 declared as a function", 0, true, false, 3)
DIAG(err_field_designator_non_aggr, CLASS_ERROR, diag::MAP_ERROR, "field designator cannot initialize a %select{non-struct, non-union|non-class}0 type %1", 0, true, false, 3)
DIAG(err_field_designator_nonfield, CLASS_ERROR, diag::MAP_ERROR, "field designator %0 does not refer to a non-static data member", 0, true, false, 3)
DIAG(err_field_designator_unknown, CLASS_ERROR, diag::MAP_ERROR, "field designator %0 does not refer to any field in type %1", 0, true, false, 3)
DIAG(err_field_designator_unknown_suggest, CLASS_ERROR, diag::MAP_ERROR, "field designator %0 does not refer to any field in type %1; did you mean %2?", 0, true, false, 3)
DIAG(err_field_incomplete, CLASS_ERROR, diag::MAP_ERROR, "field has incomplete type %0", 0, true, false, 3)
DIAG(err_field_instantiates_to_function, CLASS_ERROR, diag::MAP_ERROR, "data member instantiated with function type %0", 0, true, false, 3)
DIAG(err_final_base, CLASS_ERROR, diag::MAP_ERROR, "derivation from 'final' %0", 0, true, false, 3)
DIAG(err_final_function_overridden, CLASS_ERROR, diag::MAP_ERROR, "declaration of %0 overrides a 'final' function", 0, true, false, 3)
DIAG(err_first_argument_to_va_arg_not_of_type_va_list, CLASS_ERROR, diag::MAP_ERROR, "first argument to 'va_arg' is of type %0 and not 'va_list'", 0, true, false, 3)
DIAG(err_flexible_array_empty_struct, CLASS_ERROR, diag::MAP_ERROR, "flexible array %0 not allowed in otherwise empty struct", 0, true, false, 3)
DIAG(err_flexible_array_has_nonpod_type, CLASS_ERROR, diag::MAP_ERROR, "flexible array member %0 of non-POD element type %1", 0, true, false, 3)
DIAG(err_flexible_array_init_needs_braces, CLASS_ERROR, diag::MAP_ERROR, "flexible array requires brace-enclosed initializer", 0, true, false, 3)
DIAG(err_flexible_array_init_nonempty, CLASS_ERROR, diag::MAP_ERROR, "non-empty initialization of flexible array member inside subobject", 0, true, false, 3)
DIAG(err_format_attribute_implicit_this_format_string, CLASS_ERROR, diag::MAP_ERROR, "format attribute cannot specify the implicit this argument as the format string", 0, true, false, 3)
DIAG(err_format_attribute_not, CLASS_ERROR, diag::MAP_ERROR, "format argument not %0", 0, true, false, 3)
DIAG(err_format_attribute_requires_variadic, CLASS_ERROR, diag::MAP_ERROR, "format attribute requires variadic function", 0, true, false, 3)
DIAG(err_format_attribute_result_not, CLASS_ERROR, diag::MAP_ERROR, "function does not return %0", 0, true, false, 3)
DIAG(err_format_strftime_third_parameter, CLASS_ERROR, diag::MAP_ERROR, "strftime format attribute requires 3rd parameter to be 0", 0, true, false, 3)
DIAG(err_forward_ref_enum, CLASS_ERROR, diag::MAP_ERROR, "ISO C++ forbids forward references to 'enum' types", 0, true, false, 3)
DIAG(err_friend_is_member, CLASS_ERROR, diag::MAP_ERROR, "friends cannot be members of the declaring class", 0, true, false, 3)
DIAG(err_func_def_incomplete_result, CLASS_ERROR, diag::MAP_ERROR, "incomplete result type %0 in function definition", 0, true, false, 3)
DIAG(err_func_returning_array_function, CLASS_ERROR, diag::MAP_ERROR, "function cannot return %select{array|function}0 type %1", 0, true, false, 3)
DIAG(err_function_marked_override_not_overriding, CLASS_ERROR, diag::MAP_ERROR, "%0 marked 'override' but does not override any member functions", 0, true, false, 3)
DIAG(err_function_overriding_without_override, CLASS_ERROR, diag::MAP_ERROR, "%0 overrides function%s1 without being marked 'override'", 0, true, false, 3)
DIAG(err_function_parameter_pack_without_parameter_packs, CLASS_ERROR, diag::MAP_ERROR, "type %0 of function parameter pack does not contain any unexpanded parameter packs", 0, true, false, 3)
DIAG(err_function_template_partial_spec, CLASS_ERROR, diag::MAP_ERROR, "function template partial specialization is not allowed", 0, true, false, 3)
DIAG(err_function_template_spec_ambiguous, CLASS_ERROR, diag::MAP_ERROR, "function template specialization %0 ambiguously refers to more than one function template; explicitly specify%select{|additional }1 template arguments to identify a particular function template", 0, true, false, 3)
DIAG(err_function_template_spec_no_match, CLASS_ERROR, diag::MAP_ERROR, "no function template matches function template specialization %0", 0, true, false, 3)
DIAG(err_getter_not_found, CLASS_ERROR, diag::MAP_ERROR, "expected getter method not found on object of type %0", 0, true, false, 3)
DIAG(err_goto_into_protected_scope, CLASS_ERROR, diag::MAP_ERROR, "goto into protected scope", 0, true, false, 3)
DIAG(err_iboutletcollection_object_type, CLASS_ERROR, diag::MAP_ERROR, "%select{ivar|property}1 with iboutletcollection attribute must have object type (invalid %0)", 0, true, false, 3)
DIAG(err_iboutletcollection_type, CLASS_ERROR, diag::MAP_ERROR, "invalid type %0 as argument of iboutletcollection attribute", 0, true, false, 3)
DIAG(err_ident_in_dtor_not_a_type, CLASS_ERROR, diag::MAP_ERROR, "identifier %0 in object destruction expression does not name a type", 0, true, false, 3)
DIAG(err_ident_list_in_fn_declaration, CLASS_ERROR, diag::MAP_ERROR, "a parameter list without types is only allowed in a function definition", 0, true, false, 3)
DIAG(err_illegal_decl_array_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "array has incomplete element type %0", 0, true, false, 3)
DIAG(err_illegal_decl_array_of_auto, CLASS_ERROR, diag::MAP_ERROR, "'%0' declared as array of %1", 0, true, false, 3)
DIAG(err_illegal_decl_array_of_functions, CLASS_ERROR, diag::MAP_ERROR, "'%0' declared as array of functions of type %1", 0, true, false, 3)
DIAG(err_illegal_decl_array_of_references, CLASS_ERROR, diag::MAP_ERROR, "'%0' declared as array of references of type %1", 0, true, false, 3)
DIAG(err_illegal_decl_mempointer_in_nonclass, CLASS_ERROR, diag::MAP_ERROR, "'%0' does not point into a class", 0, true, false, 3)
DIAG(err_illegal_decl_mempointer_to_reference, CLASS_ERROR, diag::MAP_ERROR, "'%0' declared as a member pointer to a reference of type %1", 0, true, false, 3)
DIAG(err_illegal_decl_mempointer_to_void, CLASS_ERROR, diag::MAP_ERROR, "'%0' declared as a member pointer to void", 0, true, false, 3)
DIAG(err_illegal_decl_pointer_to_reference, CLASS_ERROR, diag::MAP_ERROR, "'%0' declared as a pointer to a reference of type %1", 0, true, false, 3)
DIAG(err_illegal_initializer, CLASS_ERROR, diag::MAP_ERROR, "illegal initializer (only variables can be initialized)", 0, true, false, 3)
DIAG(err_illegal_initializer_type, CLASS_ERROR, diag::MAP_ERROR, "illegal initializer type %0", 0, true, false, 3)
DIAG(err_illegal_message_expr_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "objective-c message has incomplete result type %0", 0, true, false, 3)
DIAG(err_illegal_qualifiers_on_catch_parm, CLASS_ERROR, diag::MAP_ERROR, "illegal qualifiers on @catch parameter", 0, true, false, 3)
DIAG(err_illegal_union_or_anon_struct_member, CLASS_ERROR, diag::MAP_ERROR, "%select{anonymous struct|union}0 member %1 has a non-trivial %select{constructor|copy constructor|copy assignment operator|destructor}2", 0, true, false, 3)
DIAG(err_imaginary_not_supported, CLASS_ERROR, diag::MAP_ERROR, "imaginary types are not supported", 0, true, false, 3)
DIAG(err_implicit_empty_initializer, CLASS_ERROR, diag::MAP_ERROR, "initializer for aggregate with no elements requires explicit braces", 0, true, false, 3)
DIAG(err_implicit_instantiate_member_undefined, CLASS_ERROR, diag::MAP_ERROR, "implicit instantiation of undefined member %0", 0, true, false, 3)
DIAG(err_implicit_object_parameter_init, CLASS_ERROR, diag::MAP_ERROR, "cannot initialize object parameter of type %0 with an expression of type %1", 0, true, false, 3)
DIAG(err_in_class_initializer_bad_type, CLASS_ERROR, diag::MAP_ERROR, "static data member of type %0 must be initialized out of line", 0, true, false, 3)
DIAG(err_in_class_initializer_non_const, CLASS_ERROR, diag::MAP_ERROR, "non-const static data member must be initialized out of line", 0, true, false, 3)
DIAG(err_in_class_initializer_non_constant, CLASS_ERROR, diag::MAP_ERROR, "in-class initializer is not a constant expression", 0, true, false, 3)
DIAG(err_incompatible_exception_specs, CLASS_ERROR, diag::MAP_ERROR, "target exception specification is not superset of source", 0, true, false, 3)
DIAG(err_incomplete_base_class, CLASS_ERROR, diag::MAP_ERROR, "base class has incomplete type", 0, true, false, 3)
DIAG(err_incomplete_in_exception_spec, CLASS_ERROR, diag::MAP_ERROR, "%select{|pointer to |reference to }0incomplete type %1 is not allowed in exception specification", 0, true, false, 3)
DIAG(err_incomplete_member_access, CLASS_ERROR, diag::MAP_ERROR, "member access into incomplete type %0", 0, true, false, 3)
DIAG(err_incomplete_nested_name_spec, CLASS_ERROR, diag::MAP_ERROR, "incomplete type %0 named in nested name specifier", 0, true, false, 3)
DIAG(err_incomplete_object_call, CLASS_ERROR, diag::MAP_ERROR, "incomplete type in call to object of type %0", 0, true, false, 3)
DIAG(err_incomplete_pointer_to_member_return, CLASS_ERROR, diag::MAP_ERROR, "incomplete return type %0 of pointer-to-member constant", 0, true, false, 3)
DIAG(err_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "incomplete type %0 where a complete type is required", 0, true, false, 3)
DIAG(err_incomplete_type_used_in_type_trait_expr, CLASS_ERROR, diag::MAP_ERROR, "incomplete type %0 used in type trait expression", 0, true, false, 3)
DIAG(err_incomplete_typeid, CLASS_ERROR, diag::MAP_ERROR, "'typeid' of incomplete type %0", 0, true, false, 3)
DIAG(err_inconsistant_ivar_count, CLASS_ERROR, diag::MAP_ERROR, "inconsistent number of instance variables specified", 0, true, false, 3)
DIAG(err_indirect_goto_in_protected_scope, CLASS_ERROR, diag::MAP_ERROR, "indirect goto might cross protected scopes", 0, true, false, 3)
DIAG(err_indirect_goto_without_addrlabel, CLASS_ERROR, diag::MAP_ERROR, "indirect goto in function with no address-of-label expressions", 0, true, false, 3)
DIAG(err_init_conversion_failed, CLASS_ERROR, diag::MAP_ERROR, "cannot initialize %select{a variable|a parameter|return object|an exception object|a member subobject|an array element|a new value|a value|a base class|a constructor delegation|a vector element}0 of type %1 with an %select{rvalue|lvalue}2 of type %3", 0, true, false, 3)
DIAG(err_init_element_not_constant, CLASS_ERROR, diag::MAP_ERROR, "initializer element is not a compile-time constant", 0, true, false, 3)
DIAG(err_init_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "initialization of incomplete type %0", 0, true, false, 3)
DIAG(err_init_list_bad_dest_type, CLASS_ERROR, diag::MAP_ERROR, "%select{|non-aggregate }0type %1 cannot be initialized with an initializer list", 0, true, false, 3)
DIAG(err_init_non_aggr_init_list, CLASS_ERROR, diag::MAP_ERROR, "initialization of non-aggregate type %0 with an initializer list", 0, true, false, 3)
DIAG(err_init_objc_class, CLASS_ERROR, diag::MAP_ERROR, "cannot initialize Objective-C class type %0", 0, true, false, 3)
DIAG(err_init_priority_object_attr, CLASS_ERROR, diag::MAP_ERROR, "can only use 'init_priority' attribute on file-scope definitions of objects of class type", 0, true, false, 3)
DIAG(err_init_reference_member_uninitialized, CLASS_ERROR, diag::MAP_ERROR, "reference member of type %0 uninitialized", 0, true, false, 3)
DIAG(err_inline_declaration_block_scope, CLASS_ERROR, diag::MAP_ERROR, "inline declaration of %0 not allowed in block scope", 0, true, false, 3)
DIAG(err_inline_namespace_mismatch, CLASS_ERROR, diag::MAP_ERROR, "%select{|non-}0inline namespace cannot be reopened as %select{non-|}0inline", 0, true, false, 3)
DIAG(err_inline_non_function, CLASS_ERROR, diag::MAP_ERROR, "'inline' can only appear on functions", 0, true, false, 3)
DIAG(err_int_to_block_pointer, CLASS_ERROR, diag::MAP_ERROR, "invalid block pointer conversion %select{assigning to|passing|returning|converting|initializing|sending|casting}2 %0 %select{from|to parameter of type|from a function with result type|to type|with an expression of type|to parameter of type|to type}2 %1", 0, true, false, 3)
DIAG(err_introducing_special_friend, CLASS_ERROR, diag::MAP_ERROR, "must use a qualified name when declaring a %select{constructor|destructor|conversion operator}0 as a friend", 0, true, false, 3)
DIAG(err_invalid_asm_cast_lvalue, CLASS_ERROR, diag::MAP_ERROR, "invalid use of a cast in a inline asm context requiring an l-value: remove the cast or build with -fheinous-gnu-extensions", 0, true, false, 4)
DIAG(err_invalid_conversion_between_ext_vectors, CLASS_ERROR, diag::MAP_ERROR, "invalid conversion between ext-vector type %0 and %1", 0, true, false, 3)
DIAG(err_invalid_conversion_between_vector_and_integer, CLASS_ERROR, diag::MAP_ERROR, "invalid conversion between vector type %0 and integer type %1 of different size", 0, true, false, 3)
DIAG(err_invalid_conversion_between_vector_and_scalar, CLASS_ERROR, diag::MAP_ERROR, "invalid conversion between vector type %0 and scalar type %1", 0, true, false, 3)
DIAG(err_invalid_conversion_between_vectors, CLASS_ERROR, diag::MAP_ERROR, "invalid conversion between vector type %0 and %1 of different size", 0, true, false, 3)
DIAG(err_invalid_declarator_global_scope, CLASS_ERROR, diag::MAP_ERROR, "definition or redeclaration of %0 cannot name the global scope", 0, true, false, 3)
DIAG(err_invalid_declarator_in_function, CLASS_ERROR, diag::MAP_ERROR, "definition or redeclaration of %0 not allowed inside a function", 0, true, false, 3)
DIAG(err_invalid_declarator_scope, CLASS_ERROR, diag::MAP_ERROR, "definition or redeclaration of %0 not in a namespace enclosing %1", 0, true, false, 3)
DIAG(err_invalid_form_pointer_member_function, CLASS_ERROR, diag::MAP_ERROR, "cannot create a non-constant pointer to member function", 0, true, false, 3)
DIAG(err_invalid_incomplete_type_use, CLASS_ERROR, diag::MAP_ERROR, "invalid use of incomplete type %0", 0, true, false, 3)
DIAG(err_invalid_initialization, CLASS_ERROR, diag::MAP_ERROR, "invalid initialization of reference of type %0 from expression of type %1", 0, true, false, 3)
DIAG(err_invalid_member_use_in_static_method, CLASS_ERROR, diag::MAP_ERROR, "invalid use of member %0 in static member function", 0, true, false, 3)
DIAG(err_invalid_neon_type_code, CLASS_ERROR, diag::MAP_ERROR, "incompatible constant for this __builtin_neon function", 0, true, false, 3)
DIAG(err_invalid_non_static_member_use, CLASS_ERROR, diag::MAP_ERROR, "invalid use of nonstatic data member %0", 0, true, false, 3)
DIAG(err_invalid_protocol_qualifiers, CLASS_ERROR, diag::MAP_ERROR, "invalid protocol qualifiers on non-ObjC type", 0, true, false, 3)
DIAG(err_invalid_qualified_constructor, CLASS_ERROR, diag::MAP_ERROR, "'%0' qualifier is not allowed on a constructor", 0, true, false, 3)
DIAG(err_invalid_qualified_destructor, CLASS_ERROR, diag::MAP_ERROR, "'%0' qualifier is not allowed on a destructor", 0, true, false, 3)
DIAG(err_invalid_qualified_function_pointer, CLASS_ERROR, diag::MAP_ERROR, "type qualifier is not allowed on this function %select{pointer|reference}0", 0, true, false, 3)
DIAG(err_invalid_qualified_function_type, CLASS_ERROR, diag::MAP_ERROR, "type qualifier is not allowed on this function", 0, true, false, 3)
DIAG(err_invalid_qualified_typedef_function_type_use, CLASS_ERROR, diag::MAP_ERROR, "a qualified function type cannot be used to declare a %select{static member|nonmember}0 function", 0, true, false, 3)
DIAG(err_invalid_receiver_class_message, CLASS_ERROR, diag::MAP_ERROR, "receiver type %0 is not an Objective-C class", 0, true, false, 3)
DIAG(err_invalid_receiver_to_message, CLASS_ERROR, diag::MAP_ERROR, "invalid receiver to message expression", 0, true, false, 3)
DIAG(err_invalid_receiver_to_message_super, CLASS_ERROR, diag::MAP_ERROR, "'super' is only valid in a method body", 0, true, false, 3)
DIAG(err_invalid_ref_qualifier_function_type, CLASS_ERROR, diag::MAP_ERROR, "ref-qualifier '%select{&&|&}0' is only allowed on non-static member functions, member function pointers, and typedefs of function types", 0, true, false, 3)
DIAG(err_invalid_ref_qualifier_typedef_function_type_use, CLASS_ERROR, diag::MAP_ERROR, "%select{static member|nonmember}0 function cannot have a ref-qualifier '%select{&&|&}1'", 0, true, false, 3)
DIAG(err_invalid_this_use, CLASS_ERROR, diag::MAP_ERROR, "invalid use of 'this' outside of a nonstatic member function", 0, true, false, 3)
DIAG(err_invalid_thread, CLASS_ERROR, diag::MAP_ERROR, "'__thread' is only allowed on variable declarations", 0, true, false, 3)
DIAG(err_invalid_use_of_array_type, CLASS_ERROR, diag::MAP_ERROR, "an array type is not allowed here", 0, true, false, 3)
DIAG(err_invalid_use_of_bound_member_func, CLASS_ERROR, diag::MAP_ERROR, "a bound member function may only be called", 0, true, false, 3)
DIAG(err_invalid_use_of_function_type, CLASS_ERROR, diag::MAP_ERROR, "a function type is not allowed here", 0, true, false, 3)
DIAG(err_ivar_reference_type, CLASS_ERROR, diag::MAP_ERROR, "instance variables cannot be of reference type", 0, true, false, 3)
DIAG(err_kern_call_not_global_function, CLASS_ERROR, diag::MAP_ERROR, "kernel call to non-global function %0", 0, true, false, 3)
DIAG(err_kern_type_not_void_return, CLASS_ERROR, diag::MAP_ERROR, "kernel function type %0 must have void return type", 0, true, false, 3)
DIAG(err_literal_operator_outside_namespace, CLASS_ERROR, diag::MAP_ERROR, "literal operator %0 must be in a namespace or global scope", 0, true, false, 3)
DIAG(err_literal_operator_params, CLASS_ERROR, diag::MAP_ERROR, "parameter declaration for literal operator %0 is not valid", 0, true, false, 3)
DIAG(err_lvalue_reference_bind_to_temporary, CLASS_ERROR, diag::MAP_ERROR, "%select{non-const|volatile}0 lvalue reference to type %1 cannot bind to a temporary of type %2", 0, true, false, 3)
DIAG(err_lvalue_reference_bind_to_unrelated, CLASS_ERROR, diag::MAP_ERROR, "%select{non-const|volatile}0 lvalue reference to type %1 cannot bind to a value of unrelated type %2", 0, true, false, 3)
DIAG(err_lvalue_to_rvalue_ambig_ref, CLASS_ERROR, diag::MAP_ERROR, "rvalue reference cannot bind to lvalue due to multiple conversion functions", 0, true, false, 3)
DIAG(err_lvalue_to_rvalue_ref, CLASS_ERROR, diag::MAP_ERROR, "rvalue reference to type %0 cannot bind to lvalue of type %1", 0, true, false, 3)
DIAG(err_main_arg_wrong, CLASS_ERROR, diag::MAP_ERROR, "%select{first|second|third|fourth}0 parameter of 'main' (%select{argument count|argument array|environment|platform-specific data}0) must be of type %1", 0, true, false, 3)
DIAG(err_main_returns_nonint, CLASS_ERROR, diag::MAP_ERROR, "'main' must return 'int'", 0, true, false, 3)
DIAG(err_main_surplus_args, CLASS_ERROR, diag::MAP_ERROR, "too many parameters (%0) for 'main': must be 0, 2, or 3", 0, true, false, 3)
DIAG(err_main_template_decl, CLASS_ERROR, diag::MAP_ERROR, "'main' cannot be a template", 0, true, false, 3)
DIAG(err_maybe_falloff_nonvoid_block, CLASS_ERROR, diag::MAP_ERROR, "control may reach end of non-void block", 0, true, false, 3)
DIAG(err_mem_init_not_member_or_class, CLASS_ERROR, diag::MAP_ERROR, "member initializer %0 does not name a non-static data member or base class", 0, true, false, 3)
DIAG(err_mem_init_not_member_or_class_suggest, CLASS_ERROR, diag::MAP_ERROR, "initializer %0 does not name a non-static data member or base class; did you mean the %select{base class|member}1 %2?", 0, true, false, 3)
DIAG(err_member_call_without_object, CLASS_ERROR, diag::MAP_ERROR, "call to non-static member function without an object argument", 0, true, false, 3)
DIAG(err_member_def_does_not_match, CLASS_ERROR, diag::MAP_ERROR, "out-of-line definition of %0 does not match any declaration in %1", 0, true, false, 3)
DIAG(err_member_def_does_not_match_ret_type, CLASS_ERROR, diag::MAP_ERROR, "out-of-line definition of %q0 differ from the declaration in the return type", 0, true, false, 3)
DIAG(err_member_def_undefined_record, CLASS_ERROR, diag::MAP_ERROR, "out-of-line definition of %0 from class %1 without definition", 0, true, false, 3)
DIAG(err_member_function_call_bad_cvr, CLASS_ERROR, diag::MAP_ERROR, "member function %0 not viable: 'this' argument has type %1, but function is not marked %select{const|restrict|const or restrict|volatile|const or volatile|volatile or restrict|const, volatile, or restrict}2", 0, true, false, 3)
DIAG(err_member_function_initialization, CLASS_ERROR, diag::MAP_ERROR, "initializer on function does not look like a pure-specifier", 0, true, false, 3)
DIAG(err_member_initialization, CLASS_ERROR, diag::MAP_ERROR, "fields can only be initialized in constructors", 0, true, false, 3)
DIAG(err_member_name_of_class, CLASS_ERROR, diag::MAP_ERROR, "member %0 has the same name as its class", 0, true, false, 3)
DIAG(err_member_not_yet_instantiated, CLASS_ERROR, diag::MAP_ERROR, "no member %0 in %1; it has not yet been instantiated", 0, true, false, 3)
DIAG(err_member_qualification, CLASS_ERROR, diag::MAP_ERROR, "non-friend class member %0 cannot have a qualified name", 0, true, false, 3)
DIAG(err_member_redeclared, CLASS_ERROR, diag::MAP_ERROR, "class member cannot be redeclared", 0, true, false, 3)
DIAG(err_member_reference_needs_call, CLASS_ERROR, diag::MAP_ERROR, "base of member reference is %select{a function|an overloaded function}0; perhaps you meant to call it%select{| with no arguments}1?", 0, true, false, 3)
DIAG(err_mempointer_in_nonclass_type, CLASS_ERROR, diag::MAP_ERROR, "member pointer refers into non-class type %0", 0, true, false, 3)
DIAG(err_memptr_conv_via_virtual, CLASS_ERROR, diag::MAP_ERROR, "conversion from pointer to member of class %0 to pointer to member of class %1 via virtual base %2 is not allowed", 0, true, false, 3)
DIAG(err_memptr_rhs_to_incomplete, CLASS_ERROR, diag::MAP_ERROR, "cannot dereference pointer into incomplete class type %0", 0, true, false, 3)
DIAG(err_mismatched_exception_spec, CLASS_ERROR, diag::MAP_ERROR, "exception specification in declaration does not match previous declaration", 0, true, false, 3)
DIAG(err_misplaced_ivar, CLASS_ERROR, diag::MAP_ERROR, "ivars may not be placed in %select{categories|class extension}0", 0, true, false, 3)
DIAG(err_missing_default_ctor, CLASS_ERROR, diag::MAP_ERROR, "%select{|implicit default }0constructor for %1 must explicitly initialize the %select{base class|member}2 %3 which does not have a default constructor", 0, true, false, 3)
DIAG(err_missing_open_square_message_send, CLASS_ERROR, diag::MAP_ERROR, "missing '[' at start of message send expression", 0, true, false, 3)
DIAG(err_missing_param_declspec, CLASS_ERROR, diag::MAP_ERROR, "parameter requires a declaration specifier", 0, true, false, 3)
DIAG(err_missing_qualified_for_redecl, CLASS_ERROR, diag::MAP_ERROR, "must qualify the name %0 to declare %q1 in this scope", 0, true, false, 3)
DIAG(err_missing_type_specifier, CLASS_ERROR, diag::MAP_ERROR, "C++ requires a type specifier for all declarations", 0, true, false, 3)
DIAG(err_mode_not_primitive, CLASS_ERROR, diag::MAP_ERROR, "mode attribute only supported for integer and floating-point types", 0, true, false, 3)
DIAG(err_mode_wrong_type, CLASS_ERROR, diag::MAP_ERROR, "type of machine mode does not match type of base type", 0, true, false, 3)
DIAG(err_multiple_base_initialization, CLASS_ERROR, diag::MAP_ERROR, "multiple initializations given for base %0", 0, true, false, 3)
DIAG(err_multiple_default_labels_defined, CLASS_ERROR, diag::MAP_ERROR, "multiple default labels in one switch", 0, true, false, 3)
DIAG(err_multiple_final_overriders, CLASS_ERROR, diag::MAP_ERROR, "virtual function %q0 has more than one final overrider in %1", 0, true, false, 3)
DIAG(err_multiple_mem_initialization, CLASS_ERROR, diag::MAP_ERROR, "multiple initializations given for non-static member %0", 0, true, false, 3)
DIAG(err_multiple_mem_union_initialization, CLASS_ERROR, diag::MAP_ERROR, "initializing multiple members of anonymous union", 0, true, false, 3)
DIAG(err_mutable_const, CLASS_ERROR, diag::MAP_ERROR, "'mutable' and 'const' cannot be mixed", 0, true, false, 3)
DIAG(err_mutable_function, CLASS_ERROR, diag::MAP_ERROR, "'mutable' cannot be applied to functions", 0, true, false, 3)
DIAG(err_mutable_nonmember, CLASS_ERROR, diag::MAP_ERROR, "'mutable' can only be applied to member variables", 0, true, false, 3)
DIAG(err_mutable_reference, CLASS_ERROR, diag::MAP_ERROR, "'mutable' cannot be applied to references", 0, true, false, 3)
DIAG(err_need_header_before_ms_uuidof, CLASS_ERROR, diag::MAP_ERROR, "you need to include <guiddef.h> before using the '__uuidof' operator", 0, true, false, 3)
DIAG(err_need_header_before_typeid, CLASS_ERROR, diag::MAP_ERROR, "you need to include <typeinfo> before using the 'typeid' operator", 0, true, false, 3)
DIAG(err_nested_name_member_ref_lookup_ambiguous, CLASS_ERROR, diag::MAP_ERROR, "lookup of %0 in member access expression is ambiguous", 0, true, false, 3)
DIAG(err_nested_name_spec_non_tag, CLASS_ERROR, diag::MAP_ERROR, "type %0 cannot be used prior to '::' because it has no members", 0, true, false, 3)
DIAG(err_nested_redefinition, CLASS_ERROR, diag::MAP_ERROR, "nested redefinition of %0", 0, true, false, 3)
DIAG(err_new_array_init_args, CLASS_ERROR, diag::MAP_ERROR, "array 'new' cannot have initialization arguments", 0, true, false, 3)
DIAG(err_new_array_nonconst, CLASS_ERROR, diag::MAP_ERROR, "only the first dimension of an allocated array may have dynamic size", 0, true, false, 3)
DIAG(err_new_array_of_auto, CLASS_ERROR, diag::MAP_ERROR, "cannot allocate array of 'auto'", 0, true, false, 3)
DIAG(err_new_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "allocation of incomplete type %0", 0, true, false, 3)
DIAG(err_no_matching_local_friend, CLASS_ERROR, diag::MAP_ERROR, "no matching function found in local scope", 0, true, false, 3)
DIAG(err_no_member, CLASS_ERROR, diag::MAP_ERROR, "no member named %0 in %1", 0, true, false, 3)
DIAG(err_no_member_suggest, CLASS_ERROR, diag::MAP_ERROR, "no member named %0 in %1; did you mean %2?", 0, true, false, 3)
DIAG(err_no_member_template_suggest, CLASS_ERROR, diag::MAP_ERROR, "no template named %0 in %1; did you mean %2?", 0, true, false, 3)
DIAG(err_no_nsconstant_string_class, CLASS_ERROR, diag::MAP_ERROR, "cannot find interface declaration for %0", 0, true, false, 3)
DIAG(err_no_suitable_delete_member_function_found, CLASS_ERROR, diag::MAP_ERROR, "no suitable member %0 in %1", 0, true, false, 3)
DIAG(err_no_template_suggest, CLASS_ERROR, diag::MAP_ERROR, "no template named %0; did you mean %1?", 0, true, false, 3)
DIAG(err_non_extern_extern, CLASS_ERROR, diag::MAP_ERROR, "non-extern declaration of %0 follows extern declaration", 0, true, false, 3)
DIAG(err_non_static_static, CLASS_ERROR, diag::MAP_ERROR, "non-static declaration of %0 follows static declaration", 0, true, false, 3)
DIAG(err_non_thread_thread, CLASS_ERROR, diag::MAP_ERROR, "non-thread-local declaration of %0 follows thread-local declaration", 0, true, false, 3)
DIAG(err_non_type_template_in_nested_name_specifier, CLASS_ERROR, diag::MAP_ERROR, "qualified name refers into a specialization of function template '%0'", 0, true, false, 3)
DIAG(err_non_variable_decl_in_for, CLASS_ERROR, diag::MAP_ERROR, "declaration of non-local variable in 'for' loop", 0, true, false, 3)
DIAG(err_non_virtual_pure, CLASS_ERROR, diag::MAP_ERROR, "%0 is not virtual and cannot be declared pure", 0, true, false, 3)
DIAG(err_nonfunction_block_type, CLASS_ERROR, diag::MAP_ERROR, "block pointer to non-function type is invalid", 0, true, false, 3)
DIAG(err_nonstatic_flexible_variable, CLASS_ERROR, diag::MAP_ERROR, "non-static initialization of a variable with flexible array member", 0, true, false, 3)
DIAG(err_nonstatic_member_out_of_line, CLASS_ERROR, diag::MAP_ERROR, "non-static data member defined out-of-line", 0, true, false, 3)
DIAG(err_noreturn_block_has_return_expr, CLASS_ERROR, diag::MAP_ERROR, "block declared 'noreturn' should not return", 0, true, false, 3)
DIAG(err_not_class_template_specialization, CLASS_ERROR, diag::MAP_ERROR, "cannot specialize a %select{dependent template|template template parameter}0", 0, true, false, 3)
DIAG(err_not_direct_base_or_virtual, CLASS_ERROR, diag::MAP_ERROR, "type %0 is not a direct or virtual base of %1", 0, true, false, 3)
DIAG(err_not_integral_type_anon_bitfield, CLASS_ERROR, diag::MAP_ERROR, "anonymous bit-field has non-integral type %0", 0, true, false, 3)
DIAG(err_not_integral_type_bitfield, CLASS_ERROR, diag::MAP_ERROR, "bit-field %0 has non-integral type %1", 0, true, false, 3)
DIAG(err_not_reference_to_const_init, CLASS_ERROR, diag::MAP_ERROR, "%select{non-const|volatile}0 lvalue reference to type %1 cannot be initialized with a %select{value|temporary}2 of type %3", 0, true, false, 3)
DIAG(err_not_tag_in_scope, CLASS_ERROR, diag::MAP_ERROR, "no %select{struct|union|class|enum}0 named %1 in %2", 0, true, false, 3)
DIAG(err_nsobject_attribute, CLASS_ERROR, diag::MAP_ERROR, "__attribute ((NSObject)) is for pointer types only", 0, true, false, 3)
DIAG(err_objc_array_of_interfaces, CLASS_ERROR, diag::MAP_ERROR, "array of interface %0 is invalid (probably should be an array of pointers)", 0, true, false, 3)
DIAG(err_objc_decls_may_only_appear_in_global_scope, CLASS_ERROR, diag::MAP_ERROR, "Objective-C declarations may only appear in global scope", 0, true, false, 3)
DIAG(err_objc_exceptions_disabled, CLASS_ERROR, diag::MAP_ERROR, "cannot use '%0' with Objective-C exceptions disabled", 0, true, false, 3)
DIAG(err_objc_object_catch, CLASS_ERROR, diag::MAP_ERROR, "can't catch an Objective C object by value", 0, true, false, 3)
DIAG(err_objc_pointer_cxx_catch_fragile, CLASS_ERROR, diag::MAP_ERROR, "can't catch Objective C exceptions in C++ in the non-unified exception model", 0, true, false, 3)
DIAG(err_objc_pointer_cxx_catch_gnu, CLASS_ERROR, diag::MAP_ERROR, "can't catch Objective C exceptions in C++ in the GNU runtime", 0, true, false, 3)
DIAG(err_objc_property_attr_mutually_exclusive, CLASS_ERROR, diag::MAP_ERROR, "property attributes '%0' and '%1' are mutually exclusive", 0, true, false, 3)
DIAG(err_objc_property_requires_object, CLASS_ERROR, diag::MAP_ERROR, "property with '%0' attribute must be of object type", 0, true, false, 3)
DIAG(err_objc_var_decl_inclass, CLASS_ERROR, diag::MAP_ERROR, "cannot declare variable inside @interface or @protocol", 0, true, false, 3)
DIAG(err_object_cannot_be_passed_returned_by_value, CLASS_ERROR, diag::MAP_ERROR, "interface type %1 cannot be %select{returned|passed}0 by value; did you forget * in %1", 0, true, false, 3)
DIAG(err_offsetof_array_type, CLASS_ERROR, diag::MAP_ERROR, "offsetof requires array type, %0 invalid", 0, true, false, 3)
DIAG(err_offsetof_bitfield, CLASS_ERROR, diag::MAP_ERROR, "cannot compute offset of bit-field %0", 0, true, false, 3)
DIAG(err_offsetof_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "offsetof of incomplete type %0", 0, true, false, 3)
DIAG(err_offsetof_record_type, CLASS_ERROR, diag::MAP_ERROR, "offsetof requires struct, union, or class type, %0 invalid", 0, true, false, 3)
DIAG(err_only_constructors_take_base_inits, CLASS_ERROR, diag::MAP_ERROR, "only constructors take base initializers", 0, true, false, 3)
DIAG(err_operator_arrow_circular, CLASS_ERROR, diag::MAP_ERROR, "circular pointer delegation detected", 0, true, false, 3)
DIAG(err_operator_delete_dependent_param_type, CLASS_ERROR, diag::MAP_ERROR, "%0 cannot take a dependent type as first parameter; use %1 instead", 0, true, false, 3)
DIAG(err_operator_delete_param_type, CLASS_ERROR, diag::MAP_ERROR, "first parameter of %0 must have type %1", 0, true, false, 3)
DIAG(err_operator_new_default_arg, CLASS_ERROR, diag::MAP_ERROR, "parameter of %0 cannot have a default argument", 0, true, false, 3)
DIAG(err_operator_new_delete_declared_in_namespace, CLASS_ERROR, diag::MAP_ERROR, "%0 cannot be declared inside a namespace", 0, true, false, 3)
DIAG(err_operator_new_delete_declared_static, CLASS_ERROR, diag::MAP_ERROR, "%0 cannot be declared static in global scope", 0, true, false, 3)
DIAG(err_operator_new_delete_dependent_result_type, CLASS_ERROR, diag::MAP_ERROR, "%0 cannot have a dependent return type; use %1 instead", 0, true, false, 3)
DIAG(err_operator_new_delete_invalid_result_type, CLASS_ERROR, diag::MAP_ERROR, "%0 must return type %1", 0, true, false, 3)
DIAG(err_operator_new_delete_template_too_few_parameters, CLASS_ERROR, diag::MAP_ERROR, "%0 template must have at least two parameters.", 0, true, false, 3)
DIAG(err_operator_new_delete_too_few_parameters, CLASS_ERROR, diag::MAP_ERROR, "%0 must have at least one parameter.", 0, true, false, 3)
DIAG(err_operator_new_dependent_param_type, CLASS_ERROR, diag::MAP_ERROR, "%0 cannot take a dependent type as first parameter; use size_t (%1) instead", 0, true, false, 3)
DIAG(err_operator_new_param_type, CLASS_ERROR, diag::MAP_ERROR, "%0 takes type size_t (%1) as first parameter", 0, true, false, 3)
DIAG(err_operator_overload_default_arg, CLASS_ERROR, diag::MAP_ERROR, "parameter of overloaded %0 cannot have a default argument", 0, true, false, 3)
DIAG(err_operator_overload_must_be, CLASS_ERROR, diag::MAP_ERROR, "overloaded %0 must be a %select{unary|binary|unary or binary}2 operator (has %1 parameter%s1)", 0, true, false, 3)
DIAG(err_operator_overload_must_be_member, CLASS_ERROR, diag::MAP_ERROR, "overloaded %0 must be a non-static member function", 0, true, false, 3)
DIAG(err_operator_overload_needs_class_or_enum, CLASS_ERROR, diag::MAP_ERROR, "overloaded %0 must have at least one parameter of class or enumeration type", 0, true, false, 3)
DIAG(err_operator_overload_post_incdec_must_be_int, CLASS_ERROR, diag::MAP_ERROR, "parameter of overloaded post-%select{increment|decrement}1 operator must have type 'int' (not %0)", 0, true, false, 3)
DIAG(err_operator_overload_static, CLASS_ERROR, diag::MAP_ERROR, "overloaded %0 cannot be a static member function", 0, true, false, 3)
DIAG(err_operator_overload_variadic, CLASS_ERROR, diag::MAP_ERROR, "overloaded %0 cannot be variadic", 0, true, false, 3)
DIAG(err_overload_expr_requires_non_zero_constant, CLASS_ERROR, diag::MAP_ERROR, "overload requires a non-zero constant expression as first argument", 0, true, false, 3)
DIAG(err_overload_incorrect_fntype, CLASS_ERROR, diag::MAP_ERROR, "argument is not a function, or has wrong number of parameters", 0, true, false, 3)
DIAG(err_override_exception_spec, CLASS_ERROR, diag::MAP_ERROR, "exception specification of overriding function is more lax than base version", 0, true, false, 3)
DIAG(err_ovl_ambiguous_call, CLASS_ERROR, diag::MAP_ERROR, "call to %0 is ambiguous", 0, true, false, 3)
DIAG(err_ovl_ambiguous_conversion_in_cast, CLASS_ERROR, diag::MAP_ERROR, "ambiguous conversion for %select{|static_cast|reinterpret_cast|dynamic_cast|C-style cast|functional-style cast}0 from %1 to %2", 0, true, false, 3)
DIAG(err_ovl_ambiguous_init, CLASS_ERROR, diag::MAP_ERROR, "call to constructor of %0 is ambiguous", 0, true, false, 3)
DIAG(err_ovl_ambiguous_member_call, CLASS_ERROR, diag::MAP_ERROR, "call to member function %0 is ambiguous", 0, true, false, 3)
DIAG(err_ovl_ambiguous_object_call, CLASS_ERROR, diag::MAP_ERROR, "call to object of type %0 is ambiguous", 0, true, false, 3)
DIAG(err_ovl_ambiguous_oper_binary, CLASS_ERROR, diag::MAP_ERROR, "use of overloaded operator '%0' is ambiguous (with operand types %1 and %2)", 0, true, false, 3)
DIAG(err_ovl_ambiguous_oper_unary, CLASS_ERROR, diag::MAP_ERROR, "use of overloaded operator '%0' is ambiguous (operand type %1)", 0, true, false, 3)
DIAG(err_ovl_deleted_call, CLASS_ERROR, diag::MAP_ERROR, "call to %select{unavailable|deleted}0 function %1 %2", 0, true, false, 3)
DIAG(err_ovl_deleted_conversion_in_cast, CLASS_ERROR, diag::MAP_ERROR, "%select{|static_cast|reinterpret_cast|dynamic_cast|C-style cast|functional-style cast}0 from %1 to %2 uses deleted function", 0, true, false, 3)
DIAG(err_ovl_deleted_init, CLASS_ERROR, diag::MAP_ERROR, "call to %select{unavailable|deleted}0 constructor of %1", 0, true, false, 3)
DIAG(err_ovl_deleted_member_call, CLASS_ERROR, diag::MAP_ERROR, "call to %select{unavailable|deleted}0 member function %1 %2", 0, true, false, 3)
DIAG(err_ovl_deleted_object_call, CLASS_ERROR, diag::MAP_ERROR, "call to %select{unavailable|deleted}0 function call operator in type %1 %2", 0, true, false, 3)
DIAG(err_ovl_deleted_oper, CLASS_ERROR, diag::MAP_ERROR, "overload resolution selected %select{unavailable|deleted}0 operator '%1' %2", 0, true, false, 3)
DIAG(err_ovl_diff_return_type, CLASS_ERROR, diag::MAP_ERROR, "functions that differ only in their return type cannot be overloaded", 0, true, false, 3)
DIAG(err_ovl_no_conversion_in_cast, CLASS_ERROR, diag::MAP_ERROR, "cannot convert %1 to %2 without a conversion operator", 0, true, false, 3)
DIAG(err_ovl_no_oper, CLASS_ERROR, diag::MAP_ERROR, "type %0 does not provide a %select{subscript|call}1 operator", 0, true, false, 3)
DIAG(err_ovl_no_viable_conversion_in_cast, CLASS_ERROR, diag::MAP_ERROR, "no matching conversion for %select{|static_cast|reinterpret_cast|dynamic_cast|C-style cast|functional-style cast}0 from %1 to %2", 0, true, false, 3)
DIAG(err_ovl_no_viable_function_in_call, CLASS_ERROR, diag::MAP_ERROR, "no matching function for call to %0", 0, true, false, 3)
DIAG(err_ovl_no_viable_function_in_init, CLASS_ERROR, diag::MAP_ERROR, "no matching constructor for initialization of %0", 0, true, false, 3)
DIAG(err_ovl_no_viable_member_function_in_call, CLASS_ERROR, diag::MAP_ERROR, "no matching member function for call to %0", 0, true, false, 3)
DIAG(err_ovl_no_viable_object_call, CLASS_ERROR, diag::MAP_ERROR, "no matching function for call to object of type %0", 0, true, false, 3)
DIAG(err_ovl_no_viable_oper, CLASS_ERROR, diag::MAP_ERROR, "no viable overloaded '%0'", 0, true, false, 3)
DIAG(err_ovl_no_viable_subscript, CLASS_ERROR, diag::MAP_ERROR, "no viable overloaded operator[] for type %0", 0, true, false, 3)
DIAG(err_ovl_static_nonstatic_member, CLASS_ERROR, diag::MAP_ERROR, "static and non-static member functions with the same parameter types cannot be overloaded", 0, true, false, 3)
DIAG(err_ovl_unresolvable, CLASS_ERROR, diag::MAP_ERROR, "cannot resolve overloaded function from context", 0, true, false, 3)
DIAG(err_ownership_type, CLASS_ERROR, diag::MAP_ERROR, "%0 attribute only applies to %1 arguments", 0, true, false, 3)
DIAG(err_pack_expansion_length_conflict, CLASS_ERROR, diag::MAP_ERROR, "pack expansion contains parameter packs %0 and %1 that have different lengths (%2 vs. %3)", 0, true, false, 3)
DIAG(err_pack_expansion_length_conflict_multilevel, CLASS_ERROR, diag::MAP_ERROR, "pack expansion contains parameter pack %0 that has a different length (%1 vs. %2) from outer parameter packs", 0, true, false, 3)
DIAG(err_pack_expansion_member_init, CLASS_ERROR, diag::MAP_ERROR, "pack expansion for initialization of member %0", 0, true, false, 3)
DIAG(err_pack_expansion_without_parameter_packs, CLASS_ERROR, diag::MAP_ERROR, "pack expansion does not contain any unexpanded parameter packs", 0, true, false, 3)
DIAG(err_param_default_argument, CLASS_ERROR, diag::MAP_ERROR, "C does not support default arguments", 0, true, false, 3)
DIAG(err_param_default_argument_member_template_redecl, CLASS_ERROR, diag::MAP_ERROR, "default arguments cannot be added to an out-of-line definition of a member of a %select{class template|class template partial specialization|nested class in a template}0", 0, true, false, 3)
DIAG(err_param_default_argument_missing, CLASS_ERROR, diag::MAP_ERROR, "missing default argument on parameter", 0, true, false, 3)
DIAG(err_param_default_argument_missing_name, CLASS_ERROR, diag::MAP_ERROR, "missing default argument on parameter %0", 0, true, false, 3)
DIAG(err_param_default_argument_nonfunc, CLASS_ERROR, diag::MAP_ERROR, "default arguments can only be specified for parameters in a function declaration", 0, true, false, 3)
DIAG(err_param_default_argument_redefinition, CLASS_ERROR, diag::MAP_ERROR, "redefinition of default argument", 0, true, false, 3)
DIAG(err_param_default_argument_references_local, CLASS_ERROR, diag::MAP_ERROR, "default argument references local variable %0 of enclosing function", 0, true, false, 3)
DIAG(err_param_default_argument_references_param, CLASS_ERROR, diag::MAP_ERROR, "default argument references parameter %0", 0, true, false, 3)
DIAG(err_param_default_argument_references_this, CLASS_ERROR, diag::MAP_ERROR, "default argument references 'this'", 0, true, false, 3)
DIAG(err_param_default_argument_template_redecl, CLASS_ERROR, diag::MAP_ERROR, "default arguments cannot be added to a function template that has already been declared", 0, true, false, 3)
DIAG(err_param_typedef_of_void, CLASS_ERROR, diag::MAP_ERROR, "empty parameter list defined with a typedef of 'void' not allowed in C++", 0, true, false, 3)
DIAG(err_param_with_void_type, CLASS_ERROR, diag::MAP_ERROR, "argument may not have 'void' type", 0, true, false, 3)
DIAG(err_parameter_name_omitted, CLASS_ERROR, diag::MAP_ERROR, "parameter name omitted", 0, true, false, 3)
DIAG(err_parens_pointer_member_function, CLASS_ERROR, diag::MAP_ERROR, "cannot parenthesize the name of a method when forming a member pointer", 0, true, false, 3)
DIAG(err_partial_spec_args_match_primary_template, CLASS_ERROR, diag::MAP_ERROR, "class template partial specialization does not specialize any template argument; to %select{declare|define}0 the primary template, remove the template argument list", 0, true, false, 3)
DIAG(err_partial_spec_fully_specialized, CLASS_ERROR, diag::MAP_ERROR, "partial specialization of %0 does not use any of its template parameters", 0, true, false, 3)
DIAG(err_partial_spec_ordering_ambiguous, CLASS_ERROR, diag::MAP_ERROR, "ambiguous partial specializations of %0", 0, true, false, 3)
DIAG(err_partial_spec_redeclared, CLASS_ERROR, diag::MAP_ERROR, "class template partial specialization %0 cannot be redeclared", 0, true, false, 3)
DIAG(err_partial_specialization_friend, CLASS_ERROR, diag::MAP_ERROR, "partial specialization cannot be declared as a friend", 0, true, false, 3)
DIAG(err_placement_new_non_placement_delete, CLASS_ERROR, diag::MAP_ERROR, "'new' expression with placement arguments refers to non-placement 'operator delete'", 0, true, false, 3)
DIAG(err_pointer_to_member_call_drops_quals, CLASS_ERROR, diag::MAP_ERROR, "call to pointer to member function of type %0 drops '%1' qualifier%s2", 0, true, false, 3)
DIAG(err_pointer_to_member_oper_value_classify, CLASS_ERROR, diag::MAP_ERROR, "pointer-to-member function type %0 can only be called on an %select{rvalue|lvalue}1", 0, true, false, 3)
DIAG(err_pointer_to_member_type, CLASS_ERROR, diag::MAP_ERROR, "invalid use of pointer to member type after %select{.*|->*}0", 0, true, false, 3)
DIAG(err_pragma_options_align_mac68k_target_unsupported, CLASS_ERROR, diag::MAP_ERROR, "mac68k alignment pragma is not supported on this target", 0, true, false, 3)
DIAG(err_property_not_as_forward_class, CLASS_ERROR, diag::MAP_ERROR, "property %0 refers to an incomplete Objective-C class %1 (with no @interface available)", 0, true, false, 3)
DIAG(err_property_not_found, CLASS_ERROR, diag::MAP_ERROR, "property %0 not found on object of type %1", 0, true, false, 3)
DIAG(err_property_not_found_forward_class, CLASS_ERROR, diag::MAP_ERROR, "property %0 cannot be found in forward class object %1", 0, true, false, 3)
DIAG(err_property_not_found_suggest, CLASS_ERROR, diag::MAP_ERROR, "property %0 not found on object of type %1; did you mean %2?", 0, true, false, 3)
DIAG(err_property_type, CLASS_ERROR, diag::MAP_ERROR, "property cannot have array or function type %0", 0, true, false, 3)
DIAG(err_protocol_has_circular_dependency, CLASS_ERROR, diag::MAP_ERROR, "protocol has circular dependency", 0, true, false, 3)
DIAG(err_pseudo_dtor_base_not_scalar, CLASS_ERROR, diag::MAP_ERROR, "object expression of non-scalar type %0 cannot be used in a pseudo-destructor expression", 0, true, false, 3)
DIAG(err_pseudo_dtor_call_with_args, CLASS_ERROR, diag::MAP_ERROR, "call to pseudo-destructor cannot have any arguments", 0, true, false, 3)
DIAG(err_pseudo_dtor_destructor_non_type, CLASS_ERROR, diag::MAP_ERROR, "%0 does not refer to a type name in pseudo-destructor expression; expected the name of type %1", 0, true, false, 3)
DIAG(err_pseudo_dtor_template, CLASS_ERROR, diag::MAP_ERROR, "specialization of template %0 does not refer to a scalar type in pseudo-destructor expression", 0, true, false, 3)
DIAG(err_pseudo_dtor_type_mismatch, CLASS_ERROR, diag::MAP_ERROR, "the type of object expression (%0) does not match the type being destroyed (%1) in pseudo-destructor expression", 0, true, false, 3)
DIAG(err_qualified_block_pointer_type, CLASS_ERROR, diag::MAP_ERROR, "qualifier specification on block pointer type not allowed", 0, true, false, 3)
DIAG(err_qualified_catch_declarator, CLASS_ERROR, diag::MAP_ERROR, "exception declarator cannot be qualified", 0, true, false, 3)
DIAG(err_qualified_friend_not_found, CLASS_ERROR, diag::MAP_ERROR, "no function named %0 with type %1 was found in the specified scope", 0, true, false, 3)
DIAG(err_qualified_member_nonclass, CLASS_ERROR, diag::MAP_ERROR, "qualified member access refers to a member in %0", 0, true, false, 3)
DIAG(err_qualified_member_of_unrelated, CLASS_ERROR, diag::MAP_ERROR, "%q0 is not a member of class %1", 0, true, false, 3)
DIAG(err_qualified_objc_catch_parm, CLASS_ERROR, diag::MAP_ERROR, "@catch parameter declarator cannot be qualified", 0, true, false, 3)
DIAG(err_qualified_param_declarator, CLASS_ERROR, diag::MAP_ERROR, "parameter declarator cannot be qualified", 0, true, false, 3)
DIAG(err_qualified_typedef_declarator, CLASS_ERROR, diag::MAP_ERROR, "typedef declarator cannot be qualified", 0, true, false, 3)
DIAG(err_realimag_invalid_type, CLASS_ERROR, diag::MAP_ERROR, "invalid type %0 to %1 operator", 0, true, false, 3)
DIAG(err_recursive_superclass, CLASS_ERROR, diag::MAP_ERROR, "trying to recursively use %0 as superclass of %1", 0, true, false, 3)
DIAG(err_redefinition, CLASS_ERROR, diag::MAP_ERROR, "redefinition of %0", 0, true, false, 3)
DIAG(err_redefinition_different_kind, CLASS_ERROR, diag::MAP_ERROR, "redefinition of %0 as different kind of symbol", 0, true, false, 3)
DIAG(err_redefinition_different_type, CLASS_ERROR, diag::MAP_ERROR, "redefinition of %0 with a different type", 0, true, false, 3)
DIAG(err_redefinition_different_typedef, CLASS_ERROR, diag::MAP_ERROR, "typedef redefinition with different types (%0 vs %1)", 0, true, false, 3)
DIAG(err_redefinition_extern_inline, CLASS_ERROR, diag::MAP_ERROR, "redefinition of a 'extern inline' function %0 is not supported in %select{C99 mode|C++}1", 0, true, false, 3)
DIAG(err_redefinition_of_enumerator, CLASS_ERROR, diag::MAP_ERROR, "redefinition of enumerator %0", 0, true, false, 3)
DIAG(err_redefinition_of_label, CLASS_ERROR, diag::MAP_ERROR, "redefinition of label %0", 0, true, false, 3)
DIAG(err_ref_array_type, CLASS_ERROR, diag::MAP_ERROR, "cannot refer to declaration with an array type inside block", 0, true, false, 3)
DIAG(err_ref_init_ambiguous, CLASS_ERROR, diag::MAP_ERROR, "reference initialization of type %0 with initializer of type %1 is ambiguous", 0, true, false, 3)
DIAG(err_ref_non_value, CLASS_ERROR, diag::MAP_ERROR, "%0 does not refer to a value", 0, true, false, 3)
DIAG(err_ref_qualifier_constructor, CLASS_ERROR, diag::MAP_ERROR, "ref-qualifier '%select{&&|&}0' is not allowed on a constructor", 0, true, false, 3)
DIAG(err_ref_qualifier_destructor, CLASS_ERROR, diag::MAP_ERROR, "ref-qualifier '%select{&&|&}0' is not allowed on a destructor", 0, true, false, 3)
DIAG(err_ref_qualifier_overload, CLASS_ERROR, diag::MAP_ERROR, "cannot overload a member function %select{without a ref-qualifier|with ref-qualifier '&'|with ref-qualifier '&&'}0 with a member function %select{without a ref-qualifier|with ref-qualifier '&'|with ref-qualifier '&&'}1", 0, true, false, 3)
DIAG(err_ref_vm_type, CLASS_ERROR, diag::MAP_ERROR, "cannot refer to declaration with a variably modified type inside block", 0, true, false, 3)
DIAG(err_reference_bind_drops_quals, CLASS_ERROR, diag::MAP_ERROR, "binding of reference to type %0 to a value of type %1 drops qualifiers", 0, true, false, 3)
DIAG(err_reference_bind_failed, CLASS_ERROR, diag::MAP_ERROR, "reference to type %0 could not bind to an %select{rvalue|lvalue}1 of type %2", 0, true, false, 3)
DIAG(err_reference_bind_init_list, CLASS_ERROR, diag::MAP_ERROR, "reference to type %0 cannot bind to an initializer list", 0, true, false, 3)
DIAG(err_reference_bind_to_bitfield, CLASS_ERROR, diag::MAP_ERROR, "%select{non-const|volatile}0 reference cannot bind to bit-field %1", 0, true, false, 3)
DIAG(err_reference_bind_to_vector_element, CLASS_ERROR, diag::MAP_ERROR, "%select{non-const|volatile}0 reference cannot bind to vector element", 0, true, false, 3)
DIAG(err_reference_has_multiple_inits, CLASS_ERROR, diag::MAP_ERROR, "reference cannot be initialized with multiple values", 0, true, false, 3)
DIAG(err_reference_init_drops_quals, CLASS_ERROR, diag::MAP_ERROR, "initialization of reference to type %0 with a %select{value|temporary}1 of type %2 drops qualifiers", 0, true, false, 3)
DIAG(err_reference_to_local_var_in_enclosing_function, CLASS_ERROR, diag::MAP_ERROR, "reference to local variable %0 declared in enclosed function %1", 0, true, false, 3)
DIAG(err_reference_to_void, CLASS_ERROR, diag::MAP_ERROR, "cannot form a reference to 'void'", 0, true, false, 3)
DIAG(err_reference_var_requires_init, CLASS_ERROR, diag::MAP_ERROR, "declaration of reference variable %0 requires an initializer", 0, true, false, 3)
DIAG(err_reference_without_init, CLASS_ERROR, diag::MAP_ERROR, "reference to type %0 requires an initializer", 0, true, false, 3)
DIAG(err_regparm_mismatch, CLASS_ERROR, diag::MAP_ERROR, "function declared with with regparm(%0) attribute was previously declared %plural{0:without the regparm|:with the regparm(%1)}1 attribute", 0, true, false, 3)
DIAG(err_repeat_attribute, CLASS_ERROR, diag::MAP_ERROR, "'%0' attribute cannot be repeated", 0, true, false, 3)
DIAG(err_ret_local_block, CLASS_ERROR, diag::MAP_ERROR, "returning block that lives on the local stack", 0, true, false, 3)
DIAG(err_return_block_has_expr, CLASS_ERROR, diag::MAP_ERROR, "void block should not return a value", 0, true, false, 3)
DIAG(err_return_in_block_expression, CLASS_ERROR, diag::MAP_ERROR, "return not allowed in block expression literal", 0, true, false, 3)
DIAG(err_return_in_constructor_handler, CLASS_ERROR, diag::MAP_ERROR, "return in the catch of a function try block of a constructor is illegal", 0, true, false, 3)
DIAG(err_selector_element_not_lvalue, CLASS_ERROR, diag::MAP_ERROR, "selector element is not a valid lvalue", 0, true, false, 3)
DIAG(err_selector_element_type, CLASS_ERROR, diag::MAP_ERROR, "selector element type %0 is not a valid object", 0, true, false, 3)
DIAG(err_setter_type_void, CLASS_ERROR, diag::MAP_ERROR, "type of setter must be void", 0, true, false, 3)
DIAG(err_shufflevector_argument_too_large, CLASS_ERROR, diag::MAP_ERROR, "index for __builtin_shufflevector must be less than the total number of vector elements", 0, true, false, 3)
DIAG(err_shufflevector_incompatible_vector, CLASS_ERROR, diag::MAP_ERROR, "first two arguments to __builtin_shufflevector must have the same type", 0, true, false, 3)
DIAG(err_shufflevector_non_vector, CLASS_ERROR, diag::MAP_ERROR, "first two arguments to __builtin_shufflevector must be vectors", 0, true, false, 3)
DIAG(err_shufflevector_nonconstant_argument, CLASS_ERROR, diag::MAP_ERROR, "index for __builtin_shufflevector must be a constant integer", 0, true, false, 3)
DIAG(err_sizeof_alignof_bitfield, CLASS_ERROR, diag::MAP_ERROR, "invalid application of '%select{sizeof|__alignof}0' to bit-field", 0, true, false, 3)
DIAG(err_sizeof_alignof_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "invalid application of '%select{sizeof|__alignof}0' to an incomplete type %1", 0, true, false, 3)
DIAG(err_sizeof_alignof_overloaded_function_type, CLASS_ERROR, diag::MAP_ERROR, "invalid application of '%select{sizeof|__alignof}0' to an overloaded function", 0, true, false, 3)
DIAG(err_sizeof_nonfragile_interface, CLASS_ERROR, diag::MAP_ERROR, "invalid application of '%select{alignof|sizeof}1' to interface %0 in non-fragile ABI", 0, true, false, 3)
DIAG(err_sizeof_pack_no_pack_name, CLASS_ERROR, diag::MAP_ERROR, "%0 does not refer to the name of a parameter pack", 0, true, false, 3)
DIAG(err_sizeof_pack_no_pack_name_suggest, CLASS_ERROR, diag::MAP_ERROR, "%0 does not refer to the name of a parameter pack; did you mean %1?", 0, true, false, 3)
DIAG(err_spec_member_not_instantiated, CLASS_ERROR, diag::MAP_ERROR, "specialization of member %q0 does not specialize an instantiated member", 0, true, false, 3)
DIAG(err_specialization_after_instantiation, CLASS_ERROR, diag::MAP_ERROR, "explicit specialization of %0 after instantiation", 0, true, false, 3)
DIAG(err_static_assert_expression_is_not_constant, CLASS_ERROR, diag::MAP_ERROR, "static_assert expression is not an integral constant expression", 0, true, false, 3)
DIAG(err_static_assert_failed, CLASS_ERROR, diag::MAP_ERROR, "static_assert failed \"%0\"", 0, true, false, 3)
DIAG(err_static_block_func, CLASS_ERROR, diag::MAP_ERROR, "function declared in block scope cannot have 'static' storage class", 0, true, false, 3)
DIAG(err_static_data_member_not_allowed_in_local_class, CLASS_ERROR, diag::MAP_ERROR, "static data member %0 not allowed in local class %1", 0, true, false, 3)
DIAG(err_static_data_member_not_allowed_in_union_or_anon_struct, CLASS_ERROR, diag::MAP_ERROR, "static data member %0 not allowed in %select{anonymous struct|union}1", 0, true, false, 3)
DIAG(err_static_downcast_via_virtual, CLASS_ERROR, diag::MAP_ERROR, "cannot cast %0 to %1 via virtual base %2", 0, true, false, 3)
DIAG(err_static_illegal_in_new, CLASS_ERROR, diag::MAP_ERROR, "the 'static' modifier for the array size is not legal in new expressions", 0, true, false, 3)
DIAG(err_static_non_static, CLASS_ERROR, diag::MAP_ERROR, "static declaration of %0 follows non-static declaration", 0, true, false, 3)
DIAG(err_static_not_bitfield, CLASS_ERROR, diag::MAP_ERROR, "static member %0 cannot be a bit-field", 0, true, false, 3)
DIAG(err_static_out_of_line, CLASS_ERROR, diag::MAP_ERROR, "'static' can only be specified inside the class definition", 0, true, false, 3)
DIAG(err_static_overrides_virtual, CLASS_ERROR, diag::MAP_ERROR, "'static' member function %0 overrides a virtual function in a base class", 0, true, false, 3)
DIAG(err_statically_allocated_object, CLASS_ERROR, diag::MAP_ERROR, "interface type cannot be statically allocated", 0, true, false, 3)
DIAG(err_stmtexpr_file_scope, CLASS_ERROR, diag::MAP_ERROR, "statement expression not allowed at file scope", 0, true, false, 3)
DIAG(err_storage_spec_on_catch_parm, CLASS_ERROR, diag::MAP_ERROR, "@catch parameter cannot have storage specifier %select{|'typedef'|'extern'|'static'|'auto'|'register'|'__private_extern__'|'mutable'}0", 0, true, false, 3)
DIAG(err_storageclass_invalid_for_member, CLASS_ERROR, diag::MAP_ERROR, "storage class specified for a member declaration", 0, true, false, 3)
DIAG(err_subscript_function_type, CLASS_ERROR, diag::MAP_ERROR, "subscript of pointer to function type %0", 0, true, false, 3)
DIAG(err_subscript_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "subscript of pointer to incomplete type %0", 0, true, false, 3)
DIAG(err_subscript_nonfragile_interface, CLASS_ERROR, diag::MAP_ERROR, "subscript requires size of interface %0, which is not constant in non-fragile ABI", 0, true, false, 3)
DIAG(err_switch_explicit_conversion, CLASS_ERROR, diag::MAP_ERROR, "switch condition type %0 requires explicit conversion to %1", 0, true, false, 3)
DIAG(err_switch_incomplete_class_type, CLASS_ERROR, diag::MAP_ERROR, "switch condition has incomplete class type %0", 0, true, false, 3)
DIAG(err_switch_into_protected_scope, CLASS_ERROR, diag::MAP_ERROR, "switch case is in protected scope", 0, true, false, 3)
DIAG(err_switch_multiple_conversions, CLASS_ERROR, diag::MAP_ERROR, "multiple conversions from switch condition type %0 to an integral or enumeration type", 0, true, false, 3)
DIAG(err_tag_definition_of_typedef, CLASS_ERROR, diag::MAP_ERROR, "definition of type %0 conflicts with typedef of the same name", 0, true, false, 3)
DIAG(err_tag_reference_conflict, CLASS_ERROR, diag::MAP_ERROR, "implicit declaration introduced by elaborated type conflicts with %select{a declaration|a typedef|a template}0 of the same name", 0, true, false, 3)
DIAG(err_tag_reference_non_tag, CLASS_ERROR, diag::MAP_ERROR, "elaborated type refers to %select{a non-tag type|a typedef|a template}0", 0, true, false, 3)
DIAG(err_tagless_friend_type_template, CLASS_ERROR, diag::MAP_ERROR, "friend type templates must use an elaborated type", 0, true, false, 3)
DIAG(err_temp_copy_ambiguous, CLASS_ERROR, diag::MAP_ERROR, "ambiguous constructor call when %select{copying variable|copying parameter|returning object|throwing object|copying member subobject|copying array element|allocating object|copying temporary|initializing base subobject|initializing vector element}0 of type %1", 0, true, false, 3)
DIAG(err_temp_copy_deleted, CLASS_ERROR, diag::MAP_ERROR, "%select{copying variable|copying parameter|returning object|throwing object|copying member subobject|copying array element|allocating object|copying temporary|initializing base subobject|initializing vector element}0 of type %1 invokes deleted constructor", 0, true, false, 3)
DIAG(err_temp_copy_incomplete, CLASS_ERROR, diag::MAP_ERROR, "copying a temporary object of incomplete type %0", 0, true, false, 3)
DIAG(err_temp_copy_no_viable, CLASS_ERROR, diag::MAP_ERROR, "no viable constructor %select{copying variable|copying parameter|returning object|throwing object|copying member subobject|copying array element|allocating object|copying temporary|initializing base subobject|initializing vector element}0 of type %1", 0, true, false, 3)
DIAG(err_template_arg_address_of_non_pointer, CLASS_ERROR, diag::MAP_ERROR, "address taken in non-type template argument for template parameter of reference type %0", 0, true, false, 3)
DIAG(err_template_arg_field, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument refers to non-static data member %0", 0, true, false, 3)
DIAG(err_template_arg_function_not_extern, CLASS_ERROR, diag::MAP_ERROR, "non-template argument refers to function %0 with internal linkage", 0, true, false, 3)
DIAG(err_template_arg_list_different_arity, CLASS_ERROR, diag::MAP_ERROR, "%select{too few|too many}0 template arguments for %select{class template|function template|template template parameter|template}1 %2", 0, true, false, 3)
DIAG(err_template_arg_method, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument refers to non-static member function %0", 0, true, false, 3)
DIAG(err_template_arg_must_be_expr, CLASS_ERROR, diag::MAP_ERROR, "template argument for non-type template parameter must be an expression", 0, true, false, 3)
DIAG(err_template_arg_must_be_template, CLASS_ERROR, diag::MAP_ERROR, "template argument for template template parameter must be a class template", 0, true, false, 3)
DIAG(err_template_arg_must_be_type, CLASS_ERROR, diag::MAP_ERROR, "template argument for template type parameter must be a type", 0, true, false, 3)
DIAG(err_template_arg_no_ref_bind, CLASS_ERROR, diag::MAP_ERROR, "non-type template parameter of reference type %0 cannot bind to template argument of type %1", 0, true, false, 3)
DIAG(err_template_arg_nontype_ambig, CLASS_ERROR, diag::MAP_ERROR, "template argument for non-type template parameter is treated as type %0", 0, true, false, 3)
DIAG(err_template_arg_not_address_of, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument for template parameter of pointer type %0 must have its address taken", 0, true, false, 3)
DIAG(err_template_arg_not_class_template, CLASS_ERROR, diag::MAP_ERROR, "template argument does not refer to a class template or template template parameter", 0, true, false, 3)
DIAG(err_template_arg_not_convertible, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument of type %0 cannot be converted to a value of type %1", 0, true, false, 3)
DIAG(err_template_arg_not_decl_ref, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument does not refer to any declaration", 0, true, false, 3)
DIAG(err_template_arg_not_ice, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument of type %0 is not an integral constant expression", 0, true, false, 3)
DIAG(err_template_arg_not_integral_or_enumeral, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument of type %0 must have an integral or enumeration type", 0, true, false, 3)
DIAG(err_template_arg_not_object_or_func, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument does not refer to an object or function", 0, true, false, 3)
DIAG(err_template_arg_not_object_or_func_form, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument does not directly refer to an object or function", 0, true, false, 3)
DIAG(err_template_arg_not_pointer_to_member_form, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument is not a pointer to member constant", 0, true, false, 3)
DIAG(err_template_arg_object_not_extern, CLASS_ERROR, diag::MAP_ERROR, "non-template argument refers to object %0 that does not have external linkage", 0, true, false, 3)
DIAG(err_template_arg_overload_type, CLASS_ERROR, diag::MAP_ERROR, "template argument is the type of an unresolved overloaded function", 0, true, false, 3)
DIAG(err_template_arg_ref_bind_ignores_quals, CLASS_ERROR, diag::MAP_ERROR, "reference binding of non-type template parameter of type %0 to template argument of type %1 ignores qualifiers", 0, true, false, 3)
DIAG(err_template_arg_reference_var, CLASS_ERROR, diag::MAP_ERROR, "non-type template argument of reference type %0 is not an object", 0, true, false, 3)
DIAG(err_template_arg_template_params_mismatch, CLASS_ERROR, diag::MAP_ERROR, "template template argument has different template parameters than its corresponding template template parameter", 0, true, false, 3)
DIAG(err_template_decl_ref, CLASS_ERROR, diag::MAP_ERROR, "cannot refer to class template %0 without a template argument list", 0, true, false, 3)
DIAG(err_template_id_not_a_type, CLASS_ERROR, diag::MAP_ERROR, "template name refers to non-type template '%0'", 0, true, false, 3)
DIAG(err_template_instantiate_undefined, CLASS_ERROR, diag::MAP_ERROR, "%select{implicit|explicit}0 instantiation of undefined template %1", 0, true, false, 3)
DIAG(err_template_kw_missing, CLASS_ERROR, diag::MAP_ERROR, "missing 'template' keyword prior to dependent template name '%0%1'", 0, true, false, 3)
DIAG(err_template_kw_refers_to_class_template, CLASS_ERROR, diag::MAP_ERROR, "'%0%1' instantiated to a class template, not a function template", 0, true, false, 3)
DIAG(err_template_kw_refers_to_function_template, CLASS_ERROR, diag::MAP_ERROR, "%0 following the 'template' keyword refers to a function template", 0, true, false, 3)
DIAG(err_template_kw_refers_to_non_template, CLASS_ERROR, diag::MAP_ERROR, "%0 following the 'template' keyword does not refer to a template", 0, true, false, 3)
DIAG(err_template_linkage, CLASS_ERROR, diag::MAP_ERROR, "templates must have C++ linkage", 0, true, false, 3)
DIAG(err_template_missing_args, CLASS_ERROR, diag::MAP_ERROR, "use of class template %0 requires template arguments", 0, true, false, 3)
DIAG(err_template_nontype_parm_bad_type, CLASS_ERROR, diag::MAP_ERROR, "a non-type template parameter cannot have type %0", 0, true, false, 3)
DIAG(err_template_nontype_parm_different_type, CLASS_ERROR, diag::MAP_ERROR, "template non-type parameter has a different type %0 in template %select{|template parameter }1redeclaration", 0, true, false, 3)
DIAG(err_template_outside_namespace_or_class_scope, CLASS_ERROR, diag::MAP_ERROR, "templates can only be declared in namespace or class scope", 0, true, false, 3)
DIAG(err_template_param_default_arg_missing, CLASS_ERROR, diag::MAP_ERROR, "template parameter missing a default argument", 0, true, false, 3)
DIAG(err_template_param_default_arg_redefinition, CLASS_ERROR, diag::MAP_ERROR, "template parameter redefines default argument", 0, true, false, 3)
DIAG(err_template_param_different_kind, CLASS_ERROR, diag::MAP_ERROR, "template parameter has a different kind in template %select{|template parameter }0redeclaration", 0, true, false, 3)
DIAG(err_template_param_list_different_arity, CLASS_ERROR, diag::MAP_ERROR, "%select{too few|too many}0 template parameters in template %select{|template parameter }1redeclaration", 0, true, false, 3)
DIAG(err_template_param_list_matches_nontemplate, CLASS_ERROR, diag::MAP_ERROR, "template parameter list matching the non-templated nested type %0 should be empty ('template<>')", 0, true, false, 3)
DIAG(err_template_param_pack_default_arg, CLASS_ERROR, diag::MAP_ERROR, "template parameter pack cannot have a default argument", 0, true, false, 3)
DIAG(err_template_param_pack_must_be_last_template_parameter, CLASS_ERROR, diag::MAP_ERROR, "template parameter pack must be the last template parameter", 0, true, false, 3)
DIAG(err_template_param_shadow, CLASS_ERROR, diag::MAP_ERROR, "declaration of %0 shadows template parameter", 0, true, false, 3)
DIAG(err_template_parameter_default_friend_template, CLASS_ERROR, diag::MAP_ERROR, "default template argument not permitted on a friend template", 0, true, false, 3)
DIAG(err_template_parameter_default_template_member, CLASS_ERROR, diag::MAP_ERROR, "cannot add a default template argument to the definition of a member of a class template", 0, true, false, 3)
DIAG(err_template_parameter_pack_non_pack, CLASS_ERROR, diag::MAP_ERROR, "%select{template type|non-type template|template template}0 parameter%select{| pack}1 conflicts with previous %select{template type|non-type template|template template}0 parameter%select{ pack|}1", 0, true, false, 3)
DIAG(err_template_qualified_declarator_no_match, CLASS_ERROR, diag::MAP_ERROR, "nested name specifier '%0' for declaration does not refer into a class, class template or class template partial specialization", 0, true, false, 3)
DIAG(err_template_recursion_depth_exceeded, CLASS_ERROR, diag::MAP_FATAL, "recursive template instantiation exceeded maximum depth of %0", 0, false, false, 3)
DIAG(err_template_spec_decl_class_scope, CLASS_ERROR, diag::MAP_ERROR, "explicit specialization of %0 in class scope", 0, true, false, 3)
DIAG(err_template_spec_decl_friend, CLASS_ERROR, diag::MAP_ERROR, "cannot declare an explicit specialization in a friend", 0, true, false, 3)
DIAG(err_template_spec_decl_function_scope, CLASS_ERROR, diag::MAP_ERROR, "explicit specialization of %0 in function scope", 0, true, false, 3)
DIAG(err_template_spec_decl_out_of_scope, CLASS_ERROR, diag::MAP_ERROR, "%select{class template|class template partial|function template|member function|static data member|member class}0 specialization of %1 must originally be declared in namespace %2", 0, true, false, 3)
DIAG(err_template_spec_decl_out_of_scope_global, CLASS_ERROR, diag::MAP_ERROR, "%select{class template|class template partial|function template|member function|static data member|member class}0 specialization of %1 must originally be declared in the global scope", 0, true, false, 3)
DIAG(err_template_spec_default_arg, CLASS_ERROR, diag::MAP_ERROR, "default argument not permitted on an explicit %select{instantiation|specialization}0 of function %1", 0, true, false, 3)
DIAG(err_template_spec_extra_headers, CLASS_ERROR, diag::MAP_ERROR, "extraneous template parameter list in template specialization or out-of-line template definition", 0, true, false, 3)
DIAG(err_template_spec_friend, CLASS_ERROR, diag::MAP_ERROR, "template specialization declaration cannot be a friend", 0, true, false, 3)
DIAG(err_template_spec_needs_header, CLASS_ERROR, diag::MAP_ERROR, "template specialization requires 'template<>'", 0, true, false, 3)
DIAG(err_template_spec_needs_template_parameters, CLASS_ERROR, diag::MAP_ERROR, "template specialization or definition requires a template parameter list corresponding to the nested type %0", 0, true, false, 3)
DIAG(err_template_spec_redecl_global_scope, CLASS_ERROR, diag::MAP_ERROR, "%select{class template|class template partial|function template|member function|static data member|member class}0 specialization of %1 must occur at global scope", 0, true, false, 3)
DIAG(err_template_spec_redecl_out_of_scope, CLASS_ERROR, diag::MAP_ERROR, "%select{class template|class template partial|function template|member function|static data member|member class}0 specialization of %1 not in a namespace enclosing %2", 0, true, false, 3)
DIAG(err_template_spec_unknown_kind, CLASS_ERROR, diag::MAP_ERROR, "can only provide an explicit specialization for a class template, function template, or a member function, static data member, or member class of a class template", 0, true, false, 3)
DIAG(err_template_tag_noparams, CLASS_ERROR, diag::MAP_ERROR, "extraneous 'template<>' in declaration of %0 %1", 0, true, false, 3)
DIAG(err_template_template_parm_no_parms, CLASS_ERROR, diag::MAP_ERROR, "template template parameter must have its own template parameters", 0, true, false, 3)
DIAG(err_template_typedef, CLASS_ERROR, diag::MAP_ERROR, "a typedef cannot be a template", 0, true, false, 3)
DIAG(err_template_unnamed_class, CLASS_ERROR, diag::MAP_ERROR, "cannot declare a class template with no name", 0, true, false, 3)
DIAG(err_template_variable, CLASS_ERROR, diag::MAP_ERROR, "variable %0 declared as a template", 0, true, false, 3)
DIAG(err_template_variable_noparams, CLASS_ERROR, diag::MAP_ERROR, "extraneous 'template<>' in declaration of variable %0", 0, true, false, 3)
DIAG(err_tentative_def_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "tentative definition has type %0 that is never completed", 0, true, false, 3)
DIAG(err_tentative_def_incomplete_type_arr, CLASS_ERROR, diag::MAP_ERROR, "tentative definition has array of type %0 that is never completed", 0, true, false, 3)
DIAG(err_thread_non_global, CLASS_ERROR, diag::MAP_ERROR, "'__thread' variables must have global storage", 0, true, false, 3)
DIAG(err_thread_non_thread, CLASS_ERROR, diag::MAP_ERROR, "thread-local declaration of %0 follows non-thread-local declaration", 0, true, false, 3)
DIAG(err_thread_unsupported, CLASS_ERROR, diag::MAP_ERROR, "thread-local storage is unsupported for the current target", 0, true, false, 3)
DIAG(err_throw_abstract_type, CLASS_ERROR, diag::MAP_ERROR, "cannot throw an object of abstract type %0", 0, true, false, 3)
DIAG(err_throw_incomplete, CLASS_ERROR, diag::MAP_ERROR, "cannot throw object of incomplete type %0", 0, true, false, 3)
DIAG(err_throw_incomplete_ptr, CLASS_ERROR, diag::MAP_ERROR, "cannot throw pointer to object of incomplete type %0", 0, true, false, 3)
DIAG(err_toomany_element_decls, CLASS_ERROR, diag::MAP_ERROR, "only one element declaration is allowed", 0, true, false, 3)
DIAG(err_trailing_return_in_parens, CLASS_ERROR, diag::MAP_ERROR, "trailing return type may not be nested within parentheses", 0, true, false, 3)
DIAG(err_trailing_return_without_auto, CLASS_ERROR, diag::MAP_ERROR, "function with trailing return type must specify return type 'auto', not %0", 0, true, false, 3)
DIAG(err_type_defined_in_condition, CLASS_ERROR, diag::MAP_ERROR, "types may not be defined in conditions", 0, true, false, 3)
DIAG(err_type_defined_in_param_type, CLASS_ERROR, diag::MAP_ERROR, "%0 can not be defined in a parameter type", 0, true, false, 3)
DIAG(err_type_defined_in_result_type, CLASS_ERROR, diag::MAP_ERROR, "%0 can not be defined in the result type of a function", 0, true, false, 3)
DIAG(err_type_defined_in_type_specifier, CLASS_ERROR, diag::MAP_ERROR, "%0 can not be defined in a type specifier", 0, true, false, 3)
DIAG(err_typecheck_address_of, CLASS_ERROR, diag::MAP_ERROR, "address of %0 requested", 0, true, false, 3)
DIAG(err_typecheck_addrof_class_temporary, CLASS_ERROR, diag::MAP_ERROR, "taking the address of a temporary object of type %0", 0, true, false, 3)
DIAG(err_typecheck_ambiguous_condition, CLASS_ERROR, diag::MAP_ERROR, "conversion from %0 to %1 is ambiguous", 0, true, false, 3)
DIAG(err_typecheck_arithmetic_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "arithmetic on pointer to incomplete type %0", 0, true, false, 3)
DIAG(err_typecheck_array_not_modifiable_lvalue, CLASS_ERROR, diag::MAP_ERROR, "array type %0 is not assignable", 0, true, false, 3)
DIAG(err_typecheck_assign_const, CLASS_ERROR, diag::MAP_ERROR, "read-only variable is not assignable", 0, true, false, 3)
DIAG(err_typecheck_bool_condition, CLASS_ERROR, diag::MAP_ERROR, "value of type %0 is not contextually convertible to 'bool'", 0, true, false, 3)
DIAG(err_typecheck_call_invalid_ordered_compare, CLASS_ERROR, diag::MAP_ERROR, "ordered compare requires two args of floating point type (%0 and %1)", 0, true, false, 3)
DIAG(err_typecheck_call_invalid_unary_fp, CLASS_ERROR, diag::MAP_ERROR, "floating point classification requires argument of floating point type (passed in %0)", 0, true, false, 3)
DIAG(err_typecheck_call_not_function, CLASS_ERROR, diag::MAP_ERROR, "called object type %0 is not a function or function pointer", 0, true, false, 3)
DIAG(err_typecheck_call_too_few_args, CLASS_ERROR, diag::MAP_ERROR, "too few arguments to %select{function|block|method}0 call, expected %1, have %2", 0, true, false, 3)
DIAG(err_typecheck_call_too_few_args_at_least, CLASS_ERROR, diag::MAP_ERROR, "too few arguments to %select{function|block|method}0 call, expected at least %1, have %2", 0, true, false, 3)
DIAG(err_typecheck_call_too_many_args, CLASS_ERROR, diag::MAP_ERROR, "too many arguments to %select{function|block|method}0 call, expected %1, have %2", 0, true, false, 3)
DIAG(err_typecheck_call_too_many_args_at_most, CLASS_ERROR, diag::MAP_ERROR, "too many arguments to %select{function|block|method}0 call, expected at most %1, have %2", 0, true, false, 3)
DIAG(err_typecheck_cast_to_incomplete, CLASS_ERROR, diag::MAP_ERROR, "cast to incomplete type %0", 0, true, false, 3)
DIAG(err_typecheck_cast_to_union_no_type, CLASS_ERROR, diag::MAP_ERROR, "cast to union type from type %0 not present in union", 0, true, false, 3)
DIAG(err_typecheck_choose_expr_requires_constant, CLASS_ERROR, diag::MAP_ERROR, "'__builtin_choose_expr' requires a constant expression", 0, true, false, 3)
DIAG(err_typecheck_comparison_of_distinct_blocks, CLASS_ERROR, diag::MAP_ERROR, "comparison of distinct block types (%0 and %1)", 0, true, false, 3)
DIAG(err_typecheck_comparison_of_distinct_pointers, CLASS_ERROR, diag::MAP_ERROR, "comparison of distinct pointer types (%0 and %1)", 0, true, false, 3)
DIAG(err_typecheck_comparison_of_fptr_to_void, CLASS_ERROR, diag::MAP_ERROR, "equality comparison between function pointer and void pointer (%0 and %1)", 0, true, false, 3)
DIAG(err_typecheck_comparison_of_pointer_integer, CLASS_ERROR, diag::MAP_ERROR, "comparison between pointer and integer (%0 and %1)", 0, true, false, 3)
DIAG(err_typecheck_cond_expect_scalar, CLASS_ERROR, diag::MAP_ERROR, "used type %0 where arithmetic or pointer type is required", 0, true, false, 3)
DIAG(err_typecheck_cond_expect_scalar_or_vector, CLASS_ERROR, diag::MAP_ERROR, "used type %0 where arithmetic, pointer, or vector type is required", 0, true, false, 3)
DIAG(err_typecheck_cond_incompatible_operands, CLASS_ERROR, diag::MAP_ERROR, "incompatible operand types (%0 and %1)", 0, true, false, 3)
DIAG(err_typecheck_cond_incompatible_operands_null, CLASS_ERROR, diag::MAP_ERROR, "non-pointer operand type %0 incompatible with %select{NULL|nullptr}1", 0, true, false, 3)
DIAG(err_typecheck_convert_ambiguous, CLASS_ERROR, diag::MAP_ERROR, "ambiguity in initializing value of type %0 with initializer of type %1", 0, true, false, 3)
DIAG(err_typecheck_convert_incompatible, CLASS_ERROR, diag::MAP_ERROR, "%select{assigning to|passing|returning|converting|initializing|sending|casting}2 %0 %select{from incompatible type|to parameter of incompatible type|from a function with incompatible result type|to incompatible type|with an expression of incompatible type|to parameter of incompatible type|to incompatible type}2 %1", 0, true, false, 3)
DIAG(err_typecheck_convert_incompatible_block_pointer, CLASS_ERROR, diag::MAP_ERROR, "incompatible block pointer types %select{assigning to|passing|returning|converting|initializing|sending|casting}2 %0 %select{from|to parameter of type|from a function with result type|to type|with an expression of type|to parameter of type|to type}2 %1", 0, true, false, 3)
DIAG(err_typecheck_decl_incomplete_type, CLASS_ERROR, diag::MAP_ERROR, "variable has incomplete type %0", 0, true, false, 3)
DIAG(err_typecheck_deleted_function, CLASS_ERROR, diag::MAP_ERROR, "conversion function from %0 to %1 invokes a deleted function", 0, true, false, 3)
DIAG(err_typecheck_duplicate_vector_components_not_mlvalue, CLASS_ERROR, diag::MAP_ERROR, "vector is not assignable (contains duplicate components)", 0, true, false, 3)
DIAG(err_typecheck_expect_scalar_operand, CLASS_ERROR, diag::MAP_ERROR, "operand of type %0 where arithmetic or pointer type is required", 0, true, false, 3)
DIAG(err_typecheck_expression_not_modifiable_lvalue, CLASS_ERROR, diag::MAP_ERROR, "expression is not assignable", 0, true, false, 3)
DIAG(err_typecheck_ext_vector_not_typedef, CLASS_ERROR, diag::MAP_ERROR, "ext_vector_type only applies to types, not variables", 0, true, false, 3)
DIAG(err_typecheck_field_variable_size, CLASS_ERROR, diag::MAP_ERROR, "fields must have a constant size: 'variable length array in structure' extension will never be supported", 0, true, false, 3)
DIAG(err_typecheck_illegal_increment_decrement, CLASS_ERROR, diag::MAP_ERROR, "cannot %select{decrement|increment}1 value of type %0", 0, true, false, 3)
DIAG(err_typecheck_incompatible_address_space, CLASS_ERROR, diag::MAP_ERROR, "%select{assigning %1 to %0|passing %0 to parameter of type %1|returning %0 from a function with result type %1|converting %0 to type %1|initializing %0 with an expression of type %1|sending %0 to parameter of type %1|casting %0 to type %1}2 changes address space of pointer", 0, true, false, 3)
DIAG(err_typecheck_incomplete_array_needs_initializer, CLASS_ERROR, diag::MAP_ERROR, "definition of variable with array type needs an explicit size or an initializer", 0, true, false, 3)
DIAG(err_typecheck_incomplete_tag, CLASS_ERROR, diag::MAP_ERROR, "incomplete definition of type %0", 0, true, false, 3)
DIAG(err_typecheck_incomplete_type_not_modifiable_lvalue, CLASS_ERROR, diag::MAP_ERROR, "incomplete type %0 is not assignable", 0, true, false, 3)
DIAG(err_typecheck_indirection_requires_pointer, CLASS_ERROR, diag::MAP_ERROR, "indirection requires pointer operand (%0 invalid)", 0, true, false, 3)
DIAG(err_typecheck_invalid_lvalue_addrof, CLASS_ERROR, diag::MAP_ERROR, "address expression must be an lvalue or a function designator", 0, true, false, 3)
DIAG(err_typecheck_invalid_operands, CLASS_ERROR, diag::MAP_ERROR, "invalid operands to binary expression (%0 and %1)", 0, true, false, 3)
DIAG(err_typecheck_invalid_restrict_invalid_pointee, CLASS_ERROR, diag::MAP_ERROR, "pointer to function type %0 may not be 'restrict' qualified", 0, true, false, 3)
DIAG(err_typecheck_invalid_restrict_not_pointer, CLASS_ERROR, diag::MAP_ERROR, "restrict requires a pointer or reference (%0 is invalid)", 0, true, false, 3)
DIAG(err_typecheck_invalid_restrict_not_pointer_noarg, CLASS_ERROR, diag::MAP_ERROR, "restrict requires a pointer or reference", 0, true, false, 3)
DIAG(err_typecheck_ivar_variable_size, CLASS_ERROR, diag::MAP_ERROR, "instance variables must have a constant size", 0, true, false, 3)
DIAG(err_typecheck_lvalue_casts_not_supported, CLASS_ERROR, diag::MAP_ERROR, "assignment to cast is illegal, lvalue casts are not supported", 0, true, false, 3)
DIAG(err_typecheck_member_reference_arrow, CLASS_ERROR, diag::MAP_ERROR, "member reference type %0 is not a pointer", 0, true, false, 3)
DIAG(err_typecheck_member_reference_ivar, CLASS_ERROR, diag::MAP_ERROR, "%0 does not have a member named %1", 0, true, false, 3)
DIAG(err_typecheck_member_reference_ivar_suggest, CLASS_ERROR, diag::MAP_ERROR, "%0 does not have a member named %1; did you mean %2?", 0, true, false, 3)
DIAG(err_typecheck_member_reference_struct_union, CLASS_ERROR, diag::MAP_ERROR, "member reference base type %0 is not a structure or union", 0, true, false, 3)
DIAG(err_typecheck_member_reference_suggestion, CLASS_ERROR, diag::MAP_ERROR, "member reference type %0 is %select{a|not a}1 pointer; maybe you meant to use '%select{->|.}1'?", 0, true, false, 3)
DIAG(err_typecheck_member_reference_type, CLASS_ERROR, diag::MAP_ERROR, "cannot refer to type member %0 in %1 with '%select{.|->}2'", 0, true, false, 3)
DIAG(err_typecheck_member_reference_unknown, CLASS_ERROR, diag::MAP_ERROR, "cannot refer to member %0 in %1 with '%select{.|->}2'", 0, true, false, 3)
DIAG(err_typecheck_negative_array_size, CLASS_ERROR, diag::MAP_ERROR, "array size is negative", 0, true, false, 3)
DIAG(err_typecheck_non_object_not_modifiable_lvalue, CLASS_ERROR, diag::MAP_ERROR, "non-object type %0 is not assignable", 0, true, false, 3)
DIAG(err_typecheck_nonviable_condition, CLASS_ERROR, diag::MAP_ERROR, "no viable conversion from %0 to %1", 0, true, false, 3)
DIAG(err_typecheck_pointer_arith_function_type, CLASS_ERROR, diag::MAP_ERROR, "arithmetic on pointer to function type %0", 0, true, false, 3)
DIAG(err_typecheck_pointer_arith_void_type, CLASS_ERROR, diag::MAP_ERROR, "arithmetic on pointer to void type", 0, true, false, 3)
DIAG(err_typecheck_sclass_fscope, CLASS_ERROR, diag::MAP_ERROR, "illegal storage class on file-scoped variable", 0, true, false, 3)
DIAG(err_typecheck_sclass_func, CLASS_ERROR, diag::MAP_ERROR, "illegal storage class on function", 0, true, false, 3)
DIAG(err_typecheck_statement_requires_integer, CLASS_ERROR, diag::MAP_ERROR, "statement requires expression of integer type (%0 invalid)", 0, true, false, 3)
DIAG(err_typecheck_statement_requires_scalar, CLASS_ERROR, diag::MAP_ERROR, "statement requires expression of scalar type (%0 invalid)", 0, true, false, 3)
DIAG(err_typecheck_sub_ptr_compatible, CLASS_ERROR, diag::MAP_ERROR, "%0 and %1 are not pointers to compatible types", 0, true, false, 3)
DIAG(err_typecheck_sub_ptr_object, CLASS_ERROR, diag::MAP_ERROR, "subtraction of pointer %0 requires pointee to be a complete object type", 0, true, false, 3)
DIAG(err_typecheck_subscript_not_integer, CLASS_ERROR, diag::MAP_ERROR, "array subscript is not an integer", 0, true, false, 3)
DIAG(err_typecheck_subscript_value, CLASS_ERROR, diag::MAP_ERROR, "subscripted value is not an array, pointer, or vector", 0, true, false, 3)
DIAG(err_typecheck_unary_expr, CLASS_ERROR, diag::MAP_ERROR, "invalid argument type %0 to unary expression", 0, true, false, 3)
DIAG(err_typecheck_vector_comparison, CLASS_ERROR, diag::MAP_ERROR, "comparison of vector types (%0 and %1) not supported yet", 0, true, false, 3)
DIAG(err_typecheck_vector_not_convertable, CLASS_ERROR, diag::MAP_ERROR, "can't convert between vector values of different size (%0 and %1)", 0, true, false, 3)
DIAG(err_typecheck_zero_array_size, CLASS_ERROR, diag::MAP_ERROR, "zero-length arrays are not permitted in C++", 0, true, false, 3)
DIAG(err_typedef_not_bitfield, CLASS_ERROR, diag::MAP_ERROR, "typedef member %0 cannot be a bit-field", 0, true, false, 3)
DIAG(err_typedef_not_identifier, CLASS_ERROR, diag::MAP_ERROR, "typedef name must be an identifier", 0, true, false, 3)
DIAG(err_typename_missing, CLASS_ERROR, diag::MAP_ERROR, "missing 'typename' prior to dependent type name '%0%1'", 0, true, false, 3)
DIAG(err_typename_nested_not_found, CLASS_ERROR, diag::MAP_ERROR, "no type named %0 in %1", 0, true, false, 3)
DIAG(err_typename_nested_not_type, CLASS_ERROR, diag::MAP_ERROR, "typename specifier refers to non-type member %0 in %1", 0, true, false, 3)
DIAG(err_typename_refers_to_using_value_decl, CLASS_ERROR, diag::MAP_ERROR, "typename specifier refers to a dependent using declaration for a value %0 in %1", 0, true, false, 3)
DIAG(err_types_compatible_p_in_cplusplus, CLASS_ERROR, diag::MAP_ERROR, "__builtin_types_compatible_p is not valid in C++", 0, true, false, 3)
DIAG(err_unavailable, CLASS_ERROR, diag::MAP_ERROR, "%0 is unavailable", 0, true, false, 3)
DIAG(err_unavailable_message, CLASS_ERROR, diag::MAP_ERROR, "%0 is unavailable: %1", 0, true, false, 3)
DIAG(err_undeclared_label_use, CLASS_ERROR, diag::MAP_ERROR, "use of undeclared label %0", 0, true, false, 3)
DIAG(err_undeclared_protocol, CLASS_ERROR, diag::MAP_ERROR, "cannot find protocol declaration for %0", 0, true, false, 3)
DIAG(err_undeclared_protocol_suggest, CLASS_ERROR, diag::MAP_ERROR, "cannot find protocol declaration for %0; did you mean %1?", 0, true, false, 3)
DIAG(err_undeclared_use, CLASS_ERROR, diag::MAP_ERROR, "use of undeclared %0", 0, true, false, 3)
DIAG(err_undeclared_use_suggest, CLASS_ERROR, diag::MAP_ERROR, "use of undeclared %0; did you mean %1?", 0, true, false, 3)
DIAG(err_undeclared_var_use, CLASS_ERROR, diag::MAP_ERROR, "use of undeclared identifier %0", 0, true, false, 3)
DIAG(err_undeclared_var_use_suggest, CLASS_ERROR, diag::MAP_ERROR, "use of undeclared identifier %0; did you mean %1?", 0, true, false, 3)
DIAG(err_undef_interface, CLASS_ERROR, diag::MAP_ERROR, "cannot find interface declaration for %0", 0, true, false, 3)
DIAG(err_undef_interface_suggest, CLASS_ERROR, diag::MAP_ERROR, "cannot find interface declaration for %0; did you mean %1?", 0, true, false, 3)
DIAG(err_undef_superclass, CLASS_ERROR, diag::MAP_ERROR, "cannot find interface declaration for %0, superclass of %1", 0, true, false, 3)
DIAG(err_undef_superclass_suggest, CLASS_ERROR, diag::MAP_ERROR, "cannot find interface declaration for %0, superclass of %1; did you mean %2?", 0, true, false, 3)
DIAG(err_unexpanded_parameter_pack_0, CLASS_ERROR, diag::MAP_ERROR, "%select{expression|base type|declaration type|data member type|bit-field size|static assertion|fixed underlying type|enumerator value|using declaration|friend declaration|qualifier|initializer|default argument|non-type template parameter type|exception type|partial specialization}0 contains an unexpanded parameter pack", 0, true, false, 3)
DIAG(err_unexpanded_parameter_pack_1, CLASS_ERROR, diag::MAP_ERROR, "%select{expression|base type|declaration type|data member type|bit-field size|static assertion|fixed underlying type|enumerator value|using declaration|friend declaration|qualifier|initializer|default argument|non-type template parameter type|exception type|partial specialization}0 contains unexpanded parameter pack %1", 0, true, false, 3)
DIAG(err_unexpanded_parameter_pack_2, CLASS_ERROR, diag::MAP_ERROR, "%select{expression|base type|declaration type|data member type|bit-field size|static assertion|fixed underlying type|enumerator value|using declaration|friend declaration|qualifier|initializer|default argument|non-type template parameter type|exception type|partial specialization}0 contains unexpanded parameter packs %1 and %2", 0, true, false, 3)
DIAG(err_unexpanded_parameter_pack_3_or_more, CLASS_ERROR, diag::MAP_ERROR, "%select{expression|base type|declaration type|data member type|bit-field size|static assertion|fixed underlying type|enumerator value|using declaration|friend declaration|qualifier|initializer|default argument|non-type template parameter type|exception type|partial specialization}0 contains unexpanded parameter packs %1, %2, ...", 0, true, false, 3)
DIAG(err_unexpected_friend, CLASS_ERROR, diag::MAP_ERROR, "friends can only be classes or functions", 0, true, false, 3)
DIAG(err_unexpected_interface, CLASS_ERROR, diag::MAP_ERROR, "unexpected interface name %0: expected expression", 0, true, false, 3)
DIAG(err_unexpected_namespace, CLASS_ERROR, diag::MAP_ERROR, "unexpected namespace name %0: expected expression", 0, true, false, 3)
DIAG(err_unexpected_typedef, CLASS_ERROR, diag::MAP_ERROR, "unexpected type name %0: expected expression", 0, true, false, 3)
DIAG(err_uninitialized_member_for_assign, CLASS_ERROR, diag::MAP_ERROR, "cannot define the implicit default assignment operator for %0, because non-static %select{reference|const}1 member %2 can't use default assignment operator", 0, true, false, 3)
DIAG(err_uninitialized_member_in_ctor, CLASS_ERROR, diag::MAP_ERROR, "%select{|implicit default }0constructor for %1 must explicitly initialize the %select{reference|const}2 member %3", 0, true, false, 3)
DIAG(err_union_as_base_class, CLASS_ERROR, diag::MAP_ERROR, "unions cannot be base classes", 0, true, false, 3)
DIAG(err_union_member_of_reference_type, CLASS_ERROR, diag::MAP_ERROR, "union member %0 has reference type %1", 0, true, false, 3)
DIAG(err_unknown_machine_mode, CLASS_ERROR, diag::MAP_ERROR, "unknown machine mode %0", 0, true, false, 3)
DIAG(err_unknown_nested_typename_suggest, CLASS_ERROR, diag::MAP_ERROR, "no type named %0 in %1; did you mean %2?", 0, true, false, 3)
DIAG(err_unknown_receiver_suggest, CLASS_ERROR, diag::MAP_ERROR, "unknown receiver %0; did you mean %1?", 0, true, false, 3)
DIAG(err_unknown_typename_suggest, CLASS_ERROR, diag::MAP_ERROR, "unknown type name %0; did you mean %1?", 0, true, false, 3)
DIAG(err_unqualified_pointer_member_function, CLASS_ERROR, diag::MAP_ERROR, "must explicitly qualify name of member function when taking its address", 0, true, false, 3)
DIAG(err_unsupported_global_register, CLASS_ERROR, diag::MAP_ERROR, "global register variables are not supported", 0, true, false, 3)
DIAG(err_unsupported_machine_mode, CLASS_ERROR, diag::MAP_ERROR, "unsupported machine mode %0", 0, true, false, 3)
DIAG(err_unsupported_pragma_weak, CLASS_ERROR, diag::MAP_ERROR, "using '#pragma weak' to refer to an undeclared identifier is not yet supported", 0, true, false, 3)
DIAG(err_unsupported_vector_size, CLASS_ERROR, diag::MAP_ERROR, "unsupported type %0 for vector_size attribute, please use on typedef", 0, true, false, 3)
DIAG(err_unusual_main_decl, CLASS_ERROR, diag::MAP_ERROR, "'main' is not allowed to be declared %select{static|inline|static or inline}0", 0, true, false, 3)
DIAG(err_upcast_to_inaccessible_base, CLASS_ERROR, diag::MAP_ERROR, "cannot cast %0 to its %select{private|protected}2 base class %1", 0, true, false, 3)
DIAG(err_use_continuation_class, CLASS_ERROR, diag::MAP_ERROR, "illegal redeclaration of property in continuation class %0 (attribute must be 'readwrite', while its primary must be 'readonly')", 0, true, false, 3)
DIAG(err_use_continuation_class_redeclaration_readwrite, CLASS_ERROR, diag::MAP_ERROR, "illegal redeclaration of 'readwrite' property in continuation class %0 (perhaps you intended this to be a 'readwrite' redeclaration of a 'readonly' public property?)", 0, true, false, 3)
DIAG(err_use_of_default_argument_to_function_declared_later, CLASS_ERROR, diag::MAP_ERROR, "use of default argument to function %0 that is declared later in class %1", 0, true, false, 3)
DIAG(err_use_with_wrong_tag, CLASS_ERROR, diag::MAP_ERROR, "use of %0 with tag type that does not match previous declaration", 0, true, false, 3)
DIAG(err_using_decl_can_not_refer_to_class_member, CLASS_ERROR, diag::MAP_ERROR, "using declaration can not refer to class member", 0, true, false, 3)
DIAG(err_using_decl_can_not_refer_to_namespace, CLASS_ERROR, diag::MAP_ERROR, "using declaration can not refer to namespace", 0, true, false, 3)
DIAG(err_using_decl_conflict, CLASS_ERROR, diag::MAP_ERROR, "target of using declaration conflicts with declaration already in scope", 0, true, false, 3)
DIAG(err_using_decl_conflict_reverse, CLASS_ERROR, diag::MAP_ERROR, "declaration conflicts with target of using declaration already in scope", 0, true, false, 3)
DIAG(err_using_decl_constructor, CLASS_ERROR, diag::MAP_ERROR, "using declaration can not refer to a constructor", 0, true, false, 3)
DIAG(err_using_decl_constructor_conflict, CLASS_ERROR, diag::MAP_ERROR, "can not inherit constructor, already inherited constructor with the same signature", 0, true, false, 3)
DIAG(err_using_decl_constructor_not_in_direct_base, CLASS_ERROR, diag::MAP_ERROR, "%0 is not a direct base of %1, can not inherit constructors", 0, true, false, 3)
DIAG(err_using_decl_destructor, CLASS_ERROR, diag::MAP_ERROR, "using declaration can not refer to a destructor", 0, true, false, 3)
DIAG(err_using_decl_inherited_constructor_unsupported, CLASS_ERROR, diag::MAP_ERROR, "inherited constructors are not supported", 0, true, false, 3)
DIAG(err_using_decl_nested_name_specifier_is_current_class, CLASS_ERROR, diag::MAP_ERROR, "using declaration refers to its own class", 0, true, false, 3)
DIAG(err_using_decl_nested_name_specifier_is_not_base_class, CLASS_ERROR, diag::MAP_ERROR, "using declaration refers into '%0', which is not a base class of %1", 0, true, false, 3)
DIAG(err_using_decl_nested_name_specifier_is_not_class, CLASS_ERROR, diag::MAP_ERROR, "using declaration in class refers into '%0', which is not a class", 0, true, false, 3)
DIAG(err_using_decl_redeclaration, CLASS_ERROR, diag::MAP_ERROR, "redeclaration of using decl", 0, true, false, 3)
DIAG(err_using_decl_template_id, CLASS_ERROR, diag::MAP_ERROR, "using declaration can not refer to a template specialization", 0, true, false, 3)
DIAG(err_using_dependent_value_is_type, CLASS_ERROR, diag::MAP_ERROR, "dependent using declaration resolved to type without 'typename'", 0, true, false, 3)
DIAG(err_using_directive_member_suggest, CLASS_ERROR, diag::MAP_ERROR, "no namespace named %0 in %1; did you mean %2?", 0, true, false, 3)
DIAG(err_using_directive_suggest, CLASS_ERROR, diag::MAP_ERROR, "no namespace named %0; did you mean %1?", 0, true, false, 3)
DIAG(err_using_requires_qualname, CLASS_ERROR, diag::MAP_ERROR, "using declaration requires a qualified name", 0, true, false, 3)
DIAG(err_using_typename_non_type, CLASS_ERROR, diag::MAP_ERROR, "'typename' keyword used on a non-type", 0, true, false, 3)
DIAG(err_uuidof_without_guid, CLASS_ERROR, diag::MAP_ERROR, "cannot call operator __uuidof on a type with no GUID", 0, true, false, 3)
DIAG(err_va_start_used_in_non_variadic_function, CLASS_ERROR, diag::MAP_ERROR, "'va_start' used in function with fixed args", 0, true, false, 3)
DIAG(err_value_init_for_array_type, CLASS_ERROR, diag::MAP_ERROR, "array types cannot be value-initialized", 0, true, false, 3)
DIAG(err_variable_instantiates_to_function, CLASS_ERROR, diag::MAP_ERROR, "%select{variable|static data member}0 instantiated with function type %1", 0, true, false, 3)
DIAG(err_variable_object_no_init, CLASS_ERROR, diag::MAP_ERROR, "variable-sized object may not be initialized", 0, true, false, 3)
DIAG(err_variably_modified_new_type, CLASS_ERROR, diag::MAP_ERROR, "'new' cannot allocate object of variably modified type %0", 0, true, false, 3)
DIAG(err_variably_modified_nontype_template_param, CLASS_ERROR, diag::MAP_ERROR, "non-type template parameter of variably modified type %0", 0, true, false, 3)
DIAG(err_variably_modified_template_arg, CLASS_ERROR, diag::MAP_ERROR, "variably modified type %0 cannot be used as a template argument", 0, true, false, 3)
DIAG(err_vector_incorrect_num_initializers, CLASS_ERROR, diag::MAP_ERROR, "%select{too many|too few}0 elements in vector initialization (expected %1 elements, have %2)", 0, true, false, 3)
DIAG(err_virtual_member_function_template, CLASS_ERROR, diag::MAP_ERROR, "'virtual' can not be specified on member function templates", 0, true, false, 3)
DIAG(err_virtual_non_function, CLASS_ERROR, diag::MAP_ERROR, "'virtual' can only appear on non-static member functions", 0, true, false, 3)
DIAG(err_virtual_out_of_class, CLASS_ERROR, diag::MAP_ERROR, "'virtual' can only be specified inside the class definition", 0, true, false, 3)
DIAG(err_vla_decl_has_extern_linkage, CLASS_ERROR, diag::MAP_ERROR, "variable length array declaration can not have 'extern' linkage", 0, true, false, 3)
DIAG(err_vla_decl_has_static_storage, CLASS_ERROR, diag::MAP_ERROR, "variable length array declaration can not have 'static' storage duration", 0, true, false, 3)
DIAG(err_vla_decl_in_file_scope, CLASS_ERROR, diag::MAP_ERROR, "variable length array declaration not allowed at file scope", 0, true, false, 3)
DIAG(err_vla_in_sfinae, CLASS_ERROR, diag::MAP_ERROR, "variable length array cannot be formed during template argument deduction", 0, true, false, 3)
DIAG(err_vla_non_pod, CLASS_ERROR, diag::MAP_ERROR, "variable length array of non-POD element type %0", 0, true, false, 3)
DIAG(err_vm_decl_has_extern_linkage, CLASS_ERROR, diag::MAP_ERROR, "variably modified type declaration can not have 'extern' linkage", 0, true, false, 3)
DIAG(err_vm_decl_in_file_scope, CLASS_ERROR, diag::MAP_ERROR, "variably modified type declaration not allowed at file scope", 0, true, false, 3)
DIAG(err_vm_func_decl, CLASS_ERROR, diag::MAP_ERROR, "function declaration cannot have variably modified type", 0, true, false, 3)
DIAG(err_void_only_param, CLASS_ERROR, diag::MAP_ERROR, "'void' must be the first and only parameter if specified", 0, true, false, 3)
DIAG(err_void_param_qualified, CLASS_ERROR, diag::MAP_ERROR, "'void' as parameter must not have type qualifiers", 0, true, false, 3)
DIAG(error_bad_category_property_decl, CLASS_ERROR, diag::MAP_ERROR, "property implementation must have its declaration in the category %0", 0, true, false, 3)
DIAG(error_bad_property_context, CLASS_ERROR, diag::MAP_ERROR, "property implementation must be in a class or category implementation", 0, true, false, 3)
DIAG(error_bad_property_decl, CLASS_ERROR, diag::MAP_ERROR, "property implementation must have its declaration in interface %0", 0, true, false, 3)
DIAG(error_category_property, CLASS_ERROR, diag::MAP_ERROR, "property declared in category %0 cannot be implemented in class implementation", 0, true, false, 3)
DIAG(error_duplicate_ivar_use, CLASS_ERROR, diag::MAP_ERROR, "synthesized properties %0 and %1 both claim ivar %2", 0, true, false, 3)
DIAG(error_dynamic_property_ivar_decl, CLASS_ERROR, diag::MAP_ERROR, "dynamic property can not have ivar specification", 0, true, false, 3)
DIAG(error_ivar_in_superclass_use, CLASS_ERROR, diag::MAP_ERROR, "property %0 attempting to use ivar %1 declared in super class %2", 0, true, false, 3)
DIAG(error_ivar_use_in_class_method, CLASS_ERROR, diag::MAP_ERROR, "instance variable %0 accessed in class method", 0, true, false, 3)
DIAG(error_missing_method_context, CLASS_ERROR, diag::MAP_ERROR, "missing context for method declaration", 0, true, false, 3)
DIAG(error_missing_property_context, CLASS_ERROR, diag::MAP_ERROR, "missing context for property implementation declaration", 0, true, false, 3)
DIAG(error_missing_property_interface, CLASS_ERROR, diag::MAP_ERROR, "property implementation in a category with no category declaration", 0, true, false, 3)
DIAG(error_missing_property_ivar_decl, CLASS_ERROR, diag::MAP_ERROR, "synthesized property %0 must either be named the same as a compatible ivar or must explicitly name an ivar", 0, true, false, 3)
DIAG(error_no_subobject_property_setting, CLASS_ERROR, diag::MAP_ERROR, "expression is not assignable", 0, true, false, 3)
DIAG(error_no_super_class_message, CLASS_ERROR, diag::MAP_ERROR, "no @interface declaration found in class messaging of %0", 0, true, false, 3)
DIAG(error_nosetter_property_assignment, CLASS_ERROR, diag::MAP_ERROR, "setter method is needed to assign to object using property assignment syntax", 0, true, false, 3)
DIAG(error_objc_synchronized_expects_object, CLASS_ERROR, diag::MAP_ERROR, "@synchronized requires an Objective-C object type (%0 invalid)", 0, true, false, 3)
DIAG(error_objc_throw_expects_object, CLASS_ERROR, diag::MAP_ERROR, "@throw requires an Objective-C object type (%0 invalid)", 0, true, false, 3)
DIAG(error_private_ivar_access, CLASS_ERROR, diag::MAP_ERROR, "instance variable %0 is private", 0, true, true, 3)
DIAG(error_property_implemented, CLASS_ERROR, diag::MAP_ERROR, "property %0 is already implemented", 0, true, false, 3)
DIAG(error_property_ivar_type, CLASS_ERROR, diag::MAP_ERROR, "type of property %0 (%1) does not match type of ivar %2 (%3)", 0, true, false, 3)
DIAG(error_protected_ivar_access, CLASS_ERROR, diag::MAP_ERROR, "instance variable %0 is protected", 0, true, true, 3)
DIAG(error_readonly_property_assignment, CLASS_ERROR, diag::MAP_ERROR, "assigning to property with 'readonly' attribute not allowed", 0, true, false, 3)
DIAG(error_reference_property, CLASS_ERROR, diag::MAP_ERROR, "property of reference type is not supported", 0, true, false, 3)
DIAG(error_rethrow_used_outside_catch, CLASS_ERROR, diag::MAP_ERROR, "@throw (rethrow) used outside of a @catch block", 0, true, false, 3)
DIAG(error_root_class_cannot_use_super, CLASS_ERROR, diag::MAP_ERROR, "%0 cannot use 'super' because it is a root class", 0, true, false, 3)
DIAG(error_strong_property, CLASS_ERROR, diag::MAP_ERROR, "property %0 must be declared __weak to match existing ivar %1 with __weak attribute", 0, true, false, 3)
DIAG(error_synthesize_category_decl, CLASS_ERROR, diag::MAP_ERROR, "@synthesize not allowed in a category's implementation", 0, true, false, 3)
DIAG(error_synthesized_ivar_yet_not_supported, CLASS_ERROR, diag::MAP_ERROR, "instance variable synthesis not yet supported (need to declare %0 explicitly)", 0, true, false, 3)
DIAG(error_weak_property, CLASS_ERROR, diag::MAP_ERROR, "existing ivar %1 for __weak property %0 must be __weak", 0, true, false, 3)
DIAG(ext_anon_param_requires_type_specifier, CLASS_EXTENSION, diag::MAP_IGNORE, "type specifier required for unnamed parameter, defaults to int", 0, true, false, 3)
DIAG(ext_anonymous_record_with_type, CLASS_EXTENSION, diag::MAP_IGNORE, "types declared in an anonymous %select{struct|union}0 are a Microsoft extension", "microsoft", true, false, 3)
DIAG(ext_anonymous_struct, CLASS_EXTENSION, diag::MAP_IGNORE, "anonymous structs are a GNU extension", "gnu", true, false, 3)
DIAG(ext_anonymous_union, CLASS_EXTENSION, diag::MAP_IGNORE, "anonymous unions are a GNU extension in C", "gnu", true, false, 3)
DIAG(ext_array_init_copy, CLASS_EXTENSION, diag::MAP_IGNORE, "initialization of an array of type %0 from a compound literal of type %1 is a GNU extension", 0, true, false, 3)
DIAG(ext_array_size_conversion, CLASS_EXTENSION, diag::MAP_IGNORE, "implicit conversion from array size expression of type %0 to %select{integral|enumeration}1 type %2 is a C++0x extension", "c++0x-extensions", true, false, 3)
DIAG(ext_c99_array_usage, CLASS_EXTENSION, diag::MAP_IGNORE, "use of C99-specific array features, accepted as an extension", 0, true, false, 3)
DIAG(ext_cast_fn_obj, CLASS_EXTENSION, diag::MAP_IGNORE, "cast between pointer-to-function and pointer-to-object is an extension", 0, true, false, 3)
DIAG(ext_catch_incomplete_ptr, CLASS_EXTENSION, diag::MAP_WARNING, "ISO C++ forbids catching a pointer to incomplete type %0", 0, true, false, 3)
DIAG(ext_catch_incomplete_ref, CLASS_EXTENSION, diag::MAP_WARNING, "ISO C++ forbids catching a reference to incomplete type %0", 0, true, false, 3)
DIAG(ext_delete_void_ptr_operand, CLASS_EXTENSION, diag::MAP_WARNING, "cannot delete expression with pointer-to-'void' type %0", 0, true, false, 3)
DIAG(ext_designated_init, CLASS_EXTENSION, diag::MAP_IGNORE, "designated initializers are a C99 feature, accepted in C++ as an extension", 0, true, false, 3)
DIAG(ext_enum_friend, CLASS_EXTENSION, diag::MAP_WARNING, "enumeration type %0 cannot be a friend", 0, true, false, 3)
DIAG(ext_enum_value_not_int, CLASS_EXTENSION, diag::MAP_IGNORE, "ISO C restricts enumerator values to range of 'int' (%0 is too %select{small|large}1)", 0, true, false, 3)
DIAG(ext_enumerator_too_large, CLASS_EXTENSION, diag::MAP_WARNING, "enumerator value is not representable in the underlying type %0", "microsoft", true, false, 3)
DIAG(ext_explicit_instantiation_after_specialization, CLASS_EXTENSION, diag::MAP_IGNORE, "explicit instantiation of %0 that occurs after an explicit specialization will be ignored (C++0x extension)", "c++0x-extensions", true, false, 3)
DIAG(ext_explicit_instantiation_without_qualified_id, CLASS_EXTENSION, diag::MAP_WARNING, "qualifier in explicit instantiation of %q0 requires a template-id (a typedef is not permitted)", 0, true, false, 3)
DIAG(ext_expr_not_ice, CLASS_EXTENSION, diag::MAP_IGNORE, "expression is not integer constant expression (but is allowed as an extension)", 0, true, false, 3)
DIAG(ext_flexible_array_empty_aggregate_gnu, CLASS_EXTENSION, diag::MAP_IGNORE, "flexible array member %0 in otherwise empty %select{struct|class}1 is a GNU extension", "gnu", true, false, 3)
DIAG(ext_flexible_array_empty_aggregate_ms, CLASS_EXTENSION, diag::MAP_IGNORE, "flexible array member %0 in otherwise empty %select{struct|class}1 is a Microsoft extension", "microsoft", true, false, 3)
DIAG(ext_flexible_array_in_array, CLASS_EXTENSION, diag::MAP_IGNORE, "%0 may not be used as an array element due to flexible array member", 0, true, false, 3)
DIAG(ext_flexible_array_in_struct, CLASS_EXTENSION, diag::MAP_IGNORE, "%0 may not be nested in a struct due to flexible array member", 0, true, false, 3)
DIAG(ext_flexible_array_init, CLASS_EXTENSION, diag::MAP_IGNORE, "flexible array initialization is a GNU extension", "gnu", true, false, 3)
DIAG(ext_flexible_array_union_gnu, CLASS_EXTENSION, diag::MAP_IGNORE, "flexible array member %0 in a union is a GNU extension", "gnu", true, false, 3)
DIAG(ext_flexible_array_union_ms, CLASS_EXTENSION, diag::MAP_IGNORE, "flexible array member %0 in a union is a Microsoft extension", "microsoft", true, false, 3)
DIAG(ext_forward_ref_enum, CLASS_EXTENSION, diag::MAP_IGNORE, "ISO C forbids forward references to 'enum' types", 0, true, false, 3)
DIAG(ext_forward_ref_enum_def, CLASS_EXTENSION, diag::MAP_IGNORE, "redeclaration of already-defined enum %0 is a GNU extension", "gnu", true, false, 3)
DIAG(ext_freestanding_complex, CLASS_EXTENSION, diag::MAP_IGNORE, "complex numbers are an extension in a freestanding C99 implementation", 0, true, false, 3)
DIAG(ext_gnu_ptr_func_arith, CLASS_EXTENSION, diag::MAP_IGNORE, "arithmetic on pointer to function type %0 is a GNU extension", "pointer-arith", true, false, 3)
DIAG(ext_gnu_void_ptr, CLASS_EXTENSION, diag::MAP_IGNORE, "use of GNU void* extension", "pointer-arith", true, false, 3)
DIAG(ext_implicit_function_decl, CLASS_EXTENSION, diag::MAP_WARNING, "implicit declaration of function %0 is invalid in C99", "implicit-function-declaration", true, false, 3)
DIAG(ext_implicit_lib_function_decl, CLASS_EXTENSION, diag::MAP_WARNING, "implicitly declaring C library function '%0' with type %1", 0, true, false, 3)
DIAG(ext_in_class_initializer_float_type, CLASS_EXTENSION, diag::MAP_WARNING, "in-class initializer for static data member of type %0 is a C++0x extension", "c++0x-static-nonintegral-init", true, false, 3)
DIAG(ext_integer_complement_complex, CLASS_EXTENSION, diag::MAP_IGNORE, "ISO C does not support '~' for complex conjugation of %0", 0, true, false, 3)
DIAG(ext_integer_increment_complex, CLASS_EXTENSION, diag::MAP_IGNORE, "ISO C does not support '++'/'--' on complex integer type %0", 0, true, false, 3)
DIAG(ext_invalid_sign_spec, CLASS_EXTENSION, diag::MAP_IGNORE, "'%0' cannot be signed or unsigned", 0, true, false, 3)
DIAG(ext_missing_declspec, CLASS_EXTENSION, diag::MAP_WARNING, "declaration specifier missing, defaulting to 'int'", 0, true, false, 3)
DIAG(ext_missing_type_specifier, CLASS_EXTENSION, diag::MAP_WARNING, "type specifier missing, defaults to 'int'", "implicit-int", true, false, 3)
DIAG(ext_mixed_decls_code, CLASS_EXTENSION, diag::MAP_IGNORE, "ISO C90 forbids mixing declarations and code", "declaration-after-statement", true, false, 3)
DIAG(ext_ms_anonymous_struct, CLASS_EXTENSION, diag::MAP_WARNING, "anonymous structs are a Microsoft extension", "microsoft", true, false, 3)
DIAG(ext_ms_explicit_constructor_call, CLASS_EXTENSION, diag::MAP_WARNING, "explicit constructor calls are a Microsoft extension", "microsoft", true, false, 3)
DIAG(ext_ms_forward_ref_enum, CLASS_EXTENSION, diag::MAP_IGNORE, "forward references to 'enum' types are a Microsoft extension", "microsoft", true, false, 3)
DIAG(ext_nested_name_member_ref_lookup_ambiguous, CLASS_EXTENSION, diag::MAP_WARNING, "lookup of %0 in member access expression is ambiguous; using member of %1", "ambiguous-member-template", true, false, 3)
DIAG(ext_nested_pointer_qualifier_mismatch, CLASS_EXTENSION, diag::MAP_WARNING, "%select{assigning to|passing|returning|converting|initializing|sending|casting}2 %0 %select{from|to parameter of type|from a function with result type|to type|with an expression of type|to parameter of type|to type}2 %1 discards qualifiers in nested pointer types", 0, true, false, 3)
DIAG(ext_new_paren_array_nonconst, CLASS_EXTENSION, diag::MAP_WARNING, "when type is in parentheses, array cannot have dynamic size", 0, true, false, 3)
DIAG(ext_nonclass_type_friend, CLASS_EXTENSION, diag::MAP_WARNING, "non-class type %0 cannot be a friend", 0, true, false, 3)
DIAG(ext_offsetof_extended_field_designator, CLASS_EXTENSION, diag::MAP_IGNORE, "using extended field designator is an extension", 0, true, false, 3)
DIAG(ext_out_of_line_declaration, CLASS_EXTENSION, diag::MAP_ERROR, "out-of-line declaration of a member must be a definition", "out-of-line-declaration", true, false, 3)
DIAG(ext_param_not_declared, CLASS_EXTENSION, diag::MAP_IGNORE, "parameter %0 was not declared, defaulting to type 'int'", 0, true, false, 3)
DIAG(ext_param_promoted_not_compatible_with_prototype, CLASS_EXTENSION, diag::MAP_WARNING, "promoted type %0 of K&R function parameter is not compatible with the parameter type %1 declared in a previous prototype", 0, true, false, 3)
DIAG(ext_predef_outside_function, CLASS_WARNING, diag::MAP_WARNING, "predefined identifier is only valid inside function", 0, true, false, 3)
DIAG(ext_qualified_function_type_template_arg, CLASS_EXTENSION, diag::MAP_WARNING, "template argument of '%0' qualified function type is a GNU extension", "gnu", true, false, 3)
DIAG(ext_return_has_expr, CLASS_EXTENSION, diag::MAP_ERROR, "void %select{function|method}1 %0 should not return a value", "return-type", true, false, 3)
DIAG(ext_return_has_void_expr, CLASS_EXTENSION, diag::MAP_IGNORE, "void %select{function|method}1 %0 should not return void expression", 0, true, false, 3)
DIAG(ext_return_missing_expr, CLASS_EXTENSION, diag::MAP_ERROR, "non-void %select{function|method}1 %0 should return a value", "return-type", true, false, 3)
DIAG(ext_rvalue_to_reference_access_ctor, CLASS_EXTENSION, diag::MAP_WARNING, "C++98 requires an accessible copy constructor for class %2 when binding a reference to a temporary; was %select{private|protected}0", "bind-to-temporary-copy", true, true, 3)
DIAG(ext_rvalue_to_reference_temp_copy_no_viable, CLASS_EXTENSION, diag::MAP_WARNING, "no viable constructor %select{copying variable|copying parameter|returning object|throwing object|copying member subobject|copying array element|allocating object|copying temporary|initializing base subobject|initializing vector element}0 of type %1; C++98 requires a copy constructor when binding a reference to a temporary", "bind-to-temporary-copy", true, false, 3)
DIAG(ext_sizeof_function_type, CLASS_EXTENSION, diag::MAP_IGNORE, "invalid application of 'sizeof' to a function type", "pointer-arith", true, false, 3)
DIAG(ext_sizeof_void_type, CLASS_EXTENSION, diag::MAP_IGNORE, "invalid application of '%0' to a void type", "pointer-arith", true, false, 3)
DIAG(ext_subscript_non_lvalue, CLASS_EXTENSION, diag::MAP_IGNORE, "ISO C90 does not allow subscripting non-lvalue array", 0, true, false, 3)
DIAG(ext_template_arg_extra_parens, CLASS_EXTENSION, diag::MAP_WARNING, "address non-type template argument cannot be surrounded by parentheses", 0, true, false, 3)
DIAG(ext_template_arg_local_type, CLASS_EXTENSION, diag::MAP_WARNING, "template argument uses local type %0", "local-type-template-args", true, false, 3)
DIAG(ext_template_arg_unnamed_type, CLASS_EXTENSION, diag::MAP_WARNING, "template argument uses unnamed type", "unnamed-type-template-args", true, false, 3)
DIAG(ext_template_outside_of_template, CLASS_EXTENSION, diag::MAP_WARNING, "'template' keyword outside of a template", "c++0x-extensions", true, false, 3)
DIAG(ext_template_parameter_default_in_function_template, CLASS_EXTENSION, diag::MAP_WARNING, "default template arguments for a function template are a C++0x extension", "c++0x-extensions", true, false, 3)
DIAG(ext_template_spec_decl_out_of_scope, CLASS_EXTENSION, diag::MAP_WARNING, "%select{class template|class template partial|function template|member function|static data member|member class}0 specialization of %1 must originally be declared in namespace %2; accepted as a C++0x extension", "c++0x-extensions", true, false, 3)
DIAG(ext_template_spec_decl_out_of_scope_global, CLASS_EXTENSION, diag::MAP_WARNING, "%select{class template|class template partial|function template|member function|static data member|member class}0 specialization of %1 must originally be declared in the global scope; accepted as a C++0x extension", "c++0x-extensions", true, false, 3)
DIAG(ext_typecheck_addrof_class_temporary, CLASS_EXTENSION, diag::MAP_ERROR, "taking the address of a temporary object of type %0", "address-of-temporary", true, false, 3)
DIAG(ext_typecheck_addrof_void, CLASS_EXTENSION, diag::MAP_IGNORE, "ISO C forbids taking the address of an expression of type 'void'", 0, true, false, 3)
DIAG(ext_typecheck_base_super, CLASS_WARNING, diag::MAP_IGNORE, "method parameter type %0 does not match super class method parameter type %1", "super-class-method-mismatch", true, false, 3)
DIAG(ext_typecheck_cast_nonscalar, CLASS_EXTENSION, diag::MAP_IGNORE, "C99 forbids casting nonscalar type %0 to the same type", 0, true, false, 3)
DIAG(ext_typecheck_cast_to_union, CLASS_EXTENSION, diag::MAP_IGNORE, "C99 forbids casts to union type", 0, true, false, 3)
DIAG(ext_typecheck_comparison_of_distinct_pointers, CLASS_EXTENSION, diag::MAP_WARNING, "comparison of distinct pointer types (%0 and %1)", 0, true, false, 3)
DIAG(ext_typecheck_comparison_of_distinct_pointers_nonstandard, CLASS_EXTENSION, diag::MAP_WARNING, "comparison of distinct pointer types (%0 and %1) uses non-standard composite pointer type %2", 0, true, false, 3)
DIAG(ext_typecheck_comparison_of_fptr_to_void, CLASS_EXTENSION, diag::MAP_IGNORE, "equality comparison between function pointer and void pointer (%0 and %1)", 0, true, false, 3)
DIAG(ext_typecheck_comparison_of_pointer_integer, CLASS_EXTENSION, diag::MAP_WARNING, "comparison between pointer and integer (%0 and %1)", 0, true, false, 3)
DIAG(ext_typecheck_cond_incompatible_operands, CLASS_EXTENSION, diag::MAP_WARNING, "incompatible operand types (%0 and %1)", 0, true, false, 3)
DIAG(ext_typecheck_cond_incompatible_operands_nonstandard, CLASS_EXTENSION, diag::MAP_WARNING, "incompatible operand types (%0 and %1) use non-standard composite pointer type %2", 0, true, false, 3)
DIAG(ext_typecheck_cond_one_void, CLASS_EXTENSION, diag::MAP_IGNORE, "C99 forbids conditional expressions with only one void side", 0, true, false, 3)
DIAG(ext_typecheck_convert_discards_qualifiers, CLASS_EXTENSION, diag::MAP_WARNING, "%select{assigning to|passing|returning|converting|initializing|sending|casting}2 %0 %select{from|to parameter of type|from a function with result type|to type|with an expression of type|to parameter of type|to type}2 %1 discards qualifiers", 0, true, false, 3)
DIAG(ext_typecheck_convert_incompatible_pointer, CLASS_EXTENSION, diag::MAP_WARNING, "incompatible pointer types %select{assigning to|passing|returning|converting|initializing|sending|casting}2 %0 %select{from|to parameter of type|from a function with result type|to type|with an expression of type|to parameter of type|to type}2 %1", 0, true, false, 3)
DIAG(ext_typecheck_convert_incompatible_pointer_sign, CLASS_EXTENSION, diag::MAP_WARNING, "%select{assigning to|passing|returning|converting|initializing|sending|casting}2 %0 %select{from|to parameter of type|from a function with result type|to type|with an expression of type|to parameter of type|to type}2 %1 converts between pointers to integer types with different sign", "pointer-sign", true, false, 3)
DIAG(ext_typecheck_convert_int_pointer, CLASS_EXTENSION, diag::MAP_WARNING, "incompatible integer to pointer conversion %select{assigning to|passing|returning|converting|initializing|sending|casting}2 %0 %select{from|to parameter of type|from a function with result type|to type|with an expression of type|to parameter of type|to type}2 %1", 0, true, false, 3)
DIAG(ext_typecheck_convert_pointer_int, CLASS_EXTENSION, diag::MAP_WARNING, "incompatible pointer to integer conversion %select{assigning to|passing|returning|converting|initializing|sending|casting}2 %0 %select{from|to parameter of type|from a function with result type|to type|with an expression of type|to parameter of type|to type}2 %1", 0, true, false, 3)
DIAG(ext_typecheck_convert_pointer_void_func, CLASS_EXTENSION, diag::MAP_IGNORE, "%select{assigning to|passing|returning|converting|initializing|sending|casting}2 %0 %select{from|to parameter of type|from a function with result type|to type|with an expression of type|to parameter of type|to type}2 %1 converts between void pointer and function pointer", 0, true, false, 3)
DIAG(ext_typecheck_decl_incomplete_type, CLASS_EXTENSION, diag::MAP_WARNING, "tentative definition of variable with internal linkage has incomplete non-array type %0", 0, true, false, 3)
DIAG(ext_typecheck_expression_not_constant_but_accepted, CLASS_EXTENSION, diag::MAP_IGNORE, "expression is not a constant, but is accepted as one by GNU extensions", "gnu", true, false, 3)
DIAG(ext_typecheck_ordered_comparison_of_function_pointers, CLASS_EXTENSION, diag::MAP_WARNING, "ordered comparison of function pointers (%0 and %1)", 0, true, false, 3)
DIAG(ext_typecheck_ordered_comparison_of_pointer_and_zero, CLASS_EXTENSION, diag::MAP_IGNORE, "ordered comparison between pointer and zero (%0 and %1) is an extension", 0, true, false, 3)
DIAG(ext_typecheck_ordered_comparison_of_pointer_integer, CLASS_EXTENSION, diag::MAP_WARNING, "ordered comparison between pointer and integer (%0 and %1)", 0, true, false, 3)
DIAG(ext_typecheck_zero_array_size, CLASS_EXTENSION, diag::MAP_IGNORE, "zero size arrays are an extension", 0, true, false, 3)
DIAG(ext_typedef_without_a_name, CLASS_EXTENSION, diag::MAP_WARNING, "typedef requires a name", "missing-declarations", true, false, 3)
DIAG(ext_typename_outside_of_template, CLASS_EXTENSION, diag::MAP_WARNING, "'typename' occurs outside of a template", "c++0x-extensions", true, false, 3)
DIAG(ext_unelaborated_friend_type, CLASS_EXTENSION, diag::MAP_WARNING, "must specify '%select{struct|union|class|enum}0' to befriend %1", 0, true, false, 3)
DIAG(ext_using_undefined_std, CLASS_EXTENSION, diag::MAP_WARNING, "using directive refers to implicitly-defined namespace 'std'", 0, true, false, 3)
DIAG(ext_variable_sized_type_in_struct, CLASS_EXTENSION, diag::MAP_WARNING, "field %0 with variable sized type %1 not at the end of a struct or class is a GNU extension", "gnu", true, false, 3)
DIAG(ext_vla, CLASS_EXTENSION, diag::MAP_IGNORE, "variable length arrays are a C99 feature, accepted as an extension", "vla", true, false, 3)
DIAG(note_access_constrained_by_path, CLASS_NOTE, diag::MAP_FATAL, "constrained by %select{|implicitly }1%select{private|protected}0 inheritance here", 0, true, false, 3)
DIAG(note_access_natural, CLASS_NOTE, diag::MAP_FATAL, "%select{|implicitly }1declared %select{private|protected}0 here", 0, true, false, 3)
DIAG(note_access_protected_restricted, CLASS_NOTE, diag::MAP_FATAL, "object type %select{|%1 }0must derive from context type %2", 0, true, false, 3)
DIAG(note_ambig_member_ref_object_type, CLASS_NOTE, diag::MAP_FATAL, "lookup in the object type %0 refers here", 0, true, false, 3)
DIAG(note_ambig_member_ref_scope, CLASS_NOTE, diag::MAP_FATAL, "lookup from the current scope refers here", 0, true, false, 3)
DIAG(note_ambiguous_candidate, CLASS_NOTE, diag::MAP_FATAL, "candidate found by name lookup is %q0", 0, true, false, 3)
DIAG(note_ambiguous_member_found, CLASS_NOTE, diag::MAP_FATAL, "member found by ambiguous name lookup", 0, true, false, 3)
DIAG(note_ambiguous_type_conversion, CLASS_NOTE, diag::MAP_FATAL, "because of ambiguity in conversion of %0 to %1", 0, true, false, 3)
DIAG(note_array_index_out_of_bounds, CLASS_NOTE, diag::MAP_FATAL, "array %0 declared here", 0, true, false, 3)
DIAG(note_array_size_conversion, CLASS_NOTE, diag::MAP_FATAL, "conversion to %select{integral|enumeration}0 type %1 declared here", 0, true, false, 3)
DIAG(note_attribute_overloadable_prev_overload, CLASS_NOTE, diag::MAP_FATAL, "previous overload of function is here", 0, true, false, 3)
DIAG(note_base_class_specified_here, CLASS_NOTE, diag::MAP_FATAL, "base class %0 specified here", 0, true, false, 3)
DIAG(note_bitfield_decl, CLASS_NOTE, diag::MAP_FATAL, "bit-field is declared here", 0, true, false, 3)
DIAG(note_condition_assign_silence, CLASS_NOTE, diag::MAP_FATAL, "place parentheses around the assignment to silence this warning", 0, true, false, 3)
DIAG(note_condition_assign_to_comparison, CLASS_NOTE, diag::MAP_FATAL, "use '==' to turn this assignment into an equality comparison", 0, true, false, 3)
DIAG(note_condition_or_assign_to_comparison, CLASS_NOTE, diag::MAP_FATAL, "use '!=' to turn this compound assignment into an inequality comparison", 0, true, false, 3)
DIAG(note_declared_at, CLASS_NOTE, diag::MAP_FATAL, "declared here", 0, true, false, 3)
DIAG(note_default_arg_instantiation_here, CLASS_NOTE, diag::MAP_FATAL, "in instantiation of default argument for '%0' required here", 0, true, false, 3)
DIAG(note_default_argument_declared_here, CLASS_NOTE, diag::MAP_FATAL, "default argument declared here", 0, true, false, 3)
DIAG(note_default_function_arg_instantiation_here, CLASS_NOTE, diag::MAP_FATAL, "in instantiation of default function argument expression for '%0' required here", 0, true, false, 3)
DIAG(note_dependent_var_use, CLASS_NOTE, diag::MAP_FATAL, "must qualify identifier to find this declaration in dependent base class", 0, true, false, 3)
DIAG(note_destructor_type_here, CLASS_NOTE, diag::MAP_FATAL, "type %0 is declared here", 0, true, false, 3)
DIAG(note_equality_comparison_silence, CLASS_NOTE, diag::MAP_FATAL, "remove extraneous parentheses around the comparison to silence this warning", 0, true, false, 3)
DIAG(note_equality_comparison_to_assign, CLASS_NOTE, diag::MAP_FATAL, "use '=' to turn this equality comparison into an assignment", 0, true, false, 3)
DIAG(note_exits___block, CLASS_NOTE, diag::MAP_FATAL, "jump exits scope of __block variable", 0, true, false, 3)
DIAG(note_exits_cleanup, CLASS_NOTE, diag::MAP_FATAL, "jump exits scope of variable with __attribute__((cleanup))", 0, true, false, 3)
DIAG(note_exits_cxx_catch, CLASS_NOTE, diag::MAP_FATAL, "jump exits catch block", 0, true, false, 3)
DIAG(note_exits_cxx_try, CLASS_NOTE, diag::MAP_FATAL, "jump exits try block", 0, true, false, 3)
DIAG(note_exits_dtor, CLASS_NOTE, diag::MAP_FATAL, "jump exits scope of variable with non-trivial destructor", 0, true, false, 3)
DIAG(note_exits_objc_catch, CLASS_NOTE, diag::MAP_FATAL, "jump exits @catch block", 0, true, false, 3)
DIAG(note_exits_objc_finally, CLASS_NOTE, diag::MAP_FATAL, "jump exits @finally block", 0, true, false, 3)
DIAG(note_exits_objc_synchronized, CLASS_NOTE, diag::MAP_FATAL, "jump exits @synchronized block", 0, true, false, 3)
DIAG(note_exits_objc_try, CLASS_NOTE, diag::MAP_FATAL, "jump exits @try block", 0, true, false, 3)
DIAG(note_explicit_instantiation_candidate, CLASS_NOTE, diag::MAP_FATAL, "explicit instantiation candidate function template here %0", 0, true, false, 3)
DIAG(note_explicit_instantiation_definition_here, CLASS_NOTE, diag::MAP_FATAL, "explicit instantiation definition is here", 0, true, false, 3)
DIAG(note_explicit_instantiation_here, CLASS_NOTE, diag::MAP_FATAL, "explicit instantiation refers here", 0, true, false, 3)
DIAG(note_explicit_template_arg_substitution_here, CLASS_NOTE, diag::MAP_FATAL, "while substituting explicitly-specified template arguments into function template %0 %1", 0, true, false, 3)
DIAG(note_explicit_template_spec_does_not_need_header, CLASS_NOTE, diag::MAP_FATAL, "'template<>' header not required for explicitly-specialized class %0 declared here", 0, true, false, 3)
DIAG(note_field_decl, CLASS_NOTE, diag::MAP_FATAL, "member is declared here", 0, true, false, 3)
DIAG(note_field_designator_found, CLASS_NOTE, diag::MAP_FATAL, "field designator refers here", 0, true, false, 3)
DIAG(note_final_overrider, CLASS_NOTE, diag::MAP_FATAL, "final overrider of %q0 in %1", 0, true, false, 3)
DIAG(note_first_required_here, CLASS_NOTE, diag::MAP_FATAL, "synthesized method is first required here", 0, true, false, 3)
DIAG(note_flexible_array_member, CLASS_NOTE, diag::MAP_FATAL, "initialized flexible array member %0 is here", 0, true, false, 3)
DIAG(note_forward_class, CLASS_NOTE, diag::MAP_FATAL, "forward class is declared here", 0, true, false, 3)
DIAG(note_function_template_deduction_instantiation_here, CLASS_NOTE, diag::MAP_FATAL, "while substituting deduced template arguments into function template %0 %1", 0, true, false, 3)
DIAG(note_function_template_spec_here, CLASS_NOTE, diag::MAP_FATAL, "in instantiation of function template specialization %q0 requested here", 0, true, false, 3)
DIAG(note_function_template_spec_matched, CLASS_NOTE, diag::MAP_FATAL, "function template matches specialization %0", 0, true, false, 3)
DIAG(note_function_with_incomplete_return_type_declared_here, CLASS_NOTE, diag::MAP_FATAL, "%0 declared here", 0, true, false, 3)
DIAG(note_getter_unavailable, CLASS_NOTE, diag::MAP_FATAL, "or because setter is declared here, but no getter method %0 is found", 0, true, false, 3)
DIAG(note_global_declared_at, CLASS_NOTE, diag::MAP_FATAL, "global variable declared here", 0, true, false, 3)
DIAG(note_hidden_overloaded_virtual_declared_here, CLASS_NOTE, diag::MAP_FATAL, "hidden overloaded virtual function %q0 declared here", 0, true, false, 3)
DIAG(note_hidden_tag, CLASS_NOTE, diag::MAP_FATAL, "type declaration hidden", 0, true, false, 3)
DIAG(note_hiding_object, CLASS_NOTE, diag::MAP_FATAL, "declaration hides type", 0, true, false, 3)
DIAG(note_implementation_declared, CLASS_NOTE, diag::MAP_FATAL, "class implementation is declared here", 0, true, false, 3)
DIAG(note_indirect_goto_target, CLASS_NOTE, diag::MAP_FATAL, "possible target of indirect goto", 0, true, false, 3)
DIAG(note_indirection_through_null, CLASS_NOTE, diag::MAP_FATAL, "consider using __builtin_trap() or qualifying pointer with 'volatile'", 0, true, false, 3)
DIAG(note_inheritance_implicitly_private_here, CLASS_NOTE, diag::MAP_FATAL, "inheritance is implicitly 'private'", 0, true, false, 3)
DIAG(note_inheritance_specifier_here, CLASS_NOTE, diag::MAP_FATAL, "'%0' inheritance specifier here", 0, true, false, 3)
DIAG(note_instantiation_contexts_suppressed, CLASS_NOTE, diag::MAP_FATAL, "(skipping %0 context%s0 in backtrace; use -ftemplate-backtrace-limit=0 to see all)", 0, true, false, 3)
DIAG(note_instantiation_required_here, CLASS_NOTE, diag::MAP_FATAL, "%select{implicit|explicit}0 instantiation first required here", 0, true, false, 3)
DIAG(note_ivar_decl, CLASS_NOTE, diag::MAP_FATAL, "ivar is declared here", 0, true, false, 3)
DIAG(note_local_variable_declared_here, CLASS_NOTE, diag::MAP_FATAL, "%0 declared here", 0, true, false, 3)
DIAG(note_logical_and_in_logical_or_silence, CLASS_NOTE, diag::MAP_FATAL, "place parentheses around the '&&' expression to silence this warning", 0, true, false, 3)
DIAG(note_member_declared_here, CLASS_NOTE, diag::MAP_FATAL, "member %0 declared here", 0, true, false, 3)
DIAG(note_member_def_close_match, CLASS_NOTE, diag::MAP_FATAL, "member declaration nearly matches", 0, true, false, 3)
DIAG(note_member_of_template_here, CLASS_NOTE, diag::MAP_FATAL, "member is declared here", 0, true, false, 3)
DIAG(note_member_ref_possible_intended_overload, CLASS_NOTE, diag::MAP_FATAL, "possibly valid overload here", 0, true, false, 3)
DIAG(note_member_synthesized_at, CLASS_NOTE, diag::MAP_FATAL, "implicit default %select{constructor|copy constructor|copy assignment operator|destructor}0 for %1 first required here", 0, true, false, 3)
DIAG(note_method_declared_at, CLASS_NOTE, diag::MAP_FATAL, "method declared here", 0, true, false, 3)
DIAG(note_method_sent_forward_class, CLASS_NOTE, diag::MAP_FATAL, "method %0 is used for the forward class", 0, true, false, 3)
DIAG(note_namespace_defined_here, CLASS_NOTE, diag::MAP_FATAL, "namespace %0 defined here", 0, true, false, 3)
DIAG(note_non_instantiated_member_here, CLASS_NOTE, diag::MAP_FATAL, "not-yet-instantiated member is declared here", 0, true, false, 3)
DIAG(note_nontemplate_decl_here, CLASS_NOTE, diag::MAP_FATAL, "non-templated declaration is here", 0, true, false, 3)
DIAG(note_nontrivial_has_nontrivial, CLASS_NOTE, diag::MAP_FATAL, "because type %0 has a %select{member|base class}1 with a non-trivial %select{constructor|copy constructor|copy assignment operator|destructor}2", 0, true, false, 3)
DIAG(note_nontrivial_has_virtual, CLASS_NOTE, diag::MAP_FATAL, "because type %0 has a virtual %select{member function|base class}1", 0, true, false, 3)
DIAG(note_nontrivial_user_defined, CLASS_NOTE, diag::MAP_FATAL, "because type %0 has a user-declared %select{constructor|copy constructor|copy assignment operator|destructor}1", 0, true, false, 3)
DIAG(note_overridden_virtual_function, CLASS_NOTE, diag::MAP_FATAL, "overridden virtual function is here", 0, true, false, 3)
DIAG(note_ovl_builtin_binary_candidate, CLASS_NOTE, diag::MAP_FATAL, "built-in candidate %0", 0, true, false, 3)
DIAG(note_ovl_builtin_unary_candidate, CLASS_NOTE, diag::MAP_FATAL, "built-in candidate %0", 0, true, false, 3)
DIAG(note_ovl_candidate, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{function|function|constructor|function |function |constructor |is the implicit default constructor|is the implicit copy constructor|is the implicit copy assignment operator|is an inherited constructor}0%1", 0, true, false, 3)
DIAG(note_ovl_candidate_arity, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{function|function|constructor|function|function|constructor|constructor (the implicit default constructor)|constructor (the implicit copy constructor)|function (the implicit copy assignment operator)|constructor (inherited)}0 %select{|template }1not viable: requires%select{ at least| at most|}2 %3 argument%s3, but %4 %plural{1:was|:were}4 provided", 0, true, false, 3)
DIAG(note_ovl_candidate_bad_addrspace, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{function|function|constructor|function |function |constructor |constructor (the implicit default constructor)|constructor (the implicit copy constructor)|function (the implicit copy assignment operator)|constructor (inherited)}0%1 not viable: %select{%ordinal6|'this'}5 argument (%2) is in address space %3, but parameter must be in address space %4", 0, true, false, 3)
DIAG(note_ovl_candidate_bad_base_to_derived_conv, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{function|function|constructor|function |function |constructor |constructor (the implicit default constructor)|constructor (the implicit copy constructor)|function (the implicit copy assignment operator)|constructor (inherited)}0%1 not viable: cannot %select{convert from|convert from|bind}2 %select{base class pointer|superclass|base class object of type}2 %3 to %select{derived class pointer|subclass|derived class reference}2 %4 for %ordinal5 argument", 0, true, false, 3)
DIAG(note_ovl_candidate_bad_conv, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{function|function|constructor|function |function |constructor |constructor (the implicit default constructor)|constructor (the implicit copy constructor)|function (the implicit copy assignment operator)|constructor (inherited)}0%1 not viable: no known conversion from %2 to %3 for %select{%ordinal5 argument|object argument}4", 0, true, false, 3)
DIAG(note_ovl_candidate_bad_conv_incomplete, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{function|function|constructor|function |function |constructor |constructor (the implicit default constructor)|constructor (the implicit copy constructor)|function (the implicit copy assignment operator)|constructor (inherited)}0%1 not viable: cannot convert argument of incomplete type %2 to %3", 0, true, false, 3)
DIAG(note_ovl_candidate_bad_cvr, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{function|function|constructor|function |function |constructor |constructor (the implicit default constructor)|constructor (the implicit copy constructor)|function (the implicit copy assignment operator)|constructor (inherited)}0%1 not viable: %ordinal4 argument (%2) would lose %select{const|restrict|const and restrict|volatile|const and volatile|volatile and restrict|const, volatile, and restrict}3 qualifier%select{||s||s|s|s}3", 0, true, false, 3)
DIAG(note_ovl_candidate_bad_cvr_this, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{|function|||function||||function (the implicit copy assignment operator)|}0 not viable: 'this' argument has type %2, but method is not marked %select{const|restrict|const or restrict|volatile|const or volatile|volatile or restrict|const, volatile, or restrict}3", 0, true, false, 3)
DIAG(note_ovl_candidate_bad_deduction, CLASS_NOTE, diag::MAP_FATAL, "candidate template ignored: failed template argument deduction", 0, true, false, 3)
DIAG(note_ovl_candidate_bad_overload, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{function|function|constructor|function |function |constructor |constructor (the implicit default constructor)|constructor (the implicit copy constructor)|function (the implicit copy assignment operator)|constructor (inherited)}0%1 not viable: no overload of %3 matching %2 for %ordinal4 argument", 0, true, false, 3)
DIAG(note_ovl_candidate_deleted, CLASS_NOTE, diag::MAP_FATAL, "candidate %select{function|function|constructor|function |function |constructor ||||constructor (inherited)}0%1 has been explicitly %select{made unavailable|deleted}2", 0, true, false, 3)
DIAG(note_ovl_candidate_explicit_arg_mismatch_named, CLASS_NOTE, diag::MAP_FATAL, "candidate template ignored: invalid explicitly-specified argument for template parameter %0", 0, true, false, 3)
DIAG(note_ovl_candidate_explicit_arg_mismatch_unnamed, CLASS_NOTE, diag::MAP_FATAL, "candidate template ignored: invalid explicitly-specified argument for %ordinal0 template parameter", 0, true, false, 3)
DIAG(note_ovl_candidate_incomplete_deduction, CLASS_NOTE, diag::MAP_FATAL, "candidate template ignored: couldn't infer template argument %0", 0, true, false, 3)
DIAG(note_ovl_candidate_inconsistent_deduction, CLASS_NOTE, diag::MAP_FATAL, "candidate template ignored: deduced conflicting %select{types|values|templates}0 for parameter %1 (%2 vs. %3)", 0, true, false, 3)
DIAG(note_ovl_candidate_inherited_constructor, CLASS_NOTE, diag::MAP_FATAL, "inherited from here", 0, true, false, 3)
DIAG(note_ovl_candidate_instantiation_depth, CLASS_NOTE, diag::MAP_FATAL, "candidate template ignored: substitution exceeded maximum template instantiation depth", 0, true, false, 3)
DIAG(note_ovl_candidate_substitution_failure, CLASS_NOTE, diag::MAP_FATAL, "candidate template ignored: substitution failure %0", 0, true, false, 3)
DIAG(note_ovl_candidate_underqualified, CLASS_NOTE, diag::MAP_FATAL, "candidate template ignored: can't deduce a type for %0 which would make %2 equal %1", 0, true, false, 3)
DIAG(note_ovl_surrogate_cand, CLASS_NOTE, diag::MAP_FATAL, "conversion candidate of type %0", 0, true, false, 3)
DIAG(note_ovl_too_many_candidates, CLASS_NOTE, diag::MAP_FATAL, "remaining %0 candidate%s0 omitted; pass -fshow-overloads=all to show them", 0, true, false, 3)
DIAG(note_parameter_here, CLASS_NOTE, diag::MAP_FATAL, "passing argument to parameter here", 0, true, false, 3)
DIAG(note_parameter_named_here, CLASS_NOTE, diag::MAP_FATAL, "passing argument to parameter %0 here", 0, true, false, 3)
DIAG(note_parameter_pack_here, CLASS_NOTE, diag::MAP_FATAL, "parameter pack %0 declared here", 0, true, false, 3)
DIAG(note_partial_spec_deduct_instantiation_here, CLASS_NOTE, diag::MAP_FATAL, "during template argument deduction for class template partial specialization %0 %1", 0, true, false, 3)
DIAG(note_partial_spec_match, CLASS_NOTE, diag::MAP_FATAL, "partial specialization matches %0", 0, true, false, 3)
DIAG(note_partial_spec_unused_parameter, CLASS_NOTE, diag::MAP_FATAL, "non-deducible template parameter %0", 0, true, false, 3)
DIAG(note_please_include_header, CLASS_NOTE, diag::MAP_FATAL, "please include the header <%0> or explicitly provide a declaration for '%1'", 0, true, false, 3)
DIAG(note_precedence_bitwise_first, CLASS_NOTE, diag::MAP_FATAL, "place parentheses around the %0 expression to evaluate it first", 0, true, false, 3)
DIAG(note_precedence_bitwise_silence, CLASS_NOTE, diag::MAP_FATAL, "place parentheses around the %0 expression to silence this warning", 0, true, false, 3)
DIAG(note_prev_partial_spec_here, CLASS_NOTE, diag::MAP_FATAL, "previous declaration of class template partial specialization %0 is here", 0, true, false, 3)
DIAG(note_previous_access_declaration, CLASS_NOTE, diag::MAP_FATAL, "previously declared '%1' here", 0, true, false, 3)
DIAG(note_previous_builtin_declaration, CLASS_NOTE, diag::MAP_FATAL, "%0 is a builtin with type %1", 0, true, false, 3)
DIAG(note_previous_decl, CLASS_NOTE, diag::MAP_FATAL, "%0 declared here", 0, true, false, 3)
DIAG(note_previous_exception_handler, CLASS_NOTE, diag::MAP_FATAL, "for type %0", 0, true, false, 3)
DIAG(note_previous_explicit_instantiation, CLASS_NOTE, diag::MAP_FATAL, "previous explicit instantiation is here", 0, true, false, 3)
DIAG(note_previous_initializer, CLASS_NOTE, diag::MAP_FATAL, "previous initialization %select{|with side effects }0is here%select{| (side effects may not occur at run time)}0", 0, true, false, 3)
DIAG(note_previous_template_specialization, CLASS_NOTE, diag::MAP_FATAL, "previous template specialization is here", 0, true, false, 3)
DIAG(note_prior_template_arg_substitution, CLASS_NOTE, diag::MAP_FATAL, "while substituting prior template arguments into %select{non-type|template}0 template parameter%1 %2", 0, true, false, 3)
DIAG(note_property_declare, CLASS_NOTE, diag::MAP_FATAL, "property declared here", 0, true, false, 3)
DIAG(note_property_impl_required, CLASS_NOTE, diag::MAP_FATAL, "implementation is here", 0, true, false, 3)
DIAG(note_protected_by___block, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses setup of __block variable", 0, true, false, 3)
DIAG(note_protected_by_cleanup, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses initialization of variable with __attribute__((cleanup))", 0, true, false, 3)
DIAG(note_protected_by_cxx_catch, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses initialization of catch block", 0, true, false, 3)
DIAG(note_protected_by_cxx_try, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses initialization of try block", 0, true, false, 3)
DIAG(note_protected_by_objc_catch, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses initialization of @catch block", 0, true, false, 3)
DIAG(note_protected_by_objc_finally, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses initialization of @finally block", 0, true, false, 3)
DIAG(note_protected_by_objc_synchronized, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses initialization of @synchronized block", 0, true, false, 3)
DIAG(note_protected_by_objc_try, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses initialization of @try block", 0, true, false, 3)
DIAG(note_protected_by_variable_init, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses variable initialization", 0, true, false, 3)
DIAG(note_protected_by_vla, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses initialization of variable length array", 0, true, false, 3)
DIAG(note_protected_by_vla_typedef, CLASS_NOTE, diag::MAP_FATAL, "jump bypasses initialization of VLA typedef", 0, true, false, 3)
DIAG(note_pure_virtual_function, CLASS_NOTE, diag::MAP_FATAL, "unimplemented pure virtual method %0 in %1", 0, true, false, 3)
DIAG(note_ref_var_local_bind, CLASS_NOTE, diag::MAP_FATAL, "binding reference variable %0 here", 0, true, false, 3)
DIAG(note_refconst_member_not_initialized, CLASS_NOTE, diag::MAP_FATAL, "%select{const|reference}0 member %1 will never be initialized", 0, true, false, 3)
DIAG(note_referenced_class_template, CLASS_ERROR, diag::MAP_ERROR, "class template declared here", 0, true, false, 3)
DIAG(note_required_for_protocol_at, CLASS_NOTE, diag::MAP_FATAL, "required for direct or indirect protocol %0", 0, true, false, 3)
DIAG(note_sentinel_here, CLASS_NOTE, diag::MAP_FATAL, "%select{function|method|block}0 has been explicitly marked sentinel here", 0, true, false, 3)
DIAG(note_specialized_decl, CLASS_NOTE, diag::MAP_FATAL, "attempt to specialize declaration here", 0, true, false, 3)
DIAG(note_specialized_entity, CLASS_NOTE, diag::MAP_FATAL, "explicitly specialized declaration is here", 0, true, false, 3)
DIAG(note_switch_conversion, CLASS_NOTE, diag::MAP_FATAL, "conversion to %select{integral|enumeration}0 type %1", 0, true, false, 3)
DIAG(note_template_arg_internal_object, CLASS_NOTE, diag::MAP_FATAL, "non-template argument refers to %select{function|object}0 here", 0, true, false, 3)
DIAG(note_template_arg_refers_here, CLASS_NOTE, diag::MAP_FATAL, "non-template argument refers here", 0, true, false, 3)
DIAG(note_template_arg_refers_here_func, CLASS_NOTE, diag::MAP_FATAL, "template argument refers to function template %0, here", 0, true, false, 3)
DIAG(note_template_class_instantiation_here, CLASS_NOTE, diag::MAP_FATAL, "in instantiation of template class %0 requested here", 0, true, false, 3)
DIAG(note_template_decl_here, CLASS_NOTE, diag::MAP_FATAL, "template is declared here", 0, true, false, 3)
DIAG(note_template_declared_here, CLASS_NOTE, diag::MAP_FATAL, "%select{function template|class template|template template parameter}0 %1 declared here", 0, true, false, 3)
DIAG(note_template_default_arg_checking, CLASS_NOTE, diag::MAP_FATAL, "while checking a default template argument used here", 0, true, false, 3)
DIAG(note_template_member_class_here, CLASS_NOTE, diag::MAP_FATAL, "in instantiation of member class %0 requested here", 0, true, false, 3)
DIAG(note_template_member_function_here, CLASS_NOTE, diag::MAP_FATAL, "in instantiation of member function %q0 requested here", 0, true, false, 3)
DIAG(note_template_nontype_parm_different_type, CLASS_NOTE, diag::MAP_FATAL, "template non-type parameter has a different type %0 in template argument", 0, true, false, 3)
DIAG(note_template_nontype_parm_prev_declaration, CLASS_NOTE, diag::MAP_FATAL, "previous non-type template parameter with type %0 is here", 0, true, false, 3)
DIAG(note_template_param_different_kind, CLASS_NOTE, diag::MAP_FATAL, "template parameter has a different kind in template argument", 0, true, false, 3)
DIAG(note_template_param_here, CLASS_NOTE, diag::MAP_FATAL, "template parameter is declared here", 0, true, false, 3)
DIAG(note_template_param_list_different_arity, CLASS_NOTE, diag::MAP_FATAL, "%select{too few|too many}0 template parameters in template template argument", 0, true, false, 3)
DIAG(note_template_param_prev_default_arg, CLASS_NOTE, diag::MAP_FATAL, "previous default template argument defined here", 0, true, false, 3)
DIAG(note_template_parameter_pack_here, CLASS_NOTE, diag::MAP_FATAL, "previous %select{template type|non-type template|template template}0 parameter%select{| pack}1 declared here", 0, true, false, 3)
DIAG(note_template_parameter_pack_non_pack, CLASS_NOTE, diag::MAP_FATAL, "%select{template type|non-type template|template template}0 parameter%select{| pack}1 does not match %select{template type|non-type template|template template}0 parameter%select{ pack|}1 in template argument", 0, true, false, 3)
DIAG(note_template_prev_declaration, CLASS_NOTE, diag::MAP_FATAL, "previous template %select{declaration|template parameter}0 is here", 0, true, false, 3)
DIAG(note_template_recursion_depth, CLASS_NOTE, diag::MAP_FATAL, "use -ftemplate-depth-N to increase recursive template instantiation depth", 0, true, false, 3)
DIAG(note_template_static_data_member_def_here, CLASS_NOTE, diag::MAP_FATAL, "in instantiation of static data member %q0 requested here", 0, true, false, 3)
DIAG(note_template_unnamed_type_here, CLASS_NOTE, diag::MAP_FATAL, "unnamed type used in template argument was declared here", 0, true, false, 3)
DIAG(note_transparent_union_first_field_size_align, CLASS_NOTE, diag::MAP_FATAL, "%select{alignment|size}0 of first field is %1 bits", 0, true, false, 3)
DIAG(note_typename_refers_here, CLASS_NOTE, diag::MAP_FATAL, "referenced member %0 is declared here", 0, true, false, 3)
DIAG(note_unavailable_here, CLASS_NOTE, diag::MAP_FATAL, "function has been explicitly marked %select{unavailable|deleted|deprecated}0 here", 0, true, false, 3)
DIAG(note_undef_method_impl, CLASS_NOTE, diag::MAP_FATAL, "method definition for %0 not found", 0, true, false, 3)
DIAG(note_uninit_reference_member, CLASS_NOTE, diag::MAP_FATAL, "uninitialized reference member is here", 0, true, false, 3)
DIAG(note_uninit_var_def, CLASS_NOTE, diag::MAP_FATAL, "variable %0 is declared here", 0, true, false, 3)
DIAG(note_used_here, CLASS_NOTE, diag::MAP_FATAL, "used here", 0, true, false, 3)
DIAG(note_using_decl, CLASS_NOTE, diag::MAP_FATAL, "%select{|previous }0using declaration", 0, true, false, 3)
DIAG(note_using_decl_conflict, CLASS_NOTE, diag::MAP_FATAL, "conflicting declaration", 0, true, false, 3)
DIAG(note_using_decl_constructor_conflict_current_ctor, CLASS_NOTE, diag::MAP_FATAL, "conflicting constructor", 0, true, false, 3)
DIAG(note_using_decl_constructor_conflict_previous_ctor, CLASS_NOTE, diag::MAP_FATAL, "previous constructor", 0, true, false, 3)
DIAG(note_using_decl_constructor_conflict_previous_using, CLASS_NOTE, diag::MAP_FATAL, "previously inherited here", 0, true, false, 3)
DIAG(note_using_decl_target, CLASS_NOTE, diag::MAP_FATAL, "target of using declaration", 0, true, false, 3)
DIAG(note_using_value_decl_missing_typename, CLASS_NOTE, diag::MAP_FATAL, "add 'typename' to treat this using declaration as a type", 0, true, false, 3)
DIAG(note_var_fixit_add_initialization, CLASS_NOTE, diag::MAP_FATAL, "add initialization to silence this warning", 0, true, false, 3)
DIAG(override_keyword_only_allowed_on_virtual_member_functions, CLASS_ERROR, diag::MAP_ERROR, "only virtual member functions can be marked '%0'", 0, true, false, 3)
DIAG(warn_access_decl_deprecated, CLASS_WARNING, diag::MAP_WARNING, "access declarations are deprecated; use using declarations instead", "deprecated", true, false, 6)
DIAG(warn_accessor_property_type_mismatch, CLASS_WARNING, diag::MAP_WARNING, "type of property %0 does not match type of accessor %1", 0, true, false, 3)
DIAG(warn_anon_bitfield_width_exceeds_type_size, CLASS_WARNING, diag::MAP_WARNING, "size of anonymous bit-field (%0 bits) exceeds size of its type; value will be truncated to %1 bits", 0, true, false, 3)
DIAG(warn_array_index_exceeds_bounds, CLASS_WARNING, diag::MAP_WARNING, "array index of '%0' indexes past the end of an array (that contains %1 elements)", "array-bounds", true, false, 3)
DIAG(warn_array_index_precedes_bounds, CLASS_WARNING, diag::MAP_WARNING, "array index of '%0' indexes before the beginning of the array", "array-bounds", true, false, 3)
DIAG(warn_asm_label_on_auto_decl, CLASS_WARNING, diag::MAP_WARNING, "ignored asm label '%0' on automatic variable", 0, true, false, 4)
DIAG(warn_atomic_property_rule, CLASS_WARNING, diag::MAP_WARNING, "writable atomic property %0 cannot pair a synthesized setter/getter with a user defined setter/getter", 0, true, false, 3)
DIAG(warn_attribute_ibaction, CLASS_WARNING, diag::MAP_WARNING, "ibaction attribute can only be applied to Objective-C instance methods", 0, true, false, 3)
DIAG(warn_attribute_iboutlet, CLASS_WARNING, diag::MAP_WARNING, "%0 attribute can only be applied to instance variables or properties", 0, true, false, 3)
DIAG(warn_attribute_ignored, CLASS_WARNING, diag::MAP_WARNING, "%0 attribute ignored", 0, true, false, 3)
DIAG(warn_attribute_ignored_for_field_of_type, CLASS_WARNING, diag::MAP_WARNING, "%0 attribute ignored for field of type %1", 0, true, false, 3)
DIAG(warn_attribute_malloc_pointer_only, CLASS_WARNING, diag::MAP_WARNING, "'malloc' attribute only applies to functions returning a pointer type", 0, true, false, 3)
DIAG(warn_attribute_method_def, CLASS_WARNING, diag::MAP_WARNING, "method attribute can only be specified on method declarations", 0, true, false, 3)
DIAG(warn_attribute_nonnull_no_pointers, CLASS_WARNING, diag::MAP_WARNING, "'nonnull' attribute applied to function with no pointer arguments", 0, true, false, 3)
DIAG(warn_attribute_precede_definition, CLASS_WARNING, diag::MAP_WARNING, "attribute declaration must precede definition", 0, true, false, 3)
DIAG(warn_attribute_sentinel_named_arguments, CLASS_WARNING, diag::MAP_WARNING, "'sentinel' attribute requires named arguments", 0, true, false, 3)
DIAG(warn_attribute_sentinel_not_variadic, CLASS_WARNING, diag::MAP_WARNING, "'sentinel' attribute only supported for variadic %select{functions|blocks}0", 0, true, false, 3)
DIAG(warn_attribute_type_not_supported, CLASS_WARNING, diag::MAP_WARNING, "'%0' attribute argument not supported: %1", 0, true, false, 3)
DIAG(warn_attribute_unknown_visibility, CLASS_WARNING, diag::MAP_WARNING, "unknown visibility '%0'", 0, true, false, 3)
DIAG(warn_attribute_void_function_method, CLASS_WARNING, diag::MAP_WARNING, "attribute %0 cannot be applied to %select{functions|Objective-C method}1 without return value", 0, true, false, 3)
DIAG(warn_attribute_weak_import_invalid_on_definition, CLASS_WARNING, diag::MAP_WARNING, "'weak_import' attribute cannot be specified on a definition", 0, true, false, 3)
DIAG(warn_attribute_weak_on_field, CLASS_WARNING, diag::MAP_WARNING, "__weak attribute cannot be specified on a field declaration", 0, true, false, 3)
DIAG(warn_attribute_weak_on_local, CLASS_WARNING, diag::MAP_WARNING, "__weak attribute cannot be specified on an automatic variable", 0, true, false, 3)
DIAG(warn_attribute_wrong_decl_type, CLASS_WARNING, diag::MAP_WARNING, "%0 attribute only applies to %select{functions|unions|variables and functions|functions and methods|parameters|parameters and methods|functions, methods and blocks|classes and virtual methods|functions, methods, and parameters|classes|virtual methods|class members|variables|methods|variables, functions and labels}1", 0, true, false, 3)
DIAG(warn_auto_implicit_atomic_property, CLASS_WARNING, diag::MAP_IGNORE, "property is assumed atomic when auto-synthesizing the property", "implicit-atomic-properties", true, false, 3)
DIAG(warn_bad_receiver_type, CLASS_WARNING, diag::MAP_WARNING, "receiver type %0 is not 'id' or interface pointer, consider casting it to 'id'", 0, true, false, 3)
DIAG(warn_bitfield_width_exceeds_type_size, CLASS_WARNING, diag::MAP_WARNING, "size of bit-field %0 (%1 bits) exceeds the size of its type; value will be truncated to %2 bits", 0, true, false, 3)
DIAG(warn_bool_switch_condition, CLASS_WARNING, diag::MAP_WARNING, "switch condition has boolean value", 0, true, false, 3)
DIAG(warn_braces_around_scalar_init, CLASS_WARNING, diag::MAP_WARNING, "braces around scalar initializer", 0, true, false, 3)
DIAG(warn_builtin_unknown, CLASS_WARNING, diag::MAP_ERROR, "use of unknown builtin %0", 0, true, false, 3)
DIAG(warn_call_wrong_number_of_arguments, CLASS_WARNING, diag::MAP_WARNING, "too %select{few|many}0 arguments in call to %1", 0, true, false, 3)
DIAG(warn_cannot_pass_non_pod_arg_to_vararg, CLASS_WARNING, diag::MAP_ERROR, "cannot pass object of non-POD type %0 through variadic %select{function|block|method|constructor}1; call will abort at runtime", "non-pod-varargs", true, false, 3)
DIAG(warn_case_empty_range, CLASS_WARNING, diag::MAP_WARNING, "empty case range specified", 0, true, false, 3)
DIAG(warn_case_value_overflow, CLASS_WARNING, diag::MAP_WARNING, "overflow converting case value to switch condition type (%0 to %1)", "switch", true, false, 3)
DIAG(warn_cast_align, CLASS_WARNING, diag::MAP_IGNORE, "cast from %0 to %1 increases required alignment from %2 to %3", "cast-align", true, false, 3)
DIAG(warn_cfstring_literal_contains_nul_character, CLASS_WARNING, diag::MAP_WARNING, "CFString literal contains NUL character", 0, true, false, 3)
DIAG(warn_cfstring_truncated, CLASS_WARNING, diag::MAP_WARNING, "input conversion stopped due to an input byte that does not belong to the input codeset UTF-8", 0, true, false, 3)
DIAG(warn_class_method_not_found, CLASS_WARNING, diag::MAP_WARNING, "method %objcclass0 not found (return type defaults to 'id')", 0, true, false, 3)
DIAG(warn_collection_expr_type, CLASS_WARNING, diag::MAP_WARNING, "collection expression type %0 may not respond to %1", 0, true, false, 3)
DIAG(warn_comparison_always, CLASS_WARNING, diag::MAP_WARNING, "%select{self-|array }0comparison always evaluates to %select{false|true|a constant}1", "tautological-compare", true, false, 3)
DIAG(warn_comparison_of_mixed_enum_types, CLASS_WARNING, diag::MAP_WARNING, "comparison of two values with different enumeration types (%0 and %1)", "enum-compare", true, false, 3)
DIAG(warn_condition_is_assignment, CLASS_WARNING, diag::MAP_WARNING, "using the result of an assignment as a condition without parentheses", "parentheses", true, false, 3)
DIAG(warn_condition_is_idiomatic_assignment, CLASS_WARNING, diag::MAP_IGNORE, "using the result of an assignment as a condition without parentheses", "idiomatic-parentheses", true, false, 3)
DIAG(warn_conflicting_param_modifiers, CLASS_WARNING, diag::MAP_WARNING, "conflicting distributed object modifiers on parameter type in implementation of %0", 0, true, false, 3)
DIAG(warn_conflicting_param_types, CLASS_WARNING, diag::MAP_WARNING, "conflicting parameter types in implementation of %0: %1 vs %2", 0, true, false, 3)
DIAG(warn_conflicting_ret_type_modifiers, CLASS_WARNING, diag::MAP_WARNING, "conflicting distributed object modifiers on return type in implementation of %0", 0, true, false, 3)
DIAG(warn_conflicting_ret_types, CLASS_WARNING, diag::MAP_WARNING, "conflicting return type in implementation of %0: %1 vs %2", 0, true, false, 3)
DIAG(warn_conflicting_variadic, CLASS_WARNING, diag::MAP_WARNING, "conflicting variadic declaration of method and its implementation", 0, true, false, 3)
DIAG(warn_conv_to_base_not_used, CLASS_WARNING, diag::MAP_WARNING, "conversion function converting %0 to its base class %1 will never be used", 0, true, false, 3)
DIAG(warn_conv_to_self_not_used, CLASS_WARNING, diag::MAP_WARNING, "conversion function converting %0 to itself will never be used", 0, true, false, 3)
DIAG(warn_conv_to_void_not_used, CLASS_WARNING, diag::MAP_WARNING, "conversion function converting %0 to %1 will never be used", 0, true, false, 3)
DIAG(warn_decl_in_param_list, CLASS_WARNING, diag::MAP_WARNING, "declaration of %0 will not be visible outside of this function", 0, true, false, 3)
DIAG(warn_decl_shadow, CLASS_WARNING, diag::MAP_IGNORE, "declaration shadows a %select{local variable|variable in %2|static data member of %2|field of %2}1", "shadow", true, false, 3)
DIAG(warn_default_atomic_custom_getter_setter, CLASS_WARNING, diag::MAP_IGNORE, "atomic by default property %0 has a user defined %select{getter|setter}1 (property should be marked 'atomic' if this is intended)", "custom-atomic-properties", true, false, 3)
DIAG(warn_delete_array_type, CLASS_WARNING, diag::MAP_WARNING, "'delete' applied to a pointer-to-array type %0 treated as delete[]", 0, true, false, 3)
DIAG(warn_delete_incomplete, CLASS_WARNING, diag::MAP_WARNING, "deleting pointer to incomplete type %0 may cause undefined behaviour", 0, true, false, 3)
DIAG(warn_deprecated, CLASS_WARNING, diag::MAP_WARNING, "%0 is deprecated", "deprecated-declarations", true, false, 6)
DIAG(warn_deprecated_def, CLASS_WARNING, diag::MAP_IGNORE, "Implementing deprecated %select{method|class|category}0", "deprecated-implementations", true, false, 3)
DIAG(warn_deprecated_fwdclass_message, CLASS_WARNING, diag::MAP_WARNING, "%0 maybe deprecated because receiver type is unknown", "deprecated-declarations", true, false, 6)
DIAG(warn_deprecated_message, CLASS_WARNING, diag::MAP_WARNING, "%0 is deprecated: %1", "deprecated-declarations", true, false, 6)
DIAG(warn_deprecated_string_literal_conversion, CLASS_WARNING, diag::MAP_WARNING, "conversion from string literal to %0 is deprecated", "deprecated-writable-strings", true, false, 3)
DIAG(warn_division_by_zero, CLASS_WARNING, diag::MAP_WARNING, "division by zero is undefined", 0, true, false, 3)
DIAG(warn_dup_category_def, CLASS_WARNING, diag::MAP_WARNING, "duplicate definition of category %1 on interface %0", 0, true, false, 3)
DIAG(warn_duplicate_protocol_def, CLASS_WARNING, diag::MAP_WARNING, "duplicate protocol definition of %0 is ignored", 0, true, false, 3)
DIAG(warn_empty_format_string, CLASS_WARNING, diag::MAP_WARNING, "format string is empty", "format-zero-length", true, false, 7)
DIAG(warn_empty_if_body, CLASS_WARNING, diag::MAP_WARNING, "if statement has empty body", "empty-body", true, false, 3)
DIAG(warn_enum_too_large, CLASS_WARNING, diag::MAP_WARNING, "enumeration values exceed range of largest integer", 0, true, false, 3)
DIAG(warn_enum_value_overflow, CLASS_WARNING, diag::MAP_WARNING, "overflow in enumeration value", 0, true, false, 3)
DIAG(warn_enumerator_too_large, CLASS_WARNING, diag::MAP_WARNING, "enumerator value %0 is not representable in the largest integer type", 0, true, false, 3)
DIAG(warn_equality_with_extra_parens, CLASS_WARNING, diag::MAP_WARNING, "equality comparison with extraneous parentheses", "parentheses", true, false, 3)
DIAG(warn_exception_caught_by_earlier_handler, CLASS_WARNING, diag::MAP_WARNING, "exception of type %0 will be caught by earlier handler", 0, true, false, 3)
DIAG(warn_excess_initializers, CLASS_EXTENSION, diag::MAP_WARNING, "excess elements in %select{array|vector|scalar|union|struct}0 initializer", 0, true, false, 3)
DIAG(warn_excess_initializers_in_char_array_initializer, CLASS_EXTENSION, diag::MAP_WARNING, "excess elements in char array initializer", 0, true, false, 3)
DIAG(warn_explicit_conversion_functions, CLASS_WARNING, diag::MAP_WARNING, "explicit conversion functions are a C++0x extension", "c++0x-extensions", true, false, 3)
DIAG(warn_explicit_instantiation_must_be_global_0x, CLASS_WARNING, diag::MAP_WARNING, "explicit instantiation of %0 must occur at global scope", "-Wc++0x-compat", true, false, 3)
DIAG(warn_explicit_instantiation_out_of_scope_0x, CLASS_WARNING, diag::MAP_WARNING, "explicit instantiation of %0 not in a namespace enclosing %1", "-Wc++0x-compat", true, false, 3)
DIAG(warn_explicit_instantiation_unqualified_wrong_namespace_0x, CLASS_WARNING, diag::MAP_WARNING, "explicit instantiation of %q0 must occur in %1", "c++0x-compat", true, false, 3)
DIAG(warn_extern_init, CLASS_WARNING, diag::MAP_WARNING, "'extern' variable has an initializer", 0, true, false, 3)
DIAG(warn_falloff_nonvoid_function, CLASS_WARNING, diag::MAP_WARNING, "control reaches end of non-void function", "return-type", true, false, 3)
DIAG(warn_falloff_noreturn_function, CLASS_WARNING, diag::MAP_WARNING, "function declared 'noreturn' should not return", "invalid-noreturn", true, false, 3)
DIAG(warn_field_is_uninit, CLASS_WARNING, diag::MAP_WARNING, "field is uninitialized when used here", "uninitialized", true, false, 3)
DIAG(warn_float_overflow, CLASS_WARNING, diag::MAP_WARNING, "magnitude of floating-point constant too large for type %0; maximum is %1", "literal-range", true, false, 3)
DIAG(warn_float_underflow, CLASS_WARNING, diag::MAP_WARNING, "magnitude of floating-point constant too small for type %0; minimum is %1", "literal-range", true, false, 3)
DIAG(warn_floatingpoint_eq, CLASS_WARNING, diag::MAP_IGNORE, "comparing floating point with == or != is unsafe", "float-equal", true, false, 3)
DIAG(warn_format_invalid_conversion, CLASS_WARNING, diag::MAP_WARNING, "invalid conversion specifier '%0'", "format", true, false, 7)
DIAG(warn_format_invalid_positional_specifier, CLASS_WARNING, diag::MAP_WARNING, "invalid position specified for %select{field width|field precision}0", "format", true, false, 7)
DIAG(warn_format_mix_positional_nonpositional_args, CLASS_WARNING, diag::MAP_WARNING, "cannot mix positional and non-positional arguments in format string", "format", true, false, 7)
DIAG(warn_format_nonliteral, CLASS_WARNING, diag::MAP_IGNORE, "format string is not a string literal", "format-nonliteral", true, false, 3)
DIAG(warn_format_nonliteral_noargs, CLASS_WARNING, diag::MAP_WARNING, "format string is not a string literal (potentially insecure)", "format-security", true, false, 7)
DIAG(warn_format_nonsensical_length, CLASS_WARNING, diag::MAP_WARNING, "length modifier '%0' results in undefined behavior or no effect with '%1' conversion specifier", "format", true, false, 7)
DIAG(warn_format_string_is_wide_literal, CLASS_WARNING, diag::MAP_WARNING, "format string should not be a wide string", "format", true, false, 7)
DIAG(warn_format_zero_positional_specifier, CLASS_WARNING, diag::MAP_WARNING, "position arguments in format strings start counting at 1 (not 0)", "format", true, false, 7)
DIAG(warn_function_attribute_wrong_type, CLASS_WARNING, diag::MAP_WARNING, "%0 only applies to function types; type here is %1", 0, true, false, 3)
DIAG(warn_global_constructor, CLASS_WARNING, diag::MAP_IGNORE, "declaration requires a global constructor", "global-constructors", true, false, 3)
DIAG(warn_global_destructor, CLASS_WARNING, diag::MAP_IGNORE, "declaration requires a global destructor", "global-constructors", true, false, 3)
DIAG(warn_gnu_inline_attribute_requires_inline, CLASS_WARNING, diag::MAP_WARNING, "'gnu_inline' attribute requires function to be marked 'inline', attribute ignored", 0, true, false, 3)
DIAG(warn_illegal_constant_array_size, CLASS_EXTENSION, diag::MAP_IGNORE, "size of static array must be an integer constant expression", 0, true, false, 3)
DIAG(warn_impcast_bitfield_precision_constant, CLASS_WARNING, diag::MAP_WARNING, "implicit truncation from %2 to bitfield changes value from %0 to %1", "constant-conversion", true, false, 3)
DIAG(warn_impcast_complex_scalar, CLASS_WARNING, diag::MAP_IGNORE, "implicit conversion discards imaginary component: %0 to %1", "conversion", true, false, 3)
DIAG(warn_impcast_different_enum_types, CLASS_WARNING, diag::MAP_WARNING, "implicit conversion from enumeration type %0 to different enumeration type %1", "conversion", true, false, 3)
DIAG(warn_impcast_float_integer, CLASS_WARNING, diag::MAP_IGNORE, "implicit conversion turns floating-point number into integer: %0 to %1", "conversion", true, false, 3)
DIAG(warn_impcast_float_precision, CLASS_WARNING, diag::MAP_IGNORE, "implicit conversion loses floating-point precision: %0 to %1", "conversion", true, false, 3)
DIAG(warn_impcast_integer_64_32, CLASS_WARNING, diag::MAP_IGNORE, "implicit conversion loses integer precision: %0 to %1", "shorten-64-to-32", true, false, 3)
DIAG(warn_impcast_integer_precision, CLASS_WARNING, diag::MAP_IGNORE, "implicit conversion loses integer precision: %0 to %1", "conversion", true, false, 3)
DIAG(warn_impcast_integer_precision_constant, CLASS_WARNING, diag::MAP_WARNING, "implicit conversion from %2 to %3 changes value from %0 to %1", "constant-conversion", true, false, 3)
DIAG(warn_impcast_integer_sign, CLASS_WARNING, diag::MAP_IGNORE, "implicit conversion changes signedness: %0 to %1", "sign-conversion", true, false, 3)
DIAG(warn_impcast_integer_sign_conditional, CLASS_WARNING, diag::MAP_IGNORE, "operand of ? changes signedness: %0 to %1", "sign-conversion", true, false, 3)
DIAG(warn_impcast_literal_float_to_integer, CLASS_WARNING, diag::MAP_IGNORE, "implicit conversion turns literal floating-point number into integer: %0 to %1", "literal-conversion", true, false, 3)
DIAG(warn_impcast_vector_scalar, CLASS_WARNING, diag::MAP_IGNORE, "implicit conversion turns vector to scalar: %0 to %1", "conversion", true, false, 3)
DIAG(warn_implements_nscopying, CLASS_WARNING, diag::MAP_WARNING, "default assign attribute on property %0 which implements NSCopying protocol is not appropriate with -fobjc-gc[-only]", 0, true, false, 3)
DIAG(warn_implicit_atomic_property, CLASS_WARNING, diag::MAP_IGNORE, "property is assumed atomic by default", "implicit-atomic-properties", true, false, 3)
DIAG(warn_implicit_decl_requires_setjmp, CLASS_WARNING, diag::MAP_WARNING, "declaration of built-in function '%0' requires inclusion of the header <setjmp.h>", 0, true, false, 3)
DIAG(warn_implicit_decl_requires_stdio, CLASS_WARNING, diag::MAP_WARNING, "declaration of built-in function '%0' requires inclusion of the header <stdio.h>", 0, true, false, 3)
DIAG(warn_implicit_function_decl, CLASS_WARNING, diag::MAP_IGNORE, "implicit declaration of function %0", "implicit-function-declaration", true, false, 3)
DIAG(warn_incompatible_qualified_id, CLASS_WARNING, diag::MAP_WARNING, "%select{assigning to|passing|returning|converting|initializing|sending|casting}2 %0 %select{from incompatible type|to parameter of incompatible type|from a function with incompatible result type|to incompatible type|with an expression of incompatible type|to parameter of incompatible type|to incompatible type}2 %1", 0, true, false, 3)
DIAG(warn_incompatible_vectors, CLASS_WARNING, diag::MAP_IGNORE, "incompatible vector types %select{assigning to|passing|returning|converting|initializing|sending|casting}2 %0 %select{from|to parameter of type|from a function with result type|to type|with an expression of type|to parameter of type|to type}2 %1", "vector-conversions", true, false, 3)
DIAG(warn_incomplete_impl, CLASS_WARNING, diag::MAP_WARNING, "incomplete implementation", "incomplete-implementation", true, false, 3)
DIAG(warn_increment_bool, CLASS_WARNING, diag::MAP_WARNING, "incrementing expression of type bool is deprecated", "deprecated", true, false, 6)
DIAG(warn_indirection_through_null, CLASS_WARNING, diag::MAP_WARNING, "indirection of non-volatile null pointer will be deleted, not trap", "null-dereference", true, false, 3)
DIAG(warn_init_pointer_from_false, CLASS_WARNING, diag::MAP_WARNING, "initialization of pointer of type %0 from literal 'false'", "bool-conversions", true, false, 8)
DIAG(warn_initializer_out_of_order, CLASS_WARNING, diag::MAP_IGNORE, "%select{field|base class}0 %1 will be initialized after %select{field|base}2 %3", "reorder", true, false, 3)
DIAG(warn_initializer_overrides, CLASS_WARNING, diag::MAP_WARNING, "initializer overrides prior initialization of this subobject", "initializer-overrides", true, false, 3)
DIAG(warn_initializer_string_for_char_array_too_long, CLASS_EXTENSION, diag::MAP_WARNING, "initializer-string for char array is too long", 0, true, false, 3)
DIAG(warn_inst_method_not_found, CLASS_WARNING, diag::MAP_WARNING, "method %objcinstance0 not found (return type defaults to 'id')", 0, true, false, 3)
DIAG(warn_invalid_asm_cast_lvalue, CLASS_WARNING, diag::MAP_WARNING, "invalid use of a cast in a inline asm context requiring an l-value: accepted due to -fheinous-gnu-extensions, but clang may remove support for this in the future", 0, true, false, 4)
DIAG(warn_ivar_use_hidden, CLASS_WARNING, diag::MAP_WARNING, "local declaration of %0 hides instance variable", 0, true, false, 3)
DIAG(warn_logical_and_in_logical_or, CLASS_WARNING, diag::MAP_WARNING, "'&&' within '||'", "logical-op-parentheses", true, false, 3)
DIAG(warn_logical_instead_of_bitwise, CLASS_WARNING, diag::MAP_WARNING, "use of logical %0 with constant operand; switch to bitwise %1 or remove constant", "constant-logical-operand", true, false, 3)
DIAG(warn_lunsigned_always_true_comparison, CLASS_WARNING, diag::MAP_WARNING, "comparison of unsigned%select{| enum}2 expression %0 is always %1", "tautological-compare", true, false, 3)
DIAG(warn_main_one_arg, CLASS_WARNING, diag::MAP_WARNING, "only one parameter on 'main' declaration", 0, true, false, 3)
DIAG(warn_many_braces_around_scalar_init, CLASS_EXTENSION, diag::MAP_WARNING, "too many braces around scalar initializer", 0, true, false, 3)
DIAG(warn_maybe_falloff_nonvoid_function, CLASS_WARNING, diag::MAP_WARNING, "control may reach end of non-void function", "return-type", true, false, 3)
DIAG(warn_maynot_respond, CLASS_WARNING, diag::MAP_WARNING, "%0 may not respond to %1", 0, true, false, 3)
DIAG(warn_member_extra_qualification, CLASS_WARNING, diag::MAP_WARNING, "extra qualification on member %0", 0, true, false, 3)
DIAG(warn_missing_atend, CLASS_WARNING, diag::MAP_WARNING, "'@end' is missing in implementation context", 0, true, false, 3)
DIAG(warn_missing_braces, CLASS_WARNING, diag::MAP_IGNORE, "suggest braces around initialization of subobject", "missing-braces", true, false, 3)
DIAG(warn_missing_case1, CLASS_WARNING, diag::MAP_WARNING, "enumeration value %0 not handled in switch", "switch-enum", true, false, 3)
DIAG(warn_missing_case2, CLASS_WARNING, diag::MAP_WARNING, "enumeration values %0 and %1 not handled in switch", "switch-enum", true, false, 3)
DIAG(warn_missing_case3, CLASS_WARNING, diag::MAP_WARNING, "enumeration values %0, %1, and %2 not handled in switch", "switch-enum", true, false, 3)
DIAG(warn_missing_case_for_condition, CLASS_WARNING, diag::MAP_WARNING, "no case matching constant switch condition '%0'", 0, true, false, 3)
DIAG(warn_missing_cases, CLASS_WARNING, diag::MAP_WARNING, "%0 enumeration values not handled in switch: %1, %2, %3...", "switch-enum", true, false, 3)
DIAG(warn_missing_exception_specification, CLASS_WARNING, diag::MAP_WARNING, "%0 is missing exception specification '%1'", 0, true, false, 3)
DIAG(warn_missing_field_initializers, CLASS_WARNING, diag::MAP_IGNORE, "missing field '%0' initializer", "missing-field-initializers", true, false, 3)
DIAG(warn_missing_format_string, CLASS_WARNING, diag::MAP_WARNING, "format string missing", "format", true, false, 7)
DIAG(warn_missing_prototype, CLASS_WARNING, diag::MAP_IGNORE, "no previous prototype for function %0", "missing-prototypes", true, false, 3)
DIAG(warn_missing_sentinel, CLASS_WARNING, diag::MAP_WARNING, "missing sentinel in %select{function call|method dispatch|block call}0", 0, true, false, 3)
DIAG(warn_mixed_sign_comparison, CLASS_WARNING, diag::MAP_IGNORE, "comparison of integers of different signs: %0 and %1", "sign-compare", true, false, 3)
DIAG(warn_mixed_sign_conditional, CLASS_WARNING, diag::MAP_IGNORE, "operands of ? are integers of different signs: %0 and %1", "sign-compare", true, false, 3)
DIAG(warn_multiple_method_decl, CLASS_WARNING, diag::MAP_WARNING, "multiple methods named %0 found", 0, true, false, 3)
DIAG(warn_no_constructor_for_refconst, CLASS_WARNING, diag::MAP_WARNING, "%select{struct|union|class|enum}0 %1 does not declare any constructor to initialize its non-modifiable members", 0, true, false, 3)
DIAG(warn_non_contravariant_param_types, CLASS_WARNING, diag::MAP_IGNORE, "conflicting parameter types in implementation of %0: %1 vs %2", "method-signatures", true, false, 3)
DIAG(warn_non_covariant_ret_types, CLASS_WARNING, diag::MAP_IGNORE, "conflicting return type in implementation of %0: %1 vs %2", "method-signatures", true, false, 3)
DIAG(warn_non_virtual_dtor, CLASS_WARNING, diag::MAP_IGNORE, "%0 has virtual functions but non-virtual destructor", "non-virtual-dtor", true, false, 3)
DIAG(warn_nonnull_pointers_only, CLASS_WARNING, diag::MAP_WARNING, "nonnull attribute only applies to pointer arguments", 0, true, false, 3)
DIAG(warn_noreturn_function_has_return_expr, CLASS_WARNING, diag::MAP_WARNING, "function %0 declared 'noreturn' should not return", "invalid-noreturn", true, false, 3)
DIAG(warn_not_compound_assign, CLASS_WARNING, diag::MAP_WARNING, "use of unary operator that may be intended as compound assignment (%0=)", 0, true, false, 3)
DIAG(warn_not_enough_argument, CLASS_WARNING, diag::MAP_WARNING, "not enough variable arguments in %0 declaration to fit a sentinel", 0, true, false, 3)
DIAG(warn_not_in_enum, CLASS_WARNING, diag::MAP_WARNING, "case value not in enumerated type %0", "switch-enum", true, false, 3)
DIAG(warn_ns_attribute_wrong_parameter_type, CLASS_WARNING, diag::MAP_WARNING, "%0 attribute only applies to %select{Objective-C object|pointer}1 parameters", 0, true, false, 3)
DIAG(warn_ns_attribute_wrong_return_type, CLASS_WARNING, diag::MAP_WARNING, "%0 attribute only applies to %select{functions|methods}1 that return %select{an Objective-C object|a pointer}2", 0, true, false, 3)
DIAG(warn_null_arg, CLASS_WARNING, diag::MAP_WARNING, "null passed to a callee which requires a non-null argument", "nonnull", true, false, 7)
DIAG(warn_objc_property_attr_mutually_exclusive, CLASS_WARNING, diag::MAP_IGNORE, "property attributes '%0' and '%1' are mutually exclusive", "readonly-setter-attrs", true, false, 3)
DIAG(warn_objc_property_copy_missing_on_block, CLASS_WARNING, diag::MAP_WARNING, "'copy' attribute must be specified for the block property when -fobjc-gc-only is specified", 0, true, false, 3)
DIAG(warn_objc_property_default_assign_on_object, CLASS_WARNING, diag::MAP_WARNING, "default property attribute 'assign' not appropriate for non-gc object", 0, true, false, 3)
DIAG(warn_objc_property_no_assignment_attribute, CLASS_WARNING, diag::MAP_WARNING, "no 'assign', 'retain', or 'copy' attribute is specified - 'assign' is assumed", 0, true, false, 3)
DIAG(warn_offsetof_non_pod_type, CLASS_EXTENSION, diag::MAP_WARNING, "offset of on non-POD type %0", "invalid-offsetof", true, false, 3)
DIAG(warn_on_superclass_use, CLASS_WARNING, diag::MAP_WARNING, "class implementation may not have super class", 0, true, false, 3)
DIAG(warn_overloaded_virtual, CLASS_WARNING, diag::MAP_IGNORE, "%q0 hides overloaded virtual %select{function|functions}1", "overloaded-virtual", true, false, 3)
DIAG(warn_padded_struct_anon_field, CLASS_WARNING, diag::MAP_IGNORE, "padding %select{struct|class}0 %1 with %2 %select{byte|bit}3%select{|s}4 to align anonymous bit-field", "padded", true, false, 3)
DIAG(warn_padded_struct_field, CLASS_WARNING, diag::MAP_IGNORE, "padding %select{struct|class}0 %1 with %2 %select{byte|bit}3%select{|s}4 to align %5", "padded", true, false, 3)
DIAG(warn_padded_struct_size, CLASS_WARNING, diag::MAP_IGNORE, "padding size of %0 with %1 %select{byte|bit}2%select{|s}3 to alignment boundary", "padded", true, false, 3)
DIAG(warn_parameter_size, CLASS_WARNING, diag::MAP_WARNING, "%0 is a large (%1 bytes) pass-by-value argument; pass it by reference instead ?", "large-by-value-copy", true, false, 3)
DIAG(warn_partial_specs_not_deducible, CLASS_WARNING, diag::MAP_WARNING, "class template partial specialization contains %select{a template parameter|template parameters}0 that can not be deduced; this partial specialization will never be used", 0, true, false, 3)
DIAG(warn_pragma_options_align_reset_failed, CLASS_WARNING, diag::MAP_WARNING, "#pragma options align=reset failed: %0", 0, true, false, 3)
DIAG(warn_pragma_options_align_unsupported_option, CLASS_WARNING, diag::MAP_WARNING, "unsupported alignment option in '#pragma options align'", 0, true, false, 3)
DIAG(warn_pragma_pack_invalid_alignment, CLASS_WARNING, diag::MAP_WARNING, "expected #pragma pack parameter to be '1', '2', '4', '8', or '16'", 0, true, false, 3)
DIAG(warn_pragma_pack_pop_failed, CLASS_WARNING, diag::MAP_WARNING, "#pragma pack(pop, ...) failed: %0", 0, true, false, 3)
DIAG(warn_pragma_pack_pop_identifer_and_alignment, CLASS_WARNING, diag::MAP_WARNING, "specifying both a name and alignment to 'pop' is undefined", 0, true, false, 3)
DIAG(warn_pragma_pack_show, CLASS_WARNING, diag::MAP_WARNING, "value of #pragma pack(show) == %0", 0, true, false, 3)
DIAG(warn_pragma_unused_expected_var_arg, CLASS_WARNING, diag::MAP_WARNING, "only variables can be arguments to '#pragma unused'", 0, true, false, 3)
DIAG(warn_pragma_unused_undeclared_var, CLASS_WARNING, diag::MAP_WARNING, "undeclared variable %0 used as an argument for '#pragma unused'", 0, true, false, 3)
DIAG(warn_precedence_bitwise_rel, CLASS_WARNING, diag::MAP_WARNING, "%0 has lower precedence than %1; %1 will be evaluated first", "parentheses", true, false, 3)
DIAG(warn_previous_alias_decl, CLASS_WARNING, diag::MAP_WARNING, "previously declared alias is ignored", 0, true, false, 3)
DIAG(warn_printf_asterisk_missing_arg, CLASS_WARNING, diag::MAP_WARNING, "'%select{*|.*}0' specified field %select{width|precision}0 is missing a matching 'int' argument", 0, true, false, 3)
DIAG(warn_printf_asterisk_wrong_type, CLASS_WARNING, diag::MAP_WARNING, "field %select{width|precision}0 should have type %1, but argument has type %2", "format", true, false, 7)
DIAG(warn_printf_conversion_argument_type_mismatch, CLASS_WARNING, diag::MAP_WARNING, "conversion specifies type %0 but the argument has type %1", "format", true, false, 7)
DIAG(warn_printf_data_arg_not_used, CLASS_WARNING, diag::MAP_WARNING, "data argument not used by format string", "format-extra-args", true, false, 7)
DIAG(warn_printf_format_string_contains_null_char, CLASS_WARNING, diag::MAP_WARNING, "format string contains '\\0' within the string body", "format", true, false, 7)
DIAG(warn_printf_ignored_flag, CLASS_WARNING, diag::MAP_WARNING, "flag '%0' is ignored when flag '%1' is present", "format", true, false, 7)
DIAG(warn_printf_incomplete_specifier, CLASS_WARNING, diag::MAP_WARNING, "incomplete format specifier", "format", true, false, 7)
DIAG(warn_printf_insufficient_data_args, CLASS_WARNING, diag::MAP_WARNING, "more '%%' conversions than data arguments", "format", true, false, 7)
DIAG(warn_printf_nonsensical_flag, CLASS_WARNING, diag::MAP_WARNING, "flag '%0' results in undefined behavior with '%1' conversion specifier", "format", true, false, 7)
DIAG(warn_printf_nonsensical_optional_amount, CLASS_WARNING, diag::MAP_WARNING, "%select{field width|precision}0 used with '%1' conversion specifier, resulting in undefined behavior", "format", true, false, 7)
DIAG(warn_printf_positional_arg_exceeds_data_args, CLASS_WARNING, diag::MAP_WARNING, "data argument position '%0' exceeds the number of data arguments (%1)", "format", true, false, 7)
DIAG(warn_printf_write_back, CLASS_WARNING, diag::MAP_WARNING, "use of '%%n' in format string discouraged (potentially insecure)", "format-security", true, false, 7)
DIAG(warn_property_attr_mismatch, CLASS_WARNING, diag::MAP_WARNING, "property attribute in continuation class does not match the primary class", 0, true, false, 3)
DIAG(warn_property_attribute, CLASS_WARNING, diag::MAP_WARNING, "property %0 '%1' attribute does not match the property inherited from %2", 0, true, false, 3)
DIAG(warn_property_types_are_incompatible, CLASS_WARNING, diag::MAP_WARNING, "property type %0 is incompatible with type %1 inherited from %2", 0, true, false, 3)
DIAG(warn_qual_return_type, CLASS_WARNING, diag::MAP_IGNORE, "'%0' type qualifier%s1 on return type %plural{1:has|:have}1 no effect", "ignored-qualifiers", true, false, 3)
DIAG(warn_readonly_property, CLASS_WARNING, diag::MAP_WARNING, "attribute 'readonly' of property %0 restricts attribute 'readwrite' of property inherited from %1", 0, true, false, 3)
DIAG(warn_receiver_forward_class, CLASS_WARNING, diag::MAP_WARNING, "receiver %0 is a forward class and corresponding @interface may not exist", 0, true, false, 3)
DIAG(warn_redecl_library_builtin, CLASS_WARNING, diag::MAP_WARNING, "incompatible redeclaration of library function %0", 0, true, false, 3)
DIAG(warn_redeclaration_without_attribute_prev_attribute_ignored, CLASS_WARNING, diag::MAP_WARNING, "'%0' redeclared without %1 attribute: previous %1 ignored", 0, true, false, 3)
DIAG(warn_redefinition_of_typedef, CLASS_WARNING, diag::MAP_ERROR, "redefinition of typedef %0 is invalid in C", "typedef-redefinition", true, false, 3)
DIAG(warn_register_objc_catch_parm, CLASS_WARNING, diag::MAP_WARNING, "'register' storage specifier on @catch parameter will be ignored", 0, true, false, 3)
DIAG(warn_remainder_by_zero, CLASS_WARNING, diag::MAP_WARNING, "remainder by zero is undefined", 0, true, false, 3)
DIAG(warn_ret_addr_label, CLASS_WARNING, diag::MAP_WARNING, "returning address of label, which is local", 0, true, false, 3)
DIAG(warn_ret_local_temp_addr, CLASS_WARNING, diag::MAP_WARNING, "returning address of local temporary object", 0, true, false, 3)
DIAG(warn_ret_local_temp_ref, CLASS_WARNING, diag::MAP_WARNING, "returning reference to local temporary object", 0, true, false, 3)
DIAG(warn_ret_stack_addr, CLASS_WARNING, diag::MAP_WARNING, "address of stack memory associated with local variable %0 returned", 0, true, false, 3)
DIAG(warn_ret_stack_ref, CLASS_WARNING, diag::MAP_WARNING, "reference to stack memory associated with local variable %0 returned", 0, true, false, 3)
DIAG(warn_return_missing_expr, CLASS_WARNING, diag::MAP_ERROR, "non-void %select{function|method}1 %0 should return a value", "return-type", true, false, 3)
DIAG(warn_return_value_size, CLASS_WARNING, diag::MAP_WARNING, "return value of %0 is a large (%1 bytes) pass-by-value object; pass it by reference instead ?", "large-by-value-copy", true, false, 3)
DIAG(warn_root_inst_method_not_found, CLASS_WARNING, diag::MAP_WARNING, "instance method %0 is being used on 'Class' which is not in the root class", 0, true, false, 3)
DIAG(warn_runsigned_always_true_comparison, CLASS_WARNING, diag::MAP_WARNING, "comparison of %0 unsigned%select{| enum}2 expression is always %1", "tautological-compare", true, false, 3)
DIAG(warn_scanf_nonzero_width, CLASS_WARNING, diag::MAP_WARNING, "zero field width in scanf format string is unused", "format", true, false, 7)
DIAG(warn_scanf_scanlist_incomplete, CLASS_WARNING, diag::MAP_WARNING, "no closing ']' for '%%[' in scanf format string", "format", true, false, 7)
DIAG(warn_second_parameter_of_va_start_not_last_named_argument, CLASS_WARNING, diag::MAP_WARNING, "second parameter of 'va_start' not last named argument", 0, true, false, 3)
DIAG(warn_self_assignment, CLASS_WARNING, diag::MAP_IGNORE, "explicitly assigning a variable of type %0 to itself", "self-assign", true, false, 3)
DIAG(warn_setter_getter_impl_required, CLASS_WARNING, diag::MAP_WARNING, "property %0 requires method %1 to be defined - use @synthesize, @dynamic or provide a method implementation", 0, true, false, 3)
DIAG(warn_setter_getter_impl_required_in_category, CLASS_WARNING, diag::MAP_WARNING, "property %0 requires method %1 to be defined - use @dynamic or provide a method implementation in category", 0, true, false, 3)
DIAG(warn_shift_gt_typewidth, CLASS_WARNING, diag::MAP_WARNING, "shift count >= width of type", 0, true, false, 3)
DIAG(warn_shift_negative, CLASS_WARNING, diag::MAP_WARNING, "shift count is negative", 0, true, false, 3)
DIAG(warn_shift_result_gt_typewidth, CLASS_WARNING, diag::MAP_WARNING, "shift result (%0) requires %1 bits to represent, but %2 only has %3 bits", "shift-overflow", true, false, 3)
DIAG(warn_shift_result_overrides_sign_bit, CLASS_WARNING, diag::MAP_IGNORE, "shift result (%0) overrides the sign bit of the shift expression's type (%1) and becomes negative", "shift-sign-overflow", true, false, 3)
DIAG(warn_strict_multiple_method_decl, CLASS_WARNING, diag::MAP_IGNORE, "multiple methods named %0 found", "strict-selector-match", true, false, 3)
DIAG(warn_stringcompare, CLASS_WARNING, diag::MAP_WARNING, "result of comparison against %select{a string literal|@encode}0 is unspecified (use strncmp instead)", 0, true, false, 3)
DIAG(warn_struct_class_tag_mismatch, CLASS_WARNING, diag::MAP_IGNORE, "%select{struct|class}0 %select{|template}1 %2 was previously declared as a %select{class|struct}0 %select{|template}1", "mismatched-tags", true, false, 3)
DIAG(warn_subobject_initializer_overrides, CLASS_WARNING, diag::MAP_WARNING, "subobject initialization overrides initialization of other fields within its enclosing subobject", "initializer-overrides", true, false, 3)
DIAG(warn_subscript_is_char, CLASS_WARNING, diag::MAP_IGNORE, "array subscript is of type 'char'", "char-subscripts", true, false, 3)
DIAG(warn_suggest_noreturn_block, CLASS_WARNING, diag::MAP_IGNORE, "block could be attribute 'noreturn'", "missing-noreturn", true, false, 3)
DIAG(warn_suggest_noreturn_function, CLASS_WARNING, diag::MAP_IGNORE, "function could be attribute 'noreturn'", "missing-noreturn", true, false, 3)
DIAG(warn_synthesized_ivar_access, CLASS_WARNING, diag::MAP_IGNORE, "direct access of synthesized ivar by using property access %0", "nonfragile-abi2", true, false, 3)
DIAG(warn_template_arg_negative, CLASS_WARNING, diag::MAP_IGNORE, "non-type template argument with value '%0' converted to '%1' for unsigned template parameter of type %2", "conversion", true, false, 8)
DIAG(warn_template_arg_too_large, CLASS_WARNING, diag::MAP_IGNORE, "non-type template argument value '%0' truncated to '%1' for template parameter of type %2", "conversion", true, false, 8)
DIAG(warn_template_export_unsupported, CLASS_WARNING, diag::MAP_WARNING, "exported templates are unsupported", 0, true, false, 3)
DIAG(warn_template_spec_extra_headers, CLASS_WARNING, diag::MAP_WARNING, "extraneous template parameter list in template specialization", 0, true, false, 3)
DIAG(warn_tentative_incomplete_array, CLASS_WARNING, diag::MAP_WARNING, "tentative array definition assumed to have one element", 0, true, false, 3)
DIAG(warn_transparent_union_attribute_field_size_align, CLASS_WARNING, diag::MAP_WARNING, "%select{alignment|size}0 of field %1 (%2 bits) does not match the %select{alignment|size}0 of the first field in transparent union; transparent_union attribute ignored", 0, true, false, 3)
DIAG(warn_transparent_union_attribute_floating, CLASS_WARNING, diag::MAP_WARNING, "first field of a transparent union cannot have %select{floating point|vector}0 type %1; transparent_union attribute ignored", 0, true, false, 3)
DIAG(warn_transparent_union_attribute_not_definition, CLASS_WARNING, diag::MAP_WARNING, "transparent_union attribute can only be applied to a union definition; attribute ignored", 0, true, false, 3)
DIAG(warn_transparent_union_attribute_zero_fields, CLASS_WARNING, diag::MAP_WARNING, "transparent union definition must contain at least one field; transparent_union attribute ignored", 0, true, false, 3)
DIAG(warn_transparent_union_nonpointer, CLASS_WARNING, diag::MAP_WARNING, "'transparent_union' attribute support incomplete; only supported for pointer unions", 0, true, false, 3)
DIAG(warn_typecheck_cond_incompatible_pointers, CLASS_EXTENSION, diag::MAP_WARNING, "pointer type mismatch (%0 and %1)", 0, true, false, 3)
DIAG(warn_typecheck_cond_pointer_integer_mismatch, CLASS_EXTENSION, diag::MAP_WARNING, "pointer/integer type mismatch in conditional expression (%0 and %1)", 0, true, false, 3)
DIAG(warn_typecheck_function_qualifiers, CLASS_WARNING, diag::MAP_WARNING, "qualifier on function type %0 has unspecified behavior", 0, true, false, 3)
DIAG(warn_unavailable_fwdclass_message, CLASS_WARNING, diag::MAP_WARNING, "%0 maybe unavailable because receiver type is unknown", 0, true, false, 3)
DIAG(warn_undeclared_selector, CLASS_WARNING, diag::MAP_IGNORE, "undeclared selector %0", "undeclared-selector", true, false, 3)
DIAG(warn_undef_interface, CLASS_WARNING, diag::MAP_WARNING, "cannot find interface declaration for %0", 0, true, false, 3)
DIAG(warn_undef_interface_suggest, CLASS_WARNING, diag::MAP_WARNING, "cannot find interface declaration for %0; did you mean %1?", 0, true, false, 3)
DIAG(warn_undef_protocolref, CLASS_WARNING, diag::MAP_WARNING, "cannot find protocol definition for %0", 0, true, false, 3)
DIAG(warn_undefined_internal, CLASS_WARNING, diag::MAP_WARNING, "%select{function|variable}0 %q1 has internal linkage but is not defined", 0, true, false, 3)
DIAG(warn_unimplemented_protocol_method, CLASS_WARNING, diag::MAP_WARNING, "method in protocol not implemented", "protocol", true, false, 3)
DIAG(warn_unimplemented_selector, CLASS_WARNING, diag::MAP_IGNORE, "unimplemented selector %0", "selector", true, false, 3)
DIAG(warn_uninit_var, CLASS_WARNING, diag::MAP_IGNORE, "variable %0 is possibly uninitialized when used here", "uninitialized-experimental", true, false, 3)
DIAG(warn_uninit_var_captured_by_block, CLASS_WARNING, diag::MAP_IGNORE, "variable %0 is possibly uninitialized when captured by block", "uninitialized-experimental", true, false, 3)
DIAG(warn_unknown_attribute_ignored, CLASS_WARNING, diag::MAP_WARNING, "unknown attribute %0 ignored", "unknown-attributes", true, false, 3)
DIAG(warn_unknown_method_family, CLASS_WARNING, diag::MAP_WARNING, "unrecognized method family", 0, true, false, 3)
DIAG(warn_unnecessary_packed, CLASS_WARNING, diag::MAP_IGNORE, "packed attribute is unnecessary for %0", "packed", true, false, 3)
DIAG(warn_unreachable, CLASS_WARNING, diag::MAP_IGNORE, "will never be executed", "unreachable-code", true, false, 3)
DIAG(warn_unused_call, CLASS_WARNING, diag::MAP_WARNING, "ignoring return value of function declared with %0 attribute", "unused-value", true, false, 9)
DIAG(warn_unused_exception_param, CLASS_WARNING, diag::MAP_IGNORE, "unused exception parameter %0", "unused-exception-parameter", true, false, 3)
DIAG(warn_unused_expr, CLASS_WARNING, diag::MAP_WARNING, "expression result unused", "unused-value", true, false, 9)
DIAG(warn_unused_function, CLASS_WARNING, diag::MAP_IGNORE, "unused function %0", "unused-function", true, false, 9)
DIAG(warn_unused_label, CLASS_WARNING, diag::MAP_IGNORE, "unused label %0", "unused-label", true, false, 9)
DIAG(warn_unused_member_function, CLASS_WARNING, diag::MAP_IGNORE, "unused member function %0", "unused-member-function", true, false, 3)
DIAG(warn_unused_parameter, CLASS_WARNING, diag::MAP_IGNORE, "unused parameter %0", "unused-parameter", true, false, 3)
DIAG(warn_unused_property_expr, CLASS_WARNING, diag::MAP_WARNING, "property access result unused - getters should not be used for side effects", "unused-value", true, false, 9)
DIAG(warn_unused_variable, CLASS_WARNING, diag::MAP_IGNORE, "unused variable %0", "unused-variable", true, false, 9)
DIAG(warn_unused_voidptr, CLASS_WARNING, diag::MAP_WARNING, "expression result unused; should this cast be to 'void'?", "unused-value", true, false, 9)
DIAG(warn_unusual_main_decl, CLASS_WARNING, diag::MAP_WARNING, "'main' should not be declared %select{static|inline|static or inline}0", 0, true, false, 3)
DIAG(warn_use_out_of_scope_declaration, CLASS_WARNING, diag::MAP_WARNING, "use of out-of-scope declaration of %0", 0, true, false, 3)
DIAG(warn_used_but_marked_unused, CLASS_WARNING, diag::MAP_IGNORE, "%0 was marked unused but was used", "used-but-marked-unused", true, false, 3)
DIAG(warn_weak_identifier_undeclared, CLASS_WARNING, diag::MAP_WARNING, "weak identifier %0 never declared", 0, true, false, 3)
DIAG(warn_weak_vtable, CLASS_WARNING, diag::MAP_IGNORE, "%0 has no out-of-line virtual method definitions; its vtable will be emitted in every translation unit", "weak-vtables", true, false, 3)
