/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.LabelValueBean;
import org.apache.webapp.admin.Lists;
import org.apache.webapp.admin.service.ServiceForm;

public class EditServiceAction
extends Action {
    private MBeanServer mBServer = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        MessageResources resources = this.getResources(request);
        try {
            this.mBServer = ((ApplicationServlet)this.getServlet()).getServer();
        }
        catch (Throwable t) {
            throw new ServletException("Cannot acquire MBeanServer reference", t);
        }
        ObjectName sname = null;
        ObjectName ename = null;
        StringBuffer sb = null;
        try {
            sname = new ObjectName(request.getParameter("select"));
        }
        catch (Exception e) {
            String message = resources.getMessage(locale, "error.serviceName.bad", (Object)request.getParameter("select"));
            this.getServlet().log(message);
            response.sendError(400, message);
            return null;
        }
        try {
            sb = new StringBuffer(sname.getDomain());
            sb.append(":type=Engine");
            ename = new ObjectName(sb.toString());
        }
        catch (Exception e) {
            String message = resources.getMessage(locale, "error.engineName.bad", (Object)sb.toString());
            this.getServlet().log(message);
            response.sendError(400, message);
            return null;
        }
        String adminService = null;
        try {
            adminService = Lists.getAdminAppService(this.mBServer, sname.getDomain(), request);
        }
        catch (Exception e) {
            String message = resources.getMessage(locale, "error.serviceName.bad", (Object)adminService);
            this.getServlet().log(message);
            response.sendError(400, message);
            return null;
        }
        ServiceForm serviceFm = new ServiceForm();
        session.setAttribute("serviceForm", (Object)serviceFm);
        serviceFm.setAdminAction("Edit");
        serviceFm.setObjectName(sname.toString());
        serviceFm.setEngineObjectName(ename.toString());
        sb = new StringBuffer();
        sb.append(resources.getMessage(locale, "server.service.treeBuilder.subtreeNode"));
        sb.append(" (");
        sb.append(sname.getKeyProperty("serviceName"));
        sb.append(")");
        serviceFm.setNodeLabel(sb.toString());
        serviceFm.setAdminServiceName(adminService);
        String attribute = null;
        try {
            attribute = "name";
            serviceFm.setServiceName((String)this.mBServer.getAttribute(sname, attribute));
            attribute = "name";
            serviceFm.setEngineName((String)this.mBServer.getAttribute(ename, attribute));
            attribute = "defaultHost";
            serviceFm.setDefaultHost((String)this.mBServer.getAttribute(ename, attribute));
            attribute = "hosts";
            ArrayList<LabelValueBean> hosts = new ArrayList<LabelValueBean>();
            hosts.add(new LabelValueBean(resources.getMessage(locale, "list.none"), ""));
            Iterator items = Lists.getHosts(this.mBServer, sname).iterator();
            while (items.hasNext()) {
                ObjectName hname = new ObjectName((String)items.next());
                String name = hname.getKeyProperty("host");
                if (name == null) continue;
                hosts.add(new LabelValueBean(name, name));
            }
            serviceFm.setHostNameVals(hosts);
        }
        catch (Throwable t) {
            this.getServlet().log(resources.getMessage(locale, "users.error.attribute.get", (Object)attribute), t);
            response.sendError(500, resources.getMessage(locale, "users.error.attribute.get", (Object)attribute));
            return null;
        }
        return mapping.findForward("Service");
    }
}

