/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.migrationkit.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.swing.TextComponentMatcherEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;

public class TextFilterList
extends TransformedList {
    private TextComponentMatcherEditor matcherEditor;
    private JTextField filterEdit = null;

    public TextFilterList(EventList source) {
        this(source, (TextFilterator)null, new JTextField(""));
    }

    public TextFilterList(EventList source, TextFilterator filterator) {
        this(source, filterator, new JTextField(""));
    }

    public TextFilterList(EventList source, String[] propertyNames) {
        this(source, GlazedLists.textFilterator(propertyNames), new JTextField(""));
    }

    public TextFilterList(EventList source, String[] propertyNames, JTextField filterEdit) {
        this(source, GlazedLists.textFilterator(propertyNames), filterEdit);
    }

    public TextFilterList(EventList source, TextFilterator filterator, JTextField filterEdit) {
        super(new FilterList(source));
        this.matcherEditor = new TextComponentMatcherEditor(filterEdit, filterator);
        ((FilterList)this.source).setMatcherEditor(this.matcherEditor);
        this.source.addListEventListener(this);
    }

    public JTextField getFilterEdit() {
        return this.filterEdit;
    }

    public void setFilterEdit(JTextField filterEdit) {
        if (filterEdit == this.filterEdit) {
            return;
        }
        boolean live = this.matcherEditor.isLive();
        TextFilterator textFilterator = this.matcherEditor.getFilterator();
        this.matcherEditor.dispose();
        this.matcherEditor = new TextComponentMatcherEditor(filterEdit, textFilterator, live);
        ((FilterList)this.source).setMatcherEditor(this.matcherEditor);
    }

    public void setLive(boolean live) {
        this.matcherEditor.setLive(live);
    }

    public ActionListener getFilterActionListener() {
        return new FilterActionListener();
    }

    public void listChanged(ListEvent listChanges) {
        this.updates.forwardEvent(listChanges);
    }

    protected boolean isWritable() {
        return true;
    }

    public void dispose() {
        FilterList filteredSource = (FilterList)this.source;
        super.dispose();
        filteredSource.dispose();
        this.matcherEditor.dispose();
    }

    private class FilterActionListener
    implements ActionListener {
        private FilterActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            TextFilterList.this.matcherEditor.setFilterText(TextFilterList.this.filterEdit.getText().split("[ \t]"));
        }
    }
}

