/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.keyring.kde;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.spi.keyring.KeyringProvider;
import org.openide.util.NbBundle;

public class KWalletProvider
implements KeyringProvider {
    private static final Logger logger = Logger.getLogger(KWalletProvider.class.getName());
    private char[] handler = "0".toCharArray();

    public boolean enabled() {
        if (Boolean.getBoolean("netbeans.keyring.no.native")) {
            logger.fine("native keyring integration disabled");
            return false;
        }
        if (new String(this.runCommand("isEnabled", new char[0][])).equals("true")) {
            return this.updateHandler();
        }
        return false;
    }

    public char[] read(String key) {
        if (this.updateHandler()) {
            char[] pwd = this.runCommand("readPassword", this.handler, this.getApplicationName(), key.toCharArray(), this.getApplicationName(true));
            return (char[])(pwd.length > 0 ? pwd : null);
        }
        throw new KwalletException("read");
    }

    public void save(String key, char[] password, String description) {
        if (this.updateHandler()) {
            if (new String(this.runCommand("writePassword", this.handler, this.getApplicationName(), key.toCharArray(), password, this.getApplicationName(true))).equals("-1")) {
                throw new KwalletException("save");
            }
            return;
        }
        throw new KwalletException("save");
    }

    public void delete(String key) {
        if (this.updateHandler()) {
            if (new String(this.runCommand("removeEntry", this.handler, this.getApplicationName(), key.toCharArray(), this.getApplicationName(true))).equals("-1")) {
                throw new KwalletException("delete");
            }
            return;
        }
        throw new KwalletException("delete");
    }

    private boolean updateHandler() {
        char[] cArray = this.handler = new String(this.handler).equals("") ? "0".toCharArray() : this.handler;
        if (new String(this.runCommand("isOpen", new char[][]{this.handler})).equals("true")) {
            return true;
        }
        char[] localWallet = this.runCommand("localWallet", new char[0][]);
        this.handler = this.runCommand("open", localWallet, "0".toCharArray(), this.getApplicationName(true));
        return !new String(this.handler).equals("-1");
    }

    private char[] runCommand(String command, char[] ... commandArgs) {
        Object[] argv = new String[commandArgs.length + 4];
        argv[0] = "qdbus";
        argv[1] = "org.kde.kwalletd";
        argv[2] = "/modules/kwalletd";
        argv[3] = "org.kde.KWallet." + command;
        for (int i = 0; i < commandArgs.length; ++i) {
            argv[i + 4] = new String(commandArgs[i]);
        }
        Runtime rt = Runtime.getRuntime();
        String retVal = "";
        try {
            String line;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "executing {0}", Arrays.toString(argv));
            }
            Process pr = rt.exec((String[])argv);
            BufferedReader input = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            while ((line = input.readLine()) != null) {
                if (!retVal.equals("")) {
                    retVal = retVal.concat("\n");
                }
                retVal = retVal.concat(line);
            }
            input.close();
            input = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
            while ((line = input.readLine()) != null) {
                if (!retVal.equals("")) {
                    retVal = retVal.concat("\n");
                }
                retVal = retVal.concat(line);
            }
            input.close();
            int exitVal = pr.waitFor();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "application exit with code {0} for commandString: {1}", new Object[]{exitVal, Arrays.toString(argv)});
            }
        }
        catch (InterruptedException ex) {
            logger.log(Level.FINE, "exception thrown while invoking the command \"" + Arrays.toString(argv) + "\"", ex);
        }
        catch (IOException ex) {
            logger.log(Level.FINE, "exception thrown while invoking the command \"" + Arrays.toString(argv) + "\"", ex);
        }
        return retVal.trim().toCharArray();
    }

    private char[] getApplicationName() {
        return this.getApplicationName(false);
    }

    private char[] getApplicationName(boolean version) {
        String appName;
        try {
            appName = MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.core.windows.view.ui.Bundle").getString("CTL_MainWindow_Title_No_Project"), version ? System.getProperty("netbeans.buildnumber") : "");
        }
        catch (MissingResourceException x) {
            appName = "NetBeans" + (version ? " " + System.getProperty("netbeans.buildnumber") : "");
        }
        return appName.toCharArray();
    }

    public class KwalletException
    extends RuntimeException {
        public KwalletException(String desc) {
            super("error while trying to access KWallet, during " + desc);
        }
    }
}

