/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.indent;

import java.util.Set;
import java.util.TreeSet;
import javax.swing.text.BadLocationException;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.parser.SyntaxParser;
import org.netbeans.editor.ext.html.parser.SyntaxParserContext;
import org.netbeans.modules.css.formatting.api.embedding.JoinedTokenSequence;
import org.netbeans.modules.css.formatting.api.support.IndenterContextData;
import org.netbeans.modules.css.formatting.api.support.MarkupAbstractIndenter;
import org.netbeans.modules.editor.indent.spi.Context;
import org.openide.util.Exceptions;

public class HtmlIndenter
extends MarkupAbstractIndenter<HTMLTokenId> {
    private DTD dtd;
    private static final String[] TAGS_WITH_UNFORMATTABLE_CONTENT = new String[]{"pre", "textarea"};

    public HtmlIndenter(Context context) {
        super(HTMLTokenId.language(), context);
        try {
            SyntaxParserContext parserContext = SyntaxParserContext.createContext((CharSequence)this.getDocument().getText(0, this.getDocument().getLength()));
            this.dtd = SyntaxParser.parse((SyntaxParserContext)parserContext).getDTD();
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        assert (this.dtd != null) : "cannot find any DTD - perhaps NbReaderProvider.setupReaders() was not called?";
    }

    private DTD getDTD() {
        return this.dtd;
    }

    protected boolean isWhiteSpaceToken(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.WS || token.id() == HTMLTokenId.TEXT && ((Object)token.text()).toString().trim().length() == 0;
    }

    protected boolean isOpenTagNameToken(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.TAG_OPEN || token.id() == HTMLTokenId.DECLARATION && ((Object)token.text()).toString().toUpperCase().startsWith("<!");
    }

    protected boolean isCloseTagNameToken(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.TAG_CLOSE;
    }

    protected boolean isStartTagSymbol(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.TAG_OPEN_SYMBOL && ((Object)token.text()).toString().equals("<");
    }

    protected boolean isStartTagClosingSymbol(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.TAG_OPEN_SYMBOL && ((Object)token.text()).toString().equals("</");
    }

    protected boolean isEndTagSymbol(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.TAG_CLOSE_SYMBOL && ((Object)token.text()).toString().equals(">");
    }

    protected boolean isEndTagClosingSymbol(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.TAG_CLOSE_SYMBOL && ((Object)token.text()).toString().equals("/>") || token.id() == HTMLTokenId.DECLARATION && ((Object)token.text()).toString().startsWith(">");
    }

    protected boolean isTagArgumentToken(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.ARGUMENT;
    }

    protected boolean isBlockCommentToken(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.BLOCK_COMMENT;
    }

    protected boolean isTagContentToken(Token<HTMLTokenId> token) {
        return token.id() == HTMLTokenId.TEXT;
    }

    protected boolean isClosingTagOptional(String tagName) {
        DTD.Element elem = this.getDTD().getElement(tagName);
        if (elem == null) {
            return false;
        }
        return elem.hasOptionalEnd();
    }

    protected boolean isOpeningTagOptional(String tagName) {
        DTD.Element elem = this.getDTD().getElement(tagName);
        if (elem == null) {
            return false;
        }
        return elem.hasOptionalStart();
    }

    protected Boolean isEmptyTag(String tagName) {
        DTD.Element elem = this.getDTD().getElement(tagName);
        if (elem == null) {
            return false;
        }
        return elem.isEmpty();
    }

    protected boolean isTagContentUnformattable(String tagName) {
        for (String t : TAGS_WITH_UNFORMATTABLE_CONTENT) {
            if (!t.equalsIgnoreCase(tagName)) continue;
            return true;
        }
        return false;
    }

    protected Set<String> getTagChildren(String tagName) {
        DTD.Element elem = this.getDTD().getElement(tagName);
        if (elem == null) {
            return null;
        }
        TreeSet<String> set = new TreeSet<String>();
        for (DTD.Element el : elem.getContentModel().getIncludes()) {
            if (el == null) continue;
            set.add(el.getName());
        }
        for (DTD.Element el : elem.getContentModel().getExcludes()) {
            if (el == null) continue;
            set.remove(el.getName());
        }
        for (DTD.Element el : elem.getContentModel().getContent().getPossibleElements()) {
            if (el == null) continue;
            set.add(el.getName());
        }
        if (tagName.equalsIgnoreCase("HTML")) {
            set.add("BODY");
        }
        return set;
    }

    protected boolean isPreservedLine(Token<HTMLTokenId> token, IndenterContextData<HTMLTokenId> context) {
        String comment;
        return this.isBlockCommentToken(token) && !(comment = ((Object)token.text()).toString().trim()).startsWith("<!--") && !comment.startsWith("-->");
    }

    protected int getPreservedLineInitialIndentation(JoinedTokenSequence<HTMLTokenId> ts) throws BadLocationException {
        int index = ts.index();
        boolean found = false;
        while (this.isBlockCommentToken((Token<HTMLTokenId>)ts.token())) {
            String comment = ((Object)ts.token().text()).toString().trim();
            if (comment.startsWith("<!--")) {
                found = true;
                break;
            }
            if (ts.movePrevious()) continue;
        }
        int indent = 0;
        if (found) {
            int lineStart = Utilities.getRowStart((BaseDocument)this.getDocument(), (int)ts.offset());
            int column = ts.offset();
            indent = column - lineStart;
        }
        ts.moveIndex(index);
        ts.moveNext();
        return indent;
    }

    private boolean isOpeningTag(JoinedTokenSequence<HTMLTokenId> ts) {
        int index = ts.index();
        boolean found = false;
        while (ts.moveNext()) {
            if (this.isEndTagSymbol((Token<HTMLTokenId>)ts.currentTokenSequence().token())) {
                found = true;
                break;
            }
            if (!this.isEndTagClosingSymbol((Token<HTMLTokenId>)ts.currentTokenSequence().token())) continue;
        }
        ts.moveIndex(index);
        ts.moveNext();
        return found;
    }

    protected boolean isForeignLanguageStartToken(Token<HTMLTokenId> token, JoinedTokenSequence<HTMLTokenId> ts) {
        return this.isOpenTagNameToken(token) && (((Object)token.text()).toString().equalsIgnoreCase("style") || ((Object)token.text()).toString().equalsIgnoreCase("script")) && this.isOpeningTag(ts);
    }

    protected boolean isForeignLanguageEndToken(Token<HTMLTokenId> token, JoinedTokenSequence<HTMLTokenId> ts) {
        return this.isCloseTagNameToken(token) && (((Object)token.text()).toString().equalsIgnoreCase("style") || ((Object)token.text()).toString().equalsIgnoreCase("script"));
    }
}

