/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic.actions;

import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.highlight.semantic.MarkOccurrencesHighlighter;
import org.netbeans.modules.cnd.model.tasks.CaretAwareCsmFileTaskFactory;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class SemanticUtils {
    private static int findOccurrencePosition(boolean directionForward, Document doc, int curPos) {
        OffsetsBag bag = MarkOccurrencesHighlighter.getHighlightsBag(doc);
        HighlightsSequence hs = bag.getHighlights(0, doc.getLength());
        if (hs.moveNext()) {
            if (directionForward) {
                int firstStart = hs.getStartOffset();
                int firstEnd = hs.getEndOffset();
                while (hs.getStartOffset() <= curPos && hs.moveNext()) {
                }
                if (hs.getStartOffset() > curPos) {
                    return hs.getStartOffset();
                }
                if (firstEnd < curPos || firstStart > curPos) {
                    return firstStart;
                }
            } else {
                int last;
                int current = hs.getStartOffset();
                boolean stuck = false;
                do {
                    last = current;
                    current = hs.getStartOffset();
                } while (hs.getEndOffset() < curPos && (stuck = hs.moveNext()));
                if (last == current) {
                    while (hs.moveNext()) {
                    }
                    if (hs.getEndOffset() < curPos || hs.getStartOffset() > curPos) {
                        return hs.getStartOffset();
                    }
                } else {
                    if (stuck) {
                        return last;
                    }
                    return current;
                }
            }
        }
        return -1;
    }

    static void navigateToOccurrence(boolean next) {
        String mime;
        Node[] activatedNodes = TopComponent.getRegistry().getActivatedNodes();
        DataObject dobj = (DataObject)activatedNodes[0].getLookup().lookup(DataObject.class);
        FileObject fo = dobj == null ? null : dobj.getPrimaryFile();
        String string = mime = fo == null ? "" : fo.getMIMEType();
        if (MIMENames.isHeaderOrCppOrC((String)mime)) {
            int position;
            EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            StyledDocument doc = ec.getDocument();
            int goTo = SemanticUtils.findOccurrencePosition(next, doc, position = CaretAwareCsmFileTaskFactory.getLastPosition((FileObject)dobj.getPrimaryFile()));
            if (goTo > 0) {
                JEditorPane pane = NbDocument.findRecentEditorPane((EditorCookie)ec);
                pane.setCaretPosition(goTo);
            } else {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(SemanticUtils.class, (String)"cpp-no-marked-occurrence"));
            }
        }
    }
}

