/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.rake;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.ruby.rubyproject.RakeParameters;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.rake.RakeSupport;
import org.netbeans.modules.ruby.rubyproject.rake.RakeTask;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class RakeTaskChooser
extends JPanel {
    private static final Object NO_TASK_ITEM = RakeTaskChooser.getMessage("RakeTaskChooser.no.matching.task", new String[0]);
    private static boolean debug;
    private static String lastTask;
    private static Map<String, Map<RakeTask, ParameterContainer>> prjToTask;
    private final RubyBaseProject project;
    private final List<RakeTask> allTasks;
    private JButton runButton;
    private JCheckBox debugCheckbox;
    private JLabel matchingTaskLabel;
    private JList matchingTaskList;
    private JScrollPane matchingTaskSP;
    private JTextField rakeTaskField;
    private JPanel rakeTaskFieldPanel;
    private JLabel rakeTaskHint;
    private JLabel rakeTaskLabel;
    private JCheckBox showAllCheckbox;
    private JLabel taskParamLabel;
    private JComboBox taskParametersComboBox;

    static TaskDescriptor select(RubyBaseProject project) {
        assert (EventQueue.isDispatchThread()) : "must be called from EDT";
        final JButton runButton = new JButton(RakeTaskChooser.getMessage("RakeTaskChooser.runButton", new String[0]));
        final RakeTaskChooser chooserPanel = new RakeTaskChooser(project, runButton);
        String title = RakeTaskChooser.getMessage("RakeTaskChooser.title", ProjectUtils.getInformation((Project)project).getDisplayName());
        runButton.getAccessibleContext().setAccessibleDescription(RakeTaskChooser.getMessage("RakeTaskChooser.runButton.accessibleDescription", new String[0]));
        RakeTaskChooser.setRunButtonState(runButton, chooserPanel);
        chooserPanel.matchingTaskList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RakeTaskChooser.setRunButtonState(runButton, chooserPanel);
                chooserPanel.initTaskParameters();
            }
        });
        final JButton refreshButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)refreshButton, (String)RakeTaskChooser.getMessage("RakeTaskChooser.refreshButton", new String[0]));
        refreshButton.getAccessibleContext().setAccessibleDescription(RakeTaskChooser.getMessage("RakeTaskChooser.refreshButton.accessibleDescription", new String[0]));
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                refreshButton.setEnabled(false);
                runButton.setEnabled(false);
                chooserPanel.reloadTasks(new Runnable(){

                    @Override
                    public void run() {
                        assert (EventQueue.isDispatchThread()) : "is EDT";
                        refreshButton.setEnabled(true);
                        RakeTaskChooser.setRunButtonState(runButton, chooserPanel);
                    }
                });
            }
        });
        Object[] options = new Object[]{refreshButton, runButton, DialogDescriptor.CANCEL_OPTION};
        DialogDescriptor descriptor = new DialogDescriptor((Object)chooserPanel, title, true, options, (Object)runButton, 0, null, null);
        descriptor.setClosingOptions(new Object[]{runButton, DialogDescriptor.CANCEL_OPTION});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.getAccessibleContext().setAccessibleName(RakeTaskChooser.getMessage("RakeTaskChooser.accessibleName", new String[0]));
        dialog.getAccessibleContext().setAccessibleDescription(RakeTaskChooser.getMessage("RakeTaskChooser.accessibleDescription", new String[0]));
        dialog.setVisible(true);
        if (descriptor.getValue() == runButton) {
            RakeTask task = chooserPanel.getSelectedTask();
            debug = chooserPanel.debugCheckbox.isSelected();
            lastTask = task.getTask();
            chooserPanel.storeParameters();
            return new TaskDescriptor(task, chooserPanel.getParameters(), debug);
        }
        return null;
    }

    private void initTaskParameters() {
        RakeTask task = this.getSelectedTask();
        ArrayList<Object> params = new ArrayList<Object>();
        params.add("");
        params.addAll(this.getStoredParams(task));
        params.addAll(RakeParameters.getParameters(task, this.project));
        this.taskParametersComboBox.setModel(new DefaultComboBoxModel<Object>(params.toArray()));
        this.preselectLastSelectedParam(task);
    }

    private void preselectLastSelectedParam(RakeTask task) {
        ParameterContainer params = this.getTasksToParams().get(task);
        if (params == null) {
            return;
        }
        String lastSelected = params.getLastSelected();
        if (lastSelected == null) {
            this.taskParametersComboBox.setSelectedItem("");
            return;
        }
        for (int i = 0; i < this.taskParametersComboBox.getItemCount(); ++i) {
            Object item = this.taskParametersComboBox.getItemAt(i);
            if (item instanceof RakeParameters.RakeParameter) {
                if (!((RakeParameters.RakeParameter)item).toRakeParam().equals(lastSelected)) continue;
                this.taskParametersComboBox.setSelectedIndex(i);
                break;
            }
            if (!item.equals(lastSelected)) continue;
            this.taskParametersComboBox.setSelectedIndex(i);
        }
    }

    private Map<RakeTask, ParameterContainer> getTasksToParams() {
        String prjDir = this.project.getProjectDirectory().getPath();
        Map<RakeTask, ParameterContainer> result = prjToTask.get(prjDir);
        if (result == null) {
            result = new HashMap<RakeTask, ParameterContainer>();
            prjToTask.put(prjDir, result);
        }
        return result;
    }

    private List<String> getStoredParams(RakeTask task) {
        if (task == null) {
            return Collections.emptyList();
        }
        Map<RakeTask, ParameterContainer> tasksToParams = this.getTasksToParams();
        if (tasksToParams == null) {
            return Collections.emptyList();
        }
        ParameterContainer stored = tasksToParams.get(task);
        if (stored == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(stored.getParams());
        Collections.sort(result);
        return result;
    }

    private String getParameters() {
        Object selected = this.taskParametersComboBox.getSelectedItem();
        String result = "";
        result = selected instanceof RakeParameters.RakeParameter ? ((RakeParameters.RakeParameter)selected).toRakeParam() : selected.toString();
        return result.trim();
    }

    private static void setRunButtonState(JButton runButton, RakeTaskChooser chooserPanel) {
        runButton.setEnabled(chooserPanel.getSelectedTask() != null);
    }

    private RakeTaskChooser(RubyBaseProject project, JButton runButton) {
        this.runButton = runButton;
        this.allTasks = new ArrayList<RakeTask>();
        this.project = project;
        this.initComponents();
        this.matchingTaskList.setCellRenderer(new RakeTaskRenderer());
        this.debugCheckbox.setSelected(debug);
        this.reloadAllTasks();
        this.refreshTaskList();
        this.rakeTaskField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                RakeTaskChooser.this.refreshTaskList();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                RakeTaskChooser.this.refreshTaskList();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RakeTaskChooser.this.refreshTaskList();
            }
        });
        this.preselectLastlySelected();
        this.initTaskParameters();
    }

    private void storeParameters() {
        ParameterContainer params;
        String prjDir = this.project.getProjectDirectory().getPath();
        Map<RakeTask, ParameterContainer> taskToParams = prjToTask.get(prjDir);
        if (taskToParams == null) {
            taskToParams = new HashMap<RakeTask, ParameterContainer>();
            prjToTask.put(prjDir, taskToParams);
        }
        if ((params = taskToParams.get(this.getSelectedTask())) == null) {
            params = new ParameterContainer();
            taskToParams.put(this.getSelectedTask(), params);
        }
        String currentParam = this.getParameters();
        params.addParam(currentParam);
        params.setLastSelected(currentParam);
    }

    private void preselectLastlySelected() {
        if (lastTask == null) {
            return;
        }
        for (RakeTask task : this.allTasks) {
            if (!lastTask.equals(task.getTask())) continue;
            this.matchingTaskList.setSelectedValue(task, true);
            break;
        }
        this.initTaskParameters();
    }

    private void reloadAllTasks() {
        this.allTasks.clear();
        this.allTasks.addAll(RakeSupport.getRakeTasks(this.project, false));
    }

    private void refreshTaskList() {
        String filter = this.rakeTaskField.getText().trim();
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        List<RakeTask> matching = Filter.getFilteredTasks(this.allTasks, filter, this.showAllCheckbox.isSelected());
        for (RakeTask task : matching) {
            model.addElement(task);
        }
        this.matchingTaskList.setModel(model);
        if (model.isEmpty()) {
            model.addElement(NO_TASK_ITEM);
        }
        this.matchingTaskList.setSelectedIndex(0);
        this.initTaskParameters();
    }

    private void reloadTasks(final Runnable uiFinishAction) {
        final Object task = this.matchingTaskList.getSelectedValue();
        final JComponent[] comps = new JComponent[]{this.matchingTaskSP, this.matchingTaskLabel, this.matchingTaskLabel, this.matchingTaskList, this.rakeTaskLabel, this.rakeTaskField, this.debugCheckbox, this.taskParamLabel, this.taskParametersComboBox, this.showAllCheckbox, this.rakeTaskHint};
        this.setEnabled(comps, false);
        this.matchingTaskList.setListData(new Object[]{RakeTaskChooser.getMessage("RakeTaskChooser.reloading.tasks", new String[0])});
        new Thread(new Runnable(){

            @Override
            public void run() {
                RakeSupport.refreshTasks(RakeTaskChooser.this.project);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RakeTaskChooser.this.reloadAllTasks();
                        RakeTaskChooser.this.refreshTaskList();
                        RakeTaskChooser.this.matchingTaskList.setSelectedValue(task, true);
                        uiFinishAction.run();
                        RakeTaskChooser.this.setEnabled(comps, true);
                        RakeTaskChooser.this.rakeTaskField.requestFocus();
                    }
                });
            }
        }, "Rake Tasks Refresher").start();
    }

    private void setEnabled(JComponent[] comps, boolean enabled) {
        for (JComponent comp : comps) {
            comp.setEnabled(enabled);
        }
    }

    private RakeTask getSelectedTask() {
        Object val = this.matchingTaskList.getSelectedValue();
        if (val != null && !NO_TASK_ITEM.equals(val)) {
            return (RakeTask)val;
        }
        return null;
    }

    private static String getMessage(String key, String ... args) {
        return NbBundle.getMessage(RakeTaskChooser.class, (String)key, (Object[])args);
    }

    private void initComponents() {
        this.rakeTaskLabel = new JLabel();
        this.taskParamLabel = new JLabel();
        this.matchingTaskLabel = new JLabel();
        this.matchingTaskSP = new JScrollPane();
        this.matchingTaskList = new JList();
        this.debugCheckbox = new JCheckBox();
        this.showAllCheckbox = new JCheckBox();
        this.rakeTaskFieldPanel = new JPanel();
        this.rakeTaskField = new JTextField();
        this.rakeTaskHint = new JLabel();
        this.taskParametersComboBox = new JComboBox();
        this.rakeTaskLabel.setLabelFor(this.rakeTaskField);
        Mnemonics.setLocalizedText((JLabel)this.rakeTaskLabel, (String)NbBundle.getMessage(RakeTaskChooser.class, (String)"RakeTaskChooser.rakeTaskLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.taskParamLabel, (String)NbBundle.getMessage(RakeTaskChooser.class, (String)"RakeTaskChooser.taskParamLabel.text"));
        this.matchingTaskLabel.setLabelFor(this.matchingTaskList);
        Mnemonics.setLocalizedText((JLabel)this.matchingTaskLabel, (String)NbBundle.getMessage(RakeTaskChooser.class, (String)"RakeTaskChooser.matchingTaskLabel.text"));
        this.matchingTaskList.setFont(new Font("Monospaced", 0, 12));
        this.matchingTaskList.setSelectionMode(0);
        this.matchingTaskList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RakeTaskChooser.this.matchingTaskListMouseClicked(evt);
            }
        });
        this.matchingTaskSP.setViewportView(this.matchingTaskList);
        Mnemonics.setLocalizedText((AbstractButton)this.debugCheckbox, (String)NbBundle.getMessage(RakeTaskChooser.class, (String)"RakeTaskChooser.debugCheckbox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.showAllCheckbox, (String)NbBundle.getMessage(RakeTaskChooser.class, (String)"RakeTaskChooser.showAllCheckbox.text"));
        this.showAllCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RakeTaskChooser.this.showAllCheckboxActionPerformed(evt);
            }
        });
        this.rakeTaskFieldPanel.setLayout(new BorderLayout());
        this.rakeTaskField.setText(NbBundle.getMessage(RakeTaskChooser.class, (String)"RakeTaskChooser.rakeTaskField.text"));
        this.rakeTaskField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                RakeTaskChooser.this.rakeTaskFieldKeyPressed(evt);
            }
        });
        this.rakeTaskFieldPanel.add((Component)this.rakeTaskField, "North");
        Mnemonics.setLocalizedText((JLabel)this.rakeTaskHint, (String)NbBundle.getMessage(RakeTaskChooser.class, (String)"RakeTaskChooser.rakeTaskHint.text"));
        this.rakeTaskFieldPanel.add((Component)this.rakeTaskHint, "South");
        this.taskParametersComboBox.setEditable(true);
        this.taskParametersComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.rakeTaskLabel).add((Component)this.taskParamLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.taskParametersComboBox, 0, 568, Short.MAX_VALUE).add((Component)this.rakeTaskFieldPanel, -1, 568, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.matchingTaskLabel)).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.debugCheckbox).addPreferredGap(0).add((Component)this.showAllCheckbox)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.matchingTaskSP, -1, 659, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.rakeTaskLabel).add((Component)this.rakeTaskFieldPanel, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.taskParamLabel).add((Component)this.taskParametersComboBox, -2, 21, -2)).addPreferredGap(1).add((Component)this.matchingTaskLabel).addPreferredGap(0).add((Component)this.matchingTaskSP, -1, 352, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.debugCheckbox).add((Component)this.showAllCheckbox)).addContainerGap()));
    }

    private void handleNavigationKeys(KeyEvent evt) {
        Object actionKey = this.matchingTaskList.getInputMap().get(KeyStroke.getKeyStrokeForEvent(evt));
        boolean isListScrollAction = "selectPreviousRow".equals(actionKey) || "selectPreviousRowExtendSelection".equals(actionKey) || "selectNextRow".equals(actionKey) || "selectNextRowExtendSelection".equals(actionKey) || "scrollUp".equals(actionKey) || "scrollUpExtendSelection".equals(actionKey) || "scrollDown".equals(actionKey) || "scrollDownExtendSelection".equals(actionKey);
        int selectedIndex = this.matchingTaskList.getSelectedIndex();
        ListModel model = this.matchingTaskList.getModel();
        int modelSize = model.getSize();
        if ("selectNextRow".equals(actionKey) && selectedIndex == modelSize - 1) {
            this.matchingTaskList.setSelectedIndex(0);
            this.matchingTaskList.ensureIndexIsVisible(0);
            return;
        }
        if ("selectPreviousRow".equals(actionKey) && selectedIndex == 0) {
            int last = modelSize - 1;
            this.matchingTaskList.setSelectedIndex(last);
            this.matchingTaskList.ensureIndexIsVisible(last);
            return;
        }
        if (isListScrollAction) {
            Action action = this.matchingTaskList.getActionMap().get(actionKey);
            action.actionPerformed(new ActionEvent(this.matchingTaskList, 0, (String)actionKey));
            evt.consume();
        }
    }

    private void rakeTaskFieldKeyPressed(KeyEvent evt) {
        this.handleNavigationKeys(evt);
    }

    private void showAllCheckboxActionPerformed(ActionEvent evt) {
        this.refreshTaskList();
    }

    private void matchingTaskListMouseClicked(MouseEvent evt) {
        if (this.runButton.isEnabled() && evt.getClickCount() == 2) {
            this.runButton.doClick();
        }
    }

    static {
        prjToTask = new HashMap<String, Map<RakeTask, ParameterContainer>>();
    }

    private static class ParameterContainer {
        private final Set<String> params = new HashSet<String>();
        private String lastSelected;

        private ParameterContainer() {
        }

        public void addParam(String param) {
            this.params.add(param);
        }

        public String getLastSelected() {
            return this.lastSelected;
        }

        public void setLastSelected(String lastSelected) {
            this.lastSelected = lastSelected;
        }

        public Set<String> getParams() {
            return this.params;
        }
    }

    static final class Filter {
        private final String filter;
        private final List<RakeTask> tasks;
        private final boolean showAll;

        private Filter(List<RakeTask> tasks, String filter, boolean showAll) {
            this.tasks = tasks;
            this.filter = filter;
            this.showAll = showAll;
        }

        static List<RakeTask> getFilteredTasks(List<RakeTask> allTasks, String filter, boolean showAll) {
            Filter f = new Filter(allTasks, filter, showAll);
            return f.filter();
        }

        private List<RakeTask> filter() {
            ArrayList<RakeTask> matching = new ArrayList<RakeTask>();
            Pattern pattern = this.getPattern();
            if (pattern != null) {
                for (RakeTask task : this.tasks) {
                    Matcher m;
                    if (!this.showAll && task.getDescription() == null || !(m = pattern.matcher(task.getTask())).matches()) continue;
                    matching.add(task);
                }
            } else {
                ArrayList<RakeTask> exact = new ArrayList<RakeTask>();
                for (RakeTask task : this.tasks) {
                    String filterLC;
                    if (!this.showAll && task.getDescription() == null) continue;
                    String taskLC = task.getTask().toLowerCase(Locale.US);
                    if (taskLC.startsWith(filterLC = this.filter.toLowerCase(Locale.US))) {
                        exact.add(task);
                        continue;
                    }
                    if (!taskLC.contains(filterLC)) continue;
                    matching.add(task);
                }
                matching.addAll(0, exact);
            }
            return matching;
        }

        private Pattern getPattern() {
            if (this.filter.contains("?") || this.filter.contains("*")) {
                String reFilter = Filter.removeRegexpEscapes(this.filter);
                reFilter = reFilter.replace(".", "\\.");
                reFilter = reFilter.replace("?", ".");
                reFilter = reFilter.replace("*", ".*");
                return Pattern.compile(".*" + reFilter + ".*", 2);
            }
            return null;
        }

        private static String removeRegexpEscapes(String text) {
            StringBuilder sb = new StringBuilder();
            block3: for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                switch (c) {
                    case '\\': {
                        continue block3;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            return sb.toString();
        }
    }

    private static class RakeTaskRenderer
    extends JLabel
    implements ListCellRenderer {
        public RakeTaskRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                Color bgColor = list.getBackground();
                Color bgColorDarker = new Color(Math.abs(bgColor.getRed() - 10), Math.abs(bgColor.getGreen() - 10), Math.abs(bgColor.getBlue() - 10));
                this.setBackground(index % 2 == 0 ? bgColor : bgColorDarker);
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            if (value instanceof RakeTask) {
                RakeTask task = (RakeTask)value;
                String descripton = task.getDescription();
                if (descripton == null) {
                    this.setForeground(Color.GRAY);
                }
                StringBuilder text = new StringBuilder("<html>");
                text.append("<b>").append(task.getTask()).append("</b>");
                if (descripton != null) {
                    text.append(" : ").append(descripton);
                }
                text.append("</html>");
                this.setText(text.toString());
            } else {
                this.setText(value.toString());
            }
            return this;
        }
    }

    static class TaskDescriptor {
        private final RakeTask task;
        private final String params;
        private final boolean debug;

        TaskDescriptor(RakeTask task, String params, boolean debug) {
            this.task = task;
            this.params = params.length() == 0 ? null : params;
            this.debug = debug;
        }

        RakeTask getRakeTask() {
            return this.task;
        }

        String getTaskParams() {
            return this.params;
        }

        boolean isDebug() {
            return this.debug;
        }
    }
}

