/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.bundler;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.rubyproject.bundler.BundlerSupport;
import org.openide.awt.Actions;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public final class BundlerAction
extends AbstractAction
implements ContextAwareAction {
    private final BundlerSupport support;

    public BundlerAction(BundlerSupport support) {
        this.support = support;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        assert (false) : "No context";
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ContextAction(actionContext);
    }

    private static final class LazyMenu
    extends JMenu {
        private final BundlerSupport support;
        private boolean initialized;

        public LazyMenu(BundlerSupport support) {
            super(NbBundle.getMessage(BundlerAction.class, (String)"Bundler"));
            this.support = support;
        }

        @Override
        public JPopupMenu getPopupMenu() {
            if (!this.initialized) {
                this.initialized = true;
                super.removeAll();
                for (BundlerSupport.Task task : this.support.getTasks()) {
                    final JMenuItem item = new JMenuItem(task.name);
                    item.setToolTipText(task.descriptor);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LazyMenu.this.support.runBundlerTask(item.getText(), null, true, null);
                        }
                    });
                    this.add(item);
                }
                if (this.support.canUpdateIndices()) {
                    this.addSeparator();
                    JMenuItem updateIndices = new JMenuItem(NbBundle.getMessage(BundlerAction.class, (String)"UpdateIndices"));
                    updateIndices.setToolTipText(NbBundle.getMessage(BundlerAction.class, (String)"UpdateIndicesDesc"));
                    updateIndices.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            LazyMenu.this.support.updateIndices();
                        }
                    });
                    this.add(updateIndices);
                }
            }
            return super.getPopupMenu();
        }
    }

    private final class ContextAction
    extends AbstractAction
    implements Presenter.Popup {
        private final Project project;

        public ContextAction(Lookup lkp) {
            super(NbBundle.getMessage(BundlerAction.class, (String)"Bundler"));
            Collection apcs = lkp.lookupAll(Project.class);
            this.project = apcs.size() == 1 ? (Project)apcs.iterator().next() : null;
            super.setEnabled(this.project != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (false) : "Action should not be called directly";
        }

        public JMenuItem getPopupPresenter() {
            if (this.project != null) {
                return this.createMenu();
            }
            return new Actions.MenuItem((Action)this, false);
        }

        @Override
        public void setEnabled(boolean b) {
            assert (false) : "No modifications to enablement status permitted";
        }

        private JMenuItem createMenu() {
            LazyMenu menu = new LazyMenu(BundlerAction.this.support);
            return menu;
        }
    }
}

