/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.awt.Component;
import java.awt.Image;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import org.netbeans.modules.ruby.rubyproject.ProjectPropertyExtender;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class JavaClassPathUi {
    private JavaClassPathUi() {
    }

    public static class ClassPathListCellRenderer
    extends DefaultListCellRenderer {
        private static final Pattern FOREIGN_PLAIN_FILE_REFERENCE = Pattern.compile("\\$\\{file\\.reference\\.([^${}]+)\\}");
        private static final Pattern UNKNOWN_FILE_REFERENCE = Pattern.compile("\\$\\{([^${}]+)\\}");
        private static String RESOURCE_ICON_JAR = "org/netbeans/modules/ruby/rubyproject/ui/resources/jar.gif";
        private static String RESOURCE_ICON_LIBRARY = "org/netbeans/modules/ruby/rubyproject/ui/resources/libraries.gif";
        private static String RESOURCE_ICON_ARTIFACT = "org/netbeans/modules/ruby/rubyproject/ui/resources/projectDependencies.gif";
        private static String RESOURCE_ICON_CLASSPATH = "org/netbeans/modules/ruby/rubyproject/ui/resources/referencedClasspath.gif";
        private static String RESOURCE_ICON_BROKEN_BADGE = "org/netbeans/modules/ruby/rubyproject/ui/resources/brokenProjectBadge.gif";
        private static ImageIcon ICON_JAR = ImageUtilities.loadImageIcon((String)RESOURCE_ICON_JAR, (boolean)false);
        private static ImageIcon ICON_FOLDER = null;
        private static ImageIcon ICON_LIBRARY = ImageUtilities.loadImageIcon((String)RESOURCE_ICON_LIBRARY, (boolean)false);
        private static ImageIcon ICON_ARTIFACT = ImageUtilities.loadImageIcon((String)RESOURCE_ICON_ARTIFACT, (boolean)false);
        private static ImageIcon ICON_CLASSPATH = ImageUtilities.loadImageIcon((String)RESOURCE_ICON_CLASSPATH, (boolean)false);
        private static ImageIcon ICON_BROKEN_BADGE = ImageUtilities.loadImageIcon((String)RESOURCE_ICON_BROKEN_BADGE, (boolean)false);
        private static ImageIcon ICON_BROKEN_JAR;
        private static ImageIcon ICON_BROKEN_LIBRARY;
        private static ImageIcon ICON_BROKEN_ARTIFACT;
        private PropertyEvaluator evaluator;
        private static final Map WELL_KNOWN_PATHS_NAMES;

        public ClassPathListCellRenderer(PropertyEvaluator evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ProjectPropertyExtender.Item item = (ProjectPropertyExtender.Item)value;
            super.getListCellRendererComponent((JList<?>)list, this.getDisplayName(item), index, isSelected, cellHasFocus);
            this.setIcon(ClassPathListCellRenderer.getIcon(item));
            this.setToolTipText(this.getToolTipText(item));
            return this;
        }

        private String getDisplayName(ProjectPropertyExtender.Item item) {
            switch (item.getType()) {
                case 0: {
                    if (item.isBroken()) {
                        return NbBundle.getMessage(JavaClassPathUi.class, (String)"LBL_MISSING_FILE", (Object)this.getFileRefName(item));
                    }
                    return item.getFile().getPath();
                }
            }
            return item.getReference();
        }

        static Icon getIcon(ProjectPropertyExtender.Item item) {
            switch (item.getType()) {
                case 1: {
                    if (item.isBroken()) {
                        if (ICON_BROKEN_LIBRARY == null) {
                            ICON_BROKEN_LIBRARY = new ImageIcon(ImageUtilities.mergeImages((Image)ICON_LIBRARY.getImage(), (Image)ICON_BROKEN_BADGE.getImage(), (int)7, (int)7));
                        }
                        return ICON_BROKEN_LIBRARY;
                    }
                    return ICON_LIBRARY;
                }
                case 0: {
                    if (item.isBroken()) {
                        if (ICON_BROKEN_JAR == null) {
                            ICON_BROKEN_JAR = new ImageIcon(ImageUtilities.mergeImages((Image)ICON_JAR.getImage(), (Image)ICON_BROKEN_BADGE.getImage(), (int)7, (int)7));
                        }
                        return ICON_BROKEN_JAR;
                    }
                    File file = item.getFile();
                    return file.isDirectory() ? ClassPathListCellRenderer.getFolderIcon() : ICON_JAR;
                }
                case 3: {
                    return ICON_CLASSPATH;
                }
            }
            return null;
        }

        private String getToolTipText(ProjectPropertyExtender.Item item) {
            if (item.isBroken() && (item.getType() == 0 || item.getType() == 2)) {
                return this.evaluator.evaluate(item.getReference());
            }
            return this.getDisplayName(item);
        }

        private static ImageIcon getFolderIcon() {
            if (ICON_FOLDER == null) {
                DataFolder dataFolder = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot());
                ICON_FOLDER = new ImageIcon(dataFolder.getNodeDelegate().getIcon(1));
            }
            return ICON_FOLDER;
        }

        private String getProjectName(ProjectPropertyExtender.Item item) {
            String ID = item.getReference();
            return ID.substring(12, ID.indexOf(".", 12));
        }

        private String getLibraryName(ProjectPropertyExtender.Item item) {
            String ID = item.getReference();
            return ID.substring(7, ID.indexOf(".classpath"));
        }

        private String getFileRefName(ProjectPropertyExtender.Item item) {
            String ID = item.getReference();
            Matcher m = FOREIGN_PLAIN_FILE_REFERENCE.matcher(ID);
            if (m.matches()) {
                return m.group(1);
            }
            m = UNKNOWN_FILE_REFERENCE.matcher(ID);
            if (m.matches()) {
                return m.group(1);
            }
            return ID;
        }

        static {
            WELL_KNOWN_PATHS_NAMES = new HashMap();
        }
    }
}

