/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import java.awt.Color;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.openide.util.NbBundle;

public class TimeLineUtils {
    private static final ResourceBundle messages = NbBundle.getBundle(TimeLineUtils.class);
    private static final String MINUTES_ABBR = messages.getString("TimeLineUtils_MinutesAbbr");
    private static final String HOURS_ABBR = messages.getString("TimeLineUtils_HoursAbbr");
    private static final String HOURS_LEGEND_ABBR = messages.getString("TimeLineUtils_HoursLegendAbbr");
    private static final String MINUTES_LEGEND_ABBR = messages.getString("TimeLineUtils_MinutesLegendAbbr");
    private static final String SECONDS_LEGEND_ABBR = messages.getString("TimeLineUtils_SecondsLegendAbbr");
    private static final String MILLISECONDS_LEGEND_ABBR = messages.getString("TimeLineUtils_MillisecondsLegendAbbr");
    public static final int MIN_TIMEMARK_STEP = 150;
    public static final Color BASE_TIMELINE_COLOR = new Color(0, 0, 0);
    public static final Color MAIN_TIMELINE_COLOR = new Color(150, 150, 150);
    public static final Color TICK_TIMELINE_COLOR = new Color(230, 230, 230);
    public static final Color TIMELINE_CURSOR_COLOR = new Color(0, 95, 173);
    private static final int TIME_FORMAT_UNKNOWN = -1;
    private static final int TIME_FORMAT_MILLIS = 10;
    private static final int TIME_FORMAT_SECONDS = 20;
    private static final int TIME_FORMAT_MINUTES = 30;
    private static final int TIME_FORMAT_HOURS = 40;
    private static final int[] timeUnitsGrid = new int[]{10, 50, 100, 250, 500, 1000, 5000, 10000, 30000, 60000, 180000, 300000, 600000, 3600000, 18000000, 36000000};
    private static final int[] ticksCountGrid = new int[]{10, 5, 10, 5, 5, 10, 5, 10, 6, 6, 6, 5, 10, 6, 5, 10};
    private static final int[] timeUnitsFormat = new int[]{10, 10, 10, 10, 10, 20, 20, 20, 20, 30, 30, 30, 30, 40, 40, 40};
    private static final HashMap<Integer, Integer> timeUnitsToIndex = new HashMap();

    private TimeLineUtils() {
    }

    public static String getHoursValue(long mark) {
        long hours = mark / 3600000L;
        return "" + hours + " " + HOURS_ABBR;
    }

    public static String getMillisValue(long mark) {
        long hours = mark / 3600000L;
        String sHours = hours == 0L ? "" : "" + hours + ":";
        long minutes = (mark %= 3600000L) / 60000L;
        String sMinutes = (hours > 0L && minutes < 10L ? "0" + minutes : "" + minutes) + ":";
        long seconds = (mark %= 60000L) / 1000L;
        String sSeconds = (seconds < 10L ? "0" + seconds : "" + seconds) + ".";
        long millis = mark %= 1000L;
        String sMillis = "" + millis;
        if (millis < 10L) {
            sMillis = "0" + sMillis;
        }
        if (millis < 100L) {
            sMillis = "0" + sMillis;
        }
        return sHours + sMinutes + sSeconds + sMillis;
    }

    public static String getMillisValue2(long mark) {
        long hours = mark / 3600000L;
        String sHours = hours == 0L ? "" : "" + hours + ":";
        long minutes = (mark %= 3600000L) / 60000L;
        String sMinutes = hours == 0L && minutes == 0L ? "" : (hours > 0L && minutes < 10L ? "0" + minutes : "" + minutes) + ":";
        long seconds = (mark %= 60000L) / 1000L;
        String sSeconds = (seconds < 10L && sMinutes.length() > 0 ? "0" + seconds : "" + seconds) + ".";
        long millis = mark %= 1000L;
        String sMillis = "" + millis;
        if (millis < 10L) {
            sMillis = "0" + sMillis;
        }
        if (millis < 100L) {
            sMillis = "0" + sMillis;
        }
        return sHours + sMinutes + sSeconds + sMillis;
    }

    public static String getMinutesValue(long mark) {
        long hours = mark / 3600000L;
        String sHours = hours == 0L ? "" : "" + hours + ":";
        long minutes = (mark %= 3600000L) / 60000L;
        String sMinutes = hours > 0L && minutes < 10L ? "0" + minutes : "" + minutes + " " + MINUTES_ABBR;
        return sHours + sMinutes;
    }

    public static int getOptimalUnits(float factor) {
        for (int i = 0; i < timeUnitsGrid.length - 1; ++i) {
            if (!((float)timeUnitsGrid[i] * factor >= 150.0f)) continue;
            return timeUnitsGrid[i];
        }
        return timeUnitsGrid[timeUnitsGrid.length - 1];
    }

    public static String getSecondsValue(long mark) {
        long hours = mark / 3600000L;
        String sHours = hours == 0L ? "" : "" + hours + ":";
        long minutes = (mark %= 3600000L) / 60000L;
        String sMinutes = (hours > 0L && minutes < 10L ? "0" + minutes : "" + minutes) + ":";
        long seconds = (mark %= 60000L) / 1000L;
        String sSeconds = seconds < 10L ? "0" + seconds : "" + seconds;
        return sHours + sMinutes + sSeconds;
    }

    public static int getTicksCount(int optimalUnits) {
        int ticksGridIndex = TimeLineUtils.getUnitsIndex(optimalUnits);
        if (ticksGridIndex == -1) {
            return 0;
        }
        return ticksCountGrid[ticksGridIndex];
    }

    public static String getTimeMarkMillisString(int mark, int optimalUnits) {
        int format = TimeLineUtils.getTimeUnitsFormat(optimalUnits);
        if (format != 10) {
            return "";
        }
        mark %= 3600000;
        mark %= 60000;
        int millis = mark %= 1000;
        String sMillis = "" + millis;
        if (millis < 10) {
            sMillis = "0" + sMillis;
        }
        if (millis < 100) {
            sMillis = "0" + sMillis;
        }
        return sMillis;
    }

    public static String getTimeMarkNoMillisString(int mark, int optimalUnits) {
        int format = TimeLineUtils.getTimeUnitsFormat(optimalUnits);
        if (format == -1) {
            return "";
        }
        if (format == 10) {
            format = 20;
        }
        return TimeLineUtils.getTimeMarkStringFromFormat(mark, format);
    }

    public static String getTimeMarkString(int mark, int optimalUnits) {
        int format = TimeLineUtils.getTimeUnitsFormat(optimalUnits);
        if (format == -1) {
            return "";
        }
        return TimeLineUtils.getTimeMarkStringFromFormat(mark, format);
    }

    public static String getUnitsLegend(int lastMark, int optimalUnits) {
        int hours;
        String timeMarkNoMillis = TimeLineUtils.getTimeMarkNoMillisString(lastMark, optimalUnits);
        if (timeMarkNoMillis.endsWith(MINUTES_ABBR)) {
            return "[" + MINUTES_LEGEND_ABBR + "]";
        }
        if (timeMarkNoMillis.endsWith(HOURS_ABBR)) {
            return "[" + HOURS_LEGEND_ABBR + "]";
        }
        String sMillis = "";
        if (!TimeLineUtils.getTimeMarkMillisString(lastMark, optimalUnits).equals("")) {
            sMillis = "." + MILLISECONDS_LEGEND_ABBR;
        }
        if ((hours = lastMark / 3600000) != 0) {
            return "[" + HOURS_LEGEND_ABBR + ":" + MINUTES_LEGEND_ABBR + ":" + SECONDS_LEGEND_ABBR + sMillis + "]";
        }
        return "[" + MINUTES_LEGEND_ABBR + ":" + SECONDS_LEGEND_ABBR + sMillis + "]";
    }

    private static String getTimeMarkStringFromFormat(int mark, int format) {
        switch (format) {
            case 10: {
                return TimeLineUtils.getMillisValue(mark);
            }
            case 20: {
                return TimeLineUtils.getSecondsValue(mark);
            }
            case 30: {
                return TimeLineUtils.getMinutesValue(mark);
            }
            case 40: {
                return TimeLineUtils.getHoursValue(mark);
            }
        }
        return "";
    }

    private static int getTimeUnitsFormat(int optimalUnits) {
        int timeUnitsFormatIndex = TimeLineUtils.getUnitsIndex(optimalUnits);
        if (timeUnitsFormatIndex == -1) {
            return -1;
        }
        return timeUnitsFormat[timeUnitsFormatIndex];
    }

    private static int getUnitsIndex(int optimalUnits) {
        Integer oTimeUnitsFormatIndex = timeUnitsToIndex.get(optimalUnits);
        if (oTimeUnitsFormatIndex == null) {
            return -1;
        }
        return oTimeUnitsFormatIndex;
    }

    static {
        for (int i = 0; i < timeUnitsGrid.length; ++i) {
            timeUnitsToIndex.put(timeUnitsGrid[i], i);
        }
    }
}

