/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Collection;
import java.util.EnumMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.core.stack.api.support.ThreadStateMapper;
import org.netbeans.modules.dlight.threadmap.api.ThreadSummaryData;
import org.netbeans.modules.dlight.visualizers.api.ThreadStateResources;
import org.netbeans.modules.dlight.visualizers.threadmap.OrderedEnumStateIterator;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateColumnImpl;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadSummaryColumnImpl;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadsPanel;
import org.netbeans.modules.dlight.visualizers.threadmap.TimeLineUtils;
import org.netbeans.modules.dlight.visualizers.threadmap.UIUtils;

public class ThreadSummaryCellRenderer
extends JPanel
implements TableCellRenderer,
Serializable {
    private Color unselectedBackground;
    private Color unselectedForeground;
    private ThreadSummaryColumnImpl threadSummary;
    private ThreadsPanel viewManager;
    private long threadTime;
    private long threadRunningTime;
    private long threadRunningRatio;
    private Collection<TimeIntervalDataFilter> timeFilters;
    private long dataStart;
    private EnumMap<ThreadState.MSAState, AtomicInteger> map = new EnumMap(ThreadState.MSAState.class);

    public ThreadSummaryCellRenderer(ThreadsPanel viewManager) {
        this.viewManager = viewManager;
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.unselectedBackground = UIUtils.getProfilerResultsBackground();
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.unselectedForeground = c;
    }

    @Override
    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            super.setForeground(table.isFocusOwner() ? table.getSelectionForeground() : UIUtils.getUnfocusedSelectionForeground());
            super.setBackground(table.isFocusOwner() ? table.getSelectionBackground() : UIUtils.getUnfocusedSelectionBackground());
        } else if ((row & 1) == 0) {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            super.setBackground(UIUtils.getDarker(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground()));
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
        }
        if (value instanceof ThreadSummaryColumnImpl) {
            this.threadSummary = (ThreadSummaryColumnImpl)value;
        }
        this.timeFilters = this.viewManager.getTimeIntervalSelection();
        this.dataStart = this.viewManager.getDataStart();
        return this;
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        for (AtomicInteger i : this.map.values()) {
            i.set(0);
        }
        int count = this.countSum(this.map);
        this.threadTime = count;
        if (count > 0) {
            ThreadStateColumnImpl.normilizeMap(this.map, count, 1);
            ThreadStateColumnImpl.roundMap(this.map);
        }
        this.threadRunningTime = this.sumStates(ThreadState.MSAState.Running, ThreadState.MSAState.RunningUser, ThreadState.MSAState.RunningSystemCall, ThreadState.MSAState.RunningOther);
        int height = this.getHeight() - 6;
        if (count > 0) {
            int rest = 50;
            int oldRest = 0;
            oldRest = 0;
            int y = 6;
            int ThreadWidth = 60;
            OrderedEnumStateIterator it = new OrderedEnumStateIterator(this.map);
            while (it.hasNext()) {
                Object entry = it.next();
                AtomicInteger value = (AtomicInteger)entry.getValue();
                oldRest = rest;
                rest = (value.get() * ThreadWidth + oldRest) % 100;
                int d = (value.get() * ThreadWidth + oldRest) / 100;
                if (d > 0) {
                    g.setColor(ThreadStateColumnImpl.getThreadStateColor((ThreadState.MSAState)entry.getKey()));
                    g.fillRect(y, 3, d, height);
                }
                y += d;
            }
        }
        this.threadRunningRatio = this.sumStates(ThreadState.MSAState.Running, ThreadState.MSAState.RunningUser, ThreadState.MSAState.RunningSystemCall, ThreadState.MSAState.RunningOther);
        int percent = (int)(100L * this.threadRunningRatio) / 100;
        String s = "" + percent + "%";
        Font summary = new Font(null, 1, height - 2);
        g.setFont(summary);
        int y = this.getHeight() - 3 - 2;
        g.setColor(UIUtils.getDarker(this.getBackground(), 0.4f));
        for (int dx = -1; dx < 2; ++dx) {
            for (int dy = -1; dy < 2; ++dy) {
                g.drawString(s, 9 + dx, y + dy);
            }
        }
        g.setColor(this.getBackground());
        g.drawString(s, 9, y);
    }

    @Override
    public String getToolTipText() {
        EnumMap<ThreadState.MSAState, AtomicInteger> aMap = new EnumMap<ThreadState.MSAState, AtomicInteger>(ThreadState.MSAState.class);
        int count = this.countSum(aMap);
        if (count > 0) {
            ThreadStateColumnImpl.normilizeMap(aMap, count, 1);
            ThreadStateColumnImpl.roundMap(aMap);
            StringBuilder buf = new StringBuilder();
            buf.append("<html>");
            buf.append("<table>");
            OrderedEnumStateIterator it = new OrderedEnumStateIterator(aMap);
            while (it.hasNext()) {
                Object entry = it.next();
                int value = ((AtomicInteger)entry.getValue()).get();
                ThreadState.MSAState s = (ThreadState.MSAState)entry.getKey();
                ThreadStateResources res = ThreadStateResources.forState(s);
                if (res == null) continue;
                buf.append("<tr>");
                buf.append("<td>");
                buf.append("<font bgcolor=\"#");
                buf.append(ThreadSummaryCellRenderer.colorToHexString(res.color));
                buf.append("\">&nbsp;&nbsp;");
                buf.append("</font></td>");
                buf.append("<td>");
                buf.append(res.name);
                buf.append("</td>");
                buf.append("<td>");
                buf.append(TimeLineUtils.getMillisValue(value * count * 10));
                buf.append("</td>");
                buf.append("<td>");
                buf.append("" + value + "%");
                buf.append("</td>");
                buf.append("</tr>");
            }
            buf.append("</table>");
            buf.append("</html>");
            return buf.toString();
        }
        return super.getToolTipText();
    }

    private int countSum(EnumMap<ThreadState.MSAState, AtomicInteger> aMap) {
        int count = 0;
        for (ThreadSummaryData.StateDuration duration : this.threadSummary.getSummary()) {
            ThreadState.MSAState msa = duration.getState();
            if (!this.viewManager.isFullMode()) {
                msa = ThreadStateMapper.toSimpleState((ThreadState.MSAState)msa);
            }
            if (msa == null) continue;
            int value = (int)(duration.getDuration() / 1000L / 1000L / 10L);
            count += value;
            AtomicInteger v = aMap.get(msa);
            if (v != null) {
                v.addAndGet(value);
                continue;
            }
            v = new AtomicInteger(value);
            aMap.put(msa, v);
        }
        count = (count + 50) / 100;
        ThreadStateColumnImpl.normilizeMap(aMap, 100, count);
        return count;
    }

    private static String colorToHexString(Color c) {
        return String.format("%06x", c.getRGB() & 0xFFFFFF);
    }

    private int sumStates(ThreadState.MSAState ... states) {
        int i = 0;
        for (ThreadState.MSAState state : states) {
            AtomicInteger r = this.map.get(state);
            if (r == null) continue;
            i += r.get();
        }
        return i;
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public void validate() {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }
}

