/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.properties.UtilConvert;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;

public final class PropertiesEncoding
extends FileEncodingQueryImplementation {
    public Charset getEncoding(FileObject file) {
        assert (!file.isValid() || file.isData());
        try {
            return new PropCharset(file);
        }
        catch (FileStateInvalidException ex) {
            return null;
        }
    }

    static final class PropCharsetDecoder
    extends CharsetDecoder {
        private final Logger log = Logger.getLogger(this.getClass().getName().replace('$', '.'));
        private static final float avgCharsPerByte = 1.0f;
        private static final float maxCharsPerByte = 6.0f;
        private static final int maxCharsPerByteInt = 6;
        private static final int inBufSize = 8192;
        private static final int outBufSize = 8192;
        private static final int SIZE_UNKNOWN = -1;
        private long inputSize;
        private int bytesDecoded = 0;
        private final byte[] inBuf = new byte[8192];
        private final char[] outBuf = new char[8192];
        private int inBufPos;
        private int outBufPos;
        private boolean emptyIn;
        private boolean fullOut;
        private boolean emptyInBuf;
        private State state;
        private int unicodeBytesRead;
        private int unicodeValue;
        private char[] unicodeValueChars = new char[4];
        private static final String hexadecimalChars = "0123456789abcdefABCDEF";

        PropCharsetDecoder(Charset charset) {
            this(charset, -1L);
        }

        PropCharsetDecoder(Charset charset, long inputSize) {
            super(charset, 1.0f, 6.0f);
            this.implReset();
            this.inputSize = inputSize;
        }

        @Override
        protected void implReset() {
            this.log.finer("");
            this.log.finer("implReset() called");
            this.inputSize = -1L;
            this.bytesDecoded = 0;
            this.inBufPos = 0;
            this.outBufPos = 0;
            this.emptyIn = false;
            this.fullOut = false;
            this.emptyInBuf = true;
            this.state = State.INITIAL;
            this.unicodeBytesRead = 0;
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            this.log.finer("");
            this.log.finer("decodeLoop() called");
            if (this.log.isLoggable(Level.FINEST)) {
                String inCount = String.format("%5d", in.remaining());
                String outCount = String.format("%5d", out.remaining());
                this.log.finest("    - input:  " + inCount + " bytes");
                this.log.finest("    - output: " + outCount + " chars");
            }
            this.emptyIn = false;
            this.fullOut = false;
            try {
                block3: while (true) {
                    this.readIn(in);
                    do {
                        this.bytesDecoded += this.decodeBuf();
                        assert ((long)this.bytesDecoded != this.inputSize || this.emptyIn);
                        if (this.emptyInBuf && !this.emptyIn) continue block3;
                        if (this.emptyIn && this.hasPendingCharacters() && (this.inputSize == -1L || (long)this.bytesDecoded >= this.inputSize)) {
                            this.handlePendingCharacters();
                        }
                        this.flushOutBuf(out);
                        if (!this.fullOut) continue;
                        this.log.finest(" - returning OVERFLOW");
                        return CoderResult.OVERFLOW;
                    } while (!this.emptyInBuf || !this.emptyIn);
                    break;
                }
                this.log.finest(" - returning UNDERFLOW");
                return CoderResult.UNDERFLOW;
            }
            catch (BufferUnderflowException ex) {
                assert (false);
                return CoderResult.UNDERFLOW;
            }
            catch (BufferOverflowException ex) {
                assert (false);
                return CoderResult.OVERFLOW;
            }
        }

        private boolean hasPendingCharacters() {
            return this.state != State.INITIAL;
        }

        private void handlePendingCharacters() {
            this.log.finer("handlePendingCharacters()");
            if (!this.hasPendingCharacters()) {
                this.log.finer(" - no pending characters");
                return;
            }
            switch (this.state) {
                case INITIAL: {
                    assert (false);
                    break;
                }
                case BACKSLASH: {
                    this.log.finer(" - backslash pending");
                    this.outBuf[this.outBufPos++] = 92;
                    break;
                }
                case UNICODE: {
                    this.log.finer(" - broken \\u.... sequence pending");
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("    - " + this.unicodeBytesRead + " unicode value bytes pending");
                    }
                    assert (this.unicodeBytesRead >= 0 && this.unicodeBytesRead < 4);
                    this.flushUnicodeSequence();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.state = State.INITIAL;
        }

        @Override
        protected CoderResult implFlush(CharBuffer out) {
            this.log.finer("");
            this.log.finer("implFlush() called");
            this.fullOut = out.hasRemaining();
            return this.flushOutBuf(out) ? CoderResult.OVERFLOW : CoderResult.UNDERFLOW;
        }

        private void readIn(ByteBuffer in) {
            this.log.finer("filling inBuf: ");
            if (this.emptyIn) {
                this.log.finer(" - input empty (emptyIn already set)");
                return;
            }
            int inRemaining = in.remaining();
            if (inRemaining == 0) {
                this.log.finer(" - input empty (emptyIn will be set)");
                this.emptyIn = true;
                return;
            }
            int bufRemaining = this.inBuf.length - this.inBufPos;
            if (bufRemaining == 0) {
                this.log.finer(" - no space remaining in inBuf");
                return;
            }
            int length = Math.min(inRemaining, bufRemaining);
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer(" - " + length + " bytes will be read");
            }
            in.get(this.inBuf, this.inBufPos, length);
            this.inBufPos += length;
            this.emptyInBuf = false;
            if (length == inRemaining) {
                assert (in.remaining() == 0);
                this.log.finer(" - all remaining bytes were read (emptyIn will be set)");
                this.emptyIn = true;
            }
        }

        private int decodeBuf() {
            this.log.finer("decoding inBuf, writing to outBuf");
            if (this.emptyInBuf) {
                this.log.finer(" - inBuf is empty - nothing to decode");
                return 0;
            }
            int decodingInBufPos = 0;
            this.log.finest(" - decoding bytes:");
            this.log.finest("     - initial state: " + (Object)((Object)this.state));
            while (decodingInBufPos < this.inBufPos && this.outBufPos <= 8186) {
                int decodedChars = this.decodeByte(this.inBuf[decodingInBufPos++]);
                if (this.log.isLoggable(Level.FINEST)) {
                    StringBuilder sb = new StringBuilder(60);
                    sb.append("     - byte 0x");
                    sb.append(PropCharsetDecoder.hexavalue(this.inBuf[decodingInBufPos - 1]));
                    sb.append(" => ").append((Object)this.state);
                    this.log.finest(sb.toString());
                }
                if (decodedChars >= 0) continue;
                --decodingInBufPos;
                this.log.finer("          - last byte returned to be processed again");
                this.unicodeBytesRead = 0;
                this.unicodeValue = 0;
                this.state = State.INITIAL;
            }
            int remainder = this.inBufPos - decodingInBufPos;
            if (remainder != 0) {
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer(" - " + remainder + " bytes will remain in the inBuf");
                }
                System.arraycopy(this.inBuf, decodingInBufPos, this.inBuf, 0, remainder);
            } else {
                this.log.finer(" - all bytes were successfully decoded");
            }
            this.inBufPos = remainder;
            this.emptyInBuf = this.inBufPos == 0;
            return decodingInBufPos;
        }

        private boolean flushOutBuf(CharBuffer out) {
            this.log.finer("flushing outBuf");
            if (this.outBufPos == 0) {
                this.log.finer(" - outBuf is empty - nothing to flush");
                return false;
            }
            if (this.fullOut) {
                this.log.finer(" - output CharBuffer is full (fullOut already set)");
                return true;
            }
            int outRemaining = out.remaining();
            if (outRemaining == 0) {
                this.log.finer(" - output CharBuffer is full (fullOut will be set)");
                this.fullOut = true;
                return true;
            }
            int length = Math.min(outRemaining, this.outBufPos);
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer(" - " + length + " chars will be written");
            }
            out.put(this.outBuf, 0, length);
            int remainder = this.outBufPos - length;
            if (remainder != 0) {
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer(" - " + remainder + " bytes will remain in the outBuf");
                }
                System.arraycopy(this.outBuf, length, this.outBuf, 0, remainder);
            } else {
                this.log.finer(" - all bytes were successfully flushed");
            }
            this.outBufPos = remainder;
            if (length == outRemaining) {
                assert (out.remaining() == 0);
                this.log.finer(" - output CharBuffer is now full (fullOut will be set)");
                this.fullOut = true;
            }
            return remainder != 0;
        }

        private int decodeByte(byte b) {
            int bInt;
            int oldPos = this.outBufPos;
            int n = bInt = b >= 0 ? b : b + 256;
            assert (bInt >= 0 && (bInt & 0xFF) == bInt);
            char bChar = (char)bInt;
            switch (this.state) {
                case INITIAL: {
                    if (bChar == '\\') {
                        this.state = State.BACKSLASH;
                        break;
                    }
                    this.outBuf[this.outBufPos++] = bChar;
                    break;
                }
                case BACKSLASH: {
                    if (bChar == 'u') {
                        this.state = State.UNICODE;
                        break;
                    }
                    this.outBuf[this.outBufPos++] = 92;
                    this.outBuf[this.outBufPos++] = bChar;
                    this.state = State.INITIAL;
                    break;
                }
                case UNICODE: {
                    boolean malformed = false;
                    int index = hexadecimalChars.indexOf(bChar);
                    if (index >= 0) {
                        if (index > 15) {
                            index -= 6;
                        }
                        assert (index <= 15);
                        this.unicodeValue = this.unicodeValue << 4 | index;
                        if (++this.unicodeBytesRead == 4) {
                            if (this.unicodeValue <= 32) {
                                this.unicodeValueChars[3] = bChar;
                                this.flushUnicodeSequence();
                            } else {
                                this.outBuf[this.outBufPos++] = (char)this.unicodeValue;
                            }
                            this.state = State.INITIAL;
                        } else {
                            this.unicodeValueChars[this.unicodeBytesRead - 1] = bChar;
                        }
                    } else {
                        malformed = true;
                        this.flushUnicodeSequence();
                        this.state = State.INITIAL;
                    }
                    if (this.state == State.UNICODE) break;
                    this.unicodeBytesRead = 0;
                    this.unicodeValue = 0;
                    if (!malformed) break;
                    return -1;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return this.outBufPos - oldPos;
        }

        private void flushUnicodeSequence() {
            this.outBuf[this.outBufPos++] = 92;
            this.outBuf[this.outBufPos++] = 117;
            for (int i = 0; i < this.unicodeBytesRead; ++i) {
                this.outBuf[this.outBufPos++] = this.unicodeValueChars[i];
            }
            this.unicodeBytesRead = 0;
            this.unicodeValue = 0;
        }

        private static char[] hexavalue(byte b) {
            int bInt = b >= 0 ? b : b + 256;
            char[] result = new char[]{hexadecimalChars.charAt(bInt / 16), hexadecimalChars.charAt(bInt % 16)};
            return result;
        }

        char[] decodeBytesForTests(byte[] bytes) throws CharacterCodingException {
            CharBuffer resultBuf = this.decode(ByteBuffer.wrap(bytes));
            char[] resultBufArray = resultBuf.array();
            int resultBufPos = resultBuf.limit();
            if (resultBufPos == resultBufArray.length) {
                return resultBufArray;
            }
            char[] result = new char[resultBufPos];
            System.arraycopy(resultBufArray, 0, result, 0, resultBufPos);
            return result;
        }

        private static enum State {
            INITIAL,
            BACKSLASH,
            UNICODE;

        }
    }

    static final class PropCharsetEncoder
    extends CharsetEncoder {
        private static final int avgEncodedTokenLen = 3;
        private static final int maxEncodedTokenLen = 6;
        private static final int inBufSize = 8192;
        private static final int outBufSize = 24576;
        private final char[] inBuf = new char[8192];
        private final byte[] outBuf = new byte[24576];
        private int inBufPos;
        private int outBufPos;
        private boolean emptyIn;
        private boolean fullOut;
        private boolean emptyInBuf;
        private static final byte zeroByte = 48;
        private static final byte[] hexadecimalChars = UtilConvert.hexDigit;

        PropCharsetEncoder(Charset charset) {
            super(charset, 3.0f, 6.0f);
            this.implReset();
        }

        PropCharsetEncoder() {
            super(new PropCharset(), 3.0f, 6.0f);
            this.implReset();
        }

        @Override
        protected void implReset() {
            this.inBufPos = 0;
            this.outBufPos = 0;
            this.emptyIn = false;
            this.fullOut = false;
            this.emptyInBuf = true;
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            this.emptyIn = false;
            this.fullOut = false;
            try {
                block3: while (true) {
                    this.readIn(in);
                    do {
                        this.encodeBuf();
                        if (this.emptyInBuf && !this.emptyIn) continue block3;
                        this.flushOutBuf(out);
                        if (!this.fullOut) continue;
                        return CoderResult.OVERFLOW;
                    } while (!this.emptyInBuf || !this.emptyIn);
                    break;
                }
                return CoderResult.UNDERFLOW;
            }
            catch (BufferUnderflowException ex) {
                assert (false);
                return CoderResult.UNDERFLOW;
            }
            catch (BufferOverflowException ex) {
                assert (false);
                return CoderResult.OVERFLOW;
            }
        }

        @Override
        protected CoderResult implFlush(ByteBuffer out) {
            return this.flushOutBuf(out) ? CoderResult.OVERFLOW : CoderResult.UNDERFLOW;
        }

        private void readIn(CharBuffer in) {
            if (this.emptyIn) {
                return;
            }
            int inRemaining = in.remaining();
            if (inRemaining == 0) {
                this.emptyIn = true;
                return;
            }
            int bufRemaining = this.inBuf.length - this.inBufPos;
            if (bufRemaining == 0) {
                return;
            }
            int length = Math.min(inRemaining, bufRemaining);
            in.get(this.inBuf, this.inBufPos, length);
            this.inBufPos += length;
            this.emptyInBuf = false;
            if (length == inRemaining) {
                assert (in.remaining() == 0);
                this.emptyIn = true;
            }
        }

        private void encodeBuf() {
            if (this.emptyInBuf) {
                return;
            }
            int encodingInBufPos = 0;
            while (encodingInBufPos < this.inBufPos && this.outBufPos <= 24570) {
                this.encodeChar(this.inBuf[encodingInBufPos++]);
            }
            int remainder = this.inBufPos - encodingInBufPos;
            if (remainder != 0) {
                System.arraycopy(this.inBuf, encodingInBufPos, this.inBuf, 0, remainder);
            }
            this.inBufPos = remainder;
            this.emptyInBuf = this.inBufPos == 0;
        }

        private boolean flushOutBuf(ByteBuffer out) {
            if (this.fullOut) {
                return true;
            }
            int outRemaining = out.remaining();
            if (outRemaining == 0) {
                this.fullOut = true;
                return true;
            }
            if (this.outBufPos == 0) {
                return false;
            }
            int length = Math.min(outRemaining, this.outBufPos);
            out.put(this.outBuf, 0, length);
            int remainder = this.outBufPos - length;
            if (remainder != 0) {
                System.arraycopy(this.outBuf, length, this.outBuf, 0, remainder);
            }
            this.outBufPos = remainder;
            if (length == outRemaining) {
                assert (out.remaining() == 0);
                this.fullOut = true;
            }
            return remainder != 0;
        }

        private int encodeChar(char c) {
            int oldPos = this.outBufPos;
            char cInt = c;
            if (c == '\r' || c == '\n' || c == '\t' || c == '\f') {
                this.outBuf[this.outBufPos++] = (byte)c;
            } else if (c < ' ' || c > '~') {
                this.outBuf[this.outBufPos++] = 92;
                this.outBuf[this.outBufPos++] = 117;
                if (c >= '\u0100') {
                    this.outBuf[this.outBufPos++] = hexadecimalChars[cInt >> 12 & 0xF];
                    this.outBuf[this.outBufPos++] = hexadecimalChars[cInt >> 8 & 0xF];
                } else {
                    this.outBuf[this.outBufPos++] = 48;
                    this.outBuf[this.outBufPos++] = 48;
                }
                this.outBuf[this.outBufPos++] = hexadecimalChars[cInt >> 4 & 0xF];
                this.outBuf[this.outBufPos++] = hexadecimalChars[cInt & 0xF];
            } else {
                this.outBuf[this.outBufPos++] = (byte)c;
            }
            return this.outBufPos - oldPos;
        }

        byte[] encodeCharForTests(char c) {
            this.reset();
            int tokenLength = this.encodeChar(c);
            byte[] result = new byte[tokenLength];
            System.arraycopy(this.outBuf, 0, result, 0, tokenLength);
            return result;
        }

        byte[] encodeStringForTests(String s) throws CharacterCodingException {
            ByteBuffer resultBuf = this.encode(CharBuffer.wrap(s));
            byte[] resultBufArray = resultBuf.array();
            int resultBufPos = resultBuf.limit();
            if (resultBufPos == resultBufArray.length) {
                return resultBufArray;
            }
            byte[] result = new byte[resultBufPos];
            System.arraycopy(resultBufArray, 0, result, 0, resultBufPos);
            return result;
        }
    }

    static final class PropCharset
    extends Charset
    implements FileChangeListener {
        private final Reference<FileObject> fileRef;
        private URL fileURL;

        PropCharset(FileObject file) throws FileStateInvalidException {
            super("ISO-8859-1", null);
            this.fileRef = new WeakReference<FileObject>(file);
            file.addFileChangeListener((FileChangeListener)this);
            this.updateURL(file);
        }

        PropCharset() {
            super("ISO-8859-1", null);
            this.fileRef = null;
        }

        @Override
        public boolean contains(Charset charset) {
            return true;
        }

        @Override
        public CharsetEncoder newEncoder() {
            return new PropCharsetEncoder(this);
        }

        @Override
        public CharsetDecoder newDecoder() {
            long fileSize = this.fileRef != null ? this.getFileSize() : -1L;
            return fileSize > 0L ? new PropCharsetDecoder(this, fileSize) : new PropCharsetDecoder(this);
        }

        private long getFileSize() {
            FileObject file = this.getFile();
            return file != null && file.isValid() ? file.getSize() : 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FileObject getFile() {
            URL url;
            FileObject fileObj = this.fileRef.get();
            PropCharset propCharset = this;
            synchronized (propCharset) {
                url = this.fileURL;
            }
            if (fileObj == null && url != null) {
                fileObj = URLMapper.findFileObject((URL)url);
            }
            return fileObj;
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.updateURL(fe.getFile());
        }

        public void fileChanged(FileEvent fe) {
            this.updateURL(fe.getFile());
        }

        private synchronized void updateURL(FileObject file) {
            try {
                this.fileURL = file.getURL();
            }
            catch (FileStateInvalidException ex) {
                this.fileURL = null;
            }
        }

        public void fileDeleted(FileEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileFolderCreated(FileEvent fe) {
            assert (false);
        }
    }
}

