/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.spi;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.javacard.spi.Card;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public final class ConnectionWatchdog<CardImpl extends Card> {
    private final R r = new R();
    private final Reference<CardImpl> cardRef;
    private volatile boolean attached;
    private volatile boolean applicationIsActive;
    private static final RequestProcessor rp = new RequestProcessor("Java Card connection polling thread pool", 1);
    private final RequestProcessor.Task task = rp.create((Runnable)this.r);
    private static final Logger LOGGER = Logger.getLogger(ConnectionWatchdog.class.getName());
    private boolean done;
    private final Callback<CardImpl> callback;
    private int POLL_FREQUENCY = 30000;
    private int delayAfterActivation = 200;
    private boolean enabled = true;

    public ConnectionWatchdog(CardImpl card, Callback<CardImpl> callback, int pollFrequency, int delayAfterActivation) {
        assert (pollFrequency > 0) : "Negative or 0 polling frequency: " + pollFrequency;
        assert (delayAfterActivation > 0) : "Negative or 0 delay: " + delayAfterActivation;
        Parameters.notNull((CharSequence)"card", card);
        Parameters.notNull((CharSequence)"callback", callback);
        this.POLL_FREQUENCY = pollFrequency;
        this.delayAfterActivation = delayAfterActivation;
        this.cardRef = new WeakReference<CardImpl>(card);
        this.callback = callback;
        EventQueue.invokeLater(this.r);
    }

    public ConnectionWatchdog(CardImpl card, Callback<CardImpl> callback) {
        Parameters.notNull((CharSequence)"card", card);
        Parameters.notNull((CharSequence)"callback", callback);
        this.cardRef = new WeakReference<CardImpl>(card);
        this.callback = callback;
        EventQueue.invokeLater(this.r);
    }

    public final void refreshNow() {
        if (this.applicationIsActive) {
            this.task.schedule(1);
        }
    }

    public void setEnabled(boolean val) {
        this.enabled = val;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void done() {
        if (!this.done) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, super.toString() + " shutting down");
            }
            this.task.cancel();
            EventQueue.invokeLater(this.r);
            this.done = true;
        }
    }

    void setApplicationActive(boolean val) {
        if (this.applicationIsActive != val) {
            this.applicationIsActive = val;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, this + " application active " + val);
            }
            if (this.applicationIsActive) {
                this.task.schedule(this.delayAfterActivation);
            } else {
                this.task.cancel();
            }
        }
    }

    private CardImpl getCard() {
        Card result = (Card)this.cardRef.get();
        if (result == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, super.toString() + " Lost reference to card");
            }
            this.done();
        }
        return (CardImpl)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCardStatus() {
        assert (!EventQueue.isDispatchThread());
        CardImpl card = this.getCard();
        if (card != null) {
            try {
                this.callback.poll(card);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                this.done();
            }
            finally {
                if (!this.done) {
                    this.task.schedule(this.POLL_FREQUENCY);
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        CardImpl card = this.getCard();
        if (card != null) {
            sb.append(" for ");
            sb.append(card);
            sb.append(" at ");
            try {
                sb.append(this.callback);
            }
            catch (Exception ex) {
                sb.append(ex.getMessage());
            }
        } else {
            sb.append(" dead card: " + this.callback);
        }
        return sb.toString();
    }

    private class R
    extends WindowAdapter
    implements Runnable {
        private R() {
        }

        @Override
        public void run() {
            if (EventQueue.isDispatchThread()) {
                if (!ConnectionWatchdog.this.attached && !ConnectionWatchdog.this.done) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Attaching window listener for polling " + this);
                    }
                    Frame f = WindowManager.getDefault().getMainWindow();
                    f.addWindowListener(this);
                    ConnectionWatchdog.this.setApplicationActive(f.isActive() || KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() != null);
                } else {
                    WindowManager.getDefault().getMainWindow().removeWindowListener(this);
                }
            } else if (ConnectionWatchdog.this.enabled) {
                ConnectionWatchdog.this.updateCardStatus();
            }
        }

        @Override
        public void windowActivated(WindowEvent e) {
            ConnectionWatchdog.this.setApplicationActive(true);
        }

        @Override
        public void windowClosed(WindowEvent e) {
            super.windowClosed(e);
            ConnectionWatchdog.this.done();
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            ConnectionWatchdog.this.setApplicationActive(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() != null);
        }
    }

    public static interface Callback<T extends Card> {
        public void poll(T var1) throws Exception;
    }
}

