/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.makeproject.ui.wizards.ConfigureUtils;
import org.netbeans.modules.cnd.makeproject.ui.wizards.PanelProjectLocationVisual;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SelectModeDescriptorPanel;
import org.netbeans.modules.cnd.utils.ui.FileChooser;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SelectModePanel
extends JPanel {
    private final SelectModeDescriptorPanel controller;
    private volatile boolean initialized = false;
    private static final byte noMessage = 0;
    private static final byte notFolder = 1;
    private static final byte cannotReadFolder = 2;
    private static final byte cannotWriteFolder = 3;
    private static final byte alreadyNbPoject = 4;
    private static final byte notFoundMakeAndConfigure = 5;
    private byte messageKind = 0;
    private JRadioButton advancedMode;
    private JButton browseButton;
    private ButtonGroup buttonGroup1;
    private JComboBox hostComboBox;
    private JLabel hostLabel;
    private JPanel instructionPanel;
    private JTextPane instructions;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JLabel modeLabel;
    private JTextField projectFolder;
    private JRadioButton simpleMode;
    private JComboBox toolchainComboBox;
    private JLabel toolchainLabel;

    public SelectModePanel(SelectModeDescriptorPanel wizard) {
        this.controller = wizard;
        this.initComponents();
        this.instructions.setEditorKit(new HTMLEditorKit());
        this.instructions.setBackground(this.instructionPanel.getBackground());
        this.disableHostSensitiveComponents();
        this.addListeners();
    }

    private void addListeners() {
        this.projectFolder.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                SelectModePanel.this.controller.getWizardStorage().setPath(SelectModePanel.this.projectFolder.getText());
                SelectModePanel.this.updateInstruction();
            }
        });
        this.simpleMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectModePanel.this.controller.getWizardStorage().setMode(SelectModePanel.this.simpleMode.isSelected());
                SelectModePanel.this.updateInstruction();
            }
        });
        this.advancedMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectModePanel.this.controller.getWizardStorage().setMode(SelectModePanel.this.simpleMode.isSelected());
                SelectModePanel.this.updateInstruction();
            }
        });
        this.updateInstruction();
    }

    private void updateInstruction() {
        if (this.simpleMode.isSelected()) {
            String tool = "Makefile";
            String toolsInfo = this.getString("SelectModeSimpleInstructionExtraText_Make", new String[0]);
            if (this.controller.getWizardStorage() != null) {
                String configure = this.controller.getWizardStorage().getConfigure();
                if (configure != null) {
                    toolsInfo = this.getString("SelectModeSimpleInstructionExtraText_Configure", new String[0]);
                    tool = configure;
                    File confFile = FileUtil.normalizeFile((File)new File(configure));
                    FileObject fo = FileUtil.toFileObject((File)confFile);
                    if (fo != null) {
                        String mimeType = fo.getMIMEType();
                        if ("text/x-cmake".equals(mimeType)) {
                            toolsInfo = this.getString("SelectModeSimpleInstructionExtraText_CMake", new String[0]);
                            tool = "cmake";
                        } else if ("text/x-qtproject".equals(mimeType)) {
                            toolsInfo = this.getString("SelectModeSimpleInstructionExtraText_QMake", new String[0]);
                            tool = "qmake";
                        }
                    }
                } else {
                    String makefile = this.controller.getWizardStorage().getMake();
                    if (makefile != null) {
                        tool = makefile;
                    }
                }
            }
            String modeInfo = this.getString("SimpleModeButtonText", tool);
            Mnemonics.setLocalizedText((AbstractButton)this.simpleMode, (String)modeInfo);
            this.instructions.setText(this.getString("SelectModeSimpleInstructionText", toolsInfo));
        } else {
            this.instructions.setText(this.getString("SelectModeAdvancedInstructionText", new String[0]));
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.instructionPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.instructions = new JTextPane();
        this.simpleMode = new JRadioButton();
        this.advancedMode = new JRadioButton();
        this.modeLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.projectFolder = new JTextField();
        this.browseButton = new JButton();
        this.toolchainComboBox = new JComboBox();
        this.toolchainLabel = new JLabel();
        this.hostComboBox = new JComboBox();
        this.hostLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.instructionPanel.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setPreferredSize(new Dimension(200, 200));
        this.instructions.setBorder(null);
        this.instructions.setEditable(false);
        this.instructions.setFocusable(false);
        this.jScrollPane1.setViewportView(this.instructions);
        this.instructionPanel.add((Component)this.jScrollPane1, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.instructionPanel, gridBagConstraints);
        this.buttonGroup1.add(this.simpleMode);
        this.simpleMode.setSelected(true);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.simpleMode, (String)bundle.getString("SimpleModeButtonText"));
        this.simpleMode.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.simpleMode.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 12, 0, 0);
        this.add((Component)this.simpleMode, gridBagConstraints);
        this.buttonGroup1.add(this.advancedMode);
        Mnemonics.setLocalizedText((AbstractButton)this.advancedMode, (String)bundle.getString("AdvancedModeButtonText"));
        this.advancedMode.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.advancedMode.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 12, 0, 0);
        this.add((Component)this.advancedMode, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.modeLabel, (String)bundle.getString("SelectModeLabelText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.modeLabel, gridBagConstraints);
        this.jLabel1.setLabelFor(this.projectFolder);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SelectModePanel.class, (String)"SELECT_MODE_PROJECT_FOLDER"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.projectFolder, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(SelectModePanel.class, (String)"SELECT_MODE_BROWSE_PROJECT_FOLDER"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectModePanel.this.browseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.browseButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.toolchainComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.toolchainLabel, (String)NbBundle.getMessage(SelectModePanel.class, (String)"LBL_TOOLCHAIN"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 8, 0);
        this.add((Component)this.toolchainLabel, gridBagConstraints);
        this.hostComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SelectModePanel.this.hostComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.hostComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)NbBundle.getMessage(SelectModePanel.class, (String)"LBL_HOST"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 8, 0);
        this.add((Component)this.hostLabel, gridBagConstraints);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        String seed = this.projectFolder.getText();
        FileChooser fileChooser = new FileChooser(this.getString("PROJECT_DIR_CHOOSER_TITLE_TXT", new String[0]), this.getString("PROJECT_DIR_BUTTON_TXT", new String[0]), 1, null, seed, false);
        int ret = fileChooser.showOpenDialog(this);
        if (ret == 1) {
            return;
        }
        String path = fileChooser.getSelectedFile().getPath();
        this.projectFolder.setText(path);
    }

    private void hostComboBoxItemStateChanged(ItemEvent evt) {
        if (!this.initialized) {
            return;
        }
        if (evt.getStateChange() == 1) {
            ServerRecord newItem = (ServerRecord)evt.getItem();
            PanelProjectLocationVisual.updateToolchains(this.toolchainComboBox, newItem);
            this.controller.fireChangeEvent();
        }
    }

    void read(WizardDescriptor wizardDescriptor) {
        this.initialized = false;
        this.updateControls();
        String hostUID = (String)wizardDescriptor.getProperty("hostUID");
        CompilerSet cs = (CompilerSet)wizardDescriptor.getProperty("toolchain");
        RequestProcessor.getDefault().post((Runnable)new PanelProjectLocationVisual.DevHostsInitializer(hostUID, cs, false){

            @Override
            public void updateComponents(Collection<ServerRecord> records, ServerRecord srToSelect, CompilerSet csToSelect, boolean enabled) {
                SelectModePanel.this.enableHostSensitiveComponents(records, srToSelect, csToSelect, enabled);
            }
        });
    }

    void updateControls() {
        this.updateInstruction();
    }

    void enableControls(boolean enable) {
        this.advancedMode.setEnabled(enable);
        this.simpleMode.setEnabled(enable);
    }

    void store(WizardDescriptor wizardDescriptor) {
        Object tc;
        if (this.simpleMode.isSelected()) {
            wizardDescriptor.putProperty("simpleMode", (Object)Boolean.TRUE);
            wizardDescriptor.putProperty("setAsMain", (Object)Boolean.TRUE);
        } else {
            wizardDescriptor.putProperty("simpleMode", (Object)Boolean.FALSE);
        }
        wizardDescriptor.putProperty("simpleModeFolder", (Object)this.projectFolder.getText().trim());
        wizardDescriptor.putProperty("readOnlyToolchain", (Object)Boolean.TRUE);
        Object obj = this.hostComboBox.getSelectedItem();
        if (obj != null && obj instanceof ServerRecord) {
            ServerRecord sr = (ServerRecord)obj;
            ExecutionEnvironment ee = sr.getExecutionEnvironment();
            wizardDescriptor.putProperty("hostUID", (Object)ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)ee));
            this.controller.getWizardStorage().setExecutionEnvironment(ee);
        }
        if ((tc = this.toolchainComboBox.getSelectedItem()) != null && tc instanceof CompilerSet) {
            wizardDescriptor.putProperty("toolchain", tc);
            this.controller.getWizardStorage().setCompilerSet((CompilerSet)tc);
        }
        this.initialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    boolean valid() {
        block41: {
            block31: {
                block29: {
                    block40: {
                        block30: {
                            block27: {
                                block39: {
                                    block28: {
                                        block25: {
                                            block38: {
                                                block26: {
                                                    block37: {
                                                        block23: {
                                                            block36: {
                                                                block24: {
                                                                    block21: {
                                                                        block35: {
                                                                            block22: {
                                                                                block19: {
                                                                                    block34: {
                                                                                        block20: {
                                                                                            block17: {
                                                                                                block33: {
                                                                                                    block18: {
                                                                                                        block15: {
                                                                                                            block32: {
                                                                                                                block16: {
                                                                                                                    this.messageKind = 0;
                                                                                                                    path = this.projectFolder.getText().trim();
                                                                                                                    try {
                                                                                                                        if (path.length() != 0) break block15;
                                                                                                                        var2_2 = false;
                                                                                                                        if (this.messageKind <= 0) break block16;
                                                                                                                    }
                                                                                                                    catch (Throwable var6_16) {
                                                                                                                        if (this.messageKind > 0) {
                                                                                                                            this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)this.getString("SelectModeError" + this.messageKind, new String[]{path}));
                                                                                                                        } else {
                                                                                                                            this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", null);
                                                                                                                        }
                                                                                                                        throw var6_16;
                                                                                                                    }
                                                                                                                    this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)this.getString("SelectModeError" + this.messageKind, new String[]{path}));
                                                                                                                    break block32;
                                                                                                                }
                                                                                                                this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", null);
                                                                                                            }
                                                                                                            return var2_2;
                                                                                                        }
                                                                                                        file = FileUtil.normalizeFile((File)new File(path));
                                                                                                        if (file.isDirectory() && file.canRead()) break block17;
                                                                                                        this.messageKind = file.isDirectory() != false ? (byte)2 : 1;
                                                                                                        var3_4 = false;
                                                                                                        if (this.messageKind <= 0) break block18;
                                                                                                        this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)this.getString("SelectModeError" + this.messageKind, new String[]{path}));
                                                                                                        break block33;
                                                                                                    }
                                                                                                    this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", null);
                                                                                                }
                                                                                                return var3_4;
                                                                                            }
                                                                                            if (!this.simpleMode.isSelected()) ** GOTO lbl79
                                                                                            if (file.canWrite()) break block19;
                                                                                            this.messageKind = (byte)3;
                                                                                            var3_5 = false;
                                                                                            if (this.messageKind <= 0) break block20;
                                                                                            this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)this.getString("SelectModeError" + this.messageKind, new String[]{path}));
                                                                                            break block34;
                                                                                        }
                                                                                        this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", null);
                                                                                    }
                                                                                    return var3_5;
                                                                                }
                                                                                nbFile = new File(new File(path, "nbproject"), "project.xml");
                                                                                if (!nbFile.exists()) break block21;
                                                                                this.messageKind = (byte)4;
                                                                                var4_11 = false;
                                                                                if (this.messageKind <= 0) break block22;
                                                                                this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)this.getString("SelectModeError" + this.messageKind, new String[]{path}));
                                                                                break block35;
                                                                            }
                                                                            this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", null);
                                                                        }
                                                                        return var4_11;
                                                                    }
                                                                    if (!file.isDirectory() || (fo = FileUtil.toFileObject((File)file)) == null) ** GOTO lbl79
                                                                    if (ProjectManager.getDefault().findProject(fo) == null) break block23;
                                                                    this.messageKind = (byte)4;
                                                                    var5_13 = false;
                                                                    if (this.messageKind <= 0) break block24;
                                                                    this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)this.getString("SelectModeError" + this.messageKind, new String[]{path}));
                                                                    break block36;
                                                                }
                                                                this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", null);
                                                            }
                                                            return var5_13;
                                                        }
                                                        break block37;
                                                        {
                                                            catch (IOException ex) {
                                                            }
                                                            catch (IllegalArgumentException ex) {
                                                                // empty catch block
                                                            }
                                                        }
                                                    }
                                                    if (ConfigureUtils.findConfigureScript(path) == null) break block25;
                                                    var3_7 = true;
                                                    if (this.messageKind <= 0) break block26;
                                                    this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)this.getString("SelectModeError" + this.messageKind, new String[]{path}));
                                                    break block38;
                                                }
                                                this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", null);
                                            }
                                            return var3_7;
                                        }
                                        if (ConfigureUtils.findMakefile(path) == null) break block27;
                                        var3_8 = true;
                                        if (this.messageKind <= 0) break block28;
                                        this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)this.getString("SelectModeError" + this.messageKind, new String[]{path}));
                                        break block39;
                                    }
                                    this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", null);
                                }
                                return var3_8;
                            }
                            if (!this.simpleMode.isSelected()) break block29;
                            this.messageKind = (byte)5;
                            var3_9 = false;
                            if (this.messageKind <= 0) break block30;
                            this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)this.getString("SelectModeError" + this.messageKind, new String[]{path}));
                            break block40;
                        }
                        this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", null);
                    }
                    return var3_9;
                }
                var3_10 = true;
                if (this.messageKind <= 0) break block31;
                this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)this.getString("SelectModeError" + this.messageKind, new String[]{path}));
                break block41;
            }
            this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", null);
        }
        return var3_10;
    }

    private String getString(String key, String ... params) {
        return NbBundle.getMessage(SelectModePanel.class, (String)key, (Object[])params);
    }

    private void disableHostSensitiveComponents() {
        PanelProjectLocationVisual.disableHostsInfo(this.hostComboBox, this.toolchainComboBox);
        this.advancedMode.setEnabled(false);
        this.simpleMode.setEnabled(false);
    }

    private void enableHostSensitiveComponents(Collection<ServerRecord> records, ServerRecord srToSelect, CompilerSet csToSelect, boolean enabled) {
        PanelProjectLocationVisual.updateToolchainsComponents(this.hostComboBox, this.toolchainComboBox, records, srToSelect, csToSelect, enabled);
        this.advancedMode.setEnabled(true);
        this.simpleMode.setEnabled(true);
        this.updateInstruction();
        this.initialized = true;
        this.controller.fireChangeEvent();
    }
}

