/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class MakeArtifactChooser
extends JPanel
implements PropertyChangeListener {
    private ArtifactType artifactType;
    private JPanel leftPanel;
    private JLabel libFilesLabel;
    private JList listArtifacts;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JScrollPane scrollPane1;

    public MakeArtifactChooser(ArtifactType artifactType, JFileChooser chooser) {
        this.artifactType = artifactType;
        this.initComponents();
        this.listArtifacts.setModel(new DefaultListModel());
        chooser.addPropertyChangeListener(this);
        this.listArtifacts.getAccessibleContext().setAccessibleDescription(MakeArtifactChooser.getString("PROJECT_LIBRARY_FILES_AD"));
        this.libFilesLabel.setDisplayedMnemonic(MakeArtifactChooser.getString("PROJECT_LIBRARY_FILES_MN").charAt(0));
    }

    private void initComponents() {
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.libFilesLabel = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.listArtifacts = new JList();
        this.leftPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.projectLabel.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/configurations/ui/Bundle").getString("PROJECT_NAME_TXT"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 2, 0);
        this.add((Component)this.projectLabel, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 6, 0);
        this.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleDescription(null);
        this.libFilesLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/configurations/ui/Bundle").getString("PROJECT_LIBRARY_FILES_MN").charAt(0));
        this.libFilesLabel.setLabelFor(this.listArtifacts);
        Mnemonics.setLocalizedText((JLabel)this.libFilesLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/configurations/ui/Bundle").getString("PROJECT_LIBRARY_FILES_TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 2, 0);
        this.add((Component)this.libFilesLabel, gridBagConstraints);
        this.scrollPane1.setViewportView(this.listArtifacts);
        this.listArtifacts.getAccessibleContext().setAccessibleDescription(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.scrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 16;
        this.add((Component)this.leftPanel, gridBagConstraints);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("SelectedFileChangedProperty".equals(e.getPropertyName())) {
            JFileChooser chooser = (JFileChooser)e.getSource();
            File dir = chooser.getSelectedFile();
            Project project = this.getProject(dir);
            this.populateAccessory(project);
        }
    }

    private Project getProject(File projectDir) {
        if (projectDir == null) {
            return null;
        }
        try {
            File normProjectDir = CndFileUtils.normalizeFile((File)projectDir);
            FileObject fo = FileUtil.toFileObject((File)normProjectDir);
            if (fo != null) {
                return ProjectManager.getDefault().findProject(fo);
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return null;
    }

    private void populateAccessory(Project project) {
        DefaultListModel model = (DefaultListModel)this.listArtifacts.getModel();
        model.clear();
        this.projectTextField.setText(project == null ? "" : ProjectUtils.getInformation((Project)project).getDisplayName());
        if (project != null) {
            MakeArtifact[] artifacts = MakeArtifact.getMakeArtifacts(project);
            if (artifacts == null) {
                return;
            }
            int def = 0;
            for (int i = 0; i < artifacts.length; ++i) {
                if (this.artifactType == ArtifactType.LIBRARY) {
                    if (artifacts[i].getConfigurationType() == 0 && (artifacts[i].getOutput().endsWith(".a") || artifacts[i].getOutput().endsWith(".so") || artifacts[i].getOutput().endsWith(".dylib") || artifacts[i].getOutput().endsWith(".lib") || artifacts[i].getOutput().endsWith(".dll")) || artifacts[i].getConfigurationType() == 2 || artifacts[i].getConfigurationType() == 3 || artifacts[i].getConfigurationType() == 5 || artifacts[i].getConfigurationType() == 6) {
                        model.addElement(artifacts[i]);
                    }
                } else if (this.artifactType == ArtifactType.PROJECT) {
                    model.addElement(artifacts[i]);
                } else assert (false);
                if (!artifacts[i].getActive()) continue;
                def = i;
            }
            this.listArtifacts.setSelectionInterval(def, def);
        }
    }

    public static MakeArtifact[] showDialog(ArtifactType artifactType, Project master, Component parent) {
        JFileChooser chooser = ProjectChooser.projectChooser();
        chooser.getAccessibleContext().setAccessibleDescription(MakeArtifactChooser.getString("ADD_PROJECT_DIALOG_AD"));
        chooser.setDialogTitle(MakeArtifactChooser.getString("ADD_PROJECT_DIALOG_TITLE"));
        chooser.setApproveButtonText(MakeArtifactChooser.getString("ADD_BUTTON_TXT"));
        MakeArtifactChooser accessory = new MakeArtifactChooser(artifactType, chooser);
        chooser.setAccessory(accessory);
        chooser.setPreferredSize(new Dimension(650, 380));
        int option = chooser.showOpenDialog(parent);
        if (option == 0) {
            File dir = chooser.getSelectedFile();
            Project selectedProject = accessory.getProject(dir = CndFileUtils.normalizeFile((File)dir));
            if (selectedProject == null) {
                return null;
            }
            if (selectedProject.getProjectDirectory().equals(master.getProjectDirectory())) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MakeArtifactChooser.getString("ADD_ITSELF_ERROR"), 1));
                return null;
            }
            if (ProjectUtils.hasSubprojectCycles((Project)master, (Project)selectedProject)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MakeArtifactChooser.getString("ADD_CYCLIC_ERROR"), 1));
                return null;
            }
            Object[] tmp = new Object[accessory.listArtifacts.getModel().getSize()];
            int count = 0;
            for (int i = 0; i < tmp.length; ++i) {
                if (!accessory.listArtifacts.isSelectedIndex(i)) continue;
                tmp[count] = accessory.listArtifacts.getModel().getElementAt(i);
                ++count;
            }
            MakeArtifact[] artifactItems = new MakeArtifact[count];
            System.arraycopy(tmp, 0, artifactItems, 0, count);
            return artifactItems;
        }
        return null;
    }

    private static String getString(String s) {
        return NbBundle.getBundle(MakeArtifactChooser.class).getString(s);
    }

    public static enum ArtifactType {
        PROJECT,
        LIBRARY;

    }
}

