/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.Completion;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.java.hints.jackpot.impl.RulesManager;
import org.netbeans.modules.java.hints.jackpot.spi.HintMetadata;

public class SuppressWarningsCompletion
implements Processor {
    private static final Collection<? extends String> WELL_KNOWN = Arrays.asList("unchecked", "fallthrough", "deprecation");
    private static final Set<String> supportedAnnotationTypes = new HashSet<String>(Arrays.asList(SuppressWarnings.class.getName()));

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        return false;
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotationMirror, ExecutableElement executableElement, String string) {
        TreeSet<? extends String> treeSet = new TreeSet<String>();
        for (String iterator : WELL_KNOWN) {
            treeSet.add(iterator);
        }
        for (HintMetadata hintMetadata : RulesManager.getInstance().allHints.keySet()) {
            treeSet.addAll(hintMetadata.suppressWarnings);
        }
        LinkedList linkedList = new LinkedList();
        for (String string2 : treeSet) {
            linkedList.add(new CompletionImpl(string2));
        }
        return linkedList;
    }

    @Override
    public Set<String> getSupportedOptions() {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return supportedAnnotationTypes;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public void init(ProcessingEnvironment processingEnvironment) {
    }

    private final class CompletionImpl
    implements Completion {
        private final String value;
        private final String message;

        public CompletionImpl(String string) {
            this(string, null);
        }

        public CompletionImpl(String string, String string2) {
            this.value = string;
            this.message = string2;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }
}

