/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.java.hints.jackpot.spi.support.OneCheckboxCustomizerProvider;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class EqualsHint {
    private static final String ERASURE_PREFS_KEY = "eguals-hint-erasure";
    private static final boolean ERASURE_PREFS_DEFAULT = true;

    public static ErrorDescription arrayEquals(HintContext hintContext) {
        TreePath treePath = hintContext.getVariables().get("$arr");
        TypeMirror typeMirror = hintContext.getInfo().getTrees().getTypeMirror(treePath);
        if (typeMirror == null || typeMirror.getKind() != TypeKind.ARRAY) {
            return null;
        }
        String string = NbBundle.getMessage(EqualsHint.class, (String)"FIX_ReplaceWithArraysEquals");
        Fix fix = JavaFix.rewriteFix(hintContext, string, hintContext.getPath(), "java.util.Arrays.equals($obj, $arr)", new String[0]);
        String string2 = NbBundle.getMessage(EqualsHint.class, (String)"FIX_ReplaceWithInstanceEquals");
        Fix fix2 = JavaFix.rewriteFix(hintContext, string2, hintContext.getPath(), "$obj == $arr", new String[0]);
        String string3 = NbBundle.getMessage(EqualsHint.class, (String)"ERR_ARRAY_EQUALS");
        return ErrorDescriptionFactory.forName(hintContext, hintContext.getPath(), string3, fix, fix2);
    }

    public static ErrorDescription incompatibleEquals(HintContext hintContext) {
        boolean bl;
        Object object;
        TypeMirror typeMirror;
        TreePath treePath = hintContext.getVariables().get("$this");
        TreePath treePath2 = hintContext.getVariables().get("$par");
        if (treePath != null) {
            typeMirror = hintContext.getInfo().getTrees().getTypeMirror(treePath);
        } else {
            for (object = hintContext.getPath(); object != null && ((TreePath)object).getLeaf().getKind() != Tree.Kind.CLASS; object = ((TreePath)object).getParentPath()) {
            }
            if (object == null) {
                return null;
            }
            typeMirror = hintContext.getInfo().getTrees().getTypeMirror((TreePath)object);
            if (typeMirror == null || typeMirror.getKind() != TypeKind.DECLARED) {
                return null;
            }
        }
        object = hintContext.getInfo().getTrees().getTypeMirror(treePath2);
        if (hintContext.getPreferences().getBoolean(ERASURE_PREFS_KEY, true)) {
            Types types = hintContext.getInfo().getTypes();
            typeMirror = types.erasure(typeMirror);
            object = types.erasure((TypeMirror)object);
        }
        boolean bl2 = bl = hintContext.getInfo().getTypeUtilities().isCastable(typeMirror, (TypeMirror)object) || hintContext.getInfo().getTypeUtilities().isCastable((TypeMirror)object, typeMirror);
        if (bl) {
            return null;
        }
        String string = NbBundle.getMessage(EqualsHint.class, (String)"ERR_INCOMPATIBLE_EQUALS");
        return ErrorDescriptionFactory.forName(hintContext, hintContext.getPath(), string, new Fix[0]);
    }

    public static final class CustomizerProviderImpl
    extends OneCheckboxCustomizerProvider {
        public CustomizerProviderImpl() {
            super(NbBundle.getMessage(EqualsHint.class, (String)"LBL_Customizer_IncompatibleEquals"), NbBundle.getMessage(EqualsHint.class, (String)"TP_Customizer_IncompatibleEquals"), EqualsHint.ERASURE_PREFS_KEY, true);
        }
    }
}

