/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.cnd.debugger.gdb.Field;
import org.netbeans.modules.cnd.debugger.gdb.Variable;
import org.netbeans.modules.cnd.debugger.gdb.models.AbstractVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.GdbWatchVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.WatchesTreeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.PasteType;

public class VariablesNodeModel
implements ExtendedNodeModel {
    public static final String FIELD = "org/netbeans/modules/debugger/resources/watchesView/Field.gif";
    public static final String LOCAL = "org/netbeans/modules/debugger/resources/localsView/LocalVariable.gif";
    public static final String WATCH = "org/netbeans/modules/debugger/resources/watchesView/watch_16.png";
    public static final String ERROR = "org/netbeans/modules/cnd/debugger/common/resources/error_small_16.png";
    private final RequestProcessor evaluationRP = new RequestProcessor();
    private final Collection<ModelListener> modelListeners = new HashSet<ModelListener>();
    private final String LC_NoInfo = NbBundle.getMessage(VariablesNodeModel.class, (String)"CTL_No_Info");
    private final String LC_NoCurrentThreadVar = NbBundle.getMessage(VariablesNodeModel.class, (String)"NoCurrentThreadVar");
    private final String LC_LocalsModelColumnNameName = NbBundle.getMessage(VariablesNodeModel.class, (String)"CTL_LocalsModel_Column_Name_Name");
    private final String LC_LocalsModelColumnNameDesc = NbBundle.getMessage(VariablesNodeModel.class, (String)"CTL_LocalsModel_Column_Name_Desc");
    private static final String strNoInfo = "NoInfo";
    private static final String strSubArray = "SubArray";
    private static final String strNoCurrentThread = "No current thread";
    private final Map<Object, String> shortDescriptionMap = new HashMap<Object, String>();

    public VariablesNodeModel(ContextProvider lookupProvider) {
    }

    public String getDisplayName(Object o) throws UnknownTypeException {
        if (o == "Root") {
            return this.LC_LocalsModelColumnNameName;
        }
        if (o instanceof Variable) {
            return ((Variable)o).getName();
        }
        String str = o.toString();
        if (str.equals(strNoInfo)) {
            return this.LC_NoInfo;
        }
        if (str.equals(strNoCurrentThread)) {
            return this.LC_NoCurrentThreadVar;
        }
        if (str.startsWith(strSubArray)) {
            int index = str.indexOf(45);
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"CTL_LocalsModel_Column_Name_SubArray", (Object)str.substring(8, index), (Object)str.substring(index + 1));
        }
        throw new UnknownTypeException(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortDescription(final Object o) throws UnknownTypeException {
        Map<Object, String> map = this.shortDescriptionMap;
        synchronized (map) {
            String shortDescription = this.shortDescriptionMap.remove(o);
            if (shortDescription instanceof String) {
                return shortDescription;
            }
            if (shortDescription instanceof UnknownTypeException) {
                throw (UnknownTypeException)((Object)shortDescription);
            }
        }
        this.testKnown(o);
        this.evaluationRP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String shortDescription = VariablesNodeModel.this.getShortDescriptionSync(o);
                if (shortDescription != null && shortDescription.length() > 0) {
                    Map map = VariablesNodeModel.this.shortDescriptionMap;
                    synchronized (map) {
                        VariablesNodeModel.this.shortDescriptionMap.put(o, shortDescription);
                    }
                    VariablesNodeModel.this.fireModelChange((ModelEvent)new ModelEvent.NodeChanged((Object)VariablesNodeModel.this, o, 4));
                }
            }
        });
        return "";
    }

    private String getShortDescriptionSync(Object o) {
        if (o == "Root") {
            return this.LC_LocalsModelColumnNameDesc;
        }
        if (o instanceof Variable) {
            Variable v = (Variable)o;
            if (o instanceof Field && v.getType().length() == 0 && v.getValue().equals("...")) {
                return NbBundle.getMessage(VariablesNodeModel.class, (String)"LBL_TruncatedByGdb");
            }
            return "(" + v.getType() + ") " + v.getValue();
        }
        String str = o.toString();
        if (str.startsWith(strSubArray)) {
            int index = str.indexOf(45);
            return NbBundle.getMessage(VariablesNodeModel.class, (String)"CTL_LocalsModel_Column_Descr_SubArray", (Object)str.substring(8, index), (Object)str.substring(index + 1));
        }
        if (str.equals(strNoInfo)) {
            return this.LC_NoInfo;
        }
        if (str.equals(strNoCurrentThread)) {
            return this.LC_NoCurrentThreadVar;
        }
        return "";
    }

    private void testKnown(Object o) throws UnknownTypeException {
        if (o == "Root" || o instanceof Variable) {
            return;
        }
        String str = o.toString();
        if (str.startsWith(strSubArray) || str.equals(strNoInfo) || str.equals(strNoCurrentThread)) {
            return;
        }
        throw new UnknownTypeException(o);
    }

    public String getIconBase(Object o) throws UnknownTypeException {
        throw new UnsupportedOperationException();
    }

    public String getIconBaseWithExtension(Object node) throws UnknownTypeException {
        if (node == "Root" || node instanceof GdbWatchVariable || node instanceof Watch) {
            return WATCH;
        }
        if (node instanceof WatchesTreeModel.EmptyWatch) {
            return null;
        }
        if (node instanceof Field) {
            if (node instanceof AbstractVariable.ErrorField) {
                return ERROR;
            }
            return FIELD;
        }
        if (node instanceof AbstractVariable) {
            return LOCAL;
        }
        String str = node.toString();
        if (str.startsWith(strSubArray)) {
            return LOCAL;
        }
        if (str.equals(strNoInfo) || str.equals(strNoCurrentThread)) {
            return null;
        }
        throw new UnknownTypeException(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        Collection<ModelListener> collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        Collection<ModelListener> collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelChange(ModelEvent me) {
        Object[] listeners;
        Collection<ModelListener> collection = this.modelListeners;
        synchronized (collection) {
            listeners = this.modelListeners.toArray();
        }
        for (int i = 0; i < listeners.length; ++i) {
            ((ModelListener)listeners[i]).modelChanged(me);
        }
    }

    public boolean canRename(Object node) throws UnknownTypeException {
        if (node instanceof WatchesTreeModel.EmptyWatch) {
            return true;
        }
        return node instanceof GdbWatchVariable;
    }

    public boolean canCopy(Object node) throws UnknownTypeException {
        return false;
    }

    public boolean canCut(Object node) throws UnknownTypeException {
        return false;
    }

    public Transferable clipboardCopy(Object node) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException();
    }

    public Transferable clipboardCut(Object node) throws IOException, UnknownTypeException {
        throw new UnsupportedOperationException();
    }

    public PasteType[] getPasteTypes(Object node, Transferable t) throws UnknownTypeException {
        return null;
    }

    public void setName(Object node, String name) throws UnknownTypeException {
        if (node instanceof GdbWatchVariable) {
            ((GdbWatchVariable)node).getWatch().setExpression(name);
            return;
        }
        if (node instanceof WatchesTreeModel.EmptyWatch) {
            ((WatchesTreeModel.EmptyWatch)node).setExpression(name);
            return;
        }
        throw new UnknownTypeException(node);
    }
}

