/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.disassembly;

import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.cnd.debugger.common.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.common.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.common.disassembly.DisassemblyService;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.BreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.disassembly.Disassembly;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotation;

public class GdbDisassemblyService
implements DisassemblyService {
    public int getAddressLine(String address) {
        Disassembly dis = Disassembly.getCurrent();
        if (dis == null) {
            return -1;
        }
        return dis.getAddressLine(address);
    }

    public int getBreakpointLine(AddressBreakpoint b) {
        BreakpointImpl<?> bptImpl;
        int res = this.getAddressLine(b.getAddress());
        if (res < 1 && (bptImpl = GdbDebugger.getBreakpointImpl((Breakpoint)b)) != null) {
            return Disassembly.getCurrent().getAddressLine(bptImpl.getAddress());
        }
        return res;
    }

    public String getLineAddress(int lineNo) {
        Disassembly dis = Disassembly.getCurrent();
        if (dis == null) {
            return null;
        }
        return dis.getLineAddress(lineNo);
    }

    public boolean isDis(String url) {
        return Disassembly.isDisasm(url);
    }

    public boolean showBreakpoint(AddressBreakpoint b) {
        return this.showLine(this.getBreakpointLine(b));
    }

    private boolean showLine(int line) {
        if (line != -1) {
            FileObject fo = Disassembly.getFileObject();
            if (fo != null) {
                try {
                    return EditorContextBridge.getContext().showSource(DataObject.find((FileObject)fo), line, null);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {}
            }
        } else {
            Disassembly.open();
        }
        return false;
    }

    public boolean showAddress(String address) {
        return this.showLine(this.getAddressLine(address));
    }

    public Annotation annotateAddress(String address, String annotationType) {
        FileObject fo;
        Disassembly dis = Disassembly.getCurrent();
        if (dis == null) {
            return null;
        }
        int line = dis.getAddressLine(address);
        if (line != -1 && (fo = Disassembly.getFileObject()) != null) {
            try {
                return EditorContextBridge.getContext().annotate(DataObject.find((FileObject)fo), line, annotationType, null);
            }
            catch (DataObjectNotFoundException dex) {
                // empty catch block
            }
        }
        return null;
    }
}

