/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.cnd.debugger.common.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.AddressBreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.BreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.FunctionBreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.LineBreakpointImpl;
import org.netbeans.spi.debugger.ContextProvider;

public class BreakpointsEngineListener
extends LazyActionsManagerListener
implements PropertyChangeListener,
DebuggerManagerListener {
    private final GdbDebugger debugger;
    private final Map<Breakpoint, BreakpointImpl<?>> breakpointToImpl = new HashMap();
    private static final Logger log = Logger.getLogger("gdb.breakpoints.logger");

    public BreakpointsEngineListener(ContextProvider lookupProvider) {
        this.debugger = (GdbDebugger)lookupProvider.lookupFirst(null, GdbDebugger.class);
        this.debugger.addPropertyChangeListener(this);
    }

    protected void destroy() {
        this.debugger.removePropertyChangeListener(this);
        DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        this.removeBreakpointImpls();
    }

    public String[] getProperties() {
        return new String[]{"asd"};
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String pname = evt.getPropertyName();
        if (pname.equals("state")) {
            if (evt.getNewValue() == GdbDebugger.State.LOADING) {
                int count = this.createBreakpointImpls();
                DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
                if (count == 0) {
                    this.debugger.setReady();
                }
            }
        } else if (pname.equals("sharedLibLoaded")) {
            assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
            this.sharedLibLoaded();
        }
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        this.createBreakpointImpl(breakpoint);
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        this.removeBreakpointImpl(breakpoint);
    }

    private int createBreakpointImpls() {
        int count = 0;
        for (Breakpoint bp : DebuggerManager.getDebuggerManager().getBreakpoints()) {
            if (!(bp instanceof CndBreakpoint)) continue;
            this.createBreakpointImpl(bp);
            ++count;
        }
        return count;
    }

    private void createBreakpointImpl(Breakpoint b) {
        if (this.breakpointToImpl.containsKey(b)) {
            return;
        }
        BreakpointImpl impl = null;
        if (b instanceof LineBreakpoint) {
            impl = new LineBreakpointImpl((LineBreakpoint)b, this.debugger);
        } else if (b instanceof FunctionBreakpoint) {
            impl = new FunctionBreakpointImpl((FunctionBreakpoint)b, this.debugger);
        } else if (b instanceof AddressBreakpoint) {
            impl = new AddressBreakpointImpl((AddressBreakpoint)b, this.debugger);
        }
        if (impl != null) {
            this.breakpointToImpl.put(b, impl);
        }
        log.finer("BreakpointsEngineListener: created impl " + impl + " for " + b);
    }

    private void removeBreakpointImpls() {
        for (Breakpoint bp : DebuggerManager.getDebuggerManager().getBreakpoints()) {
            if (!(bp instanceof CndBreakpoint)) continue;
            this.removeBreakpointImpl(bp);
        }
    }

    private void removeBreakpointImpl(Breakpoint b) {
        BreakpointImpl<?> impl = this.breakpointToImpl.remove(b);
        if (impl != null) {
            impl.remove();
            log.finer("BreakpointsEngineListener: removed impl " + impl + " for " + b);
        }
    }

    private void sharedLibLoaded() {
        for (Breakpoint bp : DebuggerManager.getDebuggerManager().getBreakpoints()) {
            BreakpointImpl<?> impl;
            if (bp.getValidity() != Breakpoint.VALIDITY.INVALID || (impl = this.breakpointToImpl.get(bp)) == null) continue;
            impl.revalidate();
        }
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void engineAdded(DebuggerEngine engine) {
    }

    public void engineRemoved(DebuggerEngine engine) {
    }
}

