/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.version;

import hidden.org.codehaus.plexus.util.StringUtils;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.metadata.ResolutionGroup;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.Restriction;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.errors.ExtensionErrorReporterAspect;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.InvalidPluginException;
import org.apache.maven.plugin.version.PluginVersionManager;
import org.apache.maven.plugin.version.PluginVersionNotFoundException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class DefaultPluginVersionManager
extends AbstractLogEnabled
implements PluginVersionManager {
    private ArtifactFactory artifactFactory;
    private ArtifactMetadataSource artifactMetadataSource;
    private MavenProjectBuilder mavenProjectBuilder;
    private RuntimeInformation runtimeInformation;

    public String resolvePluginVersion(String groupId, String artifactId, MavenProject project, MavenSession session) throws PluginVersionResolutionException, InvalidPluginException, PluginVersionNotFoundException {
        return this.resolvePluginVersion(groupId, artifactId, project, session.getLocalRepository(), false);
    }

    public String resolveReportPluginVersion(String groupId, String artifactId, MavenProject project, MavenSession session) throws PluginVersionResolutionException, InvalidPluginException, PluginVersionNotFoundException {
        return this.resolvePluginVersion(groupId, artifactId, project, session.getLocalRepository(), true);
    }

    private String resolvePluginVersion(String groupId, String artifactId, MavenProject project, ArtifactRepository localRepository, boolean resolveAsReportPlugin) throws PluginVersionResolutionException, InvalidPluginException, PluginVersionNotFoundException {
        String version = this.getVersionFromPluginConfig(groupId, artifactId, project, resolveAsReportPlugin);
        this.getLogger().debug("Version from POM: " + version);
        if (version == null && project.getProjectReferences() != null) {
            String refId = ArtifactUtils.versionlessKey(groupId, artifactId);
            MavenProject ref = (MavenProject)project.getProjectReferences().get(refId);
            if (ref != null) {
                version = ref.getVersion();
            }
        }
        this.getLogger().debug("Version from another POM in the reactor: " + version);
        if (StringUtils.isEmpty(version) || "LATEST".equals(version)) {
            version = this.resolveMetaVersion(groupId, artifactId, project, localRepository, "LATEST");
            this.getLogger().debug("Version from LATEST metadata: " + version);
        }
        if (StringUtils.isEmpty(version) || "RELEASE".equals(version)) {
            version = this.resolveMetaVersion(groupId, artifactId, project, localRepository, "RELEASE");
            this.getLogger().debug("Version from RELEASE metadata: " + version);
        }
        if (StringUtils.isEmpty(version)) {
            throw new PluginVersionNotFoundException(groupId, artifactId);
        }
        return version;
    }

    private String getVersionFromPluginConfig(String groupId, String artifactId, MavenProject project, boolean resolveAsReportPlugin) {
        String version;
        block4: {
            block3: {
                version = null;
                if (!resolveAsReportPlugin) break block3;
                if (project.getReportPlugins() == null) break block4;
                Iterator it = project.getReportPlugins().iterator();
                while (it.hasNext() && version == null) {
                    ReportPlugin plugin = (ReportPlugin)it.next();
                    if (!groupId.equals(plugin.getGroupId()) || !artifactId.equals(plugin.getArtifactId())) continue;
                    version = plugin.getVersion();
                }
                break block4;
            }
            if (project.getBuildPlugins() != null) {
                Iterator it = project.getBuildPlugins().iterator();
                while (it.hasNext() && version == null) {
                    Plugin plugin = (Plugin)it.next();
                    if (!groupId.equals(plugin.getGroupId()) || !artifactId.equals(plugin.getArtifactId())) continue;
                    version = plugin.getVersion();
                }
            }
        }
        return version;
    }

    private String resolveMetaVersion(String groupId, String artifactId, MavenProject project, ArtifactRepository localRepository, String metaVersionId) throws PluginVersionResolutionException, InvalidPluginException {
        String string;
        try {
            this.getLogger().info("Attempting to resolve a version for plugin: " + groupId + ":" + artifactId + " using meta-version: " + metaVersionId);
            Artifact artifact = this.artifactFactory.createProjectArtifact(groupId, artifactId, metaVersionId);
            artifact.getDependencyConflictId();
            String version = null;
            try {
                ResolutionGroup resolutionGroup;
                try {
                    resolutionGroup = this.artifactMetadataSource.retrieve(artifact, localRepository, project.getRemoteArtifactRepositories());
                }
                catch (ArtifactMetadataRetrievalException artifactMetadataRetrievalException) {
                    if (ExtensionErrorReporterAspect.ajc$cflowStack$2.isValid() && ExtensionErrorReporterAspect.ajc$cflowCounter$3.isValid()) {
                        ExtensionErrorReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_errors_ExtensionErrorReporterAspect$10$5844b31c((Plugin)ExtensionErrorReporterAspect.ajc$cflowStack$2.get(0), (Model)ExtensionErrorReporterAspect.ajc$cflowStack$2.get(1), (List)ExtensionErrorReporterAspect.ajc$cflowStack$2.get(2), (MavenExecutionRequest)ExtensionErrorReporterAspect.ajc$cflowStack$2.get(3), artifactMetadataRetrievalException);
                    }
                    throw artifactMetadataRetrievalException;
                }
                ResolutionGroup resolutionGroup2 = resolutionGroup;
                artifact = resolutionGroup2.getPomArtifact();
            }
            catch (ArtifactMetadataRetrievalException e) {
                throw new PluginVersionResolutionException(groupId, artifactId, e.getMessage(), e);
            }
            String artifactVersion = artifact.getVersion();
            if (!metaVersionId.equals(artifactVersion) && artifact.getFile() != null) {
                boolean pluginValid = false;
                while (!pluginValid && artifactVersion != null) {
                    VersionRange vr;
                    VersionRange mavenRange;
                    String mavenVersion;
                    block32: {
                        MavenProject pluginProject;
                        pluginValid = true;
                        try {
                            artifact = this.artifactFactory.createProjectArtifact(groupId, artifactId, artifactVersion);
                            pluginProject = this.mavenProjectBuilder.buildFromRepository(artifact, project.getRemoteArtifactRepositories(), localRepository);
                        }
                        catch (ProjectBuildingException e) {
                            throw new InvalidPluginException("Unable to build project information for plugin '" + ArtifactUtils.versionlessKey(groupId, artifactId) + "': " + e.getMessage(), e);
                        }
                        if (pluginProject.getPrerequisites() == null) continue;
                        String string2 = pluginProject.getPrerequisites().getMaven();
                        ExtensionErrorReporterAspect.aspectOf().ajc$afterReturning$org_apache_maven_errors_ExtensionErrorReporterAspect$11$2004f911(string2);
                        if (string2 == null) continue;
                        String string3 = pluginProject.getPrerequisites().getMaven();
                        ExtensionErrorReporterAspect.aspectOf().ajc$afterReturning$org_apache_maven_errors_ExtensionErrorReporterAspect$11$2004f911(string3);
                        mavenVersion = string3;
                        mavenRange = null;
                        try {
                            VersionRange versionRange;
                            VersionRange versionRange2;
                            try {
                                versionRange2 = VersionRange.createFromVersionSpec(mavenVersion);
                            }
                            catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
                                if (ExtensionErrorReporterAspect.ajc$cflowStack$2.isValid() && ExtensionErrorReporterAspect.ajc$cflowCounter$3.isValid()) {
                                    ExtensionErrorReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_errors_ExtensionErrorReporterAspect$15$f63e085c((Plugin)ExtensionErrorReporterAspect.ajc$cflowStack$2.get(0), (Model)ExtensionErrorReporterAspect.ajc$cflowStack$2.get(1), (List)ExtensionErrorReporterAspect.ajc$cflowStack$2.get(2), (MavenExecutionRequest)ExtensionErrorReporterAspect.ajc$cflowStack$2.get(3), invalidVersionSpecificationException);
                                }
                                throw invalidVersionSpecificationException;
                            }
                            mavenRange = versionRange2;
                            List restrictions = mavenRange.getRestrictions();
                            if (restrictions.size() != 1 || !Restriction.EVERYTHING.equals(restrictions.get(0))) break block32;
                            String range = "[" + mavenVersion + ",]";
                            this.getLogger().debug("Plugin: " + pluginProject.getId() + " specifies a simple prerequisite Maven version of: " + mavenVersion + ". This version has been translated into the range: " + range + " for plugin-version resolution purposes.");
                            try {
                                versionRange = VersionRange.createFromVersionSpec(range);
                            }
                            catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
                                if (ExtensionErrorReporterAspect.ajc$cflowStack$2.isValid() && ExtensionErrorReporterAspect.ajc$cflowCounter$3.isValid()) {
                                    ExtensionErrorReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_errors_ExtensionErrorReporterAspect$15$f63e085c((Plugin)ExtensionErrorReporterAspect.ajc$cflowStack$2.get(0), (Model)ExtensionErrorReporterAspect.ajc$cflowStack$2.get(1), (List)ExtensionErrorReporterAspect.ajc$cflowStack$2.get(2), (MavenExecutionRequest)ExtensionErrorReporterAspect.ajc$cflowStack$2.get(3), invalidVersionSpecificationException);
                                }
                                throw invalidVersionSpecificationException;
                            }
                            mavenRange = versionRange;
                        }
                        catch (InvalidVersionSpecificationException e) {
                            this.getLogger().debug("Invalid prerequisite Maven version: " + mavenVersion + " for plugin: " + pluginProject.getId() + e.getMessage());
                        }
                    }
                    if (mavenRange == null) continue;
                    ArtifactVersion artifactVersion2 = this.runtimeInformation.getApplicationVersion();
                    ExtensionErrorReporterAspect.aspectOf().ajc$afterReturning$org_apache_maven_errors_ExtensionErrorReporterAspect$12$319be33e(artifactVersion2);
                    if (mavenRange.containsVersion(artifactVersion2)) continue;
                    this.getLogger().info("Ignoring available plugin version: " + artifactVersion + " for: " + groupId + ":" + artifactId + " as it requires Maven version matching: " + mavenVersion);
                    try {
                        VersionRange versionRange;
                        try {
                            versionRange = VersionRange.createFromVersionSpec("(," + artifactVersion + ")");
                        }
                        catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
                            if (ExtensionErrorReporterAspect.ajc$cflowStack$2.isValid() && ExtensionErrorReporterAspect.ajc$cflowCounter$3.isValid()) {
                                ExtensionErrorReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_errors_ExtensionErrorReporterAspect$15$f63e085c((Plugin)ExtensionErrorReporterAspect.ajc$cflowStack$2.get(0), (Model)ExtensionErrorReporterAspect.ajc$cflowStack$2.get(1), (List)ExtensionErrorReporterAspect.ajc$cflowStack$2.get(2), (MavenExecutionRequest)ExtensionErrorReporterAspect.ajc$cflowStack$2.get(3), invalidVersionSpecificationException);
                            }
                            throw invalidVersionSpecificationException;
                        }
                        vr = versionRange;
                    }
                    catch (InvalidVersionSpecificationException e) {
                        throw new PluginVersionResolutionException(groupId, artifactId, "Error getting available plugin versions: " + e.getMessage(), e);
                    }
                    this.getLogger().debug("Trying " + vr);
                    try {
                        List<ArtifactVersion> list;
                        try {
                            list = this.artifactMetadataSource.retrieveAvailableVersions(artifact, localRepository, project.getRemoteArtifactRepositories());
                        }
                        catch (ArtifactMetadataRetrievalException artifactMetadataRetrievalException) {
                            if (ExtensionErrorReporterAspect.ajc$cflowStack$2.isValid() && ExtensionErrorReporterAspect.ajc$cflowCounter$3.isValid()) {
                                ExtensionErrorReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_errors_ExtensionErrorReporterAspect$16$623f7070((Plugin)ExtensionErrorReporterAspect.ajc$cflowStack$2.get(0), (Model)ExtensionErrorReporterAspect.ajc$cflowStack$2.get(1), (List)ExtensionErrorReporterAspect.ajc$cflowStack$2.get(2), (MavenExecutionRequest)ExtensionErrorReporterAspect.ajc$cflowStack$2.get(3), artifactMetadataRetrievalException);
                            }
                            throw artifactMetadataRetrievalException;
                        }
                        List<ArtifactVersion> versions = list;
                        ArtifactVersion v = vr.matchVersion(versions);
                        artifactVersion = v != null ? v.toString() : null;
                    }
                    catch (ArtifactMetadataRetrievalException e) {
                        throw new PluginVersionResolutionException(groupId, artifactId, "Error getting available plugin versions: " + e.getMessage(), e);
                    }
                    if (artifactVersion != null) {
                        this.getLogger().debug("Found " + artifactVersion);
                        continue;
                    }
                    pluginValid = false;
                }
                version = artifactVersion;
            }
            if (version != null) {
                this.getLogger().info("Using version: " + version + " of plugin: " + groupId + ":" + artifactId);
            }
            string = version;
        }
        finally {
            ExtensionErrorReporterAspect.aspectOf().ajc$after$org_apache_maven_errors_ExtensionErrorReporterAspect$14$ce289d76();
        }
        return string;
    }
}

