/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CLIManager {
    public static final char ALTERNATE_POM_FILE = 'f';
    public static final char BATCH_MODE = 'B';
    public static final char SET_SYSTEM_PROPERTY = 'D';
    public static final char OFFLINE = 'o';
    public static final char REACTOR = 'r';
    public static final char QUIET = 'q';
    public static final char DEBUG = 'X';
    public static final char ERRORS = 'e';
    public static final char HELP = 'h';
    public static final char VERSION = 'v';
    public static final char NON_RECURSIVE = 'N';
    public static final char UPDATE_SNAPSHOTS = 'U';
    public static final char ACTIVATE_PROFILES = 'P';
    public static final String FORCE_PLUGIN_UPDATES = "cpu";
    public static final String FORCE_PLUGIN_UPDATES2 = "up";
    public static final String SUPPRESS_PLUGIN_UPDATES = "npu";
    public static final String SUPPRESS_PLUGIN_REGISTRY = "npr";
    public static final String SUPRESS_SNAPSHOT_UPDATES = "nsu";
    public static final char CHECKSUM_FAILURE_POLICY = 'C';
    public static final char CHECKSUM_WARNING_POLICY = 'c';
    public static final char ALTERNATE_USER_SETTINGS = 's';
    public static final String FAIL_FAST = "ff";
    public static final String FAIL_AT_END = "fae";
    public static final String FAIL_NEVER = "fn";
    public static final String LOG_FILE = "l";
    private Options options = new Options();

    public CLIManager() {
        OptionBuilder.withLongOpt("file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Force the use of an alternate POM file.");
        this.options.addOption(OptionBuilder.create('f'));
        OptionBuilder.withLongOpt("define");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Define a system property");
        this.options.addOption(OptionBuilder.create('D'));
        OptionBuilder.withLongOpt("offline");
        OptionBuilder.withDescription("Work offline");
        this.options.addOption(OptionBuilder.create('o'));
        OptionBuilder.withLongOpt("help");
        OptionBuilder.withDescription("Display help information");
        this.options.addOption(OptionBuilder.create('h'));
        OptionBuilder.withLongOpt("version");
        OptionBuilder.withDescription("Display version information");
        this.options.addOption(OptionBuilder.create('v'));
        OptionBuilder.withLongOpt("quiet");
        OptionBuilder.withDescription("Quiet output - only show errors");
        this.options.addOption(OptionBuilder.create('q'));
        OptionBuilder.withLongOpt("debug");
        OptionBuilder.withDescription("Produce execution debug output");
        this.options.addOption(OptionBuilder.create('X'));
        OptionBuilder.withLongOpt("errors");
        OptionBuilder.withDescription("Produce execution error messages");
        this.options.addOption(OptionBuilder.create('e'));
        OptionBuilder.withLongOpt("reactor");
        OptionBuilder.withDescription("Execute goals for project found in the reactor");
        this.options.addOption(OptionBuilder.create('r'));
        OptionBuilder.withLongOpt("non-recursive");
        OptionBuilder.withDescription("Do not recurse into sub-projects");
        this.options.addOption(OptionBuilder.create('N'));
        OptionBuilder.withLongOpt("update-snapshots");
        OptionBuilder.withDescription("Forces a check for updated releases and snapshots on remote repositories");
        this.options.addOption(OptionBuilder.create('U'));
        OptionBuilder.withLongOpt("activate-profiles");
        OptionBuilder.withDescription("Comma-delimited list of profiles to activate");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create('P'));
        OptionBuilder.withLongOpt("batch-mode");
        OptionBuilder.withDescription("Run in non-interactive (batch) mode");
        this.options.addOption(OptionBuilder.create('B'));
        OptionBuilder.withLongOpt("check-plugin-updates");
        OptionBuilder.withDescription("Force upToDate check for any relevant registered plugins");
        this.options.addOption(OptionBuilder.create(FORCE_PLUGIN_UPDATES));
        OptionBuilder.withLongOpt("update-plugins");
        OptionBuilder.withDescription("Synonym for cpu");
        this.options.addOption(OptionBuilder.create(FORCE_PLUGIN_UPDATES2));
        OptionBuilder.withLongOpt("no-plugin-updates");
        OptionBuilder.withDescription("Suppress upToDate check for any relevant registered plugins");
        this.options.addOption(OptionBuilder.create(SUPPRESS_PLUGIN_UPDATES));
        OptionBuilder.withLongOpt("no-snapshot-updates");
        OptionBuilder.withDescription("Supress SNAPSHOT updates");
        this.options.addOption(OptionBuilder.create(SUPRESS_SNAPSHOT_UPDATES));
        OptionBuilder.withLongOpt("no-plugin-registry");
        OptionBuilder.withDescription("Don't use ~/.m2/plugin-registry.xml for plugin versions");
        this.options.addOption(OptionBuilder.create(SUPPRESS_PLUGIN_REGISTRY));
        OptionBuilder.withLongOpt("strict-checksums");
        OptionBuilder.withDescription("Fail the build if checksums don't match");
        this.options.addOption(OptionBuilder.create('C'));
        OptionBuilder.withLongOpt("lax-checksums");
        OptionBuilder.withDescription("Warn if checksums don't match");
        this.options.addOption(OptionBuilder.create('c'));
        OptionBuilder.withLongOpt("settings");
        OptionBuilder.withDescription("Alternate path for the user settings file");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create('s'));
        OptionBuilder.withLongOpt("fail-fast");
        OptionBuilder.withDescription("Stop at first failure in reactorized builds");
        this.options.addOption(OptionBuilder.create(FAIL_FAST));
        OptionBuilder.withLongOpt("fail-at-end");
        OptionBuilder.withDescription("Only fail the build afterwards; allow all non-impacted builds to continue");
        this.options.addOption(OptionBuilder.create(FAIL_AT_END));
        OptionBuilder.withLongOpt("fail-never");
        OptionBuilder.withDescription("NEVER fail the build, regardless of project result");
        this.options.addOption(OptionBuilder.create(FAIL_NEVER));
        OptionBuilder.withLongOpt("log-file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Log file to where all build output will go.");
        this.options.addOption(OptionBuilder.create(LOG_FILE));
    }

    public CommandLine parse(String[] args) throws ParseException {
        String[] cleanArgs = this.cleanArgs(args);
        GnuParser parser = new GnuParser();
        return parser.parse(this.options, cleanArgs);
    }

    private String[] cleanArgs(String[] args) {
        ArrayList<String> cleaned = new ArrayList<String>();
        StringBuffer currentArg = null;
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            boolean addedToBuffer = false;
            if (arg.startsWith("\"")) {
                if (currentArg != null) {
                    cleaned.add(currentArg.toString());
                }
                currentArg = new StringBuffer(arg.substring(1));
                addedToBuffer = true;
            }
            if (arg.endsWith("\"")) {
                String cleanArgPart = arg.substring(0, arg.length() - 1);
                if (currentArg != null) {
                    if (addedToBuffer) {
                        currentArg.setLength(currentArg.length() - 1);
                    } else {
                        currentArg.append(' ').append(cleanArgPart);
                    }
                    cleaned.add(currentArg.toString());
                } else {
                    cleaned.add(cleanArgPart);
                }
                currentArg = null;
            } else if (!addedToBuffer) {
                if (currentArg != null) {
                    currentArg.append(' ').append(arg);
                } else {
                    cleaned.add(arg);
                }
            }
            ++i;
        }
        if (currentArg != null) {
            cleaned.add(currentArg.toString());
        }
        int cleanedSz = cleaned.size();
        String[] cleanArgs = null;
        cleanArgs = cleanedSz == 0 ? args : cleaned.toArray(new String[cleanedSz]);
        return cleanArgs;
    }

    public void displayHelp() {
        System.out.println();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("mvn [options] [<goal(s)>] [<phase(s)>]", "\nOptions:", this.options, "\n");
    }
}

