/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.webmvc.editor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.spring.api.beans.SpringScope;
import org.netbeans.modules.spring.webmvc.editor.AddBeanPanel;
import org.netbeans.modules.spring.webmvc.editor.AddBeanPanelVisual;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class BeanCodeGenerator
implements CodeGenerator {
    private static final String BEANS_END_TAG = "</beans>";
    private static final String CONTEXT_CONFIG_LOCATION = "contextConfigLocation";
    private static final String DISPATCHER_SERVLET_NAME = "dispatcher-servlet";
    private static final String JAVA_MIME = "text/x-java";
    private Document document;
    private FileObject fileObject;

    private BeanCodeGenerator(JTextComponent jTextComponent) {
        this.document = jTextComponent.getDocument();
        this.fileObject = NbEditorUtilities.getFileObject((Document)this.document);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(BeanCodeGenerator.class, (String)"MSG_BeanCodeGenerator");
    }

    public void invoke() {
        AddBeanPanel addBeanPanel = new AddBeanPanel(this.document);
        AddBeanPanelVisual addBeanPanelVisual = new AddBeanPanelVisual(addBeanPanel);
        boolean bl = addBeanPanelVisual.showDialog();
        if (bl) {
            this.createBean(addBeanPanel.getId(), addBeanPanel.getClassName());
        }
    }

    private void insertBean(String string, FileObject fileObject) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (dataObject != null) {
                StyledDocument styledDocument;
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
                if (editorCookie != null && lineCookie != null && (styledDocument = editorCookie.openDocument()) != null) {
                    Line line;
                    int n = styledDocument.getText(0, styledDocument.getLength()).indexOf(BEANS_END_TAG) - 1;
                    styledDocument.insertString(n, string, null);
                    int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)(n += string.length()));
                    if (n2 != -1 && (line = lineCookie.getLineSet().getCurrent(n2)) != null) {
                        int n3 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n2);
                        int n4 = n - n3;
                        line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, n4);
                    }
                }
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    private void createBean(String string, String string2) {
        SpringScope springScope = SpringScope.getSpringScope((FileObject)this.fileObject);
        String string3 = System.getProperty("line.separator");
        String string4 = string3 + "    <bean id=\"" + string + "\" class=\"" + string2 + "\"/>";
        if (!JAVA_MIME.equals(this.fileObject.getMIMEType())) {
            File file = FileUtil.toFile((FileObject)this.fileObject);
            if (springScope.getConfigFileManager().getConfigFiles().contains(file)) {
                this.insertBean(string4, this.fileObject);
                return;
            }
        }
        for (File file : springScope.getConfigFileManager().getConfigFiles()) {
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (this.isDispatcherServlet(fileObject)) continue;
            this.insertBean(string4, fileObject);
            break;
        }
    }

    private boolean isDispatcherServlet(FileObject fileObject) {
        return fileObject.getName().equals(DISPATCHER_SERVLET_NAME);
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup lookup) {
            FileObject fileObject;
            WebModule webModule;
            JTextComponent jTextComponent = (JTextComponent)lookup.lookup(JTextComponent.class);
            ArrayList<BeanCodeGenerator> arrayList = new ArrayList<BeanCodeGenerator>();
            Document document = jTextComponent.getDocument();
            if (document != null && (webModule = WebModule.getWebModule((FileObject)(fileObject = NbEditorUtilities.getFileObject((Document)document)))) != null && this.springConfigExist(webModule)) {
                arrayList.add(new BeanCodeGenerator(jTextComponent));
            }
            return arrayList;
        }

        private boolean springConfigExist(WebModule webModule) {
            FileObject fileObject = webModule.getDeploymentDescriptor();
            if (fileObject == null) {
                return false;
            }
            try {
                InitParam[] initParamArray;
                WebApp webApp = DDProvider.getDefault().getDDRoot(fileObject);
                for (InitParam initParam : initParamArray = webApp.getContextParam()) {
                    if (!initParam.getParamName().startsWith(BeanCodeGenerator.CONTEXT_CONFIG_LOCATION)) continue;
                    return true;
                }
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.INFO, null, iOException);
            }
            return false;
        }
    }
}

