/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.webmvc.editor;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.openide.util.Exceptions;

public class AddBeanPanel {
    private Document document;
    private String className;
    private String id;

    AddBeanPanel(Document document) {
        this.document = document;
    }

    Document getDocument() {
        return this.document;
    }

    void setId(String string) {
        this.id = string;
    }

    public String getClassName() {
        if (this.className == null) {
            this.className = this.findClassName();
        }
        return this.className;
    }

    void setClassName(String string) {
        this.className = string;
    }

    public String getId() {
        if (this.id == null) {
            String string = this.getClassName();
            if (string == null) {
                return null;
            }
            this.id = string.substring(string.lastIndexOf(".") + 1);
        }
        return this.id;
    }

    private String findClassName() {
        final String[] stringArray = new String[1];
        JavaSource javaSource = JavaSource.forDocument((Document)this.document);
        if (javaSource == null) {
            return null;
        }
        try {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    Document document = compilationController.getDocument();
                    if (document != null) {
                        ExpressionTree expressionTree = compilationController.getCompilationUnit().getPackageName();
                        if (expressionTree != null) {
                            stringArray[0] = expressionTree.accept(new TreePathScanner<String, Void>(){

                                @Override
                                public String visitIdentifier(IdentifierTree identifierTree, Void void_) {
                                    return identifierTree.getName().toString();
                                }
                            }, null) + ".";
                        }
                        String string = (String)new ClassScanner().scan(compilationController.getCompilationUnit(), null);
                        stringArray[0] = stringArray[0] == null ? string : stringArray[0] + string;
                    }
                }
            }, true);
            return stringArray[0];
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }

    private class ClassScanner
    extends TreePathScanner<String, Void> {
        private ClassScanner() {
        }

        @Override
        public String visitClass(ClassTree classTree, Void void_) {
            return classTree.getSimpleName().toString();
        }
    }
}

