/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.common;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.tx.common.LocalizationMessages;
import com.sun.xml.ws.tx.common.TxLogger;
import com.sun.xml.ws.tx.coordinator.CoordinationContextBase;
import com.sun.xml.ws.tx.coordinator.CoordinationContextInterface;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class Message {
    private static final TxLogger logger = TxLogger.getLogger(Message.class);
    private final com.sun.xml.ws.api.message.Message coreMessage;
    private final HeaderList hdrList;
    private SOAPVersion SOAP_VERSION;
    private AddressingVersion ADDRESSING_VERSION;
    private Header ccHdr = null;
    private static final int NOT_FOUND = -1;
    private int ccHdrIndex = -1;
    private CoordinationContextInterface cc = null;

    public Message(@NotNull com.sun.xml.ws.api.message.Message message, WSBinding wsBinding) {
        this.coreMessage = message;
        this.hdrList = message == null ? null : message.getHeaders();
        this.SOAP_VERSION = wsBinding == null ? null : wsBinding.getSOAPVersion();
        this.ADDRESSING_VERSION = wsBinding == null ? null : wsBinding.getAddressingVersion();
    }

    public Message(@NotNull com.sun.xml.ws.api.message.Message message) {
        this(message, null);
    }

    @NotNull
    public Header getCoordCtxHeader() {
        if (this.ccHdr == null && this.hdrList != null) {
            this.ccHdr = this.hdrList.get("http://schemas.xmlsoap.org/ws/2004/10/wscoor", "CoordinationContext", false);
        }
        return this.ccHdr;
    }

    @Nullable
    public Header getCoordCtxHeader(@NotNull String namespace, @NotNull String localName) {
        if (this.ccHdr == null && this.coreMessage != null) {
            this.ccHdrIndex = -1;
            int len = this.hdrList.size();
            for (int i = 0; i < len; ++i) {
                Header h = this.hdrList.get(i);
                if (!h.getLocalPart().equals(localName) || !h.getNamespaceURI().equals(namespace)) continue;
                this.ccHdrIndex = i;
                this.ccHdr = h;
                break;
            }
        }
        return this.ccHdr;
    }

    @Nullable
    public CoordinationContextInterface getCoordinationContext(@NotNull Unmarshaller unmarshaller) throws JAXBException {
        Header ccHdr;
        if (this.cc == null && (ccHdr = this.getCoordCtxHeader("http://schemas.xmlsoap.org/ws/2004/10/wscoor", "CoordinationContext")) != null) {
            try {
                this.cc = CoordinationContextBase.createCoordinationContext(ccHdr.readAsJAXB(unmarshaller));
            }
            catch (JAXBException e) {
                logger.warning("getCoordinationContext", LocalizationMessages.CANNOT_UNMARSHAL_CONTEXT_2000(e.getLocalizedMessage()));
                throw e;
            }
        }
        return this.cc;
    }

    public void setCoordCtxUnderstood() {
        if (this.ccHdr != null && this.ccHdrIndex != -1) {
            this.coreMessage.getHeaders().understood(this.ccHdrIndex);
        }
    }

    @Nullable
    public WSDLBoundOperation getOperation(@NotNull WSDLPort port) {
        return this.coreMessage.getOperation(port);
    }

    public String getMessageID() {
        String result = null;
        if (this.hdrList != null && this.ADDRESSING_VERSION != null && this.SOAP_VERSION != null) {
            result = this.hdrList.getMessageID(this.ADDRESSING_VERSION, this.SOAP_VERSION);
        }
        return result;
    }

    public String getTo() {
        String result = null;
        if (this.hdrList != null && this.ADDRESSING_VERSION != null && this.SOAP_VERSION != null) {
            result = this.hdrList.getTo(this.ADDRESSING_VERSION, this.SOAP_VERSION);
        }
        return result;
    }

    public String getAction() {
        String result = null;
        if (this.hdrList != null && this.ADDRESSING_VERSION != null && this.SOAP_VERSION != null) {
            result = this.hdrList.getAction(this.ADDRESSING_VERSION, this.SOAP_VERSION);
        }
        return result;
    }

    public WSEndpointReference getFaultTo() {
        WSEndpointReference result = null;
        if (this.hdrList != null && this.ADDRESSING_VERSION != null && this.SOAP_VERSION != null) {
            result = this.hdrList.getFaultTo(this.ADDRESSING_VERSION, this.SOAP_VERSION);
        }
        return result;
    }

    public WSEndpointReference getReplyTo() {
        WSEndpointReference result = null;
        if (this.hdrList != null && this.ADDRESSING_VERSION != null && this.SOAP_VERSION != null) {
            result = this.hdrList.getReplyTo(this.ADDRESSING_VERSION, this.SOAP_VERSION);
        }
        return result;
    }
}

