/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.platform;

import java.io.File;
import java.util.prefs.Preferences;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public class PlatformSettings {
    private static final PlatformSettings INSTANCE = new PlatformSettings();
    private static final String PROP_PLATFORMS_FOLDER = "platformsFolder";
    private static final String APPLE_JAVAVM_FRAMEWORK_PATH = "/System/Library/Frameworks/JavaVM.framework/Versions/";

    public String displayName() {
        return NbBundle.getMessage(PlatformSettings.class, (String)"TXT_PlatformSettings");
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(PlatformSettings.class);
    }

    public File getPlatformsFolder() {
        String folderName = PlatformSettings.getPreferences().get(PROP_PLATFORMS_FOLDER, null);
        if (folderName == null) {
            File f;
            if (Utilities.isMac()) {
                f = new File(APPLE_JAVAVM_FRAMEWORK_PATH);
            } else {
                File tmp;
                f = new File(System.getProperty("user.home"));
                while ((tmp = f.getParentFile()) != null) {
                    f = tmp;
                }
            }
            return f;
        }
        return new File(folderName);
    }

    public void setPlatformsFolder(File file) {
        PlatformSettings.getPreferences().put(PROP_PLATFORMS_FOLDER, file.getAbsolutePath());
    }

    public static synchronized PlatformSettings getDefault() {
        return INSTANCE;
    }
}

