/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.platform;

import org.netbeans.api.java.platform.Profile;
import org.openide.modules.SpecificationVersion;

public final class Specification {
    private String name;
    private SpecificationVersion version;
    private Profile[] profiles;

    public Specification(String name, SpecificationVersion version) {
        this(name, version, null);
    }

    public Specification(String name, SpecificationVersion version, Profile[] profiles) {
        this.name = name;
        this.version = version;
        this.profiles = profiles;
    }

    public final String getName() {
        return this.name;
    }

    public final SpecificationVersion getVersion() {
        return this.version;
    }

    public final Profile[] getProfiles() {
        return this.profiles;
    }

    public int hashCode() {
        int hc = 0;
        if (this.name != null) {
            hc = this.name.hashCode() << 16;
        }
        if (this.version != null) {
            hc += this.version.hashCode();
        }
        return hc;
    }

    public boolean equals(Object other) {
        if (other instanceof Specification) {
            boolean re;
            Specification os = (Specification)other;
            boolean bl = this.name == null ? os.name == null : (this.name.equals(os.name) && this.version == null ? os.version == null : (re = this.version.equals((Object)os.version)));
            if (!re || this.profiles == null) {
                return re;
            }
            if (os.profiles == null || this.profiles.length != os.profiles.length) {
                return false;
            }
            for (int i = 0; i < os.profiles.length; ++i) {
                re &= this.profiles[i].equals(os.profiles[i]);
            }
            return re;
        }
        return false;
    }

    public String toString() {
        String str = this.name == null ? "" : this.name + " ";
        str = str + (this.version == null ? "" : this.version + " ");
        if (this.profiles != null) {
            str = str + "[";
            for (int i = 0; i < this.profiles.length; ++i) {
                str = str + this.profiles[i] + " ";
            }
            str = str + "]";
        }
        return str;
    }
}

