/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.ui;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

class HTMLJavadocParser {
    HTMLJavadocParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJavadocText(URL url, boolean pkg) {
        if (url == null) {
            return null;
        }
        InputStream is = null;
        String charset = null;
        while (true) {
            ParserDelegator parser;
            try {
                String memberName;
                InputStreamReader reader;
                is = url.openStream();
                parser = new ParserDelegator();
                String urlStr = URLDecoder.decode(url.toString(), "UTF-8");
                int[] offsets = null;
                InputStreamReader inputStreamReader = reader = charset == null ? new InputStreamReader(is) : new InputStreamReader(is, charset);
                if (pkg) {
                    offsets = HTMLJavadocParser.parsePackage(reader, parser, charset != null);
                } else if (urlStr.indexOf(35) > 0) {
                    memberName = urlStr.substring(urlStr.indexOf(35) + 1);
                    if (memberName.length() > 0) {
                        offsets = HTMLJavadocParser.parseMember(reader, memberName, parser, charset != null);
                    }
                } else {
                    offsets = HTMLJavadocParser.parseClass(reader, parser, charset != null);
                }
                if (offsets != null) {
                    memberName = HTMLJavadocParser.getTextFromURLStream(url, offsets, charset);
                    return memberName;
                }
            }
            catch (ChangedCharSetException e) {
                if (charset == null) {
                    charset = HTMLJavadocParser.getCharSet(e);
                    continue;
                }
                e.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                parser = null;
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                continue;
            }
            break;
        }
        return null;
    }

    private static String getCharSet(ChangedCharSetException e) {
        String spec = e.getCharSetSpec();
        if (e.keyEqualsCharSet()) {
            return spec;
        }
        int index = spec.indexOf(";");
        if (index != -1) {
            spec = spec.substring(index + 1);
        }
        spec = spec.toLowerCase();
        StringTokenizer st = new StringTokenizer(spec, " \t=", true);
        boolean foundCharSet = false;
        boolean foundEquals = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals(" ") || token.equals("\t")) continue;
            if (!foundCharSet && !foundEquals && token.equals("charset")) {
                foundCharSet = true;
                continue;
            }
            if (!foundEquals && token.equals("=")) {
                foundEquals = true;
                continue;
            }
            if (foundEquals && foundCharSet) {
                return token;
            }
            foundCharSet = false;
            foundEquals = false;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getTextFromURLStream(URL url, int[] offsets, String charset) throws IOException {
        if (url == null) {
            return null;
        }
        InputStream fis = null;
        InputStreamReader fisreader = null;
        try {
            fis = url.openStream();
            fisreader = charset == null ? new InputStreamReader(fis) : new InputStreamReader(fis, charset);
            StringBuilder sb = new StringBuilder();
            int offset = 0;
            for (int i = 0; i < offsets.length - 1; i += 2) {
                int count;
                int startOffset = offsets[i];
                int endOffset = offsets[i + 1];
                if (startOffset < 0 || endOffset < 0) continue;
                if (startOffset > endOffset) {
                    throw new IOException();
                }
                int len = endOffset - startOffset;
                char[] buffer = new char[len];
                int bytesToSkip = startOffset - offset;
                long bytesSkipped = 0L;
                while ((bytesToSkip = (int)((long)bytesToSkip - (bytesSkipped = fisreader.skip(bytesToSkip)))) > 0 && bytesSkipped > 0L) {
                }
                int bytesAlreadyRead = 0;
                while ((count = fisreader.read(buffer, bytesAlreadyRead, len - bytesAlreadyRead)) >= 0 && (bytesAlreadyRead += count) < len) {
                }
                sb.append(buffer);
                offset = endOffset;
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (fisreader != null) {
                fisreader.close();
            }
        }
    }

    private static int[] parseClass(Reader reader, HTMLEditorKit.Parser parser, boolean ignoreCharset) throws IOException {
        boolean INIT = false;
        boolean CLASS_DATA_START = true;
        int TEXT_START = 2;
        final int[] state = new int[]{0};
        final int[] offset = new int[]{-1, -1, -1, -1};
        HTMLEditorKit.ParserCallback callback = new HTMLEditorKit.ParserCallback(){
            int nextHRPos = -1;
            int lastHRPos = -1;

            @Override
            public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (t == HTML.Tag.HR) {
                    if (state[0] == 2) {
                        this.nextHRPos = pos;
                    }
                    this.lastHRPos = pos;
                }
            }

            @Override
            public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                String attrName;
                if (t == HTML.Tag.P && state[0] == 1) {
                    if (offset[0] != -1 && offset[1] == -1) {
                        offset[1] = pos + 3;
                    } else {
                        state[0] = 2;
                    }
                }
                if (t == HTML.Tag.A && state[0] == 2 && (attrName = (String)a.getAttribute(HTML.Attribute.NAME)) != null && attrName.length() > 0) {
                    offset[3] = this.nextHRPos != -1 ? this.nextHRPos : pos;
                    state[0] = 0;
                }
            }

            @Override
            public void handleComment(char[] data, int pos) {
                String comment = String.valueOf(data);
                if (comment != null) {
                    if (comment.indexOf("START OF CLASS DATA") > 0) {
                        state[0] = 1;
                    } else if (comment.indexOf("NESTED CLASS SUMMARY") > 0) {
                        offset[3] = this.lastHRPos != -1 ? this.lastHRPos : pos;
                    }
                }
            }

            @Override
            public void handleText(char[] data, int pos) {
                if (state[0] == 1 && "Deprecated.".equals(new String(data))) {
                    offset[0] = this.lastHRPos + 4;
                } else if (state[0] == 2 && offset[2] < 0) {
                    offset[2] = pos;
                }
            }
        };
        parser.parse(reader, callback, ignoreCharset);
        callback = null;
        return offset;
    }

    private static int[] parseMember(Reader reader, final String name, HTMLEditorKit.Parser parser, boolean ignoreCharset) throws IOException {
        boolean INIT = false;
        boolean A_OPEN = true;
        int A_CLOSE = 2;
        int PRE_CLOSE = 3;
        int INSIDE_DIV = 3;
        final int[] state = new int[1];
        final int[] offset = new int[]{-1, -1};
        state[0] = 0;
        HTMLEditorKit.ParserCallback callback = new HTMLEditorKit.ParserCallback(){
            int div_counter = 0;
            int hrPos = -1;

            @Override
            public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (t == HTML.Tag.HR && state[0] != 0 && state[0] == 3) {
                    this.hrPos = pos;
                }
            }

            @Override
            public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (t == HTML.Tag.A) {
                    String attrName = (String)a.getAttribute(HTML.Attribute.NAME);
                    if (name.equals(attrName)) {
                        state[0] = 1;
                    } else if ((state[0] == 3 || state[0] == 3) && attrName != null) {
                        state[0] = 0;
                        offset[1] = this.hrPos != -1 ? this.hrPos : pos;
                    }
                } else if (t == HTML.Tag.DD && state[0] == 3 && offset[0] < 0) {
                    offset[0] = pos;
                } else if (t == HTML.Tag.DIV && (state[0] == 2 || state[0] == 3)) {
                    state[0] = 3;
                    ++this.div_counter;
                    if (this.div_counter == 2 && offset[0] < 0) {
                        offset[0] = pos;
                    }
                }
            }

            @Override
            public void handleEndTag(HTML.Tag t, int pos) {
                if (t == HTML.Tag.A && state[0] == 1) {
                    state[0] = 2;
                } else if (t == HTML.Tag.PRE && state[0] == 2) {
                    state[0] = 3;
                } else if (t == HTML.Tag.DIV && state[0] == 3) {
                    state[0] = 3;
                    if (this.div_counter == 1) {
                        this.hrPos = pos;
                    }
                    --this.div_counter;
                }
            }
        };
        parser.parse(reader, callback, ignoreCharset);
        callback = null;
        return offset;
    }

    private static int[] parsePackage(Reader reader, HTMLEditorKit.Parser parser, boolean ignoreCharset) throws IOException {
        String name = "package_description";
        boolean INIT = false;
        boolean A_OPEN = true;
        final int[] state = new int[1];
        final int[] offset = new int[]{-1, -1};
        state[0] = 0;
        HTMLEditorKit.ParserCallback callback = new HTMLEditorKit.ParserCallback(){
            int hrPos = -1;

            @Override
            public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (t == HTML.Tag.HR && state[0] != 0 && state[0] == 1) {
                    this.hrPos = pos;
                    offset[1] = pos;
                }
            }

            @Override
            public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (t == HTML.Tag.A) {
                    String attrName = (String)a.getAttribute(HTML.Attribute.NAME);
                    if ("package_description".equals(attrName)) {
                        state[0] = 1;
                        offset[0] = pos;
                    } else if (state[0] == 1 && attrName != null) {
                        state[0] = 0;
                        offset[1] = this.hrPos != -1 ? this.hrPos : pos;
                    }
                }
            }
        };
        parser.parse(reader, callback, ignoreCharset);
        callback = null;
        return offset;
    }
}

