/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.presenters.IdentifiablePresenter;
import org.netbeans.modules.vmd.api.model.presenters.OrderablePresenter;

public class DocumentSupport {
    public static List<DesignComponent> gatherAllComponentsOfTypeID(DesignDocument document, TypeID typeID) {
        ArrayList<DesignComponent> list = new ArrayList<DesignComponent>();
        DocumentSupport.gatherAllComponentsOfTypeID(list, typeID, document.getRootComponent());
        return list;
    }

    public static <T extends Presenter> List<DesignComponent> gatherAllComponentsContainingPresenterClass(DesignDocument document, Class<T> presenterClass) {
        ArrayList<DesignComponent> list = new ArrayList<DesignComponent>();
        DesignComponent rootComponent = document.getRootComponent();
        if (rootComponent != null) {
            DocumentSupport.gatherAllComponentsContainingPresenterClass(list, rootComponent, presenterClass);
        }
        return list;
    }

    private static <T extends Presenter> void gatherAllComponentsContainingPresenterClass(ArrayList<DesignComponent> list, DesignComponent component, Class<T> presenterClass) {
        if (component.getPresenter(presenterClass) != null) {
            list.add(component);
        }
        for (DesignComponent child : component.getComponents()) {
            DocumentSupport.gatherAllComponentsContainingPresenterClass(list, child, presenterClass);
        }
    }

    public static List<DesignComponent> gatherAllComponentsOfTypeID(DesignComponent component, TypeID typeID) {
        ArrayList<DesignComponent> list = new ArrayList<DesignComponent>();
        DocumentSupport.gatherAllComponentsOfTypeID(list, typeID, component);
        return list;
    }

    private static void gatherAllComponentsOfTypeID(Collection<? super DesignComponent> list, TypeID typeID, DesignComponent component) {
        if (component.getDocument().getDescriptorRegistry().isInHierarchy(typeID, component.getType())) {
            list.add(component);
        }
        for (DesignComponent child : component.getComponents()) {
            DocumentSupport.gatherAllComponentsOfTypeID(list, typeID, child);
        }
    }

    public static void removePresentersOfClass(ArrayList<? super Presenter> presenters, Class presenterClass) {
        Iterator<? super Presenter> iterator = presenters.iterator();
        while (iterator.hasNext()) {
            Presenter object = iterator.next();
            if (!presenterClass.isInstance(object)) continue;
            iterator.remove();
        }
    }

    public static void removePresenter(ArrayList<? super Presenter> presenters, Presenter presenter) {
        Iterator<? super Presenter> iterator = presenters.iterator();
        while (iterator.hasNext()) {
            Presenter object = iterator.next();
            if (presenter != object) continue;
            iterator.remove();
            return;
        }
    }

    public static void removePresentersOfPresenterID(ArrayList<Presenter> presenters, String presenterID) {
        if (presenterID == null) {
            return;
        }
        Iterator<Presenter> iterator = presenters.iterator();
        while (iterator.hasNext()) {
            Presenter presenter = iterator.next();
            if (!(presenter instanceof IdentifiablePresenter) || !presenterID.equals(((IdentifiablePresenter)((Object)presenter)).getPresenterID())) continue;
            iterator.remove();
        }
    }

    public static void sortPresentersByOrder(ArrayList<? extends OrderablePresenter> presenters) {
        Collections.sort(presenters, new Comparator<OrderablePresenter>(){

            @Override
            public int compare(OrderablePresenter o1, OrderablePresenter o2) {
                return o1.getOrder() - o2.getOrder();
            }
        });
    }

    public static List<DesignComponent> gatherSubComponentsOfType(DesignComponent component, TypeID typeID) {
        ArrayList<DesignComponent> list = new ArrayList<DesignComponent>();
        for (DesignComponent child : component.getComponents()) {
            if (!typeID.equals(child.getType())) continue;
            list.add(child);
        }
        return list;
    }

    public static <T extends Presenter> Collection<T> gatherAllPresentersOfClass(DesignDocument document, Class<T> clazz) {
        ArrayList list = new ArrayList();
        DocumentSupport.gatherAllPresentersOfClass(list, document.getRootComponent(), clazz);
        return list;
    }

    private static <T extends Presenter> void gatherAllPresentersOfClass(ArrayList<T> list, DesignComponent component, Class<T> clazz) {
        list.addAll(component.getPresenters(clazz));
        for (DesignComponent child : component.getComponents()) {
            DocumentSupport.gatherAllPresentersOfClass(list, child, clazz);
        }
    }

    public static <T extends Presenter> Collection<T> filterPresentersForClass(Collection<? extends Presenter> presenters, Class<T> clazz) {
        ArrayList<Presenter> list = new ArrayList<Presenter>();
        for (Presenter presenter : presenters) {
            if (!clazz.isInstance(presenter)) continue;
            list.add(presenter);
        }
        return list;
    }

    public static Collection<ComponentProducer> getComponentProducers(DesignDocument document, TypeID typeID) {
        HashSet<ComponentProducer> producers = new HashSet<ComponentProducer>();
        DescriptorRegistry registry = document.getDescriptorRegistry();
        for (ComponentProducer producer : registry.getComponentProducers()) {
            if (!registry.isInHierarchy(typeID, producer.getMainComponentTypeID())) continue;
            producers.add(producer);
        }
        return producers;
    }

    public static ComponentProducer getComponentProducer(DesignDocument document, String producerID) {
        for (ComponentProducer producer : document.getDescriptorRegistry().getComponentProducers()) {
            if (!producer.getProducerID().equals(producerID)) continue;
            return producer;
        }
        return null;
    }
}

