/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class ProgressDialog {
    private ProgressHandle pHandle;
    private Dialog dialog;

    public ProgressDialog(String title) {
        this.createDialog(title);
    }

    public void open() {
        while (this.dialog != null) {
            this.dialog.setVisible(true);
        }
    }

    public void close() {
        if (this.dialog != null) {
            Dialog oldDialog = this.dialog;
            this.dialog = null;
            oldDialog.setVisible(false);
            oldDialog.dispose();
        }
    }

    public ProgressHandle getProgressHandle() {
        return this.pHandle;
    }

    private void createDialog(String title) {
        this.pHandle = ProgressHandleFactory.createHandle((String)title);
        ProgressPanel panel = new ProgressPanel(this.pHandle);
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, title);
        Object[] OPTIONS = new Object[]{};
        descriptor.setOptions(OPTIONS);
        descriptor.setClosingOptions(OPTIONS);
        descriptor.setModal(true);
        descriptor.setOptionsAlign(0);
        this.dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        Frame mainWindow = WindowManager.getDefault().getMainWindow();
        int windowX = mainWindow.getX();
        int windowY = mainWindow.getY();
        int windowWidth = mainWindow.getWidth();
        int windowHeight = mainWindow.getHeight();
        int dialogWidth = this.dialog.getWidth();
        int dialogHeight = this.dialog.getHeight();
        int dialogX = (int)((double)windowWidth / 2.0) - (int)((double)dialogWidth / 2.0);
        int dialogY = (int)((double)windowHeight / 2.0) - (int)((double)dialogHeight / 2.0);
        this.dialog.setLocation(dialogX, dialogY);
    }

    private class ProgressPanel
    extends JPanel {
        private JLabel messageLabel;
        private JComponent progressBar;

        public ProgressPanel(ProgressHandle pHandle) {
            this.messageLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)pHandle);
            this.messageLabel.setText(NbBundle.getMessage(ProgressDialog.class, (String)"MSG_StartingProgress"));
            this.progressBar = ProgressHandleFactory.createProgressComponent((ProgressHandle)pHandle);
            this.initComponents();
        }

        private void initComponents() {
            GroupLayout layout = new GroupLayout((Container)this);
            this.setLayout((LayoutManager)layout);
            layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.progressBar, -1, 436, Short.MAX_VALUE).add(1, (Component)this.messageLabel, -1, 436, Short.MAX_VALUE)).addContainerGap()));
            layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.messageLabel).addPreferredGap(0).add((Component)this.progressBar, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension orig = super.getPreferredSize();
            return new Dimension(500, orig.height);
        }
    }
}

