/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.util.Hashtable;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.DialogWaiter;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.operators.WindowOperator;

public class DialogOperator
extends WindowOperator {
    public static final String TITLE_DPROP = "Title";
    public static final String IS_MODAL_DPROP = "Modal";
    public static final String IS_RESIZABLE_DPROP = "Resizable";

    public DialogOperator(Dialog w) {
        super(w);
    }

    public DialogOperator(ComponentChooser chooser, int index, Operator env) {
        this(DialogOperator.waitDialog(new DialogFinder(chooser), index, env.getTimeouts(), env.getOutput()));
        this.copyEnvironment(env);
    }

    public DialogOperator(ComponentChooser chooser, int index) {
        this(chooser, index, Operator.getEnvironmentOperator());
    }

    public DialogOperator(ComponentChooser chooser) {
        this(chooser, 0);
    }

    public DialogOperator(WindowOperator owner, ComponentChooser chooser, int index) {
        this((Dialog)owner.waitSubWindow(new DialogFinder(chooser), index));
        this.copyEnvironment(owner);
    }

    public DialogOperator(WindowOperator owner, ComponentChooser chooser) {
        this(owner, chooser, 0);
    }

    public DialogOperator(WindowOperator owner, String title, int index) {
        this(DialogOperator.waitDialog(owner, new DialogByTitleFinder(title, owner.getComparator()), index));
        this.copyEnvironment(owner);
    }

    public DialogOperator(WindowOperator owner, String title) {
        this(owner, title, 0);
    }

    public DialogOperator(WindowOperator owner, int index) {
        this(DialogOperator.waitDialog(owner, new DialogFinder(), index));
        this.copyEnvironment(owner);
    }

    public DialogOperator(WindowOperator owner) {
        this(owner, 0);
    }

    public DialogOperator(String title, int index, Operator env) {
        this(new DialogByTitleFinder(title, env.getComparator()), index, env);
    }

    public DialogOperator(String title, int index) {
        this(title, index, ComponentOperator.getEnvironmentOperator());
    }

    public DialogOperator(String title) {
        this(title, 0);
    }

    public DialogOperator(int index) {
        this(DialogOperator.waitDialog(new DialogFinder(), index, ComponentOperator.getEnvironmentOperator().getTimeouts(), ComponentOperator.getEnvironmentOperator().getOutput()));
        this.copyEnvironment(ComponentOperator.getEnvironmentOperator());
    }

    public DialogOperator() {
        this(0);
    }

    public void waitTitle(String title) {
        this.getOutput().printLine("Wait \"" + title + "\" title of dialog \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait \"" + title + "\" title");
        this.waitState(new DialogByTitleFinder(title, this.getComparator()));
    }

    public Hashtable getDump() {
        Hashtable result = super.getDump();
        if (((Dialog)this.getSource()).getTitle() != null) {
            result.put(TITLE_DPROP, ((Dialog)this.getSource()).getTitle());
        }
        result.put(IS_MODAL_DPROP, ((Dialog)this.getSource()).isModal() ? "true" : "false");
        result.put(IS_RESIZABLE_DPROP, ((Dialog)this.getSource()).isResizable() ? "true" : "false");
        return result;
    }

    public String getTitle() {
        return (String)this.runMapping(new Operator.MapAction("getTitle"){

            public Object map() {
                return ((Dialog)DialogOperator.this.getSource()).getTitle();
            }
        });
    }

    public boolean isModal() {
        return this.runMapping(new Operator.MapBooleanAction("isModal"){

            public boolean map() {
                return ((Dialog)DialogOperator.this.getSource()).isModal();
            }
        });
    }

    public boolean isResizable() {
        return this.runMapping(new Operator.MapBooleanAction("isResizable"){

            public boolean map() {
                return ((Dialog)DialogOperator.this.getSource()).isResizable();
            }
        });
    }

    public void setModal(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setModal"){

            public void map() {
                ((Dialog)DialogOperator.this.getSource()).setModal(b);
            }
        });
    }

    public void setResizable(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setResizable"){

            public void map() {
                ((Dialog)DialogOperator.this.getSource()).setResizable(b);
            }
        });
    }

    public void setTitle(final String string) {
        this.runMapping(new Operator.MapVoidAction("setTitle"){

            public void map() {
                ((Dialog)DialogOperator.this.getSource()).setTitle(string);
            }
        });
    }

    protected static Dialog waitDialog(ComponentChooser chooser, int index, Timeouts timeouts, TestOut output) {
        try {
            DialogWaiter waiter = new DialogWaiter();
            waiter.setTimeouts(timeouts);
            waiter.setOutput(output);
            return waiter.waitDialog(new DialogFinder(chooser), index);
        }
        catch (InterruptedException e) {
            output.printStackTrace(e);
            return null;
        }
    }

    protected static Dialog waitDialog(WindowOperator owner, ComponentChooser chooser, int index) {
        return DialogOperator.waitDialog((Window)owner.getSource(), chooser, index, owner.getTimeouts(), owner.getOutput());
    }

    protected static Dialog waitDialog(Window owner, ComponentChooser chooser, int index, Timeouts timeouts, TestOut output) {
        try {
            DialogWaiter waiter = new DialogWaiter();
            waiter.setTimeouts(timeouts);
            waiter.setOutput(output);
            return waiter.waitDialog(owner, new DialogFinder(chooser), index);
        }
        catch (InterruptedException e) {
            JemmyProperties.getCurrentOutput().printStackTrace(e);
            return null;
        }
    }

    public static class DialogByTitleFinder
    implements ComponentChooser {
        String title;
        Operator.StringComparator comparator;

        public DialogByTitleFinder(String t, Operator.StringComparator comparator) {
            this.title = t;
            this.comparator = comparator;
        }

        public DialogByTitleFinder(String t) {
            this(t, Operator.getDefaultStringComparator());
        }

        public boolean checkComponent(Component comp) {
            if (comp instanceof Dialog && ((Dialog)comp).isShowing() && ((Dialog)comp).getTitle() != null) {
                return this.comparator.equals(((Dialog)comp).getTitle(), this.title);
            }
            return false;
        }

        public String getDescription() {
            return "Dialog with title \"" + this.title + "\"";
        }
    }

    public static class DialogFinder
    extends Operator.Finder {
        public DialogFinder(ComponentChooser sf) {
            super(Dialog.class, sf);
        }

        public DialogFinder() {
            super(Dialog.class);
        }
    }
}

