/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.mobility.project.PropertyDescriptor;
import org.netbeans.api.mobility.project.ui.customizer.ProjectProperties;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.mobility.project.ui.customizer.CustomizerGeneral;
import org.netbeans.modules.mobility.project.ui.customizer.VisualClassPathItem;
import org.netbeans.spi.mobility.deployment.DeploymentPlugin;
import org.netbeans.spi.mobility.project.ProjectPropertiesDescriptor;
import org.netbeans.spi.mobility.project.PropertyParser;
import org.netbeans.spi.mobility.project.support.DefaultPropertyParsers;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;

public class J2MEProjectProperties
implements ProjectProperties {
    public static final String J2ME_PROJECT_NAME = "j2me.project.name";
    public static final String PROP_CONFIGURATIONS = "configurations";
    public static final String CONFIG_PREFIX = "configs.";
    private static final String LIBS = "${libs.";
    private final Set<PropertyDescriptor> PROPERTY_DESCRIPTORS = new HashSet<PropertyDescriptor>();
    private Project project;
    protected ReferenceHelper refHelper;
    protected AntProjectHelper antProjectHelper;
    protected HashMap<String, PropertyInfo> properties;
    protected ProjectConfigurationsHelper configHelper;
    protected ProjectConfiguration[] devConfigs;

    private void initPropertyDescriptors() {
        Collection c = Lookup.getDefault().lookupAll(ProjectPropertiesDescriptor.class);
        for (ProjectPropertiesDescriptor p : c) {
            try {
                this.PROPERTY_DESCRIPTORS.addAll(p.getPropertyDescriptors());
            }
            catch (ConcurrentModificationException cme) {
                ConcurrentModificationException nue = new ConcurrentModificationException("Property descriptor class " + p.getClass().getName() + " should return a " + "defensive copy of its property descriptors - they have" + "been modified");
                Exceptions.printStackTrace((Throwable)nue);
            }
        }
        for (ProjectPropertiesDescriptor p : Lookup.getDefault().lookup(new Lookup.Template(DeploymentPlugin.class)).allInstances()) {
            for (Map.Entry en : p.getProjectPropertyDefaultValues().entrySet()) {
                Object v = en.getValue();
                PropertyParser par = v instanceof Boolean ? DefaultPropertyParsers.BOOLEAN_PARSER : (v instanceof Integer ? DefaultPropertyParsers.INTEGER_PARSER : (v instanceof String ? DefaultPropertyParsers.STRING_PARSER : (v instanceof File ? DefaultPropertyParsers.FILE_REFERENCE_PARSER : null)));
                if (par == null) continue;
                this.PROPERTY_DESCRIPTORS.add(new PropertyDescriptor((String)en.getKey(), true, par, v.toString()));
            }
        }
    }

    public J2MEProjectProperties(Project project, AntProjectHelper antProjectHelper, ReferenceHelper refHelper, ProjectConfigurationsHelper configHelper) {
        this.project = project;
        this.properties = new HashMap();
        this.antProjectHelper = antProjectHelper;
        this.refHelper = refHelper;
        this.configHelper = configHelper;
        this.initPropertyDescriptors();
        this.read();
    }

    public synchronized void setActiveConfiguration(ProjectConfiguration cfg) {
        this.put("config.active", (Object)(cfg == null || this.configHelper.getDefaultConfiguration().equals(cfg) ? "" : cfg.getDisplayName()));
    }

    public synchronized ProjectConfiguration getActiveConfiguration() {
        String cfg = (String)this.get("config.active");
        if (this.devConfigs == null || cfg == null || cfg.length() == 0) {
            return this.configHelper.getDefaultConfiguration();
        }
        for (int i = 0; i < this.devConfigs.length; ++i) {
            if (!cfg.equals(this.devConfigs[i].getDisplayName())) continue;
            return this.devConfigs[i];
        }
        return this.configHelper.getDefaultConfiguration();
    }

    static String getAntPropertyName(String property) {
        if (property != null && property.startsWith("${") && property.endsWith("}")) {
            return property.substring(2, property.length() - 1);
        }
        return property;
    }

    AntProjectHelper getHelper() {
        return this.antProjectHelper;
    }

    private PropertyDescriptor findPropertyDescriptor(String propertyName) {
        for (PropertyDescriptor pd : this.PROPERTY_DESCRIPTORS) {
            if (!pd.getName().equals(propertyName) && (!propertyName.startsWith(CONFIG_PREFIX) || !propertyName.endsWith('.' + pd.getName()))) continue;
            return pd;
        }
        return null;
    }

    @Override
    public Object put(String propertyName, Object value) {
        PropertyInfo pi = this.properties.get(propertyName);
        if (pi == null) {
            PropertyDescriptor pd = this.findPropertyDescriptor(propertyName);
            assert (pd != null) : "Unknown property " + propertyName;
            pi = new PropertyInfo(pd.clone(propertyName), null);
            this.properties.put(propertyName, pi);
        }
        Object oldVal = pi.getValue();
        pi.setValue(value);
        return oldVal;
    }

    void putPropertyRawValue(Object propertyName, String rawValue) {
        PropertyInfo pi = this.properties.get(propertyName);
        if (pi == null) {
            PropertyDescriptor pd = this.findPropertyDescriptor((String)propertyName);
            assert (pd != null) : "Unknown property " + propertyName;
            pi = new PropertyInfo(pd.clone((String)propertyName), null);
            this.properties.put((String)propertyName, pi);
        }
        pi.setRawValue(rawValue);
    }

    @Override
    public Object get(Object propertyName) {
        PropertyInfo pi = this.properties.get(propertyName);
        return pi == null ? null : pi.getValue();
    }

    public String getPropertyRawValue(Object propertyName) {
        PropertyInfo pi = this.properties.get(propertyName);
        return pi == null ? null : pi.getRawValue();
    }

    public boolean isModified(String propertyName) {
        PropertyInfo pi = this.properties.get(propertyName);
        assert (pi != null) : "Unknown property " + propertyName;
        return pi.isModified();
    }

    @Override
    public ProjectConfiguration[] getConfigurations() {
        return this.devConfigs;
    }

    public final synchronized void setConfigurations(ProjectConfiguration[] configurations) {
        this.devConfigs = configurations;
    }

    public List<String> getAllIdentifiers() {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < this.devConfigs.length; ++i) {
            l.add(this.devConfigs[i].getDisplayName());
            Map abs = (Map)this.get(this.configHelper.getDefaultConfiguration().equals(this.devConfigs[i]) ? "abilities" : CONFIG_PREFIX + this.devConfigs[i].getDisplayName() + '.' + "abilities");
            if (abs == null) continue;
            l.addAll(abs.keySet());
        }
        return l;
    }

    @Override
    public FileObject getProjectDirectory() {
        return this.project.getProjectDirectory();
    }

    @Override
    public FileObject getSourceRoot() {
        return this.antProjectHelper.resolveFileObject(this.antProjectHelper.getStandardPropertyEvaluator().getProperty("src.dir"));
    }

    public String toString() {
        return super.toString() + "{project=" + this.project + " properties=" + this.properties + '}';
    }

    private void read() {
        EditableProperties sharedProps = this.antProjectHelper.getProperties("nbproject/project.properties");
        EditableProperties privateProps = this.antProjectHelper.getProperties("nbproject/private/private.properties");
        ProjectConfiguration[] cfgs = this.configHelper.getConfigurations().toArray(new ProjectConfiguration[0]);
        ProjectConfiguration[] confs = new ProjectConfiguration[cfgs.length];
        System.arraycopy(cfgs, 0, confs, 0, cfgs.length);
        this.setConfigurations(confs);
        this.properties.put(J2ME_PROJECT_NAME, new PropertyInfo(new PropertyDescriptor(J2ME_PROJECT_NAME, true, DefaultPropertyParsers.STRING_PARSER), ProjectUtils.getInformation((Project)this.project).getDisplayName()));
        for (PropertyDescriptor pd : this.PROPERTY_DESCRIPTORS) {
            EditableProperties ep = pd.isShared() ? sharedProps : privateProps;
            String raw = ep.getProperty(pd.getName());
            this.properties.put(pd.getName(), new PropertyInfo(pd, raw == null ? pd.getDefaultValue() : raw));
            for (int j = 0; j < this.devConfigs.length; ++j) {
                PropertyDescriptor clone = pd.clone(CONFIG_PREFIX + this.devConfigs[j].getDisplayName() + '.' + pd.getName());
                raw = ep.getProperty(clone.getName());
                if (raw == null) continue;
                this.properties.put(clone.getName(), new PropertyInfo(clone, raw));
            }
        }
    }

    public void store() {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Object>(){

                public Object run() {
                    J2MEProjectProperties.this.resolveProjectDependencies();
                    for (PropertyInfo pi : J2MEProjectProperties.this.properties.values()) {
                        pi.encode();
                    }
                    ProjectConfiguration[] configs = J2MEProjectProperties.this.configHelper.getConfigurations().toArray(new ProjectConfiguration[0]);
                    HashSet<ProjectConfiguration> newConfigs = new HashSet<ProjectConfiguration>(Arrays.asList(J2MEProjectProperties.this.devConfigs));
                    for (int i = 0; i < configs.length; ++i) {
                        if (newConfigs.remove(configs[i])) continue;
                        J2MEProjectProperties.this.configHelper.removeConfiguration(configs[i]);
                    }
                    for (ProjectConfiguration cfg : newConfigs) {
                        J2MEProjectProperties.this.configHelper.addConfiguration(cfg.getDisplayName());
                    }
                    EditableProperties sharedProps = J2MEProjectProperties.this.antProjectHelper.getProperties("nbproject/project.properties");
                    EditableProperties privateProps = J2MEProjectProperties.this.antProjectHelper.getProperties("nbproject/private/private.properties");
                    for (PropertyInfo pi : J2MEProjectProperties.this.properties.values()) {
                        PropertyDescriptor pd = pi.getPropertyDescriptor();
                        if (pd == null || !pi.isModified()) continue;
                        String newValueEncoded = pi.getNewValueEncoded();
                        if (newValueEncoded != null) {
                            (pd.isShared() ? sharedProps : privateProps).setProperty(pd.getName(), newValueEncoded);
                            continue;
                        }
                        (pd.isShared() ? sharedProps : privateProps).remove((Object)pd.getName());
                    }
                    J2MEProjectProperties.this.antProjectHelper.putProperties("nbproject/project.properties", sharedProps);
                    J2MEProjectProperties.this.antProjectHelper.putProperties("nbproject/private/private.properties", privateProps);
                    CustomizerGeneral cg = new CustomizerGeneral();
                    cg.initValues(J2MEProjectProperties.this, null);
                    cg.getSortedSubprojectsList();
                    String enc = sharedProps.getProperty("javac.encoding");
                    if (enc != null) {
                        FileEncodingQuery.setDefaultEncoding((Charset)Charset.forName(enc));
                    }
                    try {
                        ProjectManager.getDefault().saveProject(J2MEProjectProperties.this.project);
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                    return null;
                }
            });
        }
        catch (MutexException e) {
            ErrorManager.getDefault().notify((Throwable)e.getException());
        }
    }

    protected void resolveProjectDependencies() {
        HashSet<String> oldReferences = new HashSet<String>();
        HashSet<String> newReferences = new HashSet<String>();
        for (PropertyInfo pi : this.properties.values()) {
            if (pi == null) continue;
            if (pi.getPropertyDescriptor().getPropertyParser() == DefaultPropertyParsers.PATH_PARSER) {
                List newList;
                List oldList = (List)pi.getOldValue();
                if (oldList != null) {
                    Iterator it = oldList.iterator();
                    while (it.hasNext()) {
                        oldReferences.add(((VisualClassPathItem)it.next()).getRawText());
                    }
                }
                if ((newList = (List)pi.getValue()) == null) continue;
                Iterator it = newList.iterator();
                while (it.hasNext()) {
                    newReferences.add(((VisualClassPathItem)it.next()).getRawText());
                }
                continue;
            }
            if (pi.getPropertyDescriptor().getPropertyParser() != DefaultPropertyParsers.FILE_REFERENCE_PARSER) continue;
            oldReferences.add(pi.getOldRawValue());
            newReferences.add(pi.getRawValue());
        }
        HashSet removed = new HashSet(oldReferences);
        removed.removeAll(newReferences);
        HashSet added = new HashSet(newReferences);
        added.removeAll(oldReferences);
        for (String reference : removed) {
            if (reference == null || reference.startsWith(LIBS)) continue;
            this.refHelper.destroyReference(reference);
        }
        EditableProperties ep = this.antProjectHelper.getProperties("nbproject/project.properties");
        boolean changed = false;
        for (String reference : removed) {
            if (reference == null || !reference.startsWith(LIBS)) continue;
            ep.remove((Object)reference.substring(2, reference.length() - 1));
            changed = true;
        }
        File projDir = FileUtil.toFile((FileObject)this.antProjectHelper.getProjectDirectory());
        for (String reference : added) {
            String value;
            if (reference == null || !reference.startsWith(LIBS) || (value = this.relativizeLibraryClasspath(reference = reference.substring(2, reference.length() - 1), projDir)) == null) continue;
            ep.setProperty(reference, value);
            ep.setComment(reference, new String[]{NbBundle.getMessage(J2MEProjectProperties.class, (String)"DESC_J2MEProps_CommentLine1", (Object)reference), NbBundle.getMessage(J2MEProjectProperties.class, (String)"DESC_J2MEProps_CommentLine2")}, false);
            changed = true;
        }
        if (changed) {
            this.antProjectHelper.putProperties("nbproject/project.properties", ep);
        }
    }

    private String relativizeLibraryClasspath(String property, File projectDir) {
        String value = PropertyUtils.getGlobalProperties().getProperty(property);
        if (value == null) {
            return null;
        }
        String[] paths = PropertyUtils.tokenizePath((String)value);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < paths.length; ++i) {
            File f = this.antProjectHelper.resolveFile(paths[i]);
            if (!CollocationQuery.areCollocated((File)f, (File)projectDir)) {
                return null;
            }
            sb.append(PropertyUtils.relativizeFile((File)projectDir, (File)f));
            if (i + 1 >= paths.length) continue;
            sb.append(File.pathSeparatorChar);
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    @Override
    public Set entrySet() {
        return Collections.unmodifiableSet(this.properties.entrySet());
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    @Override
    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        return this.containsKey(key) ? this.put((String)key, (Object)null) : null;
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public Collection values() {
        return Collections.unmodifiableCollection(this.properties.values());
    }

    private class PropertyInfo {
        protected final PropertyDescriptor propertyDesciptor;
        private final String rawValue;
        private final Object value;
        private Object newValue;
        private String newValueEncoded;
        private boolean modified;

        public PropertyInfo(PropertyDescriptor propertyDesciptor, String rawValue) {
            this.propertyDesciptor = propertyDesciptor;
            this.rawValue = rawValue;
            this.value = rawValue == null ? null : propertyDesciptor.getPropertyParser().decode(rawValue, J2MEProjectProperties.this.antProjectHelper, J2MEProjectProperties.this.refHelper);
            this.newValue = null;
        }

        public String toString() {
            return super.toString() + "[rawvalue=" + this.rawValue + ", value=" + this.value + ", newValue=" + this.newValue + ", newValueEncoded=" + this.newValueEncoded + " modified=" + this.modified + "]";
        }

        public PropertyDescriptor getPropertyDescriptor() {
            return this.propertyDesciptor;
        }

        public void encode() {
            this.newValueEncoded = this.isModified() && this.newValue != null ? this.propertyDesciptor.getPropertyParser().encode(this.newValue, J2MEProjectProperties.this.antProjectHelper, J2MEProjectProperties.this.refHelper) : null;
        }

        public Object getValue() {
            return this.isModified() ? this.newValue : this.value;
        }

        public String getRawValue() {
            this.encode();
            return this.isModified() ? this.newValueEncoded : this.rawValue;
        }

        public void setValue(Object value) {
            this.newValue = value;
            this.modified = true;
        }

        public void setRawValue(String rawValue) {
            this.setValue(rawValue == null ? null : this.propertyDesciptor.getPropertyParser().decode(rawValue, J2MEProjectProperties.this.antProjectHelper, J2MEProjectProperties.this.refHelper));
        }

        public String getNewValueEncoded() {
            return this.newValueEncoded;
        }

        public boolean isModified() {
            return this.modified;
        }

        public Object getOldValue() {
            return this.value;
        }

        public String getOldRawValue() {
            return this.rawValue;
        }
    }
}

