/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.common.FileSearchUtility;
import org.netbeans.modules.j2ee.common.project.ui.J2eeVersionWarningPanel;
import org.netbeans.modules.j2ee.common.project.ui.ProjectImportLocationPanel;
import org.netbeans.modules.j2ee.common.project.ui.ProjectLocationPanel;
import org.netbeans.modules.j2ee.common.project.ui.ProjectServerWizardPanel;
import org.netbeans.modules.j2ee.common.project.ui.UserProjectSettings;
import org.netbeans.modules.j2ee.dd.api.client.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeApplication;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerManager;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class ProjectServerPanel
extends JPanel
implements DocumentListener {
    private ProjectServerWizardPanel wizard;
    private boolean contextModified = false;
    private final DefaultComboBoxModel serversModel = new DefaultComboBoxModel();
    private J2eeVersionWarningPanel warningPanel;
    private boolean sharableProject;
    private List<Project> earProjects;
    private final J2eeModule.Type j2eeModuleType;
    private File projectLocation;
    private boolean importScenario;
    private BigDecimal xmlVersion;
    private JButton addServerButton;
    private JCheckBox cdiCheckbox;
    private JCheckBox createCarCheckBox;
    private JCheckBox createEjbCheckBox;
    private JCheckBox createWARCheckBox;
    private JComboBox j2eeSpecComboBox;
    private JLabel j2eeSpecLabel;
    private JComboBox jComboBoxEnterprise;
    private JLabel jLabelContextPath;
    private JLabel jLabelEnterprise;
    private JTextField jTextFieldCarName;
    protected JTextField jTextFieldContextPath;
    private JTextField jTextFieldEjbModuleName;
    private JTextField jTextFieldWebAppName;
    private JLabel mainClassLabel;
    private JLabel mainClassLabel1;
    private JTextField mainClassTextField;
    private JTextField mainClassTextFieldWithinEar;
    private JComboBox serverInstanceComboBox;
    private JLabel serverInstanceLabel;
    private JCheckBox serverLibraryCheckbox;
    private JPanel warningPlaceHolderPanel;

    @Deprecated
    public ProjectServerPanel(Object object, String string, String string2, ProjectServerWizardPanel projectServerWizardPanel, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this(J2eeModule.Type.fromJsrType((Object)object), string, string2, projectServerWizardPanel, bl, bl2, bl3, bl4, bl5);
    }

    public ProjectServerPanel(J2eeModule.Type type, String string, String string2, ProjectServerWizardPanel projectServerWizardPanel, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.importScenario = bl5;
        this.initComponents();
        this.setJ2eeVersionWarningPanel();
        this.wizard = projectServerWizardPanel;
        this.j2eeModuleType = type;
        this.initServers(UserProjectSettings.getDefault().getLastUsedServer());
        if (this.j2eeSpecComboBox.getModel().getSize() > 0) {
            this.j2eeSpecComboBox.setSelectedIndex(0);
        }
        this.initEnterpriseApplications();
        this.setName(string);
        this.putClientProperty("NewProjectWizard_Title", string2);
        this.jLabelEnterprise.setVisible(bl);
        this.jComboBoxEnterprise.setVisible(bl);
        this.jLabelContextPath.setVisible(bl3);
        this.jTextFieldContextPath.setVisible(bl3);
        this.mainClassLabel.setVisible(bl2);
        this.mainClassTextField.setVisible(bl2);
        this.createCarCheckBox.setVisible(bl4);
        this.createEjbCheckBox.setVisible(bl4);
        this.createWARCheckBox.setVisible(bl4);
        this.jTextFieldCarName.setVisible(bl4);
        this.jTextFieldEjbModuleName.setVisible(bl4);
        this.jTextFieldWebAppName.setVisible(bl4);
        this.mainClassLabel1.setVisible(bl4);
        this.mainClassTextFieldWithinEar.setVisible(bl4);
        this.jTextFieldCarName.getDocument().addDocumentListener(this);
        this.jTextFieldEjbModuleName.getDocument().addDocumentListener(this);
        this.jTextFieldWebAppName.getDocument().addDocumentListener(this);
        this.mainClassTextFieldWithinEar.getDocument().addDocumentListener(this);
        this.mainClassTextField.getDocument().addDocumentListener(this);
        this.jTextFieldContextPath.getDocument().addDocumentListener(this);
    }

    private void initComponents() {
        this.jLabelEnterprise = new JLabel();
        this.jComboBoxEnterprise = new JComboBox();
        this.serverInstanceLabel = new JLabel();
        this.serverInstanceComboBox = new JComboBox();
        this.addServerButton = new JButton();
        this.j2eeSpecLabel = new JLabel();
        this.j2eeSpecComboBox = new JComboBox();
        this.jLabelContextPath = new JLabel();
        this.warningPlaceHolderPanel = new JPanel();
        this.jTextFieldContextPath = new JTextField();
        this.mainClassLabel = new JLabel();
        this.mainClassTextField = new JTextField();
        this.createEjbCheckBox = new JCheckBox();
        this.jTextFieldEjbModuleName = new JTextField();
        this.createWARCheckBox = new JCheckBox();
        this.jTextFieldWebAppName = new JTextField();
        this.createCarCheckBox = new JCheckBox();
        this.jTextFieldCarName = new JTextField();
        this.mainClassLabel1 = new JLabel();
        this.mainClassTextFieldWithinEar = new JTextField();
        this.serverLibraryCheckbox = new JCheckBox();
        this.cdiCheckbox = new JCheckBox();
        this.jLabelEnterprise.setLabelFor(this.jComboBoxEnterprise);
        Mnemonics.setLocalizedText((JLabel)this.jLabelEnterprise, (String)NbBundle.getMessage(ProjectServerPanel.class, (String)"LBL_NWP1_AddToEnterprise_Label"));
        this.serverInstanceLabel.setLabelFor(this.serverInstanceComboBox);
        Mnemonics.setLocalizedText((JLabel)this.serverInstanceLabel, (String)NbBundle.getMessage(ProjectServerPanel.class, (String)"LBL_NWP1_Server"));
        this.serverInstanceComboBox.setModel(this.serversModel);
        this.serverInstanceComboBox.setPrototypeDisplayValue("The Gr8est Marvelous Nr. 1 Server");
        this.serverInstanceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectServerPanel.this.serverInstanceComboBoxActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.addServerButton, (String)NbBundle.getMessage(ProjectServerPanel.class, (String)"LBL_AddServer"));
        this.addServerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectServerPanel.this.addServerButtonActionPerformed(actionEvent);
            }
        });
        this.j2eeSpecLabel.setLabelFor(this.j2eeSpecComboBox);
        Mnemonics.setLocalizedText((JLabel)this.j2eeSpecLabel, (String)NbBundle.getMessage(ProjectServerPanel.class, (String)"LBL_NWP1_J2EESpecLevel_Label"));
        this.j2eeSpecComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectServerPanel.this.j2eeSpecComboBoxActionPerformed(actionEvent);
            }
        });
        this.jLabelContextPath.setLabelFor(this.jTextFieldContextPath);
        Mnemonics.setLocalizedText((JLabel)this.jLabelContextPath, (String)NbBundle.getMessage(ProjectServerPanel.class, (String)"LBL_NWP1_ContextPath_Label"));
        this.warningPlaceHolderPanel.setBackground(new Color(0, 153, 102));
        this.warningPlaceHolderPanel.setLayout(new BorderLayout());
        this.jTextFieldContextPath.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                ProjectServerPanel.this.jTextFieldContextPathKeyReleased(keyEvent);
            }
        });
        this.mainClassLabel.setLabelFor(this.mainClassTextField);
        Mnemonics.setLocalizedText((JLabel)this.mainClassLabel, (String)NbBundle.getBundle(ProjectServerPanel.class).getString("LBL_NWP1_MainClass_Label"));
        this.mainClassLabel.setAlignmentX(0.5f);
        this.mainClassTextField.setText("com.myapp.Main");
        this.createEjbCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createEjbCheckBox, (String)NbBundle.getBundle(ProjectServerPanel.class).getString("LBL_NEAP_CreateEjbModule"));
        this.createEjbCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectServerPanel.this.createEjbCheckBox_action(actionEvent);
            }
        });
        this.createWARCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createWARCheckBox, (String)NbBundle.getBundle(ProjectServerPanel.class).getString("LBL_NEAP_CreatWebAppModule"));
        this.createWARCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectServerPanel.this.createWARCheckBoxcreateWebAppCheckBox_action(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.createCarCheckBox, (String)NbBundle.getBundle(ProjectServerPanel.class).getString("LBL_NEAP_CreateCarModule"));
        this.createCarCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectServerPanel.this.createCarCheckBox_action(actionEvent);
            }
        });
        this.jTextFieldCarName.setEnabled(false);
        this.mainClassLabel1.setLabelFor(this.mainClassTextFieldWithinEar);
        Mnemonics.setLocalizedText((JLabel)this.mainClassLabel1, (String)NbBundle.getBundle(ProjectServerPanel.class).getString("LBL_NWP1_MainClass_Label"));
        this.mainClassTextFieldWithinEar.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.serverLibraryCheckbox, (String)NbBundle.getMessage(ProjectServerPanel.class, (String)"PanelSharabilityVisual.serverLibraryCheckbox.text"));
        this.serverLibraryCheckbox.setMargin(new Insets(2, 0, 2, 2));
        this.serverLibraryCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectServerPanel.this.serverLibraryCheckboxActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cdiCheckbox, (String)NbBundle.getMessage(ProjectServerPanel.class, (String)"PanelSharabilityVisual.cdiCheckbox.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.mainClassLabel).addContainerGap(495, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.createCarCheckBox).add((Component)this.createEjbCheckBox).add((Component)this.createWARCheckBox)).add((Component)this.mainClassLabel1)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jTextFieldEjbModuleName, -1, 246, Short.MAX_VALUE).add((Component)this.jTextFieldWebAppName, -1, 246, Short.MAX_VALUE).add((Component)this.jTextFieldCarName, -1, 246, Short.MAX_VALUE).add((Component)this.mainClassTextFieldWithinEar, -1, 246, Short.MAX_VALUE)).add(74, 74, 74)).add((Component)this.warningPlaceHolderPanel, -1, 567, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabelEnterprise).addPreferredGap(0).add((Component)this.jComboBoxEnterprise, 0, 366, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabelContextPath).add((Component)this.serverInstanceLabel).add((Component)this.j2eeSpecLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.cdiCheckbox, -1, 441, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.mainClassTextField, -1, 379, Short.MAX_VALUE).add(74, 74, 74)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jTextFieldContextPath, -1, 379, Short.MAX_VALUE).add(74, 74, 74)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.serverInstanceComboBox, 0, 398, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.addServerButton)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.serverLibraryCheckbox, -1, 379, Short.MAX_VALUE).add(74, 74, 74)).add((Component)this.j2eeSpecComboBox, -2, -1, -2))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(0, 0, 0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabelEnterprise).add((Component)this.jComboBoxEnterprise, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.serverInstanceLabel).add((Component)this.addServerButton).add((Component)this.serverInstanceComboBox, -2, -1, -2)).addPreferredGap(0).add((Component)this.serverLibraryCheckbox).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.j2eeSpecLabel).add((Component)this.j2eeSpecComboBox, -2, -1, -2)).addPreferredGap(0).add((Component)this.cdiCheckbox).addPreferredGap(0).add((Component)this.warningPlaceHolderPanel, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabelContextPath).add((Component)this.jTextFieldContextPath, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.mainClassLabel).add((Component)this.mainClassTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jTextFieldEjbModuleName, -2, -1, -2).add((Component)this.createEjbCheckBox)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jTextFieldWebAppName, -2, -1, -2).add((Component)this.createWARCheckBox)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.createCarCheckBox).add((Component)this.jTextFieldCarName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.mainClassLabel1).add((Component)this.mainClassTextFieldWithinEar, -2, -1, -2)).add(174, 174, 174)));
        this.jLabelEnterprise.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.jComboBoxEnterprise.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.serverInstanceLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.serverInstanceComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.addServerButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectServerPanel.class, (String)"ASCN_AddServer"));
        this.addServerButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.j2eeSpecLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.j2eeSpecComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.jLabelContextPath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.warningPlaceHolderPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.warningPlaceHolderPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.jTextFieldContextPath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.mainClassLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.mainClassTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.createEjbCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.jTextFieldEjbModuleName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectServerPanel.class, (String)"LBL_NEAP_CreateEjbModule"));
        this.jTextFieldEjbModuleName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.createWARCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.jTextFieldWebAppName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectServerPanel.class, (String)"LBL_NEAP_CreatWebAppModule"));
        this.jTextFieldWebAppName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.createCarCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.jTextFieldCarName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectServerPanel.class, (String)"LBL_NEAP_CreateCarModule"));
        this.jTextFieldCarName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.mainClassLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.mainClassTextFieldWithinEar.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.serverLibraryCheckbox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.cdiCheckbox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectServerPanel.class, (String)"ACSD_ProjectServerPanel_NA"));
    }

    private void addServerButtonActionPerformed(ActionEvent actionEvent) {
        ServerInstanceWrapper serverInstanceWrapper = (ServerInstanceWrapper)this.serversModel.getSelectedItem();
        String string = null;
        if (serverInstanceWrapper != null) {
            string = serverInstanceWrapper.getServerInstanceID();
        }
        ProfileItem profileItem = (ProfileItem)this.j2eeSpecComboBox.getSelectedItem();
        String string2 = ServerManager.showAddServerInstanceWizard();
        if (string2 != null) {
            string = string2;
            profileItem = null;
            this.j2eeSpecComboBox.setSelectedItem(null);
        }
        this.initServers(string);
        if (profileItem != null) {
            this.j2eeSpecComboBox.setSelectedItem(profileItem);
        }
    }

    private void j2eeSpecComboBoxActionPerformed(ActionEvent actionEvent) {
        this.setJ2eeVersionWarningPanel();
    }

    private void serverInstanceComboBoxActionPerformed(ActionEvent actionEvent) {
        ProfileItem profileItem = (ProfileItem)this.j2eeSpecComboBox.getSelectedItem();
        ServerInstanceWrapper serverInstanceWrapper = (ServerInstanceWrapper)this.serversModel.getSelectedItem();
        this.j2eeSpecComboBox.removeAllItems();
        if (serverInstanceWrapper != null) {
            J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstanceWrapper.getServerInstanceID());
            TreeSet treeSet = new TreeSet(Profile.UI_COMPARATOR);
            treeSet.addAll(j2eePlatform.getSupportedProfiles(this.j2eeModuleType));
            for (Profile profile : treeSet) {
                if (Profile.J2EE_13.equals(profile) || (this.j2eeModuleType == J2eeModule.Type.WAR ? Profile.JAVA_EE_6_FULL.equals(profile) : Profile.JAVA_EE_6_WEB.equals(profile))) continue;
                this.j2eeSpecComboBox.addItem(new ProfileItem(profile));
            }
            if (profileItem != null) {
                this.j2eeSpecComboBox.setSelectedItem(profileItem);
            }
        }
        this.wizard.fireChangeEvent();
    }

    private void jTextFieldContextPathKeyReleased(KeyEvent keyEvent) {
        this.contextModified = true;
    }

    private void createEjbCheckBox_action(ActionEvent actionEvent) {
        this.jTextFieldEjbModuleName.setEnabled(this.createEjbCheckBox.isSelected());
        this.wizard.fireChangeEvent();
    }

    private void createWARCheckBoxcreateWebAppCheckBox_action(ActionEvent actionEvent) {
        this.jTextFieldWebAppName.setEnabled(this.createWARCheckBox.isSelected());
        this.wizard.fireChangeEvent();
    }

    private void createCarCheckBox_action(ActionEvent actionEvent) {
        this.jTextFieldCarName.setEnabled(this.createCarCheckBox.isSelected());
        this.mainClassTextFieldWithinEar.setEnabled(this.createCarCheckBox.isSelected());
        this.wizard.fireChangeEvent();
    }

    private void serverLibraryCheckboxActionPerformed(ActionEvent actionEvent) {
        this.wizard.fireChangeEvent();
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        if (this.getSelectedServer() == null) {
            String string = NbBundle.getMessage(ProjectServerPanel.class, (String)"MSG_NoServer");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
            return false;
        }
        if (this.isSharableProject() && this.serverLibraryCheckbox.isEnabled() && this.serverLibraryCheckbox.isSelected()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)ProjectLocationPanel.decorateMessage(NbBundle.getMessage(ProjectServerPanel.class, (String)"PanelSharability.licenseWarning.text")));
        }
        if (J2eeModule.Type.EJB.equals(this.j2eeModuleType)) {
            this.setJ2eeVersionWarning(wizardDescriptor);
        }
        if (J2eeModule.Type.CAR.equals(this.j2eeModuleType) && !this.isMainClassValid(this.mainClassTextField.getText())) {
            ProjectServerPanel.setErrorMessage("ERROR_IllegalMainClassName", wizardDescriptor);
            return false;
        }
        if (J2eeModule.Type.EAR.equals(this.j2eeModuleType)) {
            String string;
            if (this.createWARCheckBox.isSelected()) {
                string = this.jTextFieldWebAppName.getText();
                if (string.length() < 1) {
                    ProjectServerPanel.setErrorMessage("MSG_NoWARName", wizardDescriptor);
                    return false;
                }
                if (!string.endsWith("-war")) {
                    ProjectServerPanel.setErrorMessage("MSG_WARNameNotBlueprints", wizardDescriptor);
                }
            }
            if (this.createEjbCheckBox.isSelected()) {
                string = this.jTextFieldEjbModuleName.getText();
                if (string.length() < 1) {
                    ProjectServerPanel.setErrorMessage("MSG_NoJARName", wizardDescriptor);
                    return false;
                }
                if (!string.endsWith("-ejb")) {
                    ProjectServerPanel.setErrorMessage("MSG_JARNameNotBlueprints", wizardDescriptor);
                }
            }
            if (this.createCarCheckBox.isSelected()) {
                string = this.jTextFieldCarName.getText();
                if (string.length() < 1) {
                    ProjectServerPanel.setErrorMessage("MSG_NoCARName", wizardDescriptor);
                    return false;
                }
                if (!this.isMainClassValid(this.mainClassTextFieldWithinEar.getText())) {
                    ProjectServerPanel.setErrorMessage("ERROR_IllegalMainClassName", wizardDescriptor);
                    return false;
                }
                if (!string.endsWith("-app-client")) {
                    ProjectServerPanel.setErrorMessage("MSG_CARNameNotBlueprints", wizardDescriptor);
                }
            }
        }
        return true;
    }

    private boolean isMainClassValid(String string) {
        boolean bl;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        boolean bl2 = bl = stringTokenizer.countTokens() > 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() != 0 && Utilities.isJavaIdentifier((String)string2)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private static void setErrorMessage(String string, WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ProjectServerPanel.class, (String)string));
    }

    private boolean isSharableProject() {
        return this.sharableProject;
    }

    void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("serverInstanceID", (Object)this.getSelectedServer());
        Profile profile = this.getSelectedJ2eeProfile();
        wizardDescriptor.putProperty("j2eeLevel", (Object)profile);
        wizardDescriptor.putProperty("contextPath", (Object)this.jTextFieldContextPath.getText().trim());
        wizardDescriptor.putProperty("earApplication", (Object)this.getSelectedEarApplication());
        wizardDescriptor.putProperty("warName", (Object)this.jTextFieldWebAppName.getText());
        wizardDescriptor.putProperty("jarName", (Object)this.jTextFieldEjbModuleName.getText());
        wizardDescriptor.putProperty("carName", (Object)this.jTextFieldCarName.getText());
        wizardDescriptor.putProperty("mainClass", (Object)(J2eeModule.Type.CAR.equals(this.j2eeModuleType) ? this.mainClassTextField.getText().trim() : this.mainClassTextFieldWithinEar.getText().trim()));
        wizardDescriptor.putProperty("createWAR", (Object)(this.createWARCheckBox.isVisible() ? this.createWARCheckBox.isSelected() : false));
        wizardDescriptor.putProperty("createJAR", (Object)(this.createEjbCheckBox.isVisible() ? this.createEjbCheckBox.isSelected() : false));
        wizardDescriptor.putProperty("createCAR", (Object)(this.createCarCheckBox.isVisible() ? this.createCarCheckBox.isSelected() : false));
        wizardDescriptor.putProperty("cdi", (Object)(this.cdiCheckbox.isVisible() ? this.cdiCheckbox.isSelected() : false));
        String string = "1.5";
        if (profile != null && (Profile.JAVA_EE_6_FULL.equals(profile) || Profile.JAVA_EE_6_WEB.equals(profile))) {
            string = "1.6";
        }
        if (this.warningPanel != null && this.warningPanel.getDowngradeAllowed()) {
            wizardDescriptor.putProperty("setJavaPlatform", (Object)this.warningPanel.getSuggestedJavaPlatformName());
            if (profile != null) {
                String string2 = J2eeVersionWarningPanel.findWarningType(profile);
                UserProjectSettings userProjectSettings = UserProjectSettings.getDefault();
                if (string2.equals("warnSetSourceLevel14") && userProjectSettings.isAgreedSetSourceLevel14()) {
                    string = "1.4";
                }
            }
        }
        wizardDescriptor.putProperty("setSourceLevel", (Object)string);
        wizardDescriptor.putProperty("serverLibrary", (Object)this.getServerLibraryName());
    }

    private String getServerLibraryName() {
        if (!this.serverLibraryCheckbox.isSelected() || !this.serverLibraryCheckbox.isEnabled()) {
            return null;
        }
        Deployment deployment = Deployment.getDefault();
        String string = deployment.getServerDisplayName(deployment.getServerID(this.getSelectedServer()));
        return string == null ? "" : PropertyUtils.getUsablePropertyName((String)string);
    }

    void read(WizardDescriptor wizardDescriptor) {
        if (!this.isContextModified()) {
            this.jTextFieldContextPath.setText(ProjectServerPanel.createDefaultContext((String)wizardDescriptor.getProperty("name")));
        }
        this.sharableProject = wizardDescriptor.getProperty("sharedLibraries") != null;
        this.serverLibraryCheckbox.setEnabled(this.isSharableProject());
        if (!this.serverLibraryCheckbox.isEnabled()) {
            this.serverLibraryCheckbox.setSelected(false);
        }
        this.projectLocation = (File)wizardDescriptor.getProperty("projdir");
        if (J2eeModule.Type.EJB.equals(this.j2eeModuleType)) {
            this.updateJ2EEVersion("ejb-jar.xml");
        }
        if (J2eeModule.Type.CAR.equals(this.j2eeModuleType)) {
            this.initClientAppMainClass((String)wizardDescriptor.getProperty("name"));
            this.updateJ2EEVersion("application-client.xml");
        }
        if (J2eeModule.Type.EAR.equals(this.j2eeModuleType)) {
            String string = (String)wizardDescriptor.getProperty("name");
            this.initClientAppMainClass(string);
            this.jTextFieldEjbModuleName.setText(MessageFormat.format(NbBundle.getMessage(ProjectServerPanel.class, (String)"TXT_EJBProjectName"), string));
            this.jTextFieldWebAppName.setText(MessageFormat.format(NbBundle.getMessage(ProjectServerPanel.class, (String)"TXT_WebAppProjectName"), string));
            this.jTextFieldCarName.setText(MessageFormat.format(NbBundle.getMessage(ProjectServerPanel.class, (String)"TXT_AppClientProjectName"), string));
        }
    }

    private static String createDefaultContext(String string) {
        return "/" + PropertyUtils.getUsablePropertyName((String)string);
    }

    private void initServers(String string) {
        this.serversModel.removeAllElements();
        TreeSet<ServerInstanceWrapper> treeSet = new TreeSet<ServerInstanceWrapper>();
        ServerInstanceWrapper serverInstanceWrapper = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (String string2 : Deployment.getDefault().getServerInstanceIDs()) {
            String string3 = Deployment.getDefault().getServerInstanceDisplayName(string2);
            J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(string2);
            if (string3 == null || j2eePlatform == null || !j2eePlatform.getSupportedTypes().contains(this.j2eeModuleType)) continue;
            ServerInstanceWrapper serverInstanceWrapper2 = new ServerInstanceWrapper(string2, string3);
            if (serverInstanceWrapper == null || !bl3) {
                if (string != null) {
                    if (string.equals(string2)) {
                        serverInstanceWrapper = serverInstanceWrapper2;
                    }
                } else {
                    String string4 = Deployment.getDefault().getServerID(string2);
                    if ("gfv3ee6".equals(string4)) {
                        serverInstanceWrapper = serverInstanceWrapper2;
                        bl3 = true;
                    } else if ("gfv3".equals(string4) && !bl3) {
                        serverInstanceWrapper = serverInstanceWrapper2;
                        bl2 = true;
                    } else if ("J2EE".equals(string4) && !bl3 && !bl2) {
                        serverInstanceWrapper = serverInstanceWrapper2;
                        bl = true;
                    } else if ("JBoss4".equals(string4) && !bl3 && !bl2 && !bl) {
                        serverInstanceWrapper = serverInstanceWrapper2;
                    }
                }
            }
            treeSet.add(serverInstanceWrapper2);
        }
        for (ServerInstanceWrapper serverInstanceWrapper3 : treeSet) {
            this.serversModel.addElement(serverInstanceWrapper3);
        }
        if (serverInstanceWrapper != null) {
            this.serversModel.setSelectedItem(serverInstanceWrapper);
        } else if (this.serversModel.getSize() > 0) {
            this.serversModel.setSelectedItem(this.serversModel.getElementAt(0));
        }
    }

    private Profile getSelectedJ2eeProfile() {
        ProfileItem profileItem = (ProfileItem)this.j2eeSpecComboBox.getSelectedItem();
        return profileItem == null ? null : profileItem.getProfile();
    }

    private String getSelectedServer() {
        ServerInstanceWrapper serverInstanceWrapper = (ServerInstanceWrapper)this.serversModel.getSelectedItem();
        if (serverInstanceWrapper == null) {
            return null;
        }
        return serverInstanceWrapper.getServerInstanceID();
    }

    protected boolean isContextModified() {
        return this.contextModified;
    }

    private Project getSelectedEarApplication() {
        int n = this.jComboBoxEnterprise.getSelectedIndex();
        return n <= 0 ? null : this.earProjects.get(n - 1);
    }

    private void initEnterpriseApplications() {
        this.jComboBoxEnterprise.addItem(NbBundle.getMessage(ProjectServerPanel.class, (String)"LBL_NWP1_AddToEnterprise_None"));
        this.jComboBoxEnterprise.setSelectedIndex(0);
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        this.earProjects = new ArrayList<Project>();
        for (int i = 0; i < projectArray.length; ++i) {
            J2eeApplicationProvider j2eeApplicationProvider = (J2eeApplicationProvider)projectArray[i].getLookup().lookup(J2eeApplicationProvider.class);
            if (j2eeApplicationProvider == null) continue;
            J2eeApplication j2eeApplication = (J2eeApplication)j2eeApplicationProvider.getJ2eeModule();
            ProjectInformation projectInformation = ProjectUtils.getInformation((Project)projectArray[i]);
            if (j2eeApplication == null) continue;
            this.earProjects.add(projectInformation.getProject());
            this.jComboBoxEnterprise.addItem(projectInformation.getDisplayName());
        }
        if (this.earProjects.size() <= 0) {
            this.jComboBoxEnterprise.setEnabled(false);
        }
    }

    private void setJ2eeVersionWarningPanel() {
        Profile profile = this.getSelectedJ2eeProfile();
        if (profile == null) {
            this.warningPlaceHolderPanel.setVisible(false);
            this.cdiCheckbox.setVisible(false);
            return;
        }
        this.cdiCheckbox.setVisible(!this.importScenario && (profile.equals(Profile.JAVA_EE_6_FULL) || profile.equals(Profile.JAVA_EE_6_WEB)));
        String string = J2eeVersionWarningPanel.findWarningType(profile);
        if (string == null && this.warningPanel == null) {
            this.warningPlaceHolderPanel.setVisible(false);
            return;
        }
        if (this.warningPanel == null) {
            this.warningPanel = new J2eeVersionWarningPanel(string);
            this.warningPlaceHolderPanel.add((Component)this.warningPanel, "Center");
            this.warningPanel.setWarningType(string);
        } else {
            this.warningPanel.setWarningType(string);
        }
        this.warningPlaceHolderPanel.setVisible(true);
        this.revalidate();
    }

    private void updateJ2EEVersion(String string) {
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)this.projectLocation));
        if (fileObject != null) {
            FileObject fileObject2 = FileSearchUtility.guessConfigFilesPath(fileObject, string);
            if (fileObject2 != null) {
                FileObject fileObject3 = fileObject2.getFileObject(string);
                if (J2eeModule.Type.EJB.equals(this.j2eeModuleType)) {
                    this.checkEjbJarXmlJ2eeVersion(fileObject3);
                } else if (J2eeModule.Type.CAR.equals(this.j2eeModuleType)) {
                    this.checkACXmlJ2eeVersion(fileObject3);
                }
            } else {
                this.j2eeSpecComboBox.setSelectedItem(new ProfileItem(Profile.JAVA_EE_5));
            }
        }
    }

    private BigDecimal getEjbJarXmlVersion(FileObject fileObject) throws IOException {
        EjbJar ejbJar;
        if (fileObject != null && (ejbJar = org.netbeans.modules.j2ee.dd.api.ejb.DDProvider.getDefault().getDDRoot(fileObject)) != null) {
            return ejbJar.getVersion();
        }
        return null;
    }

    private void checkEjbJarXmlJ2eeVersion(FileObject fileObject) {
        try {
            BigDecimal bigDecimal;
            this.xmlVersion = bigDecimal = this.getEjbJarXmlVersion(fileObject);
            if (bigDecimal == null) {
                return;
            }
            if (new BigDecimal("2.1").equals(bigDecimal)) {
                this.j2eeSpecComboBox.setSelectedItem(new ProfileItem(Profile.J2EE_14));
            }
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage(ProjectServerPanel.class, (String)"MSG_EjbJarXmlCorrupted");
            Exceptions.printStackTrace((Throwable)Exceptions.attachLocalizedMessage((Throwable)iOException, (String)string));
        }
    }

    private BigDecimal getACXmlVersion(FileObject fileObject) throws IOException {
        if (fileObject != null) {
            return DDProvider.getDefault().getDDRoot(fileObject).getVersion();
        }
        return null;
    }

    private void checkACXmlJ2eeVersion(FileObject fileObject) {
        try {
            BigDecimal bigDecimal = this.getACXmlVersion(fileObject);
            if (bigDecimal == null) {
                return;
            }
            if (new BigDecimal("1.4").equals(bigDecimal)) {
                this.j2eeSpecComboBox.setSelectedItem(new ProfileItem(Profile.J2EE_14));
            } else if (new BigDecimal("5").equals(bigDecimal)) {
                this.j2eeSpecComboBox.setSelectedItem(new ProfileItem(Profile.JAVA_EE_5));
            } else if (new BigDecimal("6").equals(bigDecimal)) {
                this.j2eeSpecComboBox.setSelectedItem(new ProfileItem(Profile.JAVA_EE_6_FULL));
            }
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage(ProjectServerPanel.class, (String)"MSG_AppClientXmlCorrupted");
            Exceptions.printStackTrace((Throwable)Exceptions.attachLocalizedMessage((Throwable)iOException, (String)string));
        }
    }

    private void setJ2eeVersionWarning(WizardDescriptor wizardDescriptor) {
        boolean bl;
        String string = null;
        ProfileItem profileItem = (ProfileItem)this.j2eeSpecComboBox.getSelectedItem();
        boolean bl2 = this.xmlVersion == null ? true : (bl = new BigDecimal("2.1").compareTo(this.xmlVersion) > 0);
        if (Profile.J2EE_14 == profileItem.getProfile() && bl) {
            string = NbBundle.getMessage(ProjectServerPanel.class, (String)"MSG_EjbJarXMLNotSupported");
        }
        if (wizardDescriptor != null) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
        }
        this.setJ2eeVersionWarningPanel();
    }

    private void initClientAppMainClass(String string) {
        if (!Utilities.isJavaIdentifier((String)(string = this.getPackageName(string)))) {
            string = NbBundle.getMessage(ProjectServerPanel.class, (String)"TXT_PackageNameSuffix", (Object)string);
        }
        if (J2eeModule.Type.CAR.equals(this.j2eeModuleType)) {
            this.mainClassTextField.setText(MessageFormat.format(NbBundle.getMessage(ProjectServerPanel.class, (String)"TXT_ClassName"), string));
        } else {
            this.mainClassTextFieldWithinEar.setText(MessageFormat.format(NbBundle.getMessage(ProjectServerPanel.class, (String)"TXT_ClassName"), string));
        }
    }

    private String getPackageName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ((bl || !Character.isJavaIdentifierPart(c)) && (!bl || !Character.isJavaIdentifierStart(c))) continue;
            bl = false;
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            }
            stringBuffer.append(c);
        }
        return stringBuffer.length() == 0 ? NbBundle.getMessage(ProjectServerPanel.class, (String)"TXT_DefaultPackageName") : stringBuffer.toString();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.wizard.fireChangeEvent();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.wizard.fireChangeEvent();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.wizard.fireChangeEvent();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ProjectImportLocationPanel.generateHelpID(ProjectServerPanel.class, this.j2eeModuleType));
    }

    private static class ProfileItem {
        private final Profile profile;

        public ProfileItem(Profile profile) {
            this.profile = profile;
        }

        public Profile getProfile() {
            return this.profile;
        }

        public String toString() {
            return this.profile.getDisplayName();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ProfileItem profileItem = (ProfileItem)object;
            return this.profile == profileItem.profile || this.profile != null && this.profile.equals(profileItem.profile);
        }

        public int hashCode() {
            int n = 7;
            n = 97 * n + (this.profile != null ? this.profile.hashCode() : 0);
            return n;
        }
    }

    private static class ServerInstanceWrapper
    implements Comparable {
        private final String serverInstanceID;
        private final String displayName;

        ServerInstanceWrapper(String string, String string2) {
            this.serverInstanceID = string;
            this.displayName = string2;
        }

        public String getServerInstanceID() {
            return this.serverInstanceID;
        }

        public String toString() {
            return this.displayName;
        }

        public int compareTo(Object object) {
            return this.toString().compareTo(object.toString());
        }
    }
}

