/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.ui;

import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.openide.util.ImageUtilities;
import org.openide.util.Parameters;

public final class MessageUtils {
    private MessageUtils() {
    }

    public static void setMessage(JLabel label, MessageType type, String message) {
        Parameters.notNull((CharSequence)"type", (Object)((Object)type));
        Parameters.notNull((CharSequence)"message", (Object)message);
        label.setForeground(type.getColor());
        MessageUtils.setMessage(label, type.getIcon(), message);
    }

    public static void clear(JLabel label) {
        MessageUtils.setMessage(label, (Icon)null, (String)null);
    }

    private static void setMessage(JLabel label, Icon icon, String message) {
        label.setIcon(message == null ? null : icon);
        label.setText(message);
        label.setToolTipText(message);
    }

    public static enum MessageType {
        ERROR{

            @Override
            protected Icon getIcon() {
                return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/j2ee/common/project/ui/resources/error.gif", (boolean)false);
            }

            @Override
            protected Color getColor() {
                Color errorForeground = UIManager.getColor("nb.errorForeground");
                if (errorForeground == null) {
                    errorForeground = new Color(255, 0, 0);
                }
                return errorForeground;
            }
        }
        ,
        WARNING{

            @Override
            protected Icon getIcon() {
                return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/j2ee/common/project/ui/resources/warning.gif", (boolean)false);
            }

            @Override
            protected Color getColor() {
                Color warningForeground = UIManager.getColor("nb.warningForeground");
                if (warningForeground == null) {
                    warningForeground = new Color(51, 51, 51);
                }
                return warningForeground;
            }
        };


        protected abstract Icon getIcon();

        protected abstract Color getColor();
    }
}

