/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.Node;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.StringFunctionNode;
import oracle.toplink.essentials.internal.parsing.TypeHelper;

public class SubstringNode
extends StringFunctionNode {
    private Node startPosition = null;
    private Node stringLength = null;

    public Node qualifyAttributeAccess(ParseTreeContext context) {
        if (this.left != null) {
            this.left = this.left.qualifyAttributeAccess(context);
        }
        if (this.startPosition != null) {
            this.startPosition = this.startPosition.qualifyAttributeAccess(context);
        }
        if (this.stringLength != null) {
            this.stringLength = this.stringLength.qualifyAttributeAccess(context);
        }
        return this;
    }

    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        if (this.left != null) {
            this.left.validate(context);
            this.left.validateParameter(context, typeHelper.getStringType());
        }
        if (this.startPosition != null) {
            this.startPosition.validate(context);
            this.startPosition.validateParameter(context, typeHelper.getIntType());
        }
        if (this.stringLength != null) {
            this.stringLength.validate(context);
            this.stringLength.validateParameter(context, typeHelper.getIntType());
        }
        this.setType(typeHelper.getStringType());
    }

    public Expression generateExpression(GenerationContext context) {
        Expression whereClause = this.getLeft().generateExpression(context);
        Expression startPosition = this.getStartPosition().generateExpression(context);
        Expression stringLength = this.getStringLength().generateExpression(context);
        whereClause = whereClause.substring(startPosition, stringLength);
        return whereClause;
    }

    private Node getStartPosition() {
        return this.startPosition;
    }

    private Node getStringLength() {
        return this.stringLength;
    }

    public void setStartPosition(Node newStartPosition) {
        this.startPosition = newStartPosition;
    }

    public void setStringLength(Node newStringLength) {
        this.stringLength = newStringLength;
    }
}

