/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;

public class RunScript {
    protected static final Logger LOGGER = Logger.getLogger(RunScript.class.getName());
    private final Provider provider;

    public RunScript(Provider provider) {
        assert (provider != null);
        this.provider = provider;
    }

    public void run() {
        try {
            this.getCallable().call();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected final Callable<Cancellable> getCallable() {
        return new Callable<Cancellable>(){

            @Override
            public Cancellable call() throws Exception {
                if (!RunScript.this.provider.isValid()) {
                    LOGGER.info("RunScript provider is not valid");
                    return new Cancellable(){

                        public boolean cancel() {
                            return true;
                        }
                    };
                }
                final Future result = PhpProgram.executeLater((ExternalProcessBuilder)RunScript.this.getProcessBuilder(), (ExecutionDescriptor)RunScript.this.getDescriptor(), (String)RunScript.this.getOutputTabTitle());
                return new Cancellable(){

                    public boolean cancel() {
                        return result.cancel(true);
                    }
                };
            }
        };
    }

    protected boolean isControllable() {
        return true;
    }

    protected ExecutionDescriptor getDescriptor() throws IOException {
        return this.provider.getDescriptor().controllable(this.isControllable());
    }

    protected ExternalProcessBuilder getProcessBuilder() {
        return this.provider.getProcessBuilder();
    }

    protected String getOutputTabTitle() {
        return this.provider.getOutputTabTitle();
    }

    public static interface Provider {
        public ExecutionDescriptor getDescriptor() throws IOException;

        public ExternalProcessBuilder getProcessBuilder();

        public String getOutputTabTitle();

        public boolean isValid();
    }

    public static final class InOutPostRedirector
    implements ExecutionDescriptor.InputProcessorFactory,
    Runnable {
        private final File tmpFile;
        private final Charset encoding;
        private BufferedWriter fileWriter;

        public InOutPostRedirector(File scriptFile) throws IOException {
            assert (scriptFile != null);
            this.tmpFile = FileUtil.normalizeFile((File)InOutPostRedirector.tempFileForScript(scriptFile));
            this.encoding = FileEncodingQuery.getEncoding((FileObject)FileUtil.toFileObject((File)scriptFile));
        }

        public InputProcessor newInputProcessor(final InputProcessor defaultProcessor) {
            return InputProcessors.proxy((InputProcessor[])new InputProcessor[]{defaultProcessor, new InputProcessor(){

                public void processInput(char[] chars) throws IOException {
                    InOutPostRedirector.this.getFileWriter().write(chars);
                }

                public void reset() throws IOException {
                    defaultProcessor.reset();
                }

                public void close() throws IOException {
                    InOutPostRedirector.this.getFileWriter().flush();
                    InOutPostRedirector.this.getFileWriter().close();
                    defaultProcessor.close();
                }
            }});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                PhpOptions options = PhpOptions.getInstance();
                if (options.isOpenResultInBrowser()) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(this.tmpFile.toURI().toURL());
                }
                if (options.isOpenResultInEditor()) {
                    FileObject fo = FileUtil.toFileObject((File)this.tmpFile);
                    DataObject dobj = DataObject.find((FileObject)fo);
                    EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
                    ec.open();
                }
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (CancellationException ex) {
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                this.setFileWriter(null);
            }
        }

        public synchronized BufferedWriter getFileWriter() throws FileNotFoundException {
            if (this.fileWriter == null) {
                this.fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.tmpFile), this.encoding));
            }
            return this.fileWriter;
        }

        public synchronized void setFileWriter(BufferedWriter fileWriter) {
            this.fileWriter = fileWriter;
        }

        private static File tempFileForScript(File scriptFile) throws IOException {
            File retval = File.createTempFile(scriptFile.getName(), ".html");
            retval.deleteOnExit();
            return retval;
        }
    }
}

