/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.MainImpl;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

public abstract class CLIHandler {
    private static final int KEY_LENGTH = 10;
    private static final byte[] VERSION = new byte[]{78, 66, 67, 76, 73, 0, 0, 0, 0, 1};
    private static final int REPLY_OK = 1;
    private static final int REPLY_EXIT = 2;
    private static final int REPLY_FAIL = 0;
    private static final int REPLY_DELAY = 3;
    private static final int REPLY_READ = 10;
    private static final int REPLY_WRITE = 11;
    private static final int REPLY_AVAILABLE = 12;
    private static final int REPLY_ERROR = 13;
    private static final int REPLY_VERSION = 14;
    public static final int WHEN_BOOT = 1;
    public static final int WHEN_INIT = 2;
    public static final int WHEN_EXTRA = 3;
    private static Server server;
    private static final Logger OUTPUT;
    private int when;
    private static List<Execute> doLater;

    protected CLIHandler(int when) {
        this.when = when;
    }

    protected abstract int cli(Args var1);

    protected static void showHelp(PrintWriter w, Collection<? extends CLIHandler> handlers, int when) {
        for (CLIHandler cLIHandler : handlers) {
            if (when != -1 && when != cLIHandler.when) continue;
            cLIHandler.usage(w);
        }
    }

    protected abstract void usage(PrintWriter var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enterState(int state, Integer block) {
        Object object;
        if (OUTPUT.isLoggable(Level.FINEST)) {
            object = OUTPUT;
            synchronized (object) {
                OUTPUT.finest("state: " + state + " thread: " + Thread.currentThread());
            }
        }
        if (block == null) {
            return;
        }
        object = block;
        synchronized (object) {
            if (state == block) {
                if (OUTPUT.isLoggable(Level.FINEST)) {
                    OUTPUT.finest(state + " blocked");
                }
                block.notifyAll();
                try {
                    block.wait();
                }
                catch (InterruptedException ex) {
                    throw new IllegalStateException();
                }
            } else if (OUTPUT.isLoggable(Level.FINEST)) {
                OUTPUT.finest(state + " not blocked");
            }
        }
    }

    private static boolean checkHelp(Args args, Collection<? extends CLIHandler> handlers) {
        String[] argv = args.getArguments();
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i] == null || !argv[i].equals("-?") && !argv[i].equals("--help") && !argv[i].equals("-help")) continue;
            Logger.getLogger("").setLevel(Level.OFF);
            PrintWriter w = new PrintWriter(args.getOutputStream());
            CLIHandler.showHelp(w, handlers, -1);
            w.flush();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected static int notifyHandlers(Args args, Collection<? extends CLIHandler> handlers, int when, boolean failOnUnknownOptions, boolean consume) {
        try {
            int r = 0;
            for (CLIHandler cLIHandler : handlers) {
                if (cLIHandler.when != when) continue;
                r = cLIHandler.cli(args);
                if (r == 0) continue;
                int n = r;
                return n;
            }
            String[] argv = args.getArguments();
            if (failOnUnknownOptions) {
                void n;
                argv = args.getArguments();
                boolean bl = false;
                while (n < argv.length) {
                    if (argv[n] != null) {
                        PrintWriter w = new PrintWriter(args.getOutputStream());
                        w.println("Ignored unknown option: " + argv[n]);
                        w.flush();
                        int n2 = 2;
                        return n2;
                    }
                    ++n;
                }
            }
            int n = 0;
            return n;
        }
        finally {
            args.reset(consume);
        }
    }

    static Status initialize(String[] args, InputStream is, OutputStream os, OutputStream err, MainImpl.BootClassLoader loader, boolean failOnUnknownOptions, boolean cleanLockFile, Runnable runWhenHome) {
        return CLIHandler.initialize(new Args(args, is, os, err, System.getProperty("user.dir")), null, loader.allCLIs(), failOnUnknownOptions, cleanLockFile, runWhenHome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int registerFinishInstallation(Execute run) {
        Class<CLIHandler> clazz = CLIHandler.class;
        synchronized (CLIHandler.class) {
            boolean runNow;
            if (doLater != null) {
                doLater.add(run);
                runNow = false;
            } else {
                runNow = true;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (runNow) {
                return run.exec();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int finishInitialization(boolean recreate) {
        OUTPUT.log(Level.FINER, "finishInitialization {0}", recreate);
        Class<CLIHandler> clazz = CLIHandler.class;
        synchronized (CLIHandler.class) {
            List<Execute> toRun = doLater;
            ArrayList arrayList = doLater = recreate ? new ArrayList() : null;
            if (OUTPUT.isLoggable(Level.FINER)) {
                OUTPUT.finer("Notify: " + toRun);
            }
            if (!recreate) {
                CLIHandler.class.notifyAll();
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (toRun != null) {
                for (Execute r : toRun) {
                    int result = r.exec();
                    if (result == 0) continue;
                    return result;
                }
            }
            return 0;
        }
    }

    private static synchronized boolean waitFinishInstallationIsOver(int timeout) {
        if (doLater != null) {
            try {
                CLIHandler.class.wait((long)timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return doLater == null;
    }

    public static synchronized void stopServer() {
        Server s = server;
        if (s != null) {
            s.stopServer();
        }
    }

    private static InetAddress localHostAddress() throws IOException {
        NetworkInterface net = NetworkInterface.getByName("lo");
        if (net == null || !net.getInetAddresses().hasMoreElements()) {
            net = NetworkInterface.getByInetAddress(InetAddress.getByAddress(new byte[]{127, 0, 0, 1}));
        }
        if (net == null || !net.getInetAddresses().hasMoreElements()) {
            return InetAddress.getLocalHost();
        }
        return net.getInetAddresses().nextElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Status initialize(final Args args, final Integer block, final Collection<? extends CLIHandler> handlers, final boolean failOnUnknownOptions, boolean cleanLockFile, Runnable runWhenHome) {
        int r = CLIHandler.notifyHandlers(args, handlers, 1, false, failOnUnknownOptions);
        if (r != 0) {
            return new Status(r);
        }
        String home = System.getProperty("netbeans.user");
        if (home == null) {
            home = System.getProperty("user.home");
            System.setProperty("netbeans.user", home);
        }
        if ("memory".equals(home)) {
            return new Status(0);
        }
        if (runWhenHome != null) {
            runWhenHome.run();
        }
        File lockFile = new File(home, "lock");
        int i = 0;
        while (i < 5) {
            try {
                if (lockFile.exists()) {
                    CLIHandler.enterState(5, block);
                    throw new IOException("EXISTS");
                }
                if (i == 0 && CLIHandler.checkHelp(args, handlers)) {
                    return new Status(2);
                }
                lockFile.getParentFile().mkdirs();
                lockFile.createNewFile();
                lockFile.deleteOnExit();
                CLIHandler.secureAccess(lockFile);
                CLIHandler.enterState(10, block);
                final byte[] arr = new byte[10];
                new Random().nextBytes(arr);
                server = new Server(arr, block, handlers, failOnUnknownOptions);
                final DataOutputStream os = new DataOutputStream(new FileOutputStream(lockFile));
                int p = server.getLocalPort();
                os.writeInt(p);
                os.flush();
                CLIHandler.enterState(20, block);
                RequestProcessor.Task parael = new RequestProcessor("Secure CLI Port").post(new Runnable(){

                    @Override
                    public void run() {
                        SecureRandom random = null;
                        CLIHandler.enterState(95, block);
                        try {
                            random = SecureRandom.getInstance("SHA1PRNG");
                        }
                        catch (NoSuchAlgorithmException e) {
                            try {
                                random = SecureRandom.getInstance("IBMSecureRandom");
                            }
                            catch (NoSuchAlgorithmException e2) {
                                server.stopServer();
                            }
                        }
                        CLIHandler.enterState(96, block);
                        if (random != null) {
                            random.nextBytes(arr);
                        }
                        CLIHandler.enterState(97, block);
                        try {
                            os.write(arr);
                            os.flush();
                            CLIHandler.enterState(27, block);
                            byte[] host = InetAddress.getLocalHost().getAddress();
                            if (block != null && block == 667) {
                                throw new UnknownHostException("dhcppc0");
                            }
                            for (int all = 0; all < host.length; ++all) {
                                os.write(host[all]);
                            }
                        }
                        catch (UnknownHostException unknownHost) {
                            if (!"dhcppc0".equals(unknownHost.getMessage())) {
                                unknownHost.printStackTrace();
                            }
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
                int execCode = CLIHandler.registerFinishInstallation(new Execute(){

                    @Override
                    public int exec() {
                        return CLIHandler.notifyHandlers(args, handlers, 2, failOnUnknownOptions, failOnUnknownOptions);
                    }

                    public String toString() {
                        return handlers.toString();
                    }
                });
                CLIHandler.enterState(0, block);
                return new Status(lockFile, server.getLocalPort(), execCode, (Task)parael);
            }
            catch (IOException ex) {
                block78: {
                    int port;
                    byte[] serverAddress;
                    byte[] key;
                    block80: {
                        FilterInputStream is;
                        block77: {
                            if (!"EXISTS".equals(ex.getMessage())) {
                                ex.printStackTrace();
                            }
                            key = null;
                            serverAddress = null;
                            port = -1;
                            is = null;
                            CLIHandler.enterState(21, block);
                            if (OUTPUT.isLoggable(Level.FINER)) {
                                OUTPUT.log(Level.FINER, "Reading lock file {0}", lockFile);
                            }
                            is = new DataInputStream(new FileInputStream(lockFile));
                            port = ((DataInputStream)is).readInt();
                            CLIHandler.enterState(22, block);
                            key = new byte[10];
                            ((DataInputStream)is).readFully(key);
                            CLIHandler.enterState(23, block);
                            byte[] x = new byte[4];
                            ((DataInputStream)is).readFully(x);
                            CLIHandler.enterState(24, block);
                            serverAddress = x;
                            if (is == null) break block77;
                            try {
                                is.close();
                            }
                            catch (IOException ex3) {
                                // empty catch block
                            }
                        }
                        CLIHandler.enterState(25, block);
                        break block80;
                        catch (EOFException eof) {
                            block79: {
                                if (port != -1) {
                                    CLIHandler.enterState(94, block);
                                    try {
                                        Socket socket = new Socket(CLIHandler.localHostAddress(), port);
                                        socket.close();
                                    }
                                    catch (Exception ex3) {
                                        lockFile.delete();
                                        if (is != null) {
                                            try {
                                                is.close();
                                            }
                                            catch (IOException ex32) {
                                                // empty catch block
                                            }
                                        }
                                        CLIHandler.enterState(25, block);
                                    }
                                    try {
                                        Thread.sleep(2000L);
                                        break block78;
                                    }
                                    catch (InterruptedException inter) {
                                        inter.printStackTrace();
                                    }
                                    break block78;
                                }
                                if (is == null) break block79;
                                {
                                    catch (Throwable throwable) {
                                        throw throwable;
                                    }
                                }
                                try {
                                    is.close();
                                }
                                catch (IOException ex3) {
                                    // empty catch block
                                }
                            }
                            CLIHandler.enterState(25, block);
                            break block80;
                            catch (IOException ex2) {
                                block81: {
                                    CLIHandler.enterState(26, block);
                                    if (is == null) break block81;
                                    try {
                                        is.close();
                                    }
                                    catch (IOException ex3) {
                                        // empty catch block
                                    }
                                }
                                CLIHandler.enterState(25, block);
                                break block80;
                            }
                            finally {
                                if (is != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (IOException ex3) {}
                                }
                                CLIHandler.enterState(25, block);
                            }
                        }
                    }
                    if (key != null && port != -1) {
                        block82: {
                            int version = -1;
                            try {
                                block48: while (true) {
                                    CLIHandler.enterState(28, block);
                                    Socket socket = new Socket(CLIHandler.localHostAddress(), port);
                                    socket.setSoTimeout(5000);
                                    DataOutputStream os = new DataOutputStream(socket.getOutputStream());
                                    if (version == -1) {
                                        os.write(VERSION);
                                    } else {
                                        os.write(key);
                                    }
                                    assert (VERSION.length == key.length);
                                    os.flush();
                                    CLIHandler.enterState(30, block);
                                    DataInputStream replyStream = new DataInputStream(socket.getInputStream());
                                    byte[] outputArr = new byte[4096];
                                    block49: while (true) {
                                        CLIHandler.enterState(32, block);
                                        int reply = replyStream.read();
                                        CLIHandler.enterState(34, block);
                                        switch (reply) {
                                            case 14: {
                                                version = replyStream.readInt();
                                                os.write(key);
                                                os.flush();
                                                break;
                                            }
                                            case 0: {
                                                if (version == -1) {
                                                    os.close();
                                                    replyStream.close();
                                                    socket.close();
                                                    version = 0;
                                                    continue block48;
                                                }
                                                CLIHandler.enterState(36, block);
                                                break block82;
                                            }
                                            case 1: {
                                                CLIHandler.enterState(38, block);
                                                String[] arr = args.getArguments();
                                                os.writeInt(arr.length);
                                                for (int a = 0; a < arr.length; ++a) {
                                                    os.writeUTF(arr[a]);
                                                }
                                                os.writeUTF(args.getCurrentDirectory().toString());
                                                os.flush();
                                                break;
                                            }
                                            case 2: {
                                                int exitCode = replyStream.readInt();
                                                if (exitCode == 0) {
                                                    exitCode = -1;
                                                }
                                                os.close();
                                                replyStream.close();
                                                CLIHandler.enterState(0, block);
                                                return new Status(lockFile, port, exitCode, null);
                                            }
                                            case 10: {
                                                CLIHandler.enterState(42, block);
                                                int howMuch = replyStream.readInt();
                                                if (howMuch > outputArr.length) {
                                                    outputArr = new byte[howMuch];
                                                }
                                                int really = args.getInputStream().read(outputArr, 0, howMuch);
                                                if (version >= 1) {
                                                    os.writeInt(really);
                                                } else {
                                                    os.write(really);
                                                }
                                                if (really > 0) {
                                                    os.write(outputArr, 0, really);
                                                }
                                                os.flush();
                                                break;
                                            }
                                            case 11: {
                                                CLIHandler.enterState(44, block);
                                                int howMuch = replyStream.readInt();
                                                if (howMuch > outputArr.length) {
                                                    outputArr = new byte[howMuch];
                                                }
                                                replyStream.read(outputArr, 0, howMuch);
                                                args.getOutputStream().write(outputArr, 0, howMuch);
                                                break;
                                            }
                                            case 13: {
                                                CLIHandler.enterState(45, block);
                                                int howMuch = replyStream.readInt();
                                                if (howMuch > outputArr.length) {
                                                    outputArr = new byte[howMuch];
                                                }
                                                replyStream.read(outputArr, 0, howMuch);
                                                args.getErrorStream().write(outputArr, 0, howMuch);
                                                break;
                                            }
                                            case 12: {
                                                CLIHandler.enterState(46, block);
                                                os.writeInt(args.getInputStream().available());
                                                os.flush();
                                                break;
                                            }
                                            case 3: {
                                                CLIHandler.enterState(47, block);
                                                break;
                                            }
                                            case -1: {
                                                CLIHandler.enterState(48, block);
                                                break block82;
                                            }
                                            default: {
                                                CLIHandler.enterState(49, block);
                                                assert (false) : reply;
                                                continue block49;
                                            }
                                        }
                                    }
                                    break;
                                }
                            }
                            catch (SocketTimeoutException ex2) {
                                CLIHandler.enterState(33, block);
                            }
                            catch (ConnectException ex2) {
                                CLIHandler.enterState(33, block);
                            }
                            catch (IOException ex2) {
                                ex2.printStackTrace();
                                CLIHandler.enterState(33, block);
                            }
                        }
                        boolean isSameHost = true;
                        if (serverAddress != null) {
                            try {
                                isSameHost = Arrays.equals(InetAddress.getLocalHost().getAddress(), serverAddress);
                            }
                            catch (UnknownHostException ex5) {
                                CLIHandler.enterState(999, block);
                            }
                        }
                        if (!cleanLockFile) {
                            if (!isSameHost) return new Status(-255);
                        }
                        lockFile.delete();
                    }
                    try {
                        CLIHandler.enterState(83, block);
                        Thread.sleep((int)(Math.random() * 1000.0));
                        CLIHandler.enterState(85, block);
                    }
                    catch (InterruptedException ex2) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        return new Status();
    }

    private static void secureAccess(File file) throws IOException {
        file.setReadable(false, false);
        file.setReadable(true, true);
    }

    static {
        OUTPUT = Logger.getLogger(CLIHandler.class.getName());
        doLater = new ArrayList<Execute>();
    }

    private static final class Server
    extends Thread {
        private byte[] key;
        private ServerSocket socket;
        private Integer block;
        private Collection<? extends CLIHandler> handlers;
        private Socket work;
        private static volatile int counter;
        private final boolean failOnUnknownOptions;
        private static long lastReply;
        private static long failDelay;

        public Server(byte[] key, Integer block, Collection<? extends CLIHandler> handlers, boolean failOnUnknownOptions) throws IOException {
            super("CLI Requests Server");
            this.key = key;
            this.setDaemon(true);
            this.block = block;
            this.handlers = handlers;
            this.failOnUnknownOptions = failOnUnknownOptions;
            this.socket = new ServerSocket(0, 50, CLIHandler.localHostAddress());
            this.start();
        }

        public Server(Socket request, byte[] key, Integer block, Collection<? extends CLIHandler> handlers, boolean failOnUnknownOptions) throws IOException {
            super("CLI Handler Thread Handler: " + ++counter);
            this.key = key;
            this.setDaemon(true);
            this.block = block;
            this.handlers = handlers;
            this.work = request;
            this.failOnUnknownOptions = failOnUnknownOptions;
            this.start();
        }

        public int getLocalPort() {
            return this.socket.getLocalPort();
        }

        @Override
        public void run() {
            if (this.work != null) {
                try {
                    this.handleConnect(this.work);
                }
                catch (IOException ex) {
                    OUTPUT.log(Level.INFO, null, ex);
                }
                return;
            }
            ServerSocket toClose = this.socket;
            if (toClose == null) {
                return;
            }
            while (this.socket != null) {
                try {
                    CLIHandler.enterState(65, this.block);
                    Socket s = this.socket.accept();
                    if (this.socket == null) {
                        CLIHandler.enterState(66, this.block);
                        s.getOutputStream().write(0);
                        CLIHandler.enterState(67, this.block);
                        s.close();
                        continue;
                    }
                    new Server(s, this.key, this.block, this.handlers, this.failOnUnknownOptions);
                }
                catch (InterruptedIOException ex) {
                    if (this.socket == null) continue;
                    ex.printStackTrace();
                }
                catch (SocketException ex) {
                    if (this.socket == null) continue;
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            try {
                toClose.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        final void stopServer() {
            this.socket = null;
            this.interrupt();
        }

        private void handleConnect(Socket s) throws IOException {
            byte requestedVersion;
            byte[] check = new byte[this.key.length];
            DataInputStream is = new DataInputStream(s.getInputStream());
            CLIHandler.enterState(70, this.block);
            is.readFully(check);
            final DataOutputStream os = new DataOutputStream(s.getOutputStream());
            boolean match = true;
            for (int i = 0; i < VERSION.length - 1; ++i) {
                if (VERSION[i] == check[i]) continue;
                match = false;
            }
            if (match) {
                requestedVersion = check[VERSION.length - 1];
                os.write(14);
                os.writeInt(VERSION[VERSION.length - 1]);
                os.flush();
                is.readFully(check);
            } else {
                requestedVersion = 0;
            }
            CLIHandler.enterState(90, this.block);
            if (Arrays.equals(check, this.key)) {
                while (!CLIHandler.waitFinishInstallationIsOver(2000)) {
                    os.write(3);
                    os.flush();
                }
                CLIHandler.enterState(93, this.block);
                os.write(1);
                os.flush();
                int numberOfArguments = is.readInt();
                String[] args = new String[numberOfArguments];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = is.readUTF();
                }
                String currentDir = is.readUTF();
                final Args arguments = new Args(args, new IS(is, os, requestedVersion), new OS(os, 11), new OS(os, 13), currentDir);
                class ComputingAndNotifying
                extends Thread {
                    public int res;
                    public boolean finished;

                    public ComputingAndNotifying() {
                        super("Computes values in handlers");
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            this.res = CLIHandler.checkHelp(arguments, Server.this.handlers) ? 2 : CLIHandler.notifyHandlers(arguments, Server.this.handlers, 2, Server.this.failOnUnknownOptions, false);
                            if (this.res == 0) {
                                CLIHandler.enterState(98, Server.this.block);
                            } else {
                                CLIHandler.enterState(99, Server.this.block);
                            }
                        }
                        finally {
                            ComputingAndNotifying computingAndNotifying = this;
                            synchronized (computingAndNotifying) {
                                this.finished = true;
                                this.notifyAll();
                            }
                        }
                    }

                    public synchronized void waitForResultAndNotifyOthers() {
                        this.start();
                        while (!this.finished) {
                            try {
                                this.wait(1000L);
                                os.write(3);
                                os.flush();
                            }
                            catch (SocketException ex) {
                                if (Server.isClosedSocket(ex)) {
                                    arguments.close();
                                    this.interrupt();
                                    continue;
                                }
                                ex.printStackTrace();
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                }
                ComputingAndNotifying r = new ComputingAndNotifying();
                r.waitForResultAndNotifyOthers();
                try {
                    os.write(2);
                    os.writeInt(r.res);
                }
                catch (SocketException ex) {
                    if (Server.isClosedSocket(ex)) {
                        arguments.close();
                        r.interrupt();
                    }
                    throw ex;
                }
            } else {
                CLIHandler.enterState(103, this.block);
                long toWait = lastReply + failDelay - System.currentTimeMillis();
                if (toWait > 0L) {
                    try {
                        Thread.sleep(toWait);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    failDelay *= 2L;
                } else {
                    failDelay = 100L;
                }
                lastReply = System.currentTimeMillis();
                os.write(0);
            }
            CLIHandler.enterState(120, this.block);
            os.close();
            is.close();
        }

        static final boolean isClosedSocket(SocketException ex) {
            if (ex.getMessage().equals("Broken pipe")) {
                return true;
            }
            return ex.getMessage().startsWith("Connection reset by peer");
        }

        static {
            failDelay = 100L;
        }

        private static final class OS
        extends OutputStream {
            private DataOutputStream os;
            private int type;

            public OS(DataOutputStream os, int type) {
                this.os = os;
                this.type = type;
            }

            @Override
            public void write(int b) throws IOException {
                byte[] arr = new byte[]{(byte)b};
                this.write(arr);
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            @Override
            public void close() throws IOException {
                super.close();
            }

            @Override
            public void flush() throws IOException {
                this.os.flush();
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.os.write(this.type);
                this.os.writeInt(len);
                this.os.write(b, off, len);
            }
        }

        private static final class IS
        extends InputStream {
            private final DataInputStream is;
            private final DataOutputStream os;
            private final int requestedVersion;

            public IS(DataInputStream is, DataOutputStream os, int version) {
                this.is = is;
                this.os = os;
                this.requestedVersion = version;
            }

            @Override
            public int read() throws IOException {
                byte[] arr = new byte[1];
                if (this.read(arr) == 1) {
                    return arr[0];
                }
                return -1;
            }

            @Override
            public void close() throws IOException {
                super.close();
            }

            @Override
            public int available() throws IOException {
                this.os.write(12);
                this.os.flush();
                return this.is.readInt();
            }

            @Override
            public int read(byte[] b) throws IOException {
                return this.read(b, 0, b.length);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int really;
                this.os.write(10);
                this.os.writeInt(len);
                this.os.flush();
                int n = really = this.requestedVersion >= 1 ? this.is.readInt() : this.is.read();
                if (really > 0) {
                    return this.is.read(b, off, really);
                }
                return really;
            }
        }
    }

    public static final class Args {
        private String[] args;
        private final String[] argsBackup;
        private InputStream is;
        private OutputStream os;
        private OutputStream err;
        private File currentDir;
        private boolean closed;

        Args(String[] args, InputStream is, OutputStream os, OutputStream err, String currentDir) {
            this.argsBackup = args;
            this.reset(false);
            this.is = is;
            this.os = os;
            this.err = err;
            this.currentDir = new File(currentDir);
        }

        void reset(boolean consume) {
            if (consume) {
                String[] a = this.args;
                if (a == null) {
                    a = this.argsBackup;
                }
                ArrayList<String> l = new ArrayList<String>(Arrays.asList(a));
                l.removeAll(Collections.singleton(null));
                this.args = l.toArray(new String[l.size()]);
            } else {
                this.args = (String[])this.argsBackup.clone();
            }
        }

        final void close() {
            this.closed = true;
        }

        public String[] getArguments() {
            return this.args;
        }

        public OutputStream getOutputStream() {
            return this.os;
        }

        public OutputStream getErrorStream() {
            return this.err;
        }

        public File getCurrentDirectory() {
            return this.currentDir;
        }

        public InputStream getInputStream() {
            return this.is;
        }

        public boolean isOpen() {
            return !this.closed;
        }
    }

    static interface Execute {
        public int exec();
    }

    static final class Status {
        public static final int CANNOT_CONNECT = -255;
        private final File lockFile;
        private final int port;
        private int exitCode;
        private Task parael;

        Status() {
            this(0);
        }

        Status(int c) {
            this(null, 0, c, null);
        }

        Status(File l, int p, int c, Task parael) {
            this.lockFile = l;
            this.port = p;
            this.exitCode = c;
            this.parael = parael;
        }

        private void waitFinished() {
            if (this.parael != null) {
                this.parael.waitFinished();
            }
        }

        public File getLockFile() {
            this.waitFinished();
            return this.lockFile;
        }

        public int getServerPort() {
            return this.port;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

