/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.oql.language;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.profiler.oql.language.OQLTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

class OQLLexer
implements Lexer<OQLTokenId> {
    private static final String TOKEN_FROM = "FROM";
    private static final String TOKEN_INSTANCEOF = "INSTANCEOF";
    private static final String TOKEN_SELECT = "SELECT";
    private static final String TOKEN_WHERE = "WHERE";
    private LexerInput input;
    private TokenFactory<OQLTokenId> tokenFactory;
    private State state = State.INIT;
    private final Pattern classPattern = Pattern.compile("(\\[*)[a-z]+(?:[a-z 0-9]*)(?:[\\. \\$][a-z 0-9]+)*(\\[\\])*", 2);
    private final Pattern classIdPattern = Pattern.compile("(0X)?([0-9 a-f A-F]+)");

    OQLLexer(LexerRestartInfo<OQLTokenId> info) {
        this.input = info.input();
        this.tokenFactory = info.tokenFactory();
        if (info.state() != null) {
            this.state = (State)((Object)info.state());
        }
    }

    public Token<OQLTokenId> nextToken() {
        int actChar;
        block27: while ((actChar = this.input.read()) != -1) {
            switch (this.state) {
                case INIT: {
                    String lastToken = ((Object)this.input.readText()).toString().toUpperCase();
                    if (Character.isWhitespace(actChar)) {
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.WHITESPACE);
                    }
                    this.input.backup(this.input.readLength());
                    if (TOKEN_SELECT.startsWith(lastToken.trim())) {
                        this.state = State.IN_SELECT;
                        break;
                    }
                    this.state = State.PLAIN_JS;
                    break;
                }
                case IN_SELECT: {
                    String lastToken = ((Object)this.input.readText()).toString().toUpperCase();
                    String trimmed = lastToken.trim();
                    if (Character.isWhitespace(actChar)) {
                        if (trimmed.length() == 0) {
                            return this.tokenFactory.createToken((TokenId)OQLTokenId.SELECT);
                        }
                        if (TOKEN_SELECT.equals(trimmed)) {
                            this.state = State.JSBLOCK;
                            this.input.backup(1);
                            return this.tokenFactory.createToken((TokenId)OQLTokenId.SELECT);
                        }
                        this.state = State.ERROR;
                        this.input.backup(this.input.readLength());
                        break;
                    }
                    if (TOKEN_SELECT.startsWith(trimmed)) break;
                    this.input.backup(this.input.readLength());
                    this.state = State.PLAIN_JS;
                    break;
                }
                case IN_FROM: {
                    if (!Character.isWhitespace(actChar)) break;
                    String lastToken = ((Object)this.input.readText()).toString().toUpperCase();
                    if (lastToken.trim().length() == 0) {
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.FROM);
                    }
                    if (TOKEN_FROM.equals(lastToken.trim())) {
                        this.input.backup(1);
                        this.state = State.FROM;
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.FROM, lastToken.trim().length(), PartType.COMPLETE);
                    }
                    this.state = State.ERROR;
                    this.input.backup(this.input.readLength());
                    break;
                }
                case FROM: {
                    String lastToken = ((Object)this.input.readText()).toString().toUpperCase();
                    String trimmed = lastToken.trim();
                    if (!TOKEN_FROM.startsWith(lastToken.trim())) {
                        this.input.backup(this.input.readLength());
                        this.state = State.JSBLOCK;
                    }
                    if (!Character.isWhitespace(actChar)) break;
                    if (trimmed.length() == 0) {
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.FROM);
                    }
                    this.input.backup(lastToken.length() - trimmed.length());
                    if (TOKEN_FROM.equals(trimmed)) {
                        this.state = State.FROM_INSTANCEOF;
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.FROM);
                    }
                    this.input.backup(this.input.readLength());
                    this.state = State.JSBLOCK;
                    break;
                }
                case FROM_INSTANCEOF: {
                    String lastToken = ((Object)this.input.readText()).toString().toUpperCase();
                    String trimmed = lastToken.trim();
                    if (!TOKEN_INSTANCEOF.startsWith(trimmed)) {
                        this.state = State.IN_CLASSNAME;
                        this.input.backup(this.input.readLength());
                    }
                    if (!Character.isWhitespace(actChar)) break;
                    if (trimmed.length() == 0) {
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.INSTANCEOF);
                    }
                    this.input.backup(lastToken.length() - trimmed.length());
                    if (TOKEN_INSTANCEOF.equals(trimmed)) {
                        this.state = State.IN_CLASSNAME;
                    }
                    return this.tokenFactory.createToken((TokenId)OQLTokenId.INSTANCEOF);
                }
                case JSBLOCK: {
                    String trimmed;
                    String lastToken;
                    if (Character.isWhitespace(actChar)) {
                        lastToken = ((Object)this.input.readText()).toString().toUpperCase();
                        trimmed = lastToken.trim();
                        if (trimmed.endsWith(TOKEN_FROM)) {
                            this.state = State.FROM;
                            if (this.input.readLength() > 5) {
                                this.input.backup(5);
                                return this.tokenFactory.createToken((TokenId)OQLTokenId.JSBLOCK);
                            }
                            this.state = State.ERROR;
                            this.input.backup(this.input.readLength());
                            break;
                        }
                        if (!TOKEN_SELECT.equals(trimmed) && !TOKEN_INSTANCEOF.equals(trimmed) && !TOKEN_WHERE.equals(trimmed)) continue block27;
                        this.state = State.ERROR;
                        this.input.backup(this.input.readLength());
                        break;
                    }
                    if (actChar != 40 && actChar != 41 && actChar != 91 && actChar != 93 && actChar != 123 && actChar != 125 && actChar != 46 && actChar != 44) break;
                    this.state = State.JSBLOCK1;
                    this.input.backup(1);
                    if (this.input.readLength() <= 0) break;
                    return this.tokenFactory.createToken((TokenId)OQLTokenId.JSBLOCK);
                }
                case JSBLOCK1: {
                    if (actChar == 40 || actChar == 41 || actChar == 91 || actChar == 93 || actChar == 123 || actChar == 125) {
                        this.state = State.JSBLOCK;
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.BRACE);
                    }
                    if (actChar == 46) {
                        this.state = State.JSBLOCK;
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.DOT);
                    }
                    if (actChar != 44) break;
                    this.state = State.JSBLOCK;
                    return this.tokenFactory.createToken((TokenId)OQLTokenId.COMMA);
                }
                case IN_CLASSNAME: {
                    if (!Character.isWhitespace(actChar)) break;
                    String lastToken = ((Object)this.input.readText()).toString().toUpperCase();
                    Matcher idMatcher = this.classIdPattern.matcher(lastToken.trim());
                    if (idMatcher.matches()) {
                        this.input.backup(1);
                        this.state = State.CLASS_ALIAS;
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.CLAZZ);
                    }
                    Matcher nameMatcher = this.classPattern.matcher(lastToken.trim());
                    if (!nameMatcher.matches()) continue block27;
                    this.input.backup(1);
                    if ((OQLLexer.isEmpty(nameMatcher.group(1)) ? 0 : 1) + (OQLLexer.isEmpty(nameMatcher.group(2)) ? 0 : 1) > 1) {
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.CLAZZ_E);
                    }
                    this.state = State.CLASS_ALIAS;
                    return this.tokenFactory.createToken((TokenId)OQLTokenId.CLAZZ);
                }
                case CLASS_ALIAS: {
                    String lastToken = ((Object)this.input.readText()).toString().toUpperCase();
                    if (TOKEN_SELECT.equals(lastToken) || TOKEN_FROM.equals(lastToken) || TOKEN_INSTANCEOF.equals(lastToken) || TOKEN_WHERE.equals(lastToken)) {
                        this.state = State.ERROR;
                        this.input.backup(this.input.readLength());
                        break;
                    }
                    if (Character.isWhitespace(actChar)) {
                        if (lastToken.trim().length() == 0) {
                            return this.tokenFactory.createToken((TokenId)OQLTokenId.IDENTIFIER);
                        }
                        this.input.backup(lastToken.length() - lastToken.trim().length());
                        this.state = State.IN_WHERE;
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.IDENTIFIER);
                    }
                    if (Character.isLetter(actChar)) break;
                    this.state = State.ERROR;
                    this.input.backup(1);
                    break;
                }
                case IN_WHERE: {
                    String lastToken = ((Object)this.input.readText()).toString().toUpperCase();
                    String trimmed = lastToken.trim();
                    if (!TOKEN_WHERE.startsWith(trimmed)) {
                        this.state = State.ERROR;
                        this.input.backup(this.input.readLength());
                    }
                    if (!Character.isWhitespace(actChar)) break;
                    if (trimmed.length() == 0) {
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.WHERE);
                    }
                    this.input.backup(lastToken.length() - trimmed.length());
                    if (TOKEN_WHERE.equals(trimmed)) {
                        this.state = State.JSBLOCK;
                    }
                    return this.tokenFactory.createToken((TokenId)OQLTokenId.WHERE);
                }
                case PLAIN_JS: {
                    break;
                }
                case ERROR: {
                    while (this.input.read() != -1) {
                    }
                    return this.tokenFactory.createToken((TokenId)OQLTokenId.ERROR);
                }
            }
        }
        if (this.input.readLength() == 0) {
            return null;
        }
        switch (this.state) {
            case INIT: {
                return this.tokenFactory.createToken((TokenId)OQLTokenId.UNKNOWN);
            }
            case IN_SELECT: {
                return this.tokenFactory.createToken((TokenId)OQLTokenId.SELECT, this.input.readLength(), PartType.START);
            }
            case JSBLOCK: {
                String lastToken = ((Object)this.input.readText()).toString().trim().toUpperCase();
                if (lastToken.endsWith(TOKEN_FROM)) {
                    this.state = State.IN_FROM;
                    if (this.input.readLength() > 5) {
                        this.input.backup(5);
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.JSBLOCK);
                    }
                    this.state = State.ERROR;
                    return this.tokenFactory.createToken((TokenId)OQLTokenId.ERROR);
                }
                return this.tokenFactory.createToken((TokenId)OQLTokenId.JSBLOCK, this.input.readLength(), PartType.START);
            }
            case PLAIN_JS: {
                return this.tokenFactory.createToken((TokenId)OQLTokenId.JSBLOCK);
            }
            case IN_FROM: {
                return this.tokenFactory.createToken((TokenId)OQLTokenId.FROM, this.input.readLength(), PartType.START);
            }
            case FROM: {
                return this.tokenFactory.createToken((TokenId)OQLTokenId.UNKNOWN);
            }
            case FROM_INSTANCEOF: {
                return this.tokenFactory.createToken((TokenId)OQLTokenId.INSTANCEOF, this.input.readLength(), PartType.START);
            }
            case IN_CLASSNAME: {
                String lastToken = ((Object)this.input.readText()).toString().trim().toUpperCase();
                Matcher matcher = this.classPattern.matcher(lastToken);
                if (matcher.matches()) {
                    if ((OQLLexer.isEmpty(matcher.group(1)) ? 0 : 1) + (OQLLexer.isEmpty(matcher.group(2)) ? 0 : 1) > 1) {
                        return this.tokenFactory.createToken((TokenId)OQLTokenId.ERROR);
                    }
                    this.state = State.CLASS_ALIAS;
                    this.input.backup(1);
                    return this.tokenFactory.createToken((TokenId)OQLTokenId.CLAZZ);
                }
                return this.tokenFactory.createToken((TokenId)OQLTokenId.CLAZZ_E);
            }
            case CLASS_ALIAS: {
                String lastToken = ((Object)this.input.readText()).toString().toUpperCase();
                if (TOKEN_SELECT.equals(lastToken) || TOKEN_FROM.equals(lastToken) || TOKEN_INSTANCEOF.equals(lastToken) || TOKEN_WHERE.equals(lastToken)) {
                    this.state = State.ERROR;
                    return this.tokenFactory.createToken((TokenId)OQLTokenId.ERROR);
                }
                return this.tokenFactory.createToken((TokenId)OQLTokenId.IDENTIFIER);
            }
            case IN_WHERE: {
                return this.tokenFactory.createToken((TokenId)OQLTokenId.WHERE, this.input.readLength(), PartType.START);
            }
            case ERROR: {
                return this.tokenFactory.createToken((TokenId)OQLTokenId.ERROR);
            }
        }
        return this.tokenFactory.createToken((TokenId)OQLTokenId.UNKNOWN);
    }

    private static final boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public Object state() {
        return this.state;
    }

    public void release() {
    }

    static enum State {
        INIT,
        IN_SELECT,
        IN_FROM,
        IN_WHERE,
        IN_CLASSNAME,
        IN_CLASSID,
        PLAIN_JS,
        FROM,
        FROM_INSTANCEOF,
        CLASS_ALIAS,
        JSBLOCK,
        JSBLOCK1,
        ERROR;

    }
}

