/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.model;

import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.model.RubyEntity;
import org.rubyforge.debugcommons.model.RubyFrameInfo;
import org.rubyforge.debugcommons.model.RubyThread;
import org.rubyforge.debugcommons.model.RubyVariable;

public final class RubyFrame
extends RubyEntity {
    private final RubyFrameInfo info;
    private final RubyThread thread;
    private RubyVariable[] variables;

    public RubyFrame(RubyThread thread, RubyFrameInfo info) {
        super(thread.getProxy());
        this.info = info;
        this.thread = thread;
    }

    public String getFile() {
        return this.info.getFile();
    }

    public int getLine() {
        return this.info.getLine();
    }

    public int getIndex() {
        return this.info.getIndex();
    }

    public RubyThread getThread() {
        return this.thread;
    }

    public RubyVariable[] getVariables() throws RubyDebuggerException {
        if (this.variables == null) {
            this.variables = this.getProxy().readVariables(this);
        }
        return this.variables;
    }

    public RubyVariable inspectExpression(String expression) throws RubyDebuggerException {
        return this.getProxy().inspectExpression(this, expression);
    }

    public boolean hasVariables() throws RubyDebuggerException {
        return this.getVariables().length > 0;
    }

    public String getName() {
        return this.getFile() + ':' + this.getLine();
    }

    public boolean isStepping() {
        return false;
    }

    public void stepInto(boolean forceNewLine) {
        this.thread.resume(true);
        this.getProxy().sendStepIntoEnd(this, forceNewLine);
    }

    public void stepInto() {
        this.stepInto(false);
    }

    public void stepOver(boolean forceNewLine) {
        this.thread.resume(true);
        this.getProxy().sendStepOver(this, forceNewLine);
    }

    public void stepOver() {
        this.stepOver(false);
    }

    public void stepReturn() {
        this.thread.resume(true);
        this.getProxy().sendStepReturnEnd(this);
    }

    public void resume() {
        this.getThread().resume();
    }

    public void suspend() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RubyFrame)) {
            return false;
        }
        RubyFrame other = (RubyFrame)obj;
        return this.info == null ? other.info == null : this.info.equals(other.info);
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + (this.info != null ? this.info.hashCode() : 0);
        return hash;
    }
}

