/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.refactoring;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.websvc.wsitconf.refactoring.WSITRefactoringPlugin;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class WSITSafeDeleteRefactoringPlugin
extends WSITRefactoringPlugin<SafeDeleteRefactoring> {
    public WSITSafeDeleteRefactoringPlugin(SafeDeleteRefactoring safeDeleteRefactoring) {
        super(safeDeleteRefactoring);
    }

    @Override
    protected RefactoringElementImplementation createMethodRE(String string, WSDLModel wSDLModel) {
        return new MethodRE(string, wSDLModel);
    }

    @Override
    protected RefactoringElementImplementation createClassRE(WSDLModel wSDLModel) {
        return new ClassRE(wSDLModel);
    }

    private static class MethodRE
    extends WSITRefactoringPlugin.AbstractRefactoringElement {
        private final String methodName;

        public MethodRE(String string, WSDLModel wSDLModel) {
            super(wSDLModel);
            this.methodName = string;
        }

        public void performChange() {
            Definitions definitions = this.model.getDefinitions();
            Binding binding = (Binding)definitions.getBindings().toArray()[0];
            Collection collection = definitions.getMessages();
            Collection collection2 = binding.getBindingOperations();
            PortType portType = (PortType)definitions.getPortTypes().toArray()[0];
            Collection collection3 = portType.getOperations();
            this.model.startTransaction();
            for (BindingOperation bindingOperation : collection2) {
                if (!this.methodName.equals(bindingOperation.getName())) continue;
                binding.removeBindingOperation(bindingOperation);
            }
            for (BindingOperation bindingOperation : collection3) {
                if (!this.methodName.equals(bindingOperation.getName())) continue;
                portType.removeOperation((Operation)bindingOperation);
            }
            for (BindingOperation bindingOperation : collection) {
                if (!this.methodName.equals(bindingOperation.getName()) && !(this.methodName + "Response").equals(bindingOperation.getName())) continue;
                definitions.removeMessage((Message)bindingOperation);
            }
            this.model.endTransaction();
        }

        public void undoChange() {
        }

        public String getDisplayText() {
            Object[] objectArray = new Object[]{this.methodName, this.getParentFile().getNameExt()};
            return MessageFormat.format(NbBundle.getMessage(MethodRE.class, (String)"TXT_WsitXmlMethodSafeDelete"), objectArray);
        }
    }

    private static class ClassRE
    extends WSITRefactoringPlugin.AbstractRefactoringElement {
        private BackupFacility.Handle id;

        public ClassRE(WSDLModel wSDLModel) {
            super(wSDLModel);
        }

        public void performChange() {
            FileObject fileObject = this.getParentFile();
            try {
                this.id = BackupFacility.getDefault().backup(new FileObject[]{fileObject});
                fileObject.delete();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public void undoChange() {
            try {
                this.id.restore();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public String getDisplayText() {
            Object[] objectArray = new Object[]{this.getParentFile().getNameExt()};
            return MessageFormat.format(NbBundle.getMessage(ClassRE.class, (String)"TXT_WsitXmlClassSafeDelete"), objectArray);
        }
    }
}

