/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.search.SvnSearchPanel;
import org.netbeans.modules.subversion.ui.search.SvnSearchView;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SvnSearch
implements ActionListener,
DocumentListener {
    public static final String SEACRH_HELP_ID_CHECKOUT = "org.netbeans.modules.subversion.ui.search.checkout";
    public static final String SEACRH_HELP_ID_SWITCH = "org.netbeans.modules.subversion.ui.search.switch";
    public static final String SEACRH_HELP_ID_COPY = "org.netbeans.modules.subversion.ui.search.copy";
    public static final String SEACRH_HELP_ID_URL_PATTERN = "org.netbeans.modules.subversion.ui.search.urlpattern";
    public static final String SEACRH_HELP_ID_MERGE = "org.netbeans.modules.subversion.ui.search.merge";
    public static final String SEACRH_HELP_ID_REVERT = "org.netbeans.modules.subversion.ui.search.revert";
    private static final String DATE_FROM = "svnSearch.dateFrom";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private final SvnSearchPanel panel;
    private RepositoryFile[] repositoryFiles;
    private SvnSearchView searchView;
    private SvnProgressSupport support;
    private NoContentPanel noContentPanel;

    public SvnSearch(RepositoryFile ... repositoryFile) {
        this.repositoryFiles = repositoryFile;
        this.panel = new SvnSearchPanel();
        this.panel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SvnSearch.class, (String)"ACSN_SummaryView_Name"));
        this.panel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SvnSearch.class, (String)"ACSD_SummaryView_Desc"));
        this.panel.listButton.addActionListener(this);
        this.panel.dateFromTextField.getDocument().addDocumentListener(this);
        String date = DATE_FORMAT.format(new Date(System.currentTimeMillis() - 604800000L));
        this.panel.dateFromTextField.setText(SvnModuleConfig.getDefault().getPreferences().get(DATE_FROM, date));
        this.searchView = new SvnSearchView();
        this.panel.listPanel.setLayout(new BorderLayout());
        this.panel.listPanel.add(this.searchView.getComponent());
        this.noContentPanel = new NoContentPanel();
        this.panel.noContentPanel.setLayout(new BorderLayout());
        this.panel.noContentPanel.add((Component)this.noContentPanel);
        this.noContentPanel.setLabel(NbBundle.getMessage(SvnSearch.class, (String)"LBL_NoResults_SearchNotPerformed"));
        this.panel.listPanel.setVisible(false);
        this.panel.noContentPanel.setVisible(true);
    }

    public void cancel() {
        if (this.support != null) {
            this.support.cancel();
        }
    }

    private void listLogEntries() {
        this.noContentPanel.setLabel(NbBundle.getMessage(SvnSearch.class, (String)"LBL_NoResults_SearchInProgress"));
        this.panel.listPanel.setVisible(false);
        this.panel.noContentPanel.setVisible(true);
        final SVNRevision revisionFrom = this.getRevisionFrom();
        final SVNUrl repositoryUrl = this.repositoryFiles[0].getRepositoryUrl();
        if (revisionFrom instanceof SVNRevision.DateSpec) {
            SvnModuleConfig.getDefault().getPreferences().put(DATE_FROM, this.panel.dateFromTextField.getText().trim());
        }
        final String[] paths = new String[this.repositoryFiles.length];
        for (int i = 0; i < this.repositoryFiles.length; ++i) {
            String[] segments = this.repositoryFiles[i].getPathSegments();
            StringBuffer sb = new StringBuffer();
            for (String segment : segments) {
                sb.append(segment);
                sb.append('/');
            }
            paths[i] = sb.toString();
        }
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor();
        this.support = new SvnProgressSupport(){

            @Override
            protected void perform() {
                ISVNLogMessage[] messageArray = null;
                try {
                    SvnClient client = Subversion.getInstance().getClient(repositoryUrl, (SvnProgressSupport)this);
                    messageArray = SvnUtils.getLogMessages(client, repositoryUrl, paths, SVNRevision.HEAD, revisionFrom, false, true);
                }
                catch (SVNClientException ex) {
                    AbstractNode errorNode = new AbstractNode(Children.LEAF);
                    errorNode.setDisplayName(NbBundle.getMessage(SvnSearch.class, (String)"LBL_Error"));
                    errorNode.setShortDescription(ex.getLocalizedMessage());
                    return;
                }
                if (this.isCanceled()) {
                    return;
                }
                if (messageArray == null) {
                    return;
                }
                final ArrayList<ISVNLogMessage> messages = new ArrayList<ISVNLogMessage>();
                if (revisionFrom instanceof SVNRevision.DateSpec) {
                    long timeFrom = ((SVNRevision.DateSpec)revisionFrom).getDate().getTime();
                    for (ISVNLogMessage lm : messageArray) {
                        if (lm.getDate().getTime() < timeFrom) continue;
                        messages.add(lm);
                    }
                } else {
                    long revision = ((SVNRevision.Number)revisionFrom).getNumber();
                    for (ISVNLogMessage lm : messageArray) {
                        if (lm.getRevision().getNumber() < revision) continue;
                        messages.add(lm);
                    }
                }
                if (this.isCanceled()) {
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((SvnSearch)SvnSearch.this).panel.listPanel.setVisible(true);
                        ((SvnSearch)SvnSearch.this).panel.noContentPanel.setVisible(false);
                        SvnSearch.this.searchView.setResults(messages.toArray(new ISVNLogMessage[messages.size()]));
                    }
                });
            }
        };
        this.support.start(rp, repositoryUrl, NbBundle.getMessage(SvnSearch.class, (String)"LBL_Search_Progress")).addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                SvnSearch.this.support = null;
            }
        });
    }

    public JPanel getSearchPanel() {
        return this.panel;
    }

    public SVNRevision getSelectedRevision() {
        return this.searchView.getSelectedValue();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.searchView.addListSelectionListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.searchView.removeListSelectionListener(listener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.panel.listButton) {
            this.listLogEntries();
        }
    }

    private SVNRevision getRevisionFrom() {
        String value = this.panel.dateFromTextField.getText().trim();
        if (value.equals("")) {
            return new SVNRevision.Number(1L);
        }
        try {
            return new SVNRevision.DateSpec(DATE_FORMAT.parse(value));
        }
        catch (ParseException ex) {
            return null;
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.validateUserInput();
    }

    private void validateUserInput() {
        boolean isValid = false;
        String dateString = this.panel.dateFromTextField.getText();
        if (dateString.equals("")) {
            isValid = true;
        } else {
            try {
                DATE_FORMAT.parse(this.panel.dateFromTextField.getText());
                isValid = true;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this.panel.listButton.setEnabled(isValid);
    }
}

