/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.util;

import org.joni.Regex;
import org.joni.encoding.Encoding;
import org.joni.encoding.specific.ASCIIEncoding;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyBignum;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyFloat;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class Numeric {
    private static long SQRT_LONG_MAX = 0x80000000L;

    public static IRubyObject f_add(ThreadContext context, IRubyObject x, IRubyObject y) {
        if (y instanceof RubyFixnum && ((RubyFixnum)y).getLongValue() == 0L) {
            return x;
        }
        if (x instanceof RubyFixnum && ((RubyFixnum)x).getLongValue() == 0L) {
            return y;
        }
        return x.callMethod(context, "+", y);
    }

    public static IRubyObject f_cmp(ThreadContext context, IRubyObject x, IRubyObject y) {
        if (x instanceof RubyFixnum && y instanceof RubyFixnum) {
            long c = ((RubyFixnum)x).getLongValue() - ((RubyFixnum)y).getLongValue();
            if (c > 0L) {
                return RubyFixnum.one(context.getRuntime());
            }
            if (c < 0L) {
                return RubyFixnum.minus_one(context.getRuntime());
            }
            return RubyFixnum.zero(context.getRuntime());
        }
        return x.callMethod(context, "<=>", y);
    }

    public static IRubyObject f_div(ThreadContext context, IRubyObject x, IRubyObject y) {
        if (y instanceof RubyFixnum && ((RubyFixnum)y).getLongValue() == 1L) {
            return x;
        }
        return x.callMethod(context, "/", y);
    }

    public static IRubyObject f_gt_p(ThreadContext context, IRubyObject x, IRubyObject y) {
        if (x instanceof RubyFixnum && y instanceof RubyFixnum) {
            return ((RubyFixnum)x).getLongValue() > ((RubyFixnum)y).getLongValue() ? context.getRuntime().getTrue() : context.getRuntime().getFalse();
        }
        return x.callMethod(context, ">", y);
    }

    public static IRubyObject f_lt_p(ThreadContext context, IRubyObject x, IRubyObject y) {
        if (x instanceof RubyFixnum && y instanceof RubyFixnum) {
            return ((RubyFixnum)x).getLongValue() < ((RubyFixnum)y).getLongValue() ? context.getRuntime().getTrue() : context.getRuntime().getFalse();
        }
        return x.callMethod(context, "<", y);
    }

    public static IRubyObject f_mod(ThreadContext context, IRubyObject x, IRubyObject y) {
        return x.callMethod(context, "%", y);
    }

    public static IRubyObject f_mul(ThreadContext context, IRubyObject x, IRubyObject y) {
        Ruby runtime = context.getRuntime();
        if (y instanceof RubyFixnum) {
            long iy = ((RubyFixnum)y).getLongValue();
            if (iy == 0L) {
                if (x instanceof RubyFloat) {
                    return runtime.newFloat(0.0);
                }
                return RubyFixnum.zero(runtime);
            }
            if (iy == 1L) {
                return x;
            }
        } else if (x instanceof RubyFixnum) {
            long ix = ((RubyFixnum)x).getLongValue();
            if (ix == 0L) {
                if (y instanceof RubyFloat) {
                    return runtime.newFloat(0.0);
                }
                return RubyFixnum.zero(runtime);
            }
            if (ix == 1L) {
                return y;
            }
        }
        return x.callMethod(context, "*", y);
    }

    public static IRubyObject f_sub(ThreadContext context, IRubyObject x, IRubyObject y) {
        if (y instanceof RubyFixnum && ((RubyFixnum)y).getLongValue() == 0L) {
            return x;
        }
        return x.callMethod(context, "-", y);
    }

    public static IRubyObject f_xor(ThreadContext context, IRubyObject x, IRubyObject y) {
        return x.callMethod(context, "^", y);
    }

    public static IRubyObject f_abs(ThreadContext context, IRubyObject x) {
        return x.callMethod(context, "abs");
    }

    public static IRubyObject f_abs2(ThreadContext context, IRubyObject x) {
        return x.callMethod(context, "abs2");
    }

    public static IRubyObject f_arg(ThreadContext context, IRubyObject x) {
        return x.callMethod(context, "arg");
    }

    public static IRubyObject f_conjugate(ThreadContext context, IRubyObject x) {
        return x.callMethod(context, "conjugate");
    }

    public static IRubyObject f_denominator(ThreadContext context, IRubyObject x) {
        return x.callMethod(context, "denominator");
    }

    public static IRubyObject f_exact_p(ThreadContext context, IRubyObject x) {
        return x.callMethod(context, "exact?");
    }

    public static IRubyObject f_numerator(ThreadContext context, IRubyObject x) {
        return x.callMethod(context, "numerator");
    }

    public static IRubyObject f_polar(ThreadContext context, IRubyObject x) {
        return x.callMethod(context, "polar");
    }

    public static IRubyObject f_scalar_p(ThreadContext context, IRubyObject x) {
        return x.callMethod(context, "scalar?");
    }

    public static IRubyObject f_divmod(ThreadContext context, IRubyObject x, IRubyObject y) {
        return x.callMethod(context, "divmod", y);
    }

    public static IRubyObject f_floor(ThreadContext context, IRubyObject x) {
        return x.callMethod(context, "floor");
    }

    public static IRubyObject f_inspect(ThreadContext context, IRubyObject x) {
        return x.callMethod(context, "inspect");
    }

    public static IRubyObject f_negate(ThreadContext context, IRubyObject x) {
        return x.callMethod(context, "-@");
    }

    public static IRubyObject f_to_f(ThreadContext context, IRubyObject x) {
        return x.callMethod(context, "to_f");
    }

    public static IRubyObject f_to_i(ThreadContext context, IRubyObject x) {
        return x.callMethod(context, "to_i");
    }

    public static IRubyObject f_to_r(ThreadContext context, IRubyObject x) {
        return x.callMethod(context, "to_r");
    }

    public static IRubyObject f_to_s(ThreadContext context, IRubyObject x) {
        return x.callMethod(context, "to_s");
    }

    public static IRubyObject f_truncate(ThreadContext context, IRubyObject x) {
        return x.callMethod(context, "truncate");
    }

    public static boolean f_equal_p(ThreadContext context, IRubyObject x, IRubyObject y) {
        if (x instanceof RubyFixnum && y instanceof RubyFixnum) {
            return ((RubyFixnum)x).getLongValue() == ((RubyFixnum)y).getLongValue();
        }
        return x.callMethod(context, "==", y).isTrue();
    }

    public static IRubyObject f_expt(ThreadContext context, IRubyObject x, IRubyObject y) {
        return x.callMethod(context, "**", y);
    }

    public static IRubyObject f_idiv(ThreadContext context, IRubyObject x, IRubyObject y) {
        return x.callMethod(context, "div", y);
    }

    public static IRubyObject f_quo(ThreadContext context, IRubyObject x, IRubyObject y) {
        return x.callMethod(context, "quo", y);
    }

    public static IRubyObject f_rshift(ThreadContext context, IRubyObject x, IRubyObject y) {
        return x.callMethod(context, ">>", y);
    }

    public static IRubyObject f_lshift(ThreadContext context, IRubyObject x, IRubyObject y) {
        return x.callMethod(context, "<<", y);
    }

    public static boolean f_negative_p(ThreadContext context, IRubyObject x) {
        if (x instanceof RubyFixnum) {
            return ((RubyFixnum)x).getLongValue() < 0L;
        }
        return x.callMethod(context, "<", RubyFixnum.zero(context.getRuntime())).isTrue();
    }

    public static boolean f_zero_p(ThreadContext context, IRubyObject x) {
        if (x instanceof RubyFixnum) {
            return ((RubyFixnum)x).getLongValue() == 0L;
        }
        return x.callMethod(context, "==", RubyFixnum.zero(context.getRuntime())).isTrue();
    }

    public static boolean f_one_p(ThreadContext context, IRubyObject x) {
        if (x instanceof RubyFixnum) {
            return ((RubyFixnum)x).getLongValue() == 1L;
        }
        return x.callMethod(context, "==", RubyFixnum.one(context.getRuntime())).isTrue();
    }

    public static long i_gcd(long x, long y) {
        if (x < 0L) {
            x = -x;
        }
        if (y < 0L) {
            y = -y;
        }
        if (x == 0L) {
            return y;
        }
        if (y == 0L) {
            return x;
        }
        long b = 0L;
        while ((x & 1L) == 0L && (y & 1L) == 0L) {
            ++b;
            x >>= 1;
            y >>= 1;
        }
        while ((x & 1L) == 0L) {
            x >>= 1;
        }
        while ((y & 1L) == 0L) {
            y >>= 1;
        }
        while (x != y) {
            if (y > x) {
                long t = x;
                x = y;
                y = t;
            }
            x -= y;
            while ((x & 1L) == 0L) {
                x >>= 1;
            }
        }
        return x << (int)b;
    }

    public static IRubyObject f_gcd(ThreadContext context, IRubyObject x, IRubyObject y) {
        if (x instanceof RubyFixnum && y instanceof RubyFixnum) {
            return RubyFixnum.newFixnum(context.getRuntime(), Numeric.i_gcd(((RubyFixnum)x).getLongValue(), ((RubyFixnum)y).getLongValue()));
        }
        if (Numeric.f_negative_p(context, x)) {
            x = Numeric.f_negate(context, x);
        }
        if (Numeric.f_negative_p(context, y)) {
            y = Numeric.f_negate(context, y);
        }
        if (Numeric.f_zero_p(context, x)) {
            return y;
        }
        if (Numeric.f_zero_p(context, y)) {
            return x;
        }
        while (true) {
            if (x instanceof RubyFixnum) {
                if (((RubyFixnum)x).getLongValue() == 0L) {
                    return y;
                }
                if (y instanceof RubyFixnum) {
                    return RubyFixnum.newFixnum(context.getRuntime(), Numeric.i_gcd(((RubyFixnum)x).getLongValue(), ((RubyFixnum)y).getLongValue()));
                }
            }
            IRubyObject z = x;
            x = Numeric.f_mod(context, y, x);
            y = z;
        }
    }

    public static IRubyObject f_lcm(ThreadContext context, IRubyObject x, IRubyObject y) {
        if (Numeric.f_zero_p(context, x) || Numeric.f_zero_p(context, y)) {
            return RubyFixnum.zero(context.getRuntime());
        }
        return Numeric.f_abs(context, Numeric.f_mul(context, Numeric.f_div(context, x, Numeric.f_gcd(context, x, y)), y));
    }

    public static long i_ilog2(ThreadContext context, IRubyObject x) {
        long q = (x.callMethod(context, "size").convertToInteger().getLongValue() - 8L) * 8L + 1L;
        if (q > 0L) {
            x = Numeric.f_rshift(context, x, RubyFixnum.newFixnum(context.getRuntime(), q));
        }
        long fx = x.convertToInteger().getLongValue();
        long r = -1L;
        while (fx != 0L) {
            fx >>= 1;
            ++r;
        }
        return q + r;
    }

    public static double ldexp(double f, long e) {
        return f * Math.pow(2.0, e);
    }

    public static double frexp(double mantissa, long[] e) {
        int sign = 1;
        long exponent = 0L;
        if (mantissa != 0.0) {
            if (mantissa < 0.0) {
                mantissa = -mantissa;
                sign = -1;
            }
            while (mantissa < 0.5) {
                mantissa *= 2.0;
                --exponent;
            }
            while (mantissa >= 1.0) {
                mantissa *= 0.5;
                ++exponent;
            }
        }
        e[0] = exponent;
        return (double)sign * mantissa;
    }

    static boolean fitSqrtLong(long n) {
        return n < SQRT_LONG_MAX && n >= -SQRT_LONG_MAX;
    }

    public static IRubyObject int_pow(ThreadContext context, long x, long y) {
        boolean neg = x < 0L;
        long z = 1L;
        if (neg) {
            x = -x;
        }
        if ((y & 1L) != 0L) {
            z = x;
        } else {
            neg = false;
        }
        y &= 0xFFFFFFFFFFFFFFFEL;
        Ruby runtime = context.getRuntime();
        while (true) {
            if (y % 2L == 0L) {
                if (!Numeric.fitSqrtLong(x)) {
                    IRubyObject v = RubyBignum.newBignum(runtime, RubyBignum.fix2big(RubyFixnum.newFixnum(runtime, x))).op_pow(context, RubyFixnum.newFixnum(runtime, y));
                    if (z != 1L) {
                        v = RubyBignum.newBignum(runtime, RubyBignum.fix2big(RubyFixnum.newFixnum(runtime, neg ? -z : z))).op_mul(context, v);
                    }
                    return v;
                }
                x *= x;
                y >>= 1;
                continue;
            }
            long xz = x * x;
            if (xz / x != z) {
                IRubyObject v = RubyBignum.newBignum(runtime, RubyBignum.fix2big(RubyFixnum.newFixnum(runtime, x))).op_pow(context, RubyFixnum.newFixnum(runtime, y));
                if (z != 1L) {
                    v = RubyBignum.newBignum(runtime, RubyBignum.fix2big(RubyFixnum.newFixnum(runtime, neg ? -z : z))).op_mul(context, v);
                }
                return v;
            }
            z = xz;
            if (--y == 0L) break;
        }
        if (neg) {
            z = -z;
        }
        return RubyFixnum.newFixnum(runtime, z);
    }

    public static final class RationalPatterns {
        public static final Regex rat_pat;
        public static final Regex an_e_pat;
        public static final Regex a_dot_pat;

        static {
            String DIGITS = "(?:\\d(?:_\\d|\\d)*)";
            String NUMERATOR = "(?:" + DIGITS + "?\\.)?" + DIGITS + "(?:[eE][-+]?" + DIGITS + ")?";
            String DENOMINATOR = DIGITS;
            String PATTERN = "\\A([-+])?(" + NUMERATOR + ")(?:\\/(" + DENOMINATOR + "))?";
            rat_pat = new Regex(PATTERN.getBytes(), 0, PATTERN.length(), 0, (Encoding)ASCIIEncoding.INSTANCE);
            an_e_pat = new Regex("[Ee]".getBytes(), 0, 4, 0, (Encoding)ASCIIEncoding.INSTANCE);
            a_dot_pat = new Regex("\\.".getBytes(), 0, 2, 0, (Encoding)ASCIIEncoding.INSTANCE);
        }
    }

    public static final class ComplexPatterns {
        public static final Regex comp_pat0;
        public static final Regex comp_pat1;
        public static final Regex comp_pat2;
        public static final Regex underscores_pat;

        static {
            String DIGITS = "(?:\\d(?:_\\d|\\d)*)";
            String NUMERATOR = "(?:" + DIGITS + "?\\.)?" + DIGITS + "(?:[eE][-+]?" + DIGITS + ")?";
            String DENOMINATOR = DIGITS;
            String NUMBER = "[-+]?" + NUMERATOR + "(?:\\/" + DENOMINATOR + ")?";
            String NUMBERNOS = NUMERATOR + "(?:\\/" + DENOMINATOR + ")?";
            String PATTERN0 = "\\A(" + NUMBER + ")@(" + NUMBER + ")";
            String PATTERN1 = "\\A([-+])?(" + NUMBER + ")?[iIjJ]";
            String PATTERN2 = "\\A(" + NUMBER + ")(([-+])(" + NUMBERNOS + ")?[iIjJ])?";
            comp_pat0 = new Regex(PATTERN0.getBytes(), 0, PATTERN0.length(), 0, (Encoding)ASCIIEncoding.INSTANCE);
            comp_pat1 = new Regex(PATTERN1.getBytes(), 0, PATTERN1.length(), 0, (Encoding)ASCIIEncoding.INSTANCE);
            comp_pat2 = new Regex(PATTERN2.getBytes(), 0, PATTERN2.length(), 0, (Encoding)ASCIIEncoding.INSTANCE);
            underscores_pat = new Regex("_+".getBytes(), 0, 2, 0, (Encoding)ASCIIEncoding.INSTANCE);
        }
    }
}

