/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.BlockBody;
import org.jruby.nb.runtime.InterpretedBlock;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class IterNode
extends Node {
    private final Node varNode;
    private final Node bodyNode;
    private StaticScope scope;
    private InterpretedBlock blockBody;

    public IterNode(ISourcePosition position, Node varNode, StaticScope scope, Node bodyNode) {
        this(position, varNode, scope, bodyNode, NodeType.ITERNODE);
    }

    public IterNode(ISourcePosition position, Node varNode, StaticScope scope, Node bodyNode, NodeType id) {
        super(position, id);
        this.varNode = varNode;
        this.scope = scope;
        this.bodyNode = bodyNode;
        NodeType argsNodeId = BlockBody.getArgumentTypeWackyHack(this);
        this.blockBody = new InterpretedBlock(this, Arity.procArityOf(varNode), BlockBody.asArgumentType(argsNodeId));
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitIterNode(this);
    }

    public StaticScope getScope() {
        return this.scope;
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getVarNode() {
        return this.varNode;
    }

    public InterpretedBlock getBlockBody() {
        return this.blockBody;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.varNode, this.bodyNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        assert (false) : "Call nodes deal with these directly";
        return null;
    }
}

