/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.LazyDebuggerManagerListener;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.cnd.debugger.common.breakpoints.BreakpointsReader;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.LineBreakpoint;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public class PersistenceManager
implements LazyDebuggerManagerListener {
    private static final String CND_PROPERTY = "cnd";

    public synchronized Breakpoint[] initBreakpoints() {
        Properties p = Properties.getDefault().getProperties("debugger").getProperties("breakpoints");
        Breakpoint[] breakpoints = (Breakpoint[])p.getArray(CND_PROPERTY, (Object[])new Breakpoint[0]);
        for (int i = 0; i < breakpoints.length; ++i) {
            if (breakpoints[i] instanceof LineBreakpoint) {
                LineBreakpoint lb = (LineBreakpoint)breakpoints[i];
                try {
                    FileObject fo = URLMapper.findFileObject((URL)new URL(lb.getURL()));
                    if (fo == null) {
                        Breakpoint[] breakpoints2 = new Breakpoint[breakpoints.length - 1];
                        if (i > 0) {
                            System.arraycopy(breakpoints, 0, breakpoints2, 0, i);
                        }
                        if (i < breakpoints2.length) {
                            System.arraycopy(breakpoints, i + 1, breakpoints2, i, breakpoints2.length - i);
                        }
                        breakpoints = breakpoints2;
                        --i;
                        continue;
                    }
                }
                catch (MalformedURLException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
            breakpoints[i].addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        return breakpoints;
    }

    public synchronized Breakpoint[] unloadBreakpoints() {
        Breakpoint[] bpts = DebuggerManager.getDebuggerManager().getBreakpoints();
        ArrayList<Breakpoint> unloaded = new ArrayList<Breakpoint>();
        for (Breakpoint b : bpts) {
            if (!(b instanceof CndBreakpoint)) continue;
            unloaded.add(b);
            b.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        return unloaded.toArray(new Breakpoint[unloaded.size()]);
    }

    public void initWatches() {
    }

    public String[] getProperties() {
        return new String[]{"breakpointsInit", "breakpoints"};
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        if (breakpoint instanceof CndBreakpoint && !((CndBreakpoint)breakpoint).isHidden()) {
            PersistenceManager.storeBreakpoints();
            breakpoint.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (breakpoint instanceof CndBreakpoint) {
            PersistenceManager.storeBreakpoints();
            breakpoint.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof CndBreakpoint && !"validity".equals(evt.getPropertyName())) {
            PersistenceManager.storeBreakpoints();
        }
    }

    static BreakpointsReader findBreakpointsReader() {
        BreakpointsReader breakpointsReader = null;
        List readers = DebuggerManager.getDebuggerManager().lookup(null, Properties.Reader.class);
        for (Properties.Reader r : readers) {
            String[] ns = r.getSupportedClassNames();
            if (ns.length != 1 || !CndBreakpoint.class.getName().equals(ns[0])) continue;
            breakpointsReader = (BreakpointsReader)r;
            break;
        }
        return breakpointsReader;
    }

    static void storeBreakpoints() {
        Properties.getDefault().getProperties("debugger").getProperties("breakpoints").setArray(CND_PROPERTY, (Object[])PersistenceManager.getBreakpoints());
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void engineAdded(DebuggerEngine engine) {
    }

    public void engineRemoved(DebuggerEngine engine) {
    }

    private static Breakpoint[] getBreakpoints() {
        Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
        int k = bs.length;
        ArrayList<Breakpoint> bb = new ArrayList<Breakpoint>();
        for (int i = 0; i < k; ++i) {
            if (!(bs[i] instanceof CndBreakpoint) || ((CndBreakpoint)bs[i]).isHidden()) continue;
            bb.add(bs[i]);
        }
        return bb.toArray(new Breakpoint[bb.size()]);
    }
}

