/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.sonatype.nexus.artifact.Gav;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.context.IndexCreator;
import org.sonatype.nexus.index.context.IndexingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactContext {
    private final File pom;
    private final File artifact;
    private final File metadata;
    private final ArtifactInfo artifactInfo;
    private final Gav gav;
    private final List<Exception> errors = new ArrayList<Exception>();

    public ArtifactContext(File pom, File artifact, File metadata, ArtifactInfo artifactInfo, Gav gav) {
        if (artifactInfo == null) {
            throw new IllegalArgumentException("Parameter artifactInfo must not be null");
        }
        this.pom = pom;
        this.artifact = artifact;
        this.metadata = metadata;
        this.artifactInfo = artifactInfo;
        this.gav = gav == null ? artifactInfo.calculateGav() : gav;
    }

    public File getPom() {
        return this.pom;
    }

    public File getArtifact() {
        return this.artifact;
    }

    public File getMetadata() {
        return this.metadata;
    }

    public ArtifactInfo getArtifactInfo() {
        return this.artifactInfo;
    }

    public Gav getGav() {
        return this.gav;
    }

    public List<Exception> getErrors() {
        return this.errors;
    }

    public void addError(Exception e) {
        this.errors.add(e);
    }

    public Document createDocument(IndexingContext context) {
        Document doc = new Document();
        doc.add((Fieldable)new Field("u", this.getArtifactInfo().getUinfo(), Field.Store.YES, Field.Index.UN_TOKENIZED));
        doc.add((Fieldable)new Field("m", Long.toString(System.currentTimeMillis()), Field.Store.YES, Field.Index.NO));
        for (IndexCreator indexCreator : context.getIndexCreators()) {
            try {
                indexCreator.populateArtifactInfo(this);
            }
            catch (IOException ex) {
                this.addError(ex);
            }
        }
        for (IndexCreator indexCreator : context.getIndexCreators()) {
            indexCreator.updateDocument(this.getArtifactInfo(), doc);
        }
        return doc;
    }
}

