/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints.infrastructure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jrubyparser.IRubyWarnings;
import org.jrubyparser.ast.CaseNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.WhenNode;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyParser;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyErrorRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.hints.infrastructure.RubySelectionRule;

public class RubyHintsProvider
implements HintsProvider {
    private boolean cancelled;

    public RuleContext createRuleContext() {
        return new RubyRuleContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeErrors(HintsProvider.HintsManager manager, RuleContext context, List<Hint> result, List<Error> unhandled) {
        ParserResult parserResult = context.parserResult;
        if (parserResult == null) {
            return;
        }
        List errors = parserResult.getDiagnostics();
        if (errors == null || errors.size() == 0) {
            return;
        }
        this.cancelled = false;
        Map hints = manager.getErrors();
        if (hints.isEmpty() || this.isCancelled()) {
            unhandled.addAll(errors);
            return;
        }
        try {
            context.doc.readLock();
            for (Error error : errors) {
                if (!(error instanceof RubyParser.RubyError) || this.applyRules(manager, (RubyParser.RubyError)error, context, hints, result)) continue;
                unhandled.add(error);
            }
        }
        finally {
            context.doc.readUnlock();
        }
    }

    public List<Rule> getBuiltinRules() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeSelectionHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> result, int start, int end) {
        this.cancelled = false;
        ParserResult parserResult = context.parserResult;
        if (parserResult == null) {
            return;
        }
        Node root = AstUtilities.getRoot((Parser.Result)parserResult);
        if (root == null) {
            return;
        }
        List hints = manager.getSelectionHints();
        if (hints.isEmpty()) {
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        try {
            context.doc.readLock();
            this.applyRules(manager, context, hints, result);
        }
        finally {
            context.doc.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> result) {
        this.cancelled = false;
        ParserResult parserResult = context.parserResult;
        if (parserResult == null) {
            return;
        }
        Node root = AstUtilities.getRoot((Parser.Result)parserResult);
        if (root == null) {
            return;
        }
        Map hints = manager.getHints(false, context);
        if (hints.isEmpty()) {
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        AstPath path = new AstPath();
        path.descend(root);
        try {
            context.doc.readLock();
            this.applyRules(manager, context, NodeType.ROOTNODE, root, path, hints, result);
            this.scan(manager, context, root, path, hints, result);
        }
        finally {
            context.doc.readUnlock();
        }
        path.ascend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeSuggestions(HintsProvider.HintsManager manager, RuleContext context, List<Hint> result, int caretOffset) {
        this.cancelled = false;
        ParserResult parserResult = context.parserResult;
        if (parserResult == null) {
            return;
        }
        Node root = AstUtilities.getRoot((Parser.Result)parserResult);
        if (root == null) {
            return;
        }
        HashMap<NodeType, List<RubyAstRule>> suggestions = new HashMap<NodeType, List<RubyAstRule>>();
        Map hintsMap = manager.getHints(true, context);
        suggestions.putAll(hintsMap);
        Set suggestionsSet = manager.getSuggestions().entrySet();
        for (Map.Entry e : suggestionsSet) {
            List rules = (List)suggestions.get(e.getKey());
            if (rules != null) {
                LinkedList res = new LinkedList();
                res.addAll(rules);
                res.addAll((Collection)e.getValue());
                suggestions.put((NodeType)e.getKey(), res);
                continue;
            }
            suggestions.put((NodeType)e.getKey(), (List<RubyAstRule>)e.getValue());
        }
        if (suggestions.isEmpty()) {
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        ParserResult info = context.parserResult;
        int astOffset = AstUtilities.getAstOffset((Parser.Result)info, (int)caretOffset);
        AstPath path = new AstPath(root, astOffset);
        try {
            context.doc.readLock();
            ListIterator it = path.leafToRoot();
            while (it.hasNext()) {
                if (this.isCancelled()) {
                    return;
                }
                Node node = (Node)it.next();
                this.applyRules(manager, context, node.getNodeType(), node, path, suggestions, result);
            }
        }
        finally {
            context.doc.readUnlock();
        }
    }

    private void applyRules(HintsProvider.HintsManager manager, RuleContext context, NodeType nodeType, Node node, AstPath path, Map<NodeType, List<RubyAstRule>> hints, List<Hint> result) {
        List<RubyAstRule> rules = hints.get(nodeType);
        if (rules != null) {
            RubyRuleContext rubyContext = (RubyRuleContext)context;
            rubyContext.node = node;
            rubyContext.path = path;
            for (RubyAstRule rule : rules) {
                if (!manager.isEnabled((Rule.UserConfigurableRule)rule)) continue;
                rule.run(rubyContext, result);
            }
        }
    }

    private boolean applyRules(HintsProvider.HintsManager manager, RubyParser.RubyError error, RuleContext context, Map<IRubyWarnings.ID, List<RubyErrorRule>> hints, List<Hint> result) {
        List<RubyErrorRule> rules;
        IRubyWarnings.ID code = error.getId();
        if (code != null && (rules = hints.get(code)) != null) {
            int countBefore = result.size();
            RubyRuleContext rubyContext = (RubyRuleContext)context;
            for (RubyErrorRule rule : rules) {
                if (!manager.isEnabled((Rule.UserConfigurableRule)rule) || !rule.appliesTo(context)) continue;
                rule.run(rubyContext, error, result);
            }
            return countBefore < result.size();
        }
        return false;
    }

    private void applyRules(HintsProvider.HintsManager manager, RuleContext context, List<RubySelectionRule> rules, List<Hint> result) {
        RubyRuleContext rubyContext = (RubyRuleContext)context;
        for (RubySelectionRule rule : rules) {
            if (!rule.appliesTo(context) || !manager.isEnabled((Rule.UserConfigurableRule)rule)) continue;
            rule.run(rubyContext, result);
        }
    }

    private void scan(HintsProvider.HintsManager manager, RuleContext context, Node node, AstPath path, Map<NodeType, List<RubyAstRule>> hints, List<Hint> result) {
        this.applyRules(manager, context, node.getNodeType(), node, path, hints, result);
        List<Node> list = this.childNodes(node);
        for (Node child : list) {
            if (child.isInvisible()) continue;
            if (this.isCancelled()) {
                return;
            }
            path.descend(child);
            this.scan(manager, context, child, path, hints, result);
            path.ascend();
        }
    }

    private List<Node> childNodes(Node node) {
        if (node.getNodeType() == NodeType.WHENNODE) {
            WhenNode whenNode = (WhenNode)node;
            return this.nodeList(whenNode.getExpressionNodes(), whenNode.getBodyNode());
        }
        if (node.getNodeType() == NodeType.CASENODE) {
            CaseNode caseNode = (CaseNode)node;
            return this.nodeList(new Node[]{caseNode.getCaseNode(), caseNode.getCases(), caseNode.getElseNode()});
        }
        return node.childNodes();
    }

    private List<Node> nodeList(Node ... nodes) {
        ArrayList<Node> result = new ArrayList<Node>(nodes.length);
        for (Node node : nodes) {
            if (node == null) continue;
            result.add(node);
        }
        return result;
    }

    public void cancel() {
        this.cancelled = true;
    }

    private boolean isCancelled() {
        return this.cancelled;
    }
}

